/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.system;

import com.michelmuscle.slidersmod.SlidersMod;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class DimensionSeedRegistry
extends SavedData {
    private static final String DATA_NAME = "slidersmod_dimension_seeds";
    private static final Random RANDOM = new Random();
    private final Map<String, SeedDestination> seedMap = new HashMap<String, SeedDestination>();

    public static DimensionSeedRegistry get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (DimensionSeedRegistry)storage.m_164861_(DimensionSeedRegistry::load, DimensionSeedRegistry::new, DATA_NAME);
    }

    public static DimensionSeedRegistry load(CompoundTag tag) {
        DimensionSeedRegistry registry = new DimensionSeedRegistry();
        ListTag seedList = tag.m_128437_("Seeds", 10);
        for (int i = 0; i < seedList.size(); ++i) {
            CompoundTag seedTag = seedList.m_128728_(i);
            String seed = seedTag.m_128461_("Seed");
            String dimString = seedTag.m_128461_("Dimension");
            int x = seedTag.m_128451_("X");
            int y = seedTag.m_128451_("Y");
            int z = seedTag.m_128451_("Z");
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.parse((String)dimString));
            BlockPos pos = new BlockPos(x, y, z);
            registry.seedMap.put(seed, new SeedDestination((ResourceKey<Level>)dimension, pos));
        }
        SlidersMod.LOGGER.info("Loaded {} dimension seeds from saved data", (Object)registry.seedMap.size());
        return registry;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag seedList = new ListTag();
        for (Map.Entry<String, SeedDestination> entry : this.seedMap.entrySet()) {
            CompoundTag seedTag = new CompoundTag();
            seedTag.m_128359_("Seed", entry.getKey());
            seedTag.m_128359_("Dimension", entry.getValue().dimension.m_135782_().toString());
            seedTag.m_128405_("X", entry.getValue().position.m_123341_());
            seedTag.m_128405_("Y", entry.getValue().position.m_123342_());
            seedTag.m_128405_("Z", entry.getValue().position.m_123343_());
            seedList.add((Object)seedTag);
        }
        tag.m_128365_("Seeds", (Tag)seedList);
        SlidersMod.LOGGER.info("Saved {} dimension seeds to saved data", (Object)this.seedMap.size());
        return tag;
    }

    public String generateUniqueSeed() {
        String seed;
        int attempts = 0;
        do {
            int number = 10000000 + RANDOM.nextInt(90000000);
            seed = String.valueOf(number);
            if (++attempts <= 100) continue;
            SlidersMod.LOGGER.warn("Failed to generate unique seed after 100 attempts!");
            break;
        } while (this.seedMap.containsKey(seed));
        SlidersMod.LOGGER.info("Generated unique dimension seed: {}", (Object)seed);
        return seed;
    }

    public void registerSeed(String seed, ResourceKey<Level> dimension, BlockPos position) {
        this.seedMap.put(seed, new SeedDestination(dimension, position));
        this.m_77762_();
        SlidersMod.LOGGER.info("Registered seed {} -> {} at {}", new Object[]{seed, dimension.m_135782_(), position});
    }

    public SeedDestination getDestination(String seed) {
        return this.seedMap.get(seed);
    }

    public boolean isValidSeed(String seed) {
        return this.seedMap.containsKey(seed);
    }

    public static boolean isValidSeedFormat(String seed) {
        if (seed == null || seed.length() != 8) {
            return false;
        }
        try {
            Integer.parseInt(seed);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public int getSeedCount() {
        return this.seedMap.size();
    }

    public static class SeedDestination {
        public final ResourceKey<Level> dimension;
        public final BlockPos position;

        public SeedDestination(ResourceKey<Level> dimension, BlockPos position) {
            this.dimension = dimension;
            this.position = position;
        }
    }
}

