/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.system;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.advancements.AchievementManager;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OriginalTimerDamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class StuckTimerManager {
    private static final Map<UUID, ParticleInfo> scheduledParticles = new HashMap<UUID, ParticleInfo>();

    private StuckTimerManager() {
    }

    public static void executeStuckTransformation(ServerPlayer player, ItemStack damagedTimerStack) {
        int slot = StuckTimerManager.findDamagedTimerSlot(player, damagedTimerStack);
        StuckTimerManager.executeStuckTransformation(player, damagedTimerStack, slot);
    }

    public static void executeStuckTransformation(ServerPlayer player, ItemStack damagedTimerStack, int slotIndex) {
        SlidersMod.LOGGER.info("Executing stuck transformation for player {}", (Object)player.m_7755_().getString());
        player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.TIMER_BURNOUT.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
        if (slotIndex < 0 || slotIndex >= player.m_150109_().f_35974_.size()) {
            slotIndex = StuckTimerManager.findDamagedTimerSlot(player, damagedTimerStack);
        }
        if (slotIndex < 0) {
            SlidersMod.LOGGER.warn("Unable to locate damaged timer in {}'s inventory for stuck conversion.", (Object)player.m_7755_().getString());
            return;
        }
        StuckTimerManager.swapTimerToStuck(player, damagedTimerStack, slotIndex);
        AchievementManager.triggerStuckInDimension(player);
        ServerLevel level = (ServerLevel)player.m_9236_();
        scheduledParticles.put(player.m_20148_(), new ParticleInfo(level.m_46467_() + 40L));
    }

    public static void tick(ServerLevel level) {
        long currentTime = level.m_46467_();
        Iterator<Map.Entry<UUID, ParticleInfo>> iterator = scheduledParticles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ParticleInfo> entry = iterator.next();
            ServerPlayer player = level.m_7654_().m_6846_().m_11259_(entry.getKey());
            if (player == null) {
                iterator.remove();
                continue;
            }
            if (currentTime < entry.getValue().particleEndTime) {
                StuckTimerManager.spawnSmokeParticles(player);
                continue;
            }
            iterator.remove();
            SlidersMod.LOGGER.info("Stuck transformation particles finished for {}", (Object)entry.getKey());
        }
    }

    private static void spawnSmokeParticles(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        double baseX = player.m_20185_();
        double baseY = player.m_20186_() + 1.2;
        double baseZ = player.m_20189_();
        for (int i = 0; i < 3; ++i) {
            double offsetX = (Math.random() - 0.5) * 0.3;
            double offsetY = Math.random() * 0.3;
            double offsetZ = (Math.random() - 0.5) * 0.3;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, baseX + offsetX, baseY + offsetY, baseZ + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
        }
    }

    private static void swapTimerToStuck(ServerPlayer player, ItemStack damagedTimerStack, int slotIndex) {
        ItemStack replacement = StuckTimerManager.createStuckReplacement(damagedTimerStack);
        if (replacement == null) {
            SlidersMod.LOGGER.warn("Unknown damaged timer type {}. Cannot create stuck variant.", (Object)damagedTimerStack.m_41720_());
            return;
        }
        player.m_150109_().m_6836_(slotIndex, replacement);
        player.m_5661_((Component)Component.m_237113_((String)"\u00a74\u00a7l  Timer is permanently STUCK! It cannot be used anymore."), false);
        SlidersMod.LOGGER.info("Timer transformed to stuck at slot {} for {}", (Object)slotIndex, (Object)player.m_7755_().getString());
    }

    private static ItemStack createStuckReplacement(ItemStack damagedTimerStack) {
        if (damagedTimerStack.m_41720_() instanceof OriginalTimerDamagedItem) {
            return new ItemStack((ItemLike)ModItems.ORIGINAL_TIMER_STUCK.get());
        }
        if (damagedTimerStack.m_41720_() instanceof LoganTimerDamagedItem) {
            return new ItemStack((ItemLike)ModItems.LOGAN_TIMER_STUCK.get());
        }
        if (damagedTimerStack.m_41720_() instanceof UpgradedLoganTimerTier1DamagedItem) {
            return new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER1_STUCK.get());
        }
        if (damagedTimerStack.m_41720_() instanceof UpgradedLoganTimerTier2DamagedItem) {
            return new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER2_STUCK.get());
        }
        if (damagedTimerStack.m_41720_() instanceof UpgradedLoganTimerTier3DamagedItem) {
            return new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER3_STUCK.get());
        }
        if (damagedTimerStack.m_41720_() instanceof ExodusTimerDamagedItem) {
            return new ItemStack((ItemLike)ModItems.EXODUS_TIMER_STUCK.get());
        }
        if (damagedTimerStack.m_41720_() instanceof EgyptianTimerDamagedItem) {
            return new ItemStack((ItemLike)ModItems.EGYPTIAN_TIMER_STUCK.get());
        }
        return null;
    }

    private static int findDamagedTimerSlot(ServerPlayer player, ItemStack damagedTimerStack) {
        NonNullList items = player.m_150109_().f_35974_;
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i) != damagedTimerStack) continue;
            return i;
        }
        return -1;
    }

    private static class ParticleInfo {
        final long particleEndTime;

        ParticleInfo(long endTick) {
            this.particleEndTime = endTick;
        }
    }
}

