/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.util;

import com.michelmuscle.slidersmod.config.SlidersModConfig;
import com.michelmuscle.slidersmod.item.CustomTimerDamagedItem;
import com.michelmuscle.slidersmod.item.CustomTimerItem;
import com.michelmuscle.slidersmod.item.CustomTimerStuckItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.ExodusTimerItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerItem;
import com.michelmuscle.slidersmod.item.OriginalTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OriginalTimerItem;
import com.michelmuscle.slidersmod.item.OriginalTimerStuckItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3Item;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class ClassicTimerHelper {
    private ClassicTimerHelper() {
    }

    public static long generateDamagedTimerDuration() {
        int maxMinutes = (Integer)SlidersModConfig.MAX_SLIDE_DURATION_MINUTES.get();
        double multiplier = (Double)SlidersModConfig.DAMAGED_TIMER_DURATION_MULTIPLIER.get();
        long minTicks = 1200L;
        long maxTicks = (long)maxMinutes * 60L * 20L;
        long baseDuration = minTicks + (long)(Math.random() * (double)(maxTicks - minTicks));
        return (long)((double)baseDuration * multiplier);
    }

    public static boolean isBaseTimer(ItemStack stack) {
        return ClassicTimerHelper.isBaseTimer(stack.m_41720_());
    }

    public static boolean isBaseTimer(Item item) {
        return item instanceof OriginalTimerItem || item instanceof CustomTimerItem || item instanceof LoganTimerItem || item instanceof ExodusTimerItem || item instanceof EgyptianTimerItem || item instanceof UpgradedLoganTimerTier1Item || item instanceof UpgradedLoganTimerTier2Item || item instanceof UpgradedLoganTimerTier3Item;
    }

    public static boolean isDamagedTimer(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof OriginalTimerDamagedItem || item instanceof CustomTimerDamagedItem || item instanceof LoganTimerDamagedItem || item instanceof ExodusTimerDamagedItem || item instanceof EgyptianTimerDamagedItem || item instanceof UpgradedLoganTimerTier1DamagedItem || item instanceof UpgradedLoganTimerTier2DamagedItem || item instanceof UpgradedLoganTimerTier3DamagedItem;
    }

    public static boolean isStuckTimer(Item item) {
        return item instanceof OriginalTimerStuckItem || item instanceof CustomTimerStuckItem;
    }

    public static long getConfiguredTime(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CustomTimerItem) {
            return CustomTimerItem.getConfiguredTime(stack);
        }
        return OriginalTimerItem.getConfiguredTime(stack);
    }

    public static void setConfiguredTime(ItemStack stack, long seconds) {
        Item item = stack.m_41720_();
        if (item instanceof CustomTimerItem) {
            CustomTimerItem.setConfiguredTime(stack, seconds);
        } else if (item instanceof OriginalTimerItem) {
            OriginalTimerItem.setConfiguredTime(stack, seconds);
        }
    }

    public static boolean isActive(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CustomTimerItem) {
            return CustomTimerItem.isActive(stack);
        }
        return OriginalTimerItem.isActive(stack);
    }

    public static long getActivationTime(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CustomTimerItem) {
            return CustomTimerItem.getActivationTime(stack);
        }
        return OriginalTimerItem.getActivationTime(stack);
    }

    public static void resetTimer(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CustomTimerItem) {
            CustomTimerItem.resetTimer(stack);
        } else if (item instanceof OriginalTimerItem) {
            OriginalTimerItem.resetTimer(stack);
        }
    }

    public static void setOverheated(ItemStack stack, boolean overheated) {
        Item item = stack.m_41720_();
        if (item instanceof CustomTimerItem) {
            CustomTimerItem.setOverheated(stack, overheated);
        } else if (item instanceof OriginalTimerItem) {
            OriginalTimerItem.setOverheated(stack, overheated);
        } else if (item instanceof LoganTimerItem) {
            LoganTimerItem.setOverheated(stack, overheated);
        } else if (item instanceof ExodusTimerItem) {
            ExodusTimerItem.setOverheated(stack, overheated);
        } else if (item instanceof EgyptianTimerItem) {
            EgyptianTimerItem.setOverheated(stack, overheated);
        } else if (item instanceof UpgradedLoganTimerTier1Item) {
            UpgradedLoganTimerTier1Item.setOverheated(stack, overheated);
        } else if (item instanceof UpgradedLoganTimerTier2Item) {
            UpgradedLoganTimerTier2Item.setOverheated(stack, overheated);
        } else if (item instanceof UpgradedLoganTimerTier3Item) {
            UpgradedLoganTimerTier3Item.setOverheated(stack, overheated);
        }
    }

    public static int startCooldownOverheat(ItemStack stack, Level level) {
        if (stack.m_41619_() || level == null) {
            return 0;
        }
        if (ClassicTimerHelper.isDamagedTimer(stack)) {
            return 0;
        }
        ClassicTimerHelper.setOverheated(stack, true);
        CompoundTag tag = stack.m_41784_();
        int cooldownTicks = TimerUpgradeData.getCooldownDurationTicks(stack);
        if (cooldownTicks <= 0) {
            return 0;
        }
        tag.m_128379_("IsCooldownOverheat", true);
        tag.m_128356_("CooldownEndTime", level.m_46467_() + (long)cooldownTicks);
        return cooldownTicks;
    }

    public static void handleSwing(Player player, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CustomTimerItem) {
            CustomTimerItem.onSwing(player, stack, player.m_9236_());
        } else if (item instanceof OriginalTimerItem) {
            OriginalTimerItem.onSwing(player, stack, player.m_9236_());
        }
    }

    public static void handleDamagedSwing(Player player, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CustomTimerDamagedItem) {
            CustomTimerDamagedItem.onSwing(player, stack, player.m_9236_());
        } else if (item instanceof OriginalTimerDamagedItem) {
            OriginalTimerDamagedItem.onSwing(player, stack, player.m_9236_());
        }
    }

    public static void initializeDamagedTimer(ItemStack stack, Level level) {
        Item item = stack.m_41720_();
        if (item instanceof CustomTimerDamagedItem) {
            CustomTimerDamagedItem.initializeDamagedTimer(stack, level);
        } else if (item instanceof OriginalTimerDamagedItem) {
            OriginalTimerDamagedItem.initializeDamagedTimer(stack, level);
        }
    }

    public static long getDamagedRemainingTime(ItemStack stack, Level level) {
        Item item = stack.m_41720_();
        if (item instanceof CustomTimerDamagedItem) {
            return CustomTimerDamagedItem.getRemainingTime(stack, level);
        }
        return OriginalTimerDamagedItem.getRemainingTime(stack, level);
    }

    public static void tickBaseTimerSpawns(ServerLevel level) {
        OriginalTimerItem.tickScheduledSpawns(level);
        CustomTimerItem.tickScheduledSpawns(level);
    }

    public static void tickDamagedTimerSpawns(ServerLevel level) {
        OriginalTimerDamagedItem.tickScheduledSpawns(level);
        CustomTimerDamagedItem.tickScheduledSpawns(level);
    }
}

