/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.util;

import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.util.UpgradeInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class TimerUpgradeSlots {
    private static final String TAG_TIMER_SLOTS = "TimerSlots";
    private static final String TAG_TOTAL_SLOTS = "TotalSlots";
    private static final String TAG_SLOT_COUNTS = "SlotCounts";
    private static final String TAG_UPGRADES = "Upgrades";
    private static final int MAX_SLOTS_PER_CATEGORY = 5;
    private static final int MAX_TOTAL_SLOTS = 25;

    public static boolean isTimer(ItemStack stack) {
        return DimensionManager.isTieredTimer(stack);
    }

    public static void initializeTimer(ItemStack timerStack) {
        int i;
        int numCategories;
        CompoundTag tag = timerStack.m_41784_();
        if (tag.m_128441_(TAG_TIMER_SLOTS)) {
            return;
        }
        CompoundTag slots = new CompoundTag();
        slots.m_128405_(TAG_TOTAL_SLOTS, 2);
        CompoundTag slotCounts = new CompoundTag();
        for (int i2 = 0; i2 < 5; ++i2) {
            slotCounts.m_128405_("cat_" + i2, 0);
        }
        Random random = new Random();
        int n = numCategories = random.nextBoolean() ? 1 : 2;
        if (numCategories == 1) {
            int category = random.nextInt(5);
            slotCounts.m_128405_("cat_" + category, 2);
        } else {
            ArrayList<Integer> categories = new ArrayList<Integer>();
            for (i = 0; i < 5; ++i) {
                categories.add(i);
            }
            Collections.shuffle(categories);
            slotCounts.m_128405_("cat_" + String.valueOf(categories.get(0)), 1);
            slotCounts.m_128405_("cat_" + String.valueOf(categories.get(1)), 1);
        }
        slots.m_128365_(TAG_SLOT_COUNTS, (Tag)slotCounts);
        ListTag upgradesList = new ListTag();
        for (i = 0; i < 5; ++i) {
            CompoundTag categoryUpgrades = new CompoundTag();
            upgradesList.add((Object)categoryUpgrades);
        }
        slots.m_128365_(TAG_UPGRADES, (Tag)upgradesList);
        tag.m_128365_(TAG_TIMER_SLOTS, (Tag)slots);
    }

    public static int getTotalSlots(ItemStack timerStack) {
        CompoundTag slots = TimerUpgradeSlots.getSlotsTag(timerStack);
        return slots.m_128451_(TAG_TOTAL_SLOTS);
    }

    public static int getSlotCount(ItemStack timerStack, int category) {
        if (category < 0 || category >= 5) {
            return 0;
        }
        CompoundTag slotCounts = TimerUpgradeSlots.getSlotsTag(timerStack).m_128469_(TAG_SLOT_COUNTS);
        return slotCounts.m_128451_("cat_" + category);
    }

    public static boolean addSlotToCategory(ItemStack timerStack, int category) {
        if (category < 0 || category >= 5) {
            return false;
        }
        int totalSlots = TimerUpgradeSlots.getTotalSlots(timerStack);
        if (totalSlots >= 25) {
            return false;
        }
        int currentCount = TimerUpgradeSlots.getSlotCount(timerStack, category);
        if (currentCount >= 5) {
            return false;
        }
        CompoundTag slots = TimerUpgradeSlots.getSlotsTag(timerStack);
        slots.m_128405_(TAG_TOTAL_SLOTS, totalSlots + 1);
        CompoundTag slotCounts = slots.m_128469_(TAG_SLOT_COUNTS);
        slotCounts.m_128405_("cat_" + category, currentCount + 1);
        return true;
    }

    public static boolean addUpgrade(ItemStack timerStack, int category, int slotIndex, UpgradeInstance upgrade) {
        if (category < 0 || category >= 5 || slotIndex < 0 || slotIndex >= 5) {
            return false;
        }
        int unlockedSlots = TimerUpgradeSlots.getSlotCount(timerStack, category);
        if (slotIndex >= unlockedSlots) {
            return false;
        }
        CompoundTag slots = TimerUpgradeSlots.getSlotsTag(timerStack);
        ListTag upgradesList = slots.m_128437_(TAG_UPGRADES, 10);
        while (upgradesList.size() <= category) {
            upgradesList.add((Object)new CompoundTag());
        }
        CompoundTag categoryUpgrades = upgradesList.m_128728_(category);
        CompoundTag slotTag = upgrade.serializeNBT();
        categoryUpgrades.m_128365_("slot_" + slotIndex, (Tag)slotTag);
        slots.m_128365_(TAG_UPGRADES, (Tag)upgradesList);
        timerStack.m_41784_().m_128365_(TAG_TIMER_SLOTS, (Tag)slots);
        return true;
    }

    public static UpgradeInstance getUpgrade(ItemStack timerStack, int category, int slotIndex) {
        if (category < 0 || category >= 5 || slotIndex < 0 || slotIndex >= 5) {
            return null;
        }
        CompoundTag slots = TimerUpgradeSlots.getSlotsTag(timerStack);
        ListTag upgradesList = slots.m_128437_(TAG_UPGRADES, 10);
        if (category >= upgradesList.size()) {
            return null;
        }
        CompoundTag categoryUpgrades = upgradesList.m_128728_(category);
        CompoundTag slotTag = categoryUpgrades.m_128469_("slot_" + slotIndex);
        if (slotTag.m_128456_()) {
            return null;
        }
        return UpgradeInstance.deserializeNBT(slotTag);
    }

    public static boolean removeUpgrade(ItemStack timerStack, int category, int slotIndex) {
        if (category < 0 || category >= 5 || slotIndex < 0 || slotIndex >= 5) {
            return false;
        }
        CompoundTag slots = TimerUpgradeSlots.getSlotsTag(timerStack);
        ListTag upgradesList = slots.m_128437_(TAG_UPGRADES, 10);
        if (category >= upgradesList.size()) {
            return false;
        }
        CompoundTag categoryUpgrades = upgradesList.m_128728_(category);
        categoryUpgrades.m_128473_("slot_" + slotIndex);
        TimerUpgradeSlots.getSlotsTag(timerStack).m_128365_(TAG_UPGRADES, (Tag)upgradesList);
        return true;
    }

    public static UpgradeInstance[] getUpgradesInCategory(ItemStack timerStack, int category) {
        if (category < 0 || category >= 5) {
            return new UpgradeInstance[0];
        }
        int slotCount = TimerUpgradeSlots.getSlotCount(timerStack, category);
        UpgradeInstance[] upgrades = new UpgradeInstance[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            upgrades[i] = TimerUpgradeSlots.getUpgrade(timerStack, category, i);
        }
        return upgrades;
    }

    public static boolean canAddMoreSlots(ItemStack timerStack) {
        return TimerUpgradeSlots.getTotalSlots(timerStack) < 25;
    }

    public static int getMaxTotalSlots() {
        return 25;
    }

    public static void clearAllUpgrades(ItemStack timerStack) {
        CompoundTag slots = TimerUpgradeSlots.getSlotsTag(timerStack);
        ListTag upgradesList = new ListTag();
        for (int i = 0; i < 5; ++i) {
            upgradesList.add((Object)new CompoundTag());
        }
        slots.m_128365_(TAG_UPGRADES, (Tag)upgradesList);
    }

    private static CompoundTag getSlotsTag(ItemStack stack) {
        int i;
        CompoundTag slots;
        CompoundTag root = stack.m_41784_();
        if (!root.m_128441_(TAG_TIMER_SLOTS)) {
            root.m_128365_(TAG_TIMER_SLOTS, (Tag)new CompoundTag());
        }
        if (!(slots = root.m_128469_(TAG_TIMER_SLOTS)).m_128441_(TAG_SLOT_COUNTS)) {
            CompoundTag slotCounts = new CompoundTag();
            for (i = 0; i < 5; ++i) {
                slotCounts.m_128405_("cat_" + i, 0);
            }
            slots.m_128365_(TAG_SLOT_COUNTS, (Tag)slotCounts);
        }
        if (!slots.m_128441_(TAG_UPGRADES)) {
            upgradesList = new ListTag();
            for (i = 0; i < 5; ++i) {
                upgradesList.add((Object)new CompoundTag());
            }
            slots.m_128365_(TAG_UPGRADES, (Tag)upgradesList);
        } else {
            upgradesList = slots.m_128437_(TAG_UPGRADES, 10);
            while (upgradesList.size() < 5) {
                upgradesList.add((Object)new CompoundTag());
            }
            slots.m_128365_(TAG_UPGRADES, (Tag)upgradesList);
        }
        return slots;
    }
}

