/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.block.entity;

import com.michelmuscle.slidersmod.client.sound.BlockSoundManager;
import com.michelmuscle.slidersmod.init.ModBlockEntities;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.menu.AnalyzerStationMenu;
import com.michelmuscle.slidersmod.util.TimerUpgradeAnalyzer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyzerStationBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    public static final int SLOT_TIMER = 0;
    private static final int SLOT_COUNT = 1;
    private static final int ENERGY_CAPACITY = 25000;
    public static final int PROCESS_TIME = 200;
    public static final int ENERGY_PER_OPERATION = 5000;
    private static final int ENERGY_PER_TICK = 25;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            AnalyzerStationBlockEntity.this.m_6596_();
            AnalyzerStationBlockEntity.this.onInventoryChanged(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot == 0 && AnalyzerStationBlockEntity.isAnalyzableTimer(stack);
        }
    };
    private final LazyOptional<ItemStackHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(25000, 1000);
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this.energyStorage);
    private int progress = 0;
    private boolean isAnalyzing = false;
    private boolean analysisComplete = false;
    private final ContainerData data = new SimpleContainerData(4){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> AnalyzerStationBlockEntity.this.progress;
                case 1 -> AnalyzerStationBlockEntity.this.energyStorage.getEnergyStored();
                case 2 -> {
                    if (AnalyzerStationBlockEntity.this.isAnalyzing) {
                        yield 1;
                    }
                    yield 0;
                }
                case 3 -> {
                    if (AnalyzerStationBlockEntity.this.analysisComplete) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AnalyzerStationBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    AnalyzerStationBlockEntity.this.energyStorage.setEnergy(value);
                    break;
                }
                case 2: {
                    AnalyzerStationBlockEntity.this.isAnalyzing = value != 0;
                    break;
                }
                case 3: {
                    AnalyzerStationBlockEntity.this.analysisComplete = value != 0;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public AnalyzerStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ANALYZER_STATION.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AnalyzerStationBlockEntity entity) {
        if (level.f_46443_) {
            if (entity.progress > 0 && !BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.startBlockSound(pos, (SoundEvent)ModSounds.ANALYZER_STATION_ACTIVE.get());
            } else if (entity.progress == 0 && BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.stopBlockSound(pos);
            }
            return;
        }
        boolean dirty = false;
        ItemStack stack = entity.itemHandler.getStackInSlot(0);
        if (stack.m_41619_()) {
            if (entity.progress != 0 || entity.isAnalyzing || entity.analysisComplete) {
                entity.resetAnalysis();
                dirty = true;
            }
            return;
        }
        if (entity.analysisComplete) {
            entity.isAnalyzing = false;
            return;
        }
        if (entity.energyStorage.getEnergyStored() < 25) {
            entity.isAnalyzing = false;
            return;
        }
        entity.energyStorage.extractEnergy(25, false);
        ++entity.progress;
        entity.isAnalyzing = true;
        dirty = true;
        if (entity.progress >= 200) {
            entity.progress = 200;
            entity.isAnalyzing = false;
            entity.analysisComplete = true;
            dirty = true;
        }
        if (dirty) {
            entity.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    private void onInventoryChanged(int slot) {
        if (slot != 0) {
            return;
        }
        if (this.itemHandler.getStackInSlot(0).m_41619_()) {
            this.resetAnalysis();
        } else {
            this.progress = 0;
            this.analysisComplete = false;
            this.isAnalyzing = false;
        }
        if (!this.levelIsClient()) {
            this.m_6596_();
        }
    }

    private void resetAnalysis() {
        this.progress = 0;
        this.isAnalyzing = false;
        this.analysisComplete = false;
        if (!this.levelIsClient()) {
            this.m_6596_();
        }
    }

    public boolean isAnalyzing() {
        return this.isAnalyzing;
    }

    public boolean isAnalysisComplete() {
        return this.analysisComplete;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public ContainerData getData() {
        return this.data;
    }

    public LazyOptional<IEnergyStorage> getEnergyCapability() {
        return this.energyCapability;
    }

    public void drops() {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.m_41619_()) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
        }
    }

    public static boolean isAnalyzableTimer(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        return TimerUpgradeAnalyzer.isSupportedTimer(item);
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.itemHandler.getStackInSlot(0).m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack extracted = this.itemHandler.extractItem(slot, amount, false);
        if (!extracted.m_41619_()) {
            this.m_6596_();
        }
        return extracted;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        this.resetAnalysis();
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
        this.energyCapability.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemCapability.lazyMap(handler -> handler);
        this.energyCapability.lazyMap(storage -> storage);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("energy", (Tag)this.energyStorage.serializeNBT());
        tag.m_128405_("progress", this.progress);
        tag.m_128379_("analyzing", this.isAnalyzing);
        tag.m_128379_("analysisComplete", this.analysisComplete);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.energyStorage.deserializeNBT(tag.m_128423_("energy"));
        this.progress = tag.m_128451_("progress");
        this.isAnalyzing = tag.m_128471_("analyzing");
        this.analysisComplete = tag.m_128471_("analysisComplete");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.slidersmod.analyzer_station");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new AnalyzerStationMenu(id, inventory, this, this.data);
    }

    private boolean levelIsClient() {
        return this.f_58857_ != null && this.f_58857_.f_46443_;
    }

    private class CustomEnergyStorage
    implements IEnergyStorage {
        private int energy;
        private final int capacity;
        private final int maxReceive;

        CustomEnergyStorage(int capacity, int maxReceive) {
            this.capacity = capacity;
            this.maxReceive = maxReceive;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate && received > 0) {
                this.energy += received;
                AnalyzerStationBlockEntity.this.m_6596_();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = Math.min(this.energy, maxExtract);
            if (!simulate && extracted > 0) {
                this.energy -= extracted;
                AnalyzerStationBlockEntity.this.m_6596_();
            }
            return extracted;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        void setEnergy(int value) {
            this.energy = Math.min(value, this.capacity);
        }

        CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("energy", this.energy);
            return tag;
        }

        void deserializeNBT(@Nullable Tag nbt) {
            if (nbt instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)nbt;
                this.energy = compound.m_128451_("energy");
            }
        }
    }
}

