/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.block.entity;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.client.sound.BlockSoundManager;
import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.init.ModBlockEntities;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.AdvancedCrystalBufferItem;
import com.michelmuscle.slidersmod.item.CrystalBufferItem;
import com.michelmuscle.slidersmod.item.DimensionAnchorItem;
import com.michelmuscle.slidersmod.item.DimensionalBufferItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.EgyptianTrackerUpgradeItem;
import com.michelmuscle.slidersmod.item.ExodusSeedUpgradeItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OriginalTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OverheatCooldownReducerItem;
import com.michelmuscle.slidersmod.item.OverheatProbabilityReducerItem;
import com.michelmuscle.slidersmod.item.PhaseModulatorItem;
import com.michelmuscle.slidersmod.item.PortalStabilityUpgradeItem;
import com.michelmuscle.slidersmod.item.QuantumRelocatorItem;
import com.michelmuscle.slidersmod.item.TemporalStabilizerItem;
import com.michelmuscle.slidersmod.item.UltimateCrystalBufferItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import com.michelmuscle.slidersmod.menu.TimerWorkbenchMenu;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimerWorkbenchBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    public static final int SLOT_TIMER = 0;
    public static final int SLOT_UPGRADE = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int SLOT_COUNT = 3;
    private static final int ENERGY_CAPACITY = 20000;
    private static final int ENERGY_PER_OPERATION = 20000;
    public static final int PROCESS_TIME = 400;
    private static final int ENERGY_PER_TICK = 50;
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            TimerWorkbenchBlockEntity.this.m_6596_();
            TimerWorkbenchBlockEntity.this.onInventoryChanged(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> DimensionManager.isTieredTimer(stack);
                case 1 -> {
                    if (stack.m_41720_() instanceof DimensionalBufferItem || stack.m_41720_() instanceof OverheatCooldownReducerItem || stack.m_41720_() instanceof OverheatProbabilityReducerItem || stack.m_41720_() instanceof TemporalStabilizerItem || stack.m_41720_() instanceof PortalStabilityUpgradeItem || stack.m_41720_() instanceof EgyptianTrackerUpgradeItem || stack.m_41720_() instanceof ExodusSeedUpgradeItem || stack.m_41720_() instanceof QuantumRelocatorItem && QuantumRelocatorItem.hasEncodedSeed(stack) || stack.m_41720_() instanceof DimensionAnchorItem) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private final LazyOptional<ItemStackHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IEnergyStorage> energyCapability;
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(20000, 5000);
    private int progress = 0;
    private boolean isProcessing = false;
    private UpgradeType activeUpgrade = UpgradeType.NONE;
    private final ContainerData data = new SimpleContainerData(3){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> TimerWorkbenchBlockEntity.this.progress;
                case 1 -> TimerWorkbenchBlockEntity.this.energyStorage.getEnergyStored();
                case 2 -> {
                    if (TimerWorkbenchBlockEntity.this.isProcessing) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TimerWorkbenchBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    TimerWorkbenchBlockEntity.this.energyStorage.setEnergy(value);
                    break;
                }
                case 2: {
                    TimerWorkbenchBlockEntity.this.isProcessing = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public TimerWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TIMER_WORKBENCH.get(), pos, state);
        this.energyCapability = LazyOptional.of(() -> this.energyStorage);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TimerWorkbenchBlockEntity entity) {
        if (level.f_46443_) {
            if (entity.isProcessing && !BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.startBlockSound(pos, (SoundEvent)ModSounds.TIMER_WORKBENCH_ACTIVE.get());
            } else if (!entity.isProcessing && BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.stopBlockSound(pos);
            }
            return;
        }
        boolean dirty = false;
        if (entity.canProcess()) {
            entity.isProcessing = true;
            if (entity.energyStorage.getEnergyStored() >= 50) {
                entity.energyStorage.extractEnergy(50, false);
                ++entity.progress;
                dirty = true;
                if (entity.progress >= 400) {
                    entity.finishProcessing();
                    entity.progress = 0;
                }
            }
        } else if (entity.isProcessing || entity.progress != 0) {
            entity.isProcessing = false;
            entity.progress = 0;
            dirty = true;
        }
        if (dirty) {
            entity.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    private void onInventoryChanged(int slot) {
        if (slot == 2) {
            return;
        }
        if (!this.levelIsClient() && !this.canProcess()) {
            this.progress = 0;
            this.isProcessing = false;
        }
    }

    private boolean canProcess() {
        boolean canApply;
        ItemStack timerStack = this.itemHandler.getStackInSlot(0);
        ItemStack upgradeStack = this.itemHandler.getStackInSlot(1);
        ItemStack outputStack = this.itemHandler.getStackInSlot(2);
        if (timerStack.m_41619_() || upgradeStack.m_41619_()) {
            this.activeUpgrade = UpgradeType.NONE;
            return false;
        }
        UpgradeType type = UpgradeType.fromItem(upgradeStack);
        if (type == UpgradeType.NONE) {
            this.activeUpgrade = UpgradeType.NONE;
            return false;
        }
        if (!outputStack.m_41619_()) {
            this.activeUpgrade = UpgradeType.NONE;
            return false;
        }
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DIMENSIONAL_BUFFER: {
                boolean bl = DimensionManager.canUpgradeTimerTier(timerStack);
                break;
            }
            case OVERHEAT_COOLDOWN_REDUCER: {
                boolean bl = TimerUpgradeData.canIncreaseCooldownTier(timerStack);
                break;
            }
            case OVERHEAT_PROBABILITY_REDUCER: {
                boolean bl = TimerUpgradeData.canDecreaseOverheatChance(timerStack);
                break;
            }
            case TEMPORAL_STABILIZER: {
                boolean bl = true;
                break;
            }
            case PORTAL_STABILITY: {
                boolean bl = TimerUpgradeData.canAddPortalStabilityUpgrade(timerStack);
                break;
            }
            case EGYPTIAN_TRACKER: {
                boolean bl = TimerUpgradeData.canAddTrackerUpgrade(timerStack);
                break;
            }
            case EXODUS_SEED: {
                boolean bl = TimerUpgradeData.canAddSeedUpgrade(timerStack);
                break;
            }
            case DIMENSION_ANCHOR: {
                boolean bl = TimerUpgradeData.canAddSeedSlot(timerStack);
                break;
            }
            case PHASE_MODULATOR: {
                boolean bl = timerStack.m_41784_().m_128471_("IsOverheated");
                break;
            }
            case CRYSTAL_BUFFER: {
                boolean bl = this.isDamagedTimer(timerStack);
                break;
            }
            case ADVANCED_CRYSTAL_BUFFER: {
                boolean bl = this.isDamagedTimer(timerStack);
                break;
            }
            case ULTIMATE_CRYSTAL_BUFFER: {
                boolean bl = this.isDamagedTimer(timerStack);
                break;
            }
            case NONE: {
                boolean bl = canApply = false;
            }
        }
        if (!canApply) {
            this.activeUpgrade = UpgradeType.NONE;
            return false;
        }
        this.activeUpgrade = type;
        return true;
    }

    private void finishProcessing() {
        if (!this.canProcess()) {
            return;
        }
        ItemStack timerStack = this.itemHandler.getStackInSlot(0).m_41777_();
        boolean success = false;
        switch (this.activeUpgrade) {
            case DIMENSIONAL_BUFFER: {
                success = DimensionManager.upgradeTimerTier(timerStack);
                if (success) break;
                SlidersMod.LOGGER.warn("Timer Workbench: failed to upgrade timer (tier limit?)");
                break;
            }
            case OVERHEAT_COOLDOWN_REDUCER: {
                if (!TimerUpgradeData.canIncreaseCooldownTier(timerStack)) break;
                TimerUpgradeData.increaseCooldownTier(timerStack);
                success = true;
                SlidersMod.LOGGER.info("Applied Overheat Cooldown Reducer: tier {}", (Object)TimerUpgradeData.getCooldownTier(timerStack));
                break;
            }
            case OVERHEAT_PROBABILITY_REDUCER: {
                if (!TimerUpgradeData.canDecreaseOverheatChance(timerStack)) break;
                TimerUpgradeData.increaseOverheatReductionTier(timerStack);
                success = true;
                SlidersMod.LOGGER.info("Applied Overheat Probability Reducer: tier {}", (Object)TimerUpgradeData.getOverheatReductionTier(timerStack));
                break;
            }
            case TEMPORAL_STABILIZER: {
                TimerUpgradeData.increaseTemporalTier(timerStack);
                success = true;
                SlidersMod.LOGGER.info("Applied Temporal Stabilizer: tier {}", (Object)TimerUpgradeData.getTemporalTier(timerStack));
                break;
            }
            case PORTAL_STABILITY: {
                TimerUpgradeData.addPortalStabilityUpgrade(timerStack);
                success = true;
                SlidersMod.LOGGER.info("Applied Portal Stability Upgrade");
                break;
            }
            case EGYPTIAN_TRACKER: {
                if (!TimerUpgradeData.canAddTrackerUpgrade(timerStack)) break;
                TimerUpgradeData.addTrackerUpgrade(timerStack);
                success = true;
                SlidersMod.LOGGER.info("Applied Egyptian Tracker Upgrade to Egyptian Timer");
                break;
            }
            case EXODUS_SEED: {
                if (!TimerUpgradeData.canAddSeedUpgrade(timerStack)) break;
                TimerUpgradeData.addSeedUpgrade(timerStack);
                success = true;
                SlidersMod.LOGGER.info("Applied Exodus Seed Upgrade to Exodus Timer");
                break;
            }
            case DIMENSION_ANCHOR: {
                if (!TimerUpgradeData.canAddSeedSlot(timerStack)) break;
                TimerUpgradeData.increaseSeedSlots(timerStack);
                success = true;
                SlidersMod.LOGGER.info("Applied Dimension Anchor: slot {}/{}", (Object)TimerUpgradeData.getSeedSlots(timerStack), (Object)5);
                break;
            }
            case PHASE_MODULATOR: {
                CompoundTag tag = timerStack.m_41784_();
                if (!tag.m_128471_("IsOverheated")) break;
                tag.m_128379_("IsOverheated", false);
                tag.m_128473_("CooldownEndTime");
                tag.m_128473_("IsCooldownOverheat");
                success = true;
                SlidersMod.LOGGER.info("Applied Phase Modulator: overheat removed");
                break;
            }
            case CRYSTAL_BUFFER: {
                CompoundTag tag;
                long currentDuration;
                if (!this.isDamagedTimer(timerStack) || (currentDuration = (tag = timerStack.m_41784_()).m_128454_("RemainingTime")) <= 0L) break;
                double multiplier = 0.5 + Math.random() * 0.25;
                long newDuration = (long)((double)currentDuration * multiplier);
                tag.m_128356_("RemainingTime", newDuration);
                success = true;
                SlidersMod.LOGGER.info("Applied Crystal Buffer: reduced damage countdown from {} to {}", (Object)currentDuration, (Object)newDuration);
                break;
            }
            case ADVANCED_CRYSTAL_BUFFER: {
                CompoundTag tag;
                long currentDuration;
                if (!this.isDamagedTimer(timerStack) || (currentDuration = (tag = timerStack.m_41784_()).m_128454_("RemainingTime")) <= 0L) break;
                int divisor = 2 + (int)(Math.random() * 4.0);
                long newDuration = currentDuration / (long)divisor;
                tag.m_128356_("RemainingTime", newDuration);
                success = true;
                SlidersMod.LOGGER.info("Applied Advanced Crystal Buffer: divided countdown by {}, {} to {}", new Object[]{divisor, currentDuration, newDuration});
                break;
            }
            case ULTIMATE_CRYSTAL_BUFFER: {
                CompoundTag tag;
                long currentDuration;
                if (!this.isDamagedTimer(timerStack) || (currentDuration = (tag = timerStack.m_41784_()).m_128454_("RemainingTime")) <= 0L) break;
                int divisor = 4 + (int)(Math.random() * 6.0);
                long newDuration = currentDuration / (long)divisor;
                tag.m_128356_("RemainingTime", newDuration);
                success = true;
                SlidersMod.LOGGER.info("Applied Ultimate Crystal Buffer: divided countdown by {}, {} to {}", new Object[]{divisor, currentDuration, newDuration});
                break;
            }
            case NONE: {
                SlidersMod.LOGGER.error("Timer Workbench: attempting to apply NONE upgrade type");
            }
        }
        if (!success) {
            SlidersMod.LOGGER.warn("Timer Workbench: failed to apply upgrade of type {}", (Object)this.activeUpgrade);
            this.progress = 0;
            this.isProcessing = false;
            return;
        }
        this.itemHandler.extractItem(1, 1, false);
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        this.itemHandler.setStackInSlot(2, timerStack);
        this.isProcessing = false;
        this.activeUpgrade = UpgradeType.NONE;
    }

    public void drops() {
        if (this.f_58857_ == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
        }
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public int getProgress() {
        return this.progress;
    }

    public UpgradeType getActiveUpgrade() {
        return this.activeUpgrade;
    }

    public static int getEnergyPerOperation() {
        return 20000;
    }

    public static int getEnergyPerTick() {
        return 50;
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7983_() {
        for (int i = 0; i < 3; ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack extracted = this.itemHandler.extractItem(slot, amount, false);
        if (!extracted.m_41619_()) {
            this.m_6596_();
        }
        return extracted;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        for (int i = 0; i < 3; ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.m_6596_();
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
        this.energyCapability.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemCapability.lazyMap(handler -> handler);
        this.energyCapability.lazyMap(storage -> storage);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("energy", (Tag)this.energyStorage.serializeNBT());
        tag.m_128405_("progress", this.progress);
        tag.m_128379_("isProcessing", this.isProcessing);
        tag.m_128359_("activeUpgrade", this.activeUpgrade.name());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.energyStorage.deserializeNBT(tag.m_128423_("energy"));
        this.progress = tag.m_128451_("progress");
        this.isProcessing = tag.m_128471_("isProcessing");
        try {
            this.activeUpgrade = UpgradeType.valueOf(tag.m_128461_("activeUpgrade"));
        }
        catch (IllegalArgumentException ex) {
            this.activeUpgrade = UpgradeType.NONE;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Timer Workbench");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new TimerWorkbenchMenu(containerId, inventory, this, this.data);
    }

    public BlockPos m_58899_() {
        return this.f_58858_;
    }

    public ContainerData getData() {
        return this.data;
    }

    private boolean levelIsClient() {
        return this.f_58857_ != null && this.f_58857_.f_46443_;
    }

    private boolean isDamagedTimer(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        return item instanceof OriginalTimerDamagedItem || item instanceof LoganTimerDamagedItem || item instanceof UpgradedLoganTimerTier1DamagedItem || item instanceof UpgradedLoganTimerTier2DamagedItem || item instanceof UpgradedLoganTimerTier3DamagedItem || item instanceof ExodusTimerDamagedItem || item instanceof EgyptianTimerDamagedItem;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    private class CustomEnergyStorage
    implements IEnergyStorage {
        private int energy;
        private final int capacity;
        private final int maxReceive;

        public CustomEnergyStorage(int capacity, int maxReceive) {
            this.capacity = capacity;
            this.maxReceive = maxReceive;
            this.energy = 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate) {
                this.energy += energyReceived;
                TimerWorkbenchBlockEntity.this.m_6596_();
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(this.energy, maxExtract);
            if (!simulate) {
                this.energy -= energyExtracted;
                TimerWorkbenchBlockEntity.this.m_6596_();
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        public void setEnergy(int energy) {
            this.energy = Math.min(energy, this.capacity);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("energy", this.energy);
            return tag;
        }

        public void deserializeNBT(Tag nbt) {
            if (nbt instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)nbt;
                this.energy = tag.m_128451_("energy");
            }
        }
    }

    public static enum UpgradeType {
        NONE,
        DIMENSIONAL_BUFFER,
        OVERHEAT_COOLDOWN_REDUCER,
        OVERHEAT_PROBABILITY_REDUCER,
        TEMPORAL_STABILIZER,
        PORTAL_STABILITY,
        EGYPTIAN_TRACKER,
        EXODUS_SEED,
        DIMENSION_ANCHOR,
        PHASE_MODULATOR,
        CRYSTAL_BUFFER,
        ADVANCED_CRYSTAL_BUFFER,
        ULTIMATE_CRYSTAL_BUFFER;


        public static UpgradeType fromItem(ItemStack stack) {
            if (stack.m_41619_()) {
                return NONE;
            }
            if (stack.m_41720_() instanceof DimensionalBufferItem) {
                return DIMENSIONAL_BUFFER;
            }
            if (stack.m_41720_() instanceof OverheatCooldownReducerItem) {
                return OVERHEAT_COOLDOWN_REDUCER;
            }
            if (stack.m_41720_() instanceof OverheatProbabilityReducerItem) {
                return OVERHEAT_PROBABILITY_REDUCER;
            }
            if (stack.m_41720_() instanceof TemporalStabilizerItem) {
                return TEMPORAL_STABILIZER;
            }
            if (stack.m_41720_() instanceof PortalStabilityUpgradeItem) {
                return PORTAL_STABILITY;
            }
            if (stack.m_41720_() instanceof EgyptianTrackerUpgradeItem) {
                return EGYPTIAN_TRACKER;
            }
            if (stack.m_41720_() instanceof ExodusSeedUpgradeItem) {
                return EXODUS_SEED;
            }
            if (stack.m_41720_() instanceof QuantumRelocatorItem) {
                return EXODUS_SEED;
            }
            if (stack.m_41720_() instanceof DimensionAnchorItem) {
                return DIMENSION_ANCHOR;
            }
            if (stack.m_41720_() instanceof PhaseModulatorItem) {
                return PHASE_MODULATOR;
            }
            if (stack.m_41720_() instanceof CrystalBufferItem) {
                return CRYSTAL_BUFFER;
            }
            if (stack.m_41720_() instanceof AdvancedCrystalBufferItem) {
                return ADVANCED_CRYSTAL_BUFFER;
            }
            if (stack.m_41720_() instanceof UltimateCrystalBufferItem) {
                return ULTIMATE_CRYSTAL_BUFFER;
            }
            return NONE;
        }
    }
}

