/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.hud;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class TimerHudOverlay {
    private static String displayText = "";
    private static long displayUntilTime = 0L;
    private static boolean isWarning = false;

    public static void displayTimeRemaining(long timeLeftTicks, boolean is30Sec, boolean is15Sec) {
        long seconds = timeLeftTicks / 20L;
        if (is30Sec) {
            displayText = "\u00a7e  30 SECONDS LEFT!";
            isWarning = true;
        } else if (is15Sec) {
            displayText = "\u00a7c  15 SECONDS LEFT!";
            isWarning = true;
        } else {
            displayText = "\u00a77Remaining: " + TimerHudOverlay.formatTime(seconds);
            isWarning = false;
        }
        Minecraft mc = Minecraft.m_91087_();
        long displayDuration = is15Sec ? 300L : 100L;
        displayUntilTime = System.currentTimeMillis() + displayDuration * 50L;
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        if (System.currentTimeMillis() < displayUntilTime && !displayText.isEmpty()) {
            Minecraft mc = Minecraft.m_91087_();
            GuiGraphics graphics = event.getGuiGraphics();
            int screenWidth = mc.m_91268_().m_85445_();
            int screenHeight = mc.m_91268_().m_85446_();
            int x = screenWidth / 2;
            int y = screenHeight / 2 - 50;
            int textWidth = mc.f_91062_.m_92895_(displayText);
            int padding = 10;
            int bgX = x - textWidth / 2 - padding;
            int bgY = y - padding;
            int bgWidth = textWidth + padding * 2;
            Objects.requireNonNull(mc.f_91062_);
            int bgHeight = 9 + padding * 2;
            int bgColor = isWarning ? -867958784 : -872415232;
            graphics.m_280509_(bgX, bgY, bgX + bgWidth, bgY + bgHeight, bgColor);
            int borderColor = isWarning ? -65536 : -11184811;
            graphics.m_280509_(bgX, bgY, bgX + bgWidth, bgY + 2, borderColor);
            graphics.m_280509_(bgX, bgY + bgHeight - 2, bgX + bgWidth, bgY + bgHeight, borderColor);
            graphics.m_280509_(bgX, bgY, bgX + 2, bgY + bgHeight, borderColor);
            graphics.m_280509_(bgX + bgWidth - 2, bgY, bgX + bgWidth, bgY + bgHeight, borderColor);
            graphics.m_280137_(mc.f_91062_, displayText, x, y, 0xFFFFFF);
        }
    }

    private static String formatTime(long totalSeconds) {
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (hours > 0L) {
            return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%02dm %02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }
}

