/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.renderer;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.client.ObjMesh;
import com.michelmuscle.slidersmod.client.VortexRenderTypes;
import com.michelmuscle.slidersmod.client.renderer.EgyptianVortexObjRenderer;
import com.michelmuscle.slidersmod.client.renderer.ExodusVortexObjRenderer;
import com.michelmuscle.slidersmod.client.renderer.OgVortexObjRenderer;
import com.michelmuscle.slidersmod.entity.CustomShowcaseVortexObjEntity;
import com.michelmuscle.slidersmod.util.CustomVortexVisuals;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.q_misc_util.my_util.DQuaternion;

public class CustomShowcaseVortexObjRenderer
extends EntityRenderer<CustomShowcaseVortexObjEntity> {
    private final Map<MeshKey, ObjMesh> meshCache = new HashMap<MeshKey, ObjMesh>();
    private final Map<CustomVortexVisuals.ModelVariant, MeshConfig> configs = new EnumMap<CustomVortexVisuals.ModelVariant, MeshConfig>(CustomVortexVisuals.ModelVariant.class);
    private static final ResourceLocation CUSTOM_OG_OBJ = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/customog.obj");
    private static final ResourceLocation CUSTOM_OG_BORDER_TEX = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/customog.png");
    private static final ResourceLocation CUSTOM_EGYPT_OBJ = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/customegypt.obj");
    private static final ResourceLocation CUSTOM_EGYPT_TEX = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/customegypt.png");
    private static final ResourceLocation CUSTOM_EXO_OBJ = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/customexodus.obj");
    private static final ResourceLocation CUSTOM_EXO_TEX = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/customexodus.png");

    public CustomShowcaseVortexObjRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.f_114477_ = 0.0f;
        this.configs.put(CustomVortexVisuals.ModelVariant.CUSTOM_ORIGINAL, new MeshConfig(CUSTOM_OG_OBJ, CUSTOM_OG_BORDER_TEX, OgVortexObjRenderer.SCROLL_SPEED, OgVortexObjRenderer.SCROLL_ANGLE_DEG, RenderPipeline.OG));
        this.configs.put(CustomVortexVisuals.ModelVariant.CUSTOM_EGYPTIAN, new MeshConfig(CUSTOM_EGYPT_OBJ, CUSTOM_EGYPT_TEX, EgyptianVortexObjRenderer.SCROLL_SPEED, EgyptianVortexObjRenderer.SCROLL_ANGLE_DEG, RenderPipeline.EGYPTIAN));
        this.configs.put(CustomVortexVisuals.ModelVariant.CUSTOM_EXODUS, new MeshConfig(CUSTOM_EXO_OBJ, CUSTOM_EXO_TEX, ExodusVortexObjRenderer.SCROLL_SPEED, ExodusVortexObjRenderer.SCROLL_ANGLE_DEG, RenderPipeline.EXODUS));
    }

    public void render(CustomShowcaseVortexObjEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        CustomVortexVisuals.ModelVariant variant = entity.getVariant();
        MeshConfig config = this.configs.get((Object)variant);
        if (config == null) {
            return;
        }
        ObjMesh mesh = this.meshCache.computeIfAbsent(new MeshKey(config.obj()), key -> {
            try {
                return ObjMesh.load(key.resource());
            }
            catch (Exception e) {
                SlidersMod.LOGGER.error("Unable to load custom vortex OBJ {}", (Object)key.resource(), (Object)e);
                return null;
            }
        });
        if (mesh == null) {
            return;
        }
        float time = ((float)entity.m_9236_().m_46467_() + partialTicks) / 20.0f;
        float angle = (float)Math.toRadians(config.scrollAngleDeg());
        float du = ObjMesh.wrap01(time * config.scrollSpeed() * (float)Math.cos(angle));
        float dv = ObjMesh.wrap01(time * config.scrollSpeed() * (float)Math.sin(angle));
        poseStack.m_85836_();
        Quaternionf rotation = CustomShowcaseVortexObjRenderer.buildOrientation(entity.getAxisW(), entity.getAxisH());
        poseStack.m_252781_(rotation);
        poseStack.m_252781_(new Quaternionf().rotateY((float)Math.PI));
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        int tint = entity.getTint();
        int red = tint >> 16 & 0xFF;
        int green = tint >> 8 & 0xFF;
        int blue = tint & 0xFF;
        switch (config.pipeline()) {
            case OG: {
                this.renderOg(mesh, pose, buffer, config.texture(), du, dv, red, green, blue);
                break;
            }
            case EGYPTIAN: {
                this.renderEgyptian(mesh, pose, buffer, config.texture(), du, dv, red, green, blue);
                break;
            }
            case EXODUS: {
                this.renderExodus(mesh, pose, buffer, config.texture(), du, dv, red, green, blue);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderOg(ObjMesh mesh, Matrix4f pose, MultiBufferSource buffer, ResourceLocation texture, float du, float dv, int r, int g, int b) {
        VertexConsumer translucent = buffer.m_6299_(VortexRenderTypes.vortex(texture));
        mesh.drawTinted(translucent, pose, 0xF000F0, du, dv, r, g, b);
        if (OgVortexObjRenderer.GLOW) {
            VertexConsumer glow = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)texture));
            mesh.drawTinted(glow, pose, 0xF000F0, du, dv, r, g, b);
        }
    }

    private void renderEgyptian(ObjMesh mesh, Matrix4f pose, MultiBufferSource buffer, ResourceLocation texture, float du, float dv, int r, int g, int b) {
        boolean prevBoth = ObjMesh.DRAW_BOTH_WINDINGS;
        boolean prevFlat = ObjMesh.FORCE_FLAT_VIEW_NORMAL;
        ObjMesh.DRAW_BOTH_WINDINGS = true;
        ObjMesh.FORCE_FLAT_VIEW_NORMAL = true;
        VertexConsumer translucent = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
        mesh.drawTinted(translucent, pose, 0xF000F0, du, dv, r, g, b);
        if (EgyptianVortexObjRenderer.GLOW) {
            VertexConsumer glow = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)texture));
            mesh.drawTinted(glow, pose, 0xF000F0, du, dv, r, g, b);
        }
        ObjMesh.DRAW_BOTH_WINDINGS = prevBoth;
        ObjMesh.FORCE_FLAT_VIEW_NORMAL = prevFlat;
    }

    private void renderExodus(ObjMesh mesh, Matrix4f pose, MultiBufferSource buffer, ResourceLocation texture, float du, float dv, int r, int g, int b) {
        VertexConsumer translucent = buffer.m_6299_(VortexRenderTypes.vortex(texture));
        mesh.drawTinted(translucent, pose, 0xF000F0, du, dv, r, g, b);
        if (ExodusVortexObjRenderer.GLOW) {
            VertexConsumer glow = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)texture));
            mesh.drawTinted(glow, pose, 0xF000F0, du, dv, r, g, b);
        }
    }

    public ResourceLocation getTextureLocation(CustomShowcaseVortexObjEntity entity) {
        MeshConfig config = this.configs.get((Object)entity.getVariant());
        return config != null ? config.texture() : CUSTOM_OG_BORDER_TEX;
    }

    private static Quaternionf buildOrientation(Vec3 axisW, Vec3 axisH) {
        Vec3 w = CustomShowcaseVortexObjRenderer.normalize(axisW, new Vec3(1.0, 0.0, 0.0));
        Vec3 h = CustomShowcaseVortexObjRenderer.normalize(axisH, new Vec3(0.0, 1.0, 0.0));
        DQuaternion dq = PortalManipulation.getPortalOrientationQuaternion((Vec3)w, (Vec3)h);
        return new Quaternionf((float)dq.x, (float)dq.y, (float)dq.z, (float)dq.w);
    }

    private static Vec3 normalize(Vec3 vec, Vec3 fallback) {
        if (vec.m_82556_() < 1.0E-6) {
            return fallback;
        }
        Vec3 normalized = vec.m_82541_();
        if (normalized.m_82556_() < 1.0E-6) {
            return fallback;
        }
        return normalized;
    }

    private record MeshConfig(ResourceLocation obj, ResourceLocation texture, float scrollSpeed, float scrollAngleDeg, RenderPipeline pipeline) {
    }

    private static enum RenderPipeline {
        OG,
        EGYPTIAN,
        EXODUS;

    }

    private record MeshKey(ResourceLocation resource) {
    }
}

