/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.renderer;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.client.ObjMeshRawUV;
import com.michelmuscle.slidersmod.client.VortexRenderTypes;
import com.michelmuscle.slidersmod.client.renderer.OgVortexObjRenderer;
import com.michelmuscle.slidersmod.entity.OgVortexBackObjEntity;
import com.michelmuscle.slidersmod.util.CustomVortexVisuals;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.q_misc_util.my_util.DQuaternion;

public class OgVortexBackObjRenderer
extends EntityRenderer<OgVortexBackObjEntity> {
    private static final int FRAME_COUNT = 32;
    private static ObjMeshRawUV MESH;
    private static final ResourceLocation OBJ;
    private static final ResourceLocation TEX;
    private static boolean LOGGED_SETUP;
    public static float SCALE;
    public static boolean GLOW;

    public OgVortexBackObjRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.f_114477_ = 0.0f;
    }

    public void render(OgVortexBackObjEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        try {
            if (MESH == null) {
                MESH = ObjMeshRawUV.load(OBJ);
            }
        }
        catch (Exception ignored) {
            return;
        }
        if (!entity.isVisible()) {
            return;
        }
        if (!LOGGED_SETUP) {
            LOGGED_SETUP = true;
            SlidersMod.LOGGER.info("OgVortexBack renderer using {} frames from {}", (Object)32, (Object)TEX);
        }
        float seconds = ((float)entity.m_9236_().m_46467_() + partialTicks) / 20.0f;
        float cycleProgress = seconds - (float)Math.floor(seconds);
        int frame = Math.floorMod((int)(cycleProgress * 32.0f), 32);
        poseStack.m_85836_();
        Quaternionf rotation = OgVortexBackObjRenderer.buildOrientationQuaternion(entity.getAxisW(), entity.getAxisH());
        poseStack.m_252781_(rotation);
        poseStack.m_85841_(SCALE, SCALE, SCALE);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        ResourceLocation texture = OgVortexBackObjRenderer.resolveTexture(entity);
        VertexConsumer translucent = buffer.m_6299_(VortexRenderTypes.vortex(texture));
        if (entity.hasCustomAppearance()) {
            int tint = entity.getCustomTint();
            int red = tint >> 16 & 0xFF;
            int green = tint >> 8 & 0xFF;
            int blue = tint & 0xFF;
            MESH.drawVerticalFrameTinted(translucent, pose, 0xF000F0, frame, 32, red, green, blue);
        } else {
            MESH.drawVerticalFrame(translucent, pose, 0xF000F0, frame, 32);
        }
        if (GLOW) {
            VertexConsumer glow = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)texture));
            if (entity.hasCustomAppearance()) {
                int tint = entity.getCustomTint();
                int red = tint >> 16 & 0xFF;
                int green = tint >> 8 & 0xFF;
                int blue = tint & 0xFF;
                MESH.drawVerticalFrameTinted(glow, pose, 0xF000F0, frame, 32, red, green, blue);
            } else {
                MESH.drawVerticalFrame(glow, pose, 0xF000F0, frame, 32);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(OgVortexBackObjEntity entity) {
        return OgVortexBackObjRenderer.resolveTexture(entity);
    }

    private static ResourceLocation resolveTexture(OgVortexBackObjEntity entity) {
        if (entity.hasCustomAppearance()) {
            return CustomVortexVisuals.resolveEntityTexture(entity.getCustomTextureId(), TEX);
        }
        return TEX;
    }

    private static Quaternionf buildOrientationQuaternion(Vec3 axisW, Vec3 axisH) {
        Vec3 w = OgVortexBackObjRenderer.normalizeOrFallback(axisW, new Vec3(1.0, 0.0, 0.0));
        Vec3 h = OgVortexBackObjRenderer.normalizeOrFallback(axisH, new Vec3(0.0, 1.0, 0.0));
        DQuaternion dq = PortalManipulation.getPortalOrientationQuaternion((Vec3)w, (Vec3)h);
        return new Quaternionf((float)dq.x, (float)dq.y, (float)dq.z, (float)dq.w);
    }

    private static Vec3 normalizeOrFallback(Vec3 vec, Vec3 fallback) {
        if (vec.m_82556_() < 1.0E-6) {
            return fallback;
        }
        Vec3 normalized = vec.m_82541_();
        if (normalized.m_82556_() < 1.0E-6) {
            return fallback;
        }
        return normalized;
    }

    static {
        OBJ = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/backvortex.obj");
        TEX = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/back.png");
        LOGGED_SETUP = false;
        SCALE = OgVortexObjRenderer.SCALE;
        GLOW = OgVortexObjRenderer.GLOW;
    }
}

