/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.sound;

import com.michelmuscle.slidersmod.client.sound.BlockLoopSoundInstance;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class BlockSoundManager {
    private static final Long2ObjectMap<SoundInstance> soundMap = new Long2ObjectOpenHashMap();

    public static void startBlockSound(BlockPos blockPos, SoundEvent soundEvent) {
        long posKey = blockPos.m_121878_();
        SoundInstance existing = (SoundInstance)soundMap.get(posKey);
        if (existing == null || !Minecraft.m_91087_().m_91106_().m_120403_(existing)) {
            BlockLoopSoundInstance sound = new BlockLoopSoundInstance(soundEvent, SoundSource.BLOCKS, blockPos);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
            soundMap.put(posKey, (Object)sound);
        }
    }

    public static void stopBlockSound(BlockPos blockPos) {
        long posKey = blockPos.m_121878_();
        SoundInstance sound = (SoundInstance)soundMap.get(posKey);
        if (sound != null) {
            Minecraft.m_91087_().m_91106_().m_120399_(sound);
            soundMap.remove(posKey);
        }
    }

    public static boolean isSoundPlaying(BlockPos blockPos) {
        long posKey = blockPos.m_121878_();
        SoundInstance sound = (SoundInstance)soundMap.get(posKey);
        return sound != null && Minecraft.m_91087_().m_91106_().m_120403_(sound);
    }

    public static void stopAllBlockSounds() {
        for (SoundInstance sound : soundMap.values()) {
            Minecraft.m_91087_().m_91106_().m_120399_(sound);
        }
        soundMap.clear();
    }

    public static SoundInstance getSoundInstance(BlockPos blockPos) {
        return (SoundInstance)soundMap.get(blockPos.m_121878_());
    }
}

