/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.dimension;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.client.sound.VortexAmbientSoundInstance;
import com.michelmuscle.slidersmod.config.SlidersModConfig;
import com.michelmuscle.slidersmod.dimension.ReturnSchedulerData;
import com.michelmuscle.slidersmod.entity.VortexCollisionObjEntity;
import com.michelmuscle.slidersmod.entity.VortexEntity;
import com.michelmuscle.slidersmod.init.ModEntities;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.CustomTimerDamagedItem;
import com.michelmuscle.slidersmod.item.CustomTimerItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.ExodusTimerItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerItem;
import com.michelmuscle.slidersmod.item.OriginalTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OriginalTimerItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3Item;
import com.michelmuscle.slidersmod.system.ForceVortexManager;
import com.michelmuscle.slidersmod.util.ClassicTimerHelper;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DimensionManager {
    private static final Map<UUID, ReturnInfo> scheduledReturns = new ConcurrentHashMap<UUID, ReturnInfo>();
    private static ReturnSchedulerData persistedReturns;
    public static final String ACTIVE_RETURN_TOKEN_TAG = "ActiveReturnToken";
    private static final Set<String> VANILLA_DIMENSIONS;
    private static final double RETURN_PORTAL_HEIGHT_OFFSET = 2.2;
    private static final int DEFAULT_DIMENSION_TIER = 1;
    public static final int MAX_DIMENSION_TIER = 5;
    private static final String TAG_DIMENSION_TIER = "DimensionTier";
    private static final Map<ResourceLocation, DimensionProfile> DIMENSION_PROFILES;
    private static final Set<ResourceLocation> TIERED_TIMER_ITEMS;

    private static void persistReturn(UUID playerId, ReturnInfo info) {
        if (persistedReturns != null) {
            persistedReturns.setReturn(playerId, info);
        }
    }

    private static void persistRemoval(UUID playerId) {
        if (persistedReturns != null) {
            persistedReturns.removeReturn(playerId);
        }
    }

    private static void registerDimensionProfile(Map<ResourceLocation, DimensionProfile> map, String path, double weight, int tier) {
        ResourceLocation id = new ResourceLocation("slidersmod", path);
        map.put(id, new DimensionProfile(id, weight, tier));
    }

    private static void registerTieredTimer(Set<ResourceLocation> set, String path) {
        set.add(new ResourceLocation("slidersmod", path));
    }

    private static int clampTier(int tier) {
        int maxTier = (Integer)SlidersModConfig.MAX_TIER_ACCESSIBLE.get();
        return Math.max(1, Math.min(tier, maxTier));
    }

    public static boolean isTieredTimer(ItemStack stack) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        return itemId != null && TIERED_TIMER_ITEMS.contains(itemId);
    }

    public static int getTimerTier(ItemStack stack) {
        if (!DimensionManager.isTieredTimer(stack)) {
            return 1;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_DIMENSION_TIER)) {
            return 1;
        }
        return DimensionManager.clampTier(tag.m_128451_(TAG_DIMENSION_TIER));
    }

    public static void setTimerTier(ItemStack stack, int tier) {
        if (!DimensionManager.isTieredTimer(stack)) {
            return;
        }
        int clamped = DimensionManager.clampTier(tier);
        if (clamped <= 1) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_(TAG_DIMENSION_TIER);
            }
            return;
        }
        stack.m_41784_().m_128405_(TAG_DIMENSION_TIER, clamped);
    }

    public static boolean canUpgradeTimerTier(ItemStack stack) {
        int maxTier = (Integer)SlidersModConfig.MAX_TIER_ACCESSIBLE.get();
        return DimensionManager.isTieredTimer(stack) && DimensionManager.getTimerTier(stack) < maxTier;
    }

    public static boolean upgradeTimerTier(ItemStack stack) {
        if (!DimensionManager.canUpgradeTimerTier(stack)) {
            return false;
        }
        DimensionManager.setTimerTier(stack, DimensionManager.getTimerTier(stack) + 1);
        return true;
    }

    public static RandomDestination generateRandomDestination(MinecraftServer server, int dimensionTier) {
        return DimensionManager.generateRandomDestination(server, dimensionTier, false);
    }

    public static RandomDestination generateRandomDestination(MinecraftServer server, int dimensionTier, boolean allowVanilla) {
        Object overworld;
        int clampedTier = DimensionManager.clampTier(dimensionTier);
        ArrayList<ServerLevel> levels = new ArrayList<ServerLevel>();
        if (allowVanilla) {
            SlidersMod.LOGGER.info("Logan's Timer: Using minecraft:overworld only");
            overworld = server.m_129880_(Level.f_46428_);
            if (overworld != null) {
                levels.add((ServerLevel)overworld);
            }
        } else {
            SlidersMod.LOGGER.info("Scanning for mod dimensions (excluding vanilla)...");
            for (ServerLevel level : server.m_129785_()) {
                String dimName = level.m_46472_().m_135782_().toString();
                if (VANILLA_DIMENSIONS.contains(dimName)) {
                    SlidersMod.LOGGER.info("  Skipping vanilla dimension: {}", (Object)dimName);
                    continue;
                }
                SlidersMod.LOGGER.info("  Adding dimension: {}", (Object)dimName);
                levels.add(level);
            }
        }
        if (levels.isEmpty()) {
            SlidersMod.LOGGER.error("No valid dimensions found! Falling back to Overworld.");
            overworld = server.m_129880_(Level.f_46428_);
            if (overworld != null) {
                levels.add((ServerLevel)overworld);
            } else {
                return null;
            }
        }
        SlidersMod.LOGGER.info("Total valid dimensions: {}", (Object)levels.size());
        Random random = new Random();
        ServerLevel targetLevel = DimensionManager.selectWeightedDimension(levels, clampedTier);
        if (targetLevel == null) {
            SlidersMod.LOGGER.error("Failed to select weighted dimension! Falling back to random.");
            targetLevel = (ServerLevel)levels.get(random.nextInt(levels.size()));
        }
        SlidersMod.LOGGER.info("Selected dimension: {}", (Object)targetLevel.m_46472_().m_135782_());
        int x = random.nextInt(1500000) - 750000;
        int z = random.nextInt(1500000) - 750000;
        BlockPos spawnPos = DimensionManager.findSafeSpawnLocation(targetLevel, x, z);
        SlidersMod.LOGGER.info("Destination: {} at {}", (Object)targetLevel.m_46472_().m_135782_(), (Object)spawnPos);
        return new RandomDestination((ResourceKey<Level>)targetLevel.m_46472_(), spawnPos);
    }

    @Nullable
    public static RandomDestination generateRandomDestinationDamaged(MinecraftServer server, int dimensionTier, double overworldChance) {
        if (server == null) {
            return null;
        }
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        if (overworld != null && server.m_129783_().f_46441_.m_188500_() < overworldChance) {
            SlidersMod.LOGGER.info("Damaged timer: rolling overworld escape (chance={})", (Object)overworldChance);
            return DimensionManager.generateDestinationInDimension(server, (ResourceKey<Level>)Level.f_46428_);
        }
        return DimensionManager.generateRandomDestination(server, dimensionTier, false);
    }

    @Nullable
    public static RandomDestination generateDestinationInDimension(MinecraftServer server, ResourceKey<Level> dimensionKey) {
        if (server == null || dimensionKey == null) {
            return null;
        }
        ServerLevel targetLevel = server.m_129880_(dimensionKey);
        if (targetLevel == null) {
            SlidersMod.LOGGER.error("Requested dimension {} is not loaded; cannot generate destination.", (Object)dimensionKey.m_135782_());
            return null;
        }
        Random random = new Random();
        int x = random.nextInt(1500000) - 750000;
        int z = random.nextInt(1500000) - 750000;
        BlockPos spawnPos = DimensionManager.findSafeSpawnLocation(targetLevel, x, z);
        SlidersMod.LOGGER.info("Forced destination for {} resolved at {}", (Object)dimensionKey.m_135782_(), (Object)spawnPos);
        return new RandomDestination(dimensionKey, spawnPos);
    }

    private static ServerLevel selectWeightedDimension(List<ServerLevel> levels, int dimensionTier) {
        if (levels.isEmpty()) {
            return null;
        }
        Random random = new Random();
        double totalWeight = 0.0;
        ArrayList<ServerLevel> validDimensions = new ArrayList<ServerLevel>();
        ArrayList<Double> weights = new ArrayList<Double>();
        ArrayList<DimensionProfile> profilesForLevels = new ArrayList<DimensionProfile>();
        for (ServerLevel level : levels) {
            ResourceLocation dimId = level.m_46472_().m_135782_();
            DimensionProfile profile = DIMENSION_PROFILES.get(dimId);
            if (profile == null) {
                SlidersMod.LOGGER.warn("  Dimension {} not registered for weighted selection", (Object)dimId);
                continue;
            }
            if (profile.tier() > dimensionTier) {
                SlidersMod.LOGGER.info("  Dimension {} is tier {} and exceeds timer tier {}", new Object[]{dimId, profile.tier(), dimensionTier});
                continue;
            }
            double weight = profile.weight();
            if (weight <= 0.0) {
                SlidersMod.LOGGER.warn("  Dimension {} has non-positive weight ({})", (Object)dimId, (Object)weight);
                continue;
            }
            validDimensions.add(level);
            weights.add(weight);
            profilesForLevels.add(profile);
            totalWeight += weight;
            SlidersMod.LOGGER.info("  Dimension {} (tier {}) has weight {}", new Object[]{dimId, profile.tier(), weight});
        }
        if (validDimensions.isEmpty()) {
            SlidersMod.LOGGER.warn("No dimensions with valid weights found for tier {}. Falling back to raw list.", (Object)dimensionTier);
            return levels.isEmpty() ? null : levels.get(random.nextInt(levels.size()));
        }
        double randomValue = random.nextDouble() * totalWeight;
        double cumulativeWeight = 0.0;
        for (int i = 0; i < validDimensions.size(); ++i) {
            if (!(randomValue <= (cumulativeWeight += ((Double)weights.get(i)).doubleValue()))) continue;
            ServerLevel selected = (ServerLevel)validDimensions.get(i);
            DimensionProfile selectedProfile = (DimensionProfile)profilesForLevels.get(i);
            SlidersMod.LOGGER.info("Weighted selection: {} (weight: {}, tier: {})", new Object[]{selected.m_46472_().m_135782_(), weights.get(i), selectedProfile.tier()});
            return selected;
        }
        return (ServerLevel)validDimensions.get(validDimensions.size() - 1);
    }

    public static BlockPos findSafeSpawnLocation(ServerLevel level, int x, int z) {
        BlockPos below;
        BlockPos pos;
        int y;
        int maxHeight = level.m_151558_();
        int minHeight = level.m_141937_();
        boolean isNether = maxHeight <= 128;
        int searchStartY = isNether ? 100 : Math.min(320, maxHeight - 10);
        SlidersMod.LOGGER.info("Searching for spawn in {} dimension, maxHeight={}, searching from Y={}", new Object[]{isNether ? "Nether" : "Overworld", maxHeight, searchStartY});
        for (y = searchStartY; y > minHeight; --y) {
            pos = new BlockPos(x, y, z);
            below = pos.m_7495_();
            BlockPos above = pos.m_7494_();
            if (level.m_8055_(below).m_60795_() || !level.m_8055_(pos).m_60795_() || !level.m_8055_(above).m_60795_()) continue;
            SlidersMod.LOGGER.info("Found safe spawn (Algo 1) at Y={}", (Object)y);
            return pos;
        }
        SlidersMod.LOGGER.info("Algorithm 1 failed, trying Algorithm 2 (dense terrain search)...");
        for (y = Math.max(searchStartY, 3); y > 2; --y) {
            boolean belowIsNotAir;
            pos = new BlockPos(x, y, z);
            below = pos.m_7495_();
            boolean posIsAir = level.m_8055_(pos).m_60795_();
            boolean bl = belowIsNotAir = !level.m_8055_(below).m_60795_();
            if (!belowIsNotAir || !posIsAir) continue;
            SlidersMod.LOGGER.info("Found safe spawn (Algo 2) at Y={}", (Object)y);
            return pos;
        }
        SlidersMod.LOGGER.info("Algorithm 2 failed, trying Algorithm 3 (upward search)...");
        for (y = minHeight + 2; y <= searchStartY; ++y) {
            pos = new BlockPos(x, y, z);
            below = pos.m_7495_();
            BlockPos above = pos.m_7494_();
            if (level.m_8055_(below).m_60795_() || !level.m_8055_(pos).m_60795_() || !level.m_8055_(above).m_60795_()) continue;
            SlidersMod.LOGGER.info("Found safe spawn (Algo 3 - upward) at Y={}", (Object)y);
            return pos;
        }
        SlidersMod.LOGGER.warn("No spawn location found in any algorithm! Using final fallback...");
        int fallbackY = isNether ? 65 : 64;
        BlockPos fallbackPos = new BlockPos(x, fallbackY, z);
        SlidersMod.LOGGER.warn("Fallback position: {}", (Object)fallbackPos);
        return fallbackPos;
    }

    public static void initializePersistentData(MinecraftServer server) {
        persistedReturns = ReturnSchedulerData.get(server);
        scheduledReturns.clear();
        if (persistedReturns != null) {
            scheduledReturns.putAll(persistedReturns.getEntries());
        }
    }

    public static void clearScheduledReturn(UUID playerUUID) {
        scheduledReturns.remove(playerUUID);
        DimensionManager.persistRemoval(playerUUID);
    }

    public static void clearScheduledReturn(ServerPlayer player) {
        ReturnInfo info = scheduledReturns.remove(player.m_20148_());
        if (info != null && info.timerToken != null) {
            DimensionManager.removeReturnToken(player, info.timerToken);
        }
        DimensionManager.persistRemoval(player.m_20148_());
    }

    public static boolean hasScheduledReturn(UUID playerUUID) {
        return scheduledReturns.containsKey(playerUUID);
    }

    public static void scheduleReturn(Player player, ItemStack timerStack, ResourceKey<Level> currentDim, BlockPos currentPos) {
        CompoundTag tag;
        ServerPlayer serverPlayer;
        TimerMatch match;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        long configuredSeconds = ClassicTimerHelper.getConfiguredTime(timerStack);
        long returnGameTime = serverLevel.m_46467_() + configuredSeconds * 20L;
        int timerSlot = -1;
        UUID timerToken = null;
        if (player instanceof ServerPlayer && (match = DimensionManager.findMatchingTimer(serverPlayer = (ServerPlayer)player, timerStack)) != null) {
            timerSlot = match.slot();
            timerToken = UUID.randomUUID();
            DimensionManager.applyReturnToken(serverPlayer, match, timerToken);
        }
        if (!(tag = timerStack.m_41784_()).m_128441_("ReturnDimension") || !tag.m_128441_("ReturnX")) {
            SlidersMod.LOGGER.error("Timer NBT missing return data! Cannot schedule return.");
            SlidersMod.LOGGER.error("NBT content: {}", (Object)tag);
            return;
        }
        String dimString = tag.m_128461_("ReturnDimension");
        if (dimString.isEmpty()) {
            SlidersMod.LOGGER.error("ReturnDimension is empty in timer NBT!");
            return;
        }
        ResourceKey originDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.parse((String)dimString));
        Vec3 originPos = new Vec3(tag.m_128459_("ReturnX"), tag.m_128459_("ReturnY"), tag.m_128459_("ReturnZ"));
        SlidersMod.LOGGER.info("Scheduling return: dim={}, pos={}", (Object)originDim.m_135782_(), (Object)originPos);
        boolean isLoganVortex = tag.m_128471_("IsLoganVortex");
        boolean isExodusVortex = tag.m_128471_("IsExodusVortex");
        boolean isEgyptianVortex = tag.m_128471_("IsEgyptianVortex");
        boolean isProtoVortex = tag.m_128471_("IsProtoVortex");
        String customModelId = "";
        String customTextureId = "";
        int customTint = 0xFFFFFF;
        if (timerStack.m_41720_() instanceof CustomTimerItem) {
            CustomTimerItem.ensureVisualDefaults(timerStack);
            customModelId = CustomTimerItem.getSelectedModelVariant(timerStack).id();
            customTextureId = CustomTimerItem.getSelectedTextureVariant(timerStack).id();
            customTint = CustomTimerItem.getCustomTint(timerStack);
        }
        int portalDurationTicks = TimerUpgradeData.hasPortalStabilityUpgrade(timerStack) ? TimerUpgradeData.getPortalDurationTicks(timerStack) : TimerUpgradeData.getDefaultPortalDurationTicks();
        int returnDurationTicks = TimerUpgradeData.hasPortalStabilityUpgrade(timerStack) ? TimerUpgradeData.getReturnPortalDurationTicks(timerStack) : TimerUpgradeData.getDefaultReturnDurationTicks();
        ReturnInfo returnInfo = new ReturnInfo(returnGameTime, (ResourceKey<Level>)originDim, originPos, currentDim, currentPos, isLoganVortex, isExodusVortex, isEgyptianVortex, isProtoVortex, timerSlot, timerToken, customModelId, customTextureId, customTint, portalDurationTicks, returnDurationTicks);
        scheduledReturns.put(player.m_20148_(), returnInfo);
        DimensionManager.persistReturn(player.m_20148_(), returnInfo);
        SlidersMod.LOGGER.info("Scheduled return for player {} at game time {} (IsLoganVortex={})", new Object[]{player.m_7755_().getString(), returnGameTime, isLoganVortex});
    }

    @Nullable
    private static TimerMatch findMatchingTimer(ServerPlayer player, ItemStack reference) {
        if (reference == null || reference.m_41619_()) {
            return null;
        }
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (!DimensionManager.isSameTimerStack(stack, reference)) continue;
            return new TimerMatch(i, stack);
        }
        return null;
    }

    @Nullable
    private static TimerMatch findTimerByToken(ServerPlayer player, UUID token) {
        if (token == null) {
            return null;
        }
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            CompoundTag tag = stack.m_41783_();
            if (tag == null || !tag.m_128403_(ACTIVE_RETURN_TOKEN_TAG) || !token.equals(tag.m_128342_(ACTIVE_RETURN_TOKEN_TAG))) continue;
            return new TimerMatch(i, stack);
        }
        return null;
    }

    public static ItemStack findTimerStackByToken(ServerPlayer player, UUID token) {
        TimerMatch match = DimensionManager.findTimerByToken(player, token);
        return match != null ? match.stack() : ItemStack.f_41583_;
    }

    private static void applyReturnToken(ServerPlayer player, TimerMatch match, UUID token) {
        if (token == null || match == null) {
            return;
        }
        ItemStack stack = match.stack();
        stack.m_41784_().m_128362_(ACTIVE_RETURN_TOKEN_TAG, token);
        player.m_150109_().m_6836_(match.slot(), stack);
    }

    public static void removeReturnToken(ServerPlayer player, UUID token) {
        if (token == null) {
            return;
        }
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            CompoundTag tag = stack.m_41783_();
            if (tag == null || !tag.m_128403_(ACTIVE_RETURN_TOKEN_TAG) || !token.equals(tag.m_128342_(ACTIVE_RETURN_TOKEN_TAG))) continue;
            tag.m_128473_(ACTIVE_RETURN_TOKEN_TAG);
            player.m_150109_().m_6836_(i, stack);
            break;
        }
    }

    private static boolean isSameTimerStack(ItemStack stack, ItemStack reference) {
        return !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)reference);
    }

    public static void tick(MinecraftServer server) {
        Iterator<Map.Entry<UUID, ReturnInfo>> iterator = scheduledReturns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ReturnInfo> entry = iterator.next();
            UUID playerUUID = entry.getKey();
            ReturnInfo returnInfo = entry.getValue();
            ServerPlayer player = server.m_6846_().m_11259_(playerUUID);
            if (player == null) {
                iterator.remove();
                DimensionManager.persistRemoval(playerUUID);
                continue;
            }
            ServerLevel currentLevel = (ServerLevel)player.m_9236_();
            long currentTime = currentLevel.m_46467_();
            long timeLeft = returnInfo.returnGameTime - currentTime;
            if (timeLeft <= 200L && timeLeft > 0L && timeLeft % 20L == 0L) {
                player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)SoundEvents.f_12215_.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (timeLeft > 0L) continue;
            DimensionManager.openReturnVortex(player, returnInfo, currentLevel);
            iterator.remove();
            DimensionManager.persistRemoval(playerUUID);
        }
    }

    private static void openReturnVortex(ServerPlayer player, ReturnInfo returnInfo, ServerLevel currentLevel) {
        Vec3 playerPos = player.m_20182_();
        double yaw = Math.toRadians(player.m_146908_() + 180.0f);
        double x = playerPos.f_82479_ + Math.sin(yaw) * 3.0;
        double z = playerPos.f_82481_ + Math.cos(yaw) * 3.0;
        Vec3 vortexPos = new Vec3(x, playerPos.f_82480_, z);
        SlidersMod.LOGGER.info("Opening return vortex for player {} at {} (IsLoganVortex={})", new Object[]{player.m_7755_().getString(), vortexPos, returnInfo.isLoganVortex});
        currentLevel.m_5594_(null, new BlockPos((int)vortexPos.f_82479_, (int)vortexPos.f_82480_, (int)vortexPos.f_82481_), (SoundEvent)ModSounds.VORTEX_INCOMING.get(), SoundSource.AMBIENT, 1.5f, 1.0f);
        ReturnVortexEntity returnVortex = new ReturnVortexEntity(currentLevel, vortexPos.f_82479_, vortexPos.f_82480_ + 2.2, vortexPos.f_82481_, returnInfo.originDimension, returnInfo.originPos, player.m_20148_(), returnInfo.isLoganVortex, returnInfo.isExodusVortex, returnInfo.isEgyptianVortex, returnInfo.isProtoVortex, returnInfo.timerSlot, returnInfo.timerToken, returnInfo.customModelId, returnInfo.customTextureId, returnInfo.customTint, returnInfo.returnDurationTicks);
        currentLevel.m_7967_((Entity)returnVortex);
        Vec3 portalCenter = new Vec3(vortexPos.f_82479_, vortexPos.f_82480_ + 2.2, vortexPos.f_82481_);
        Vec3 facingVector = portalCenter.m_82546_(player.m_20182_());
        if (facingVector.m_82556_() < 1.0E-4) {
            facingVector = player.m_20154_().m_82490_(-1.0);
        }
        if (facingVector.m_82556_() < 1.0E-4) {
            facingVector = new Vec3(0.0, 0.0, 1.0);
        }
        Vec3 frontNormal = player.m_20182_().m_82546_(portalCenter);
        returnVortex.setPortalFacing(frontNormal);
        returnVortex.spawnOgVisuals(currentLevel, portalCenter, facingVector);
        int returnSeconds = Math.max(1, returnInfo.returnDurationTicks / 20);
        player.m_5661_((Component)Component.m_237113_((String)("Return vortex opening! You have " + returnSeconds + " seconds!")), true);
    }

    static {
        VANILLA_DIMENSIONS = Set.of("minecraft:overworld", "minecraft:the_nether", "minecraft:the_end");
        LinkedHashMap<ResourceLocation, DimensionProfile> profiles = new LinkedHashMap<ResourceLocation, DimensionProfile>();
        DimensionManager.registerDimensionProfile(profiles, "alternate_overworld", 25.0, 1);
        DimensionManager.registerDimensionProfile(profiles, "badlands", 10.0, 1);
        DimensionManager.registerDimensionProfile(profiles, "peaceful_overworld", 5.0, 1);
        DimensionManager.registerDimensionProfile(profiles, "desert_world", 5.0, 1);
        DimensionManager.registerDimensionProfile(profiles, "ocean_world", 5.0, 1);
        DimensionManager.registerDimensionProfile(profiles, "jungle_world", 5.0, 1);
        DimensionManager.registerDimensionProfile(profiles, "plains_world", 5.0, 1);
        DimensionManager.registerDimensionProfile(profiles, "amplified_world", 6.0, 2);
        DimensionManager.registerDimensionProfile(profiles, "prairies_colossales", 6.0, 2);
        DimensionManager.registerDimensionProfile(profiles, "frozen_world", 6.0, 2);
        DimensionManager.registerDimensionProfile(profiles, "felina", 6.0, 2);
        DimensionManager.registerDimensionProfile(profiles, "mushroom_world", 5.0, 2);
        DimensionManager.registerDimensionProfile(profiles, "flat_world", 4.0, 3);
        DimensionManager.registerDimensionProfile(profiles, "sommets_aurore", 4.0, 3);
        DimensionManager.registerDimensionProfile(profiles, "iles_inverses", 4.0, 3);
        DimensionManager.registerDimensionProfile(profiles, "skylands_world", 8.0, 3);
        DimensionManager.registerDimensionProfile(profiles, "pillager_dimension", 6.0, 3);
        DimensionManager.registerDimensionProfile(profiles, "twilight_world", 3.0, 4);
        DimensionManager.registerDimensionProfile(profiles, "eldoggo", 3.0, 4);
        DimensionManager.registerDimensionProfile(profiles, "mousson", 3.0, 4);
        DimensionManager.registerDimensionProfile(profiles, "vendavel", 3.0, 4);
        DimensionManager.registerDimensionProfile(profiles, "sablier", 2.0, 5);
        DimensionManager.registerDimensionProfile(profiles, "necropole", 2.0, 5);
        DimensionManager.registerDimensionProfile(profiles, "alternate1", 2.0, 5);
        DimensionManager.registerDimensionProfile(profiles, "eclipse", 2.0, 5);
        DIMENSION_PROFILES = Collections.unmodifiableMap(profiles);
        HashSet<ResourceLocation> tieredItems = new HashSet<ResourceLocation>();
        DimensionManager.registerTieredTimer(tieredItems, "original_timer");
        DimensionManager.registerTieredTimer(tieredItems, "original_timer_damaged");
        DimensionManager.registerTieredTimer(tieredItems, "original_timer_stuck");
        DimensionManager.registerTieredTimer(tieredItems, "exodus_timer");
        DimensionManager.registerTieredTimer(tieredItems, "exodus_timer_damaged");
        DimensionManager.registerTieredTimer(tieredItems, "exodus_timer_stuck");
        DimensionManager.registerTieredTimer(tieredItems, "egyptian_timer");
        DimensionManager.registerTieredTimer(tieredItems, "egyptian_timer_damaged");
        DimensionManager.registerTieredTimer(tieredItems, "egyptian_timer_stuck");
        TIERED_TIMER_ITEMS = Set.copyOf(tieredItems);
    }

    public static class ReturnInfo {
        public final long returnGameTime;
        public final ResourceKey<Level> originDimension;
        public final Vec3 originPos;
        public final ResourceKey<Level> currentDimension;
        public final BlockPos currentPos;
        public final boolean isLoganVortex;
        public final boolean isExodusVortex;
        public final boolean isEgyptianVortex;
        public final boolean isProtoVortex;
        public final int timerSlot;
        public final UUID timerToken;
        public final String customModelId;
        public final String customTextureId;
        public final int customTint;
        public final int portalDurationTicks;
        public final int returnDurationTicks;

        public ReturnInfo(long returnGameTime, ResourceKey<Level> originDimension, Vec3 originPos, ResourceKey<Level> currentDimension, BlockPos currentPos) {
            this(returnGameTime, originDimension, originPos, currentDimension, currentPos, false, false, false, false, -1, null);
        }

        public ReturnInfo(long returnGameTime, ResourceKey<Level> originDimension, Vec3 originPos, ResourceKey<Level> currentDimension, BlockPos currentPos, boolean isLoganVortex) {
            this(returnGameTime, originDimension, originPos, currentDimension, currentPos, isLoganVortex, false, false, false, -1, null);
        }

        public ReturnInfo(long returnGameTime, ResourceKey<Level> originDimension, Vec3 originPos, ResourceKey<Level> currentDimension, BlockPos currentPos, boolean isLoganVortex, boolean isExodusVortex) {
            this(returnGameTime, originDimension, originPos, currentDimension, currentPos, isLoganVortex, isExodusVortex, false, false, -1, null);
        }

        public ReturnInfo(long returnGameTime, ResourceKey<Level> originDimension, Vec3 originPos, ResourceKey<Level> currentDimension, BlockPos currentPos, boolean isLoganVortex, boolean isExodusVortex, boolean isEgyptianVortex) {
            this(returnGameTime, originDimension, originPos, currentDimension, currentPos, isLoganVortex, isExodusVortex, isEgyptianVortex, false, -1, null);
        }

        public ReturnInfo(long returnGameTime, ResourceKey<Level> originDimension, Vec3 originPos, ResourceKey<Level> currentDimension, BlockPos currentPos, boolean isLoganVortex, boolean isExodusVortex, boolean isEgyptianVortex, boolean isProtoVortex, int timerSlot, UUID timerToken) {
            this(returnGameTime, originDimension, originPos, currentDimension, currentPos, isLoganVortex, isExodusVortex, isEgyptianVortex, isProtoVortex, timerSlot, timerToken, "", "", 0xFFFFFF, TimerUpgradeData.getDefaultPortalDurationTicks(), TimerUpgradeData.getDefaultReturnDurationTicks());
        }

        public ReturnInfo(long returnGameTime, ResourceKey<Level> originDimension, Vec3 originPos, ResourceKey<Level> currentDimension, BlockPos currentPos, boolean isLoganVortex, boolean isExodusVortex, boolean isEgyptianVortex, boolean isProtoVortex, int timerSlot, UUID timerToken, String customModelId, String customTextureId, int customTint) {
            this(returnGameTime, originDimension, originPos, currentDimension, currentPos, isLoganVortex, isExodusVortex, isEgyptianVortex, isProtoVortex, timerSlot, timerToken, customModelId, customTextureId, customTint, TimerUpgradeData.getDefaultPortalDurationTicks(), TimerUpgradeData.getDefaultReturnDurationTicks());
        }

        public ReturnInfo(long returnGameTime, ResourceKey<Level> originDimension, Vec3 originPos, ResourceKey<Level> currentDimension, BlockPos currentPos, boolean isLoganVortex, boolean isExodusVortex, boolean isEgyptianVortex, boolean isProtoVortex, int timerSlot, UUID timerToken, String customModelId, String customTextureId, int customTint, int portalDurationTicks, int returnDurationTicks) {
            this.returnGameTime = returnGameTime;
            this.originDimension = originDimension;
            this.originPos = originPos;
            this.currentDimension = currentDimension;
            this.currentPos = currentPos;
            this.isLoganVortex = isLoganVortex;
            this.isExodusVortex = isExodusVortex;
            this.isEgyptianVortex = isEgyptianVortex;
            this.isProtoVortex = isProtoVortex;
            this.timerSlot = timerSlot;
            this.timerToken = timerToken;
            this.customModelId = customModelId == null ? "" : customModelId;
            this.customTextureId = customTextureId == null ? "" : customTextureId;
            this.customTint = customTint;
            this.portalDurationTicks = portalDurationTicks;
            this.returnDurationTicks = returnDurationTicks;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("ReturnGameTime", this.returnGameTime);
            tag.m_128359_("OriginDimension", this.originDimension.m_135782_().toString());
            tag.m_128347_("OriginX", this.originPos.f_82479_);
            tag.m_128347_("OriginY", this.originPos.f_82480_);
            tag.m_128347_("OriginZ", this.originPos.f_82481_);
            tag.m_128359_("CurrentDimension", this.currentDimension.m_135782_().toString());
            tag.m_128405_("CurrentX", this.currentPos.m_123341_());
            tag.m_128405_("CurrentY", this.currentPos.m_123342_());
            tag.m_128405_("CurrentZ", this.currentPos.m_123343_());
            tag.m_128379_("IsLogan", this.isLoganVortex);
            tag.m_128379_("IsExodus", this.isExodusVortex);
            tag.m_128379_("IsEgyptian", this.isEgyptianVortex);
            tag.m_128379_("IsProto", this.isProtoVortex);
            tag.m_128405_("TimerSlot", this.timerSlot);
            if (this.timerToken != null) {
                tag.m_128362_("TimerToken", this.timerToken);
            }
            tag.m_128359_("CustomModelId", this.customModelId == null ? "" : this.customModelId);
            tag.m_128359_("CustomTextureId", this.customTextureId == null ? "" : this.customTextureId);
            tag.m_128405_("CustomTint", this.customTint);
            tag.m_128405_("PortalDurationTicks", this.portalDurationTicks);
            tag.m_128405_("ReturnDurationTicks", this.returnDurationTicks);
            return tag;
        }

        @Nullable
        public static ReturnInfo deserialize(CompoundTag tag) {
            if (!tag.m_128441_("OriginDimension") || !tag.m_128441_("CurrentDimension")) {
                return null;
            }
            ResourceLocation originId = ResourceLocation.parse((String)tag.m_128461_("OriginDimension"));
            ResourceLocation currentId = ResourceLocation.parse((String)tag.m_128461_("CurrentDimension"));
            ResourceKey originDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)originId);
            ResourceKey currentDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)currentId);
            Vec3 originPos = new Vec3(tag.m_128459_("OriginX"), tag.m_128459_("OriginY"), tag.m_128459_("OriginZ"));
            BlockPos currentPos = new BlockPos(tag.m_128451_("CurrentX"), tag.m_128451_("CurrentY"), tag.m_128451_("CurrentZ"));
            long returnTime = tag.m_128454_("ReturnGameTime");
            boolean logan = tag.m_128471_("IsLogan");
            boolean exodus = tag.m_128471_("IsExodus");
            boolean egyptian = tag.m_128471_("IsEgyptian");
            boolean proto = tag.m_128471_("IsProto");
            int timerSlot = tag.m_128451_("TimerSlot");
            UUID token = tag.m_128403_("TimerToken") ? tag.m_128342_("TimerToken") : null;
            String customModel = tag.m_128441_("CustomModelId") ? tag.m_128461_("CustomModelId") : "";
            String customTexture = tag.m_128441_("CustomTextureId") ? tag.m_128461_("CustomTextureId") : "";
            int tint = tag.m_128441_("CustomTint") ? tag.m_128451_("CustomTint") : 0xFFFFFF;
            int portalTicks = tag.m_128441_("PortalDurationTicks") ? tag.m_128451_("PortalDurationTicks") : TimerUpgradeData.getDefaultPortalDurationTicks();
            int returnTicks = tag.m_128441_("ReturnDurationTicks") ? tag.m_128451_("ReturnDurationTicks") : TimerUpgradeData.getDefaultReturnDurationTicks();
            return new ReturnInfo(returnTime, (ResourceKey<Level>)originDim, originPos, (ResourceKey<Level>)currentDim, currentPos, logan, exodus, egyptian, proto, timerSlot, token, customModel, customTexture, tint, portalTicks, returnTicks);
        }
    }

    private record DimensionProfile(ResourceLocation id, double weight, int tier) {
    }

    public static class RandomDestination {
        public final ResourceKey<Level> dimension;
        public final BlockPos pos;

        public RandomDestination(ResourceKey<Level> dimension, BlockPos pos) {
            this.dimension = dimension;
            this.pos = pos;
        }
    }

    private record TimerMatch(int slot, ItemStack stack) {
    }

    public static class ReturnVortexEntity
    extends VortexEntity {
        private static final int RETURN_VORTEX_LIFETIME = 200;
        private static final float PULL_RADIUS = 5.0f;
        private static final float PULL_STRENGTH = 0.15f;
        private static final float TELEPORT_RADIUS = 2.25f;
        private static final float NON_OWNER_TELEPORT_RADIUS = 1.25f;
        private static final int TELEPORT_DELAY_TICKS = 1;
        private static final double BACK_COLLIDER_VERTICAL_SHIFT = -0.8;
        private ResourceKey<Level> returnDimension;
        private Vec3 returnPos;
        private UUID ownerUUID;
        private boolean hasTeleported = false;
        private int teleportedTick = 0;
        private boolean pendingTeleport = false;
        private int pendingTeleportDelay = 0;
        private int backCollisionCooldown = 0;
        private Vec3 portalFacingNormal = new Vec3(0.0, 0.0, 1.0);
        private boolean isLoganVortex = false;
        private boolean isExodusVortex = false;
        private boolean isEgyptianVortex = false;
        private boolean isProtoVortex = false;
        private final int scheduledTimerSlot;
        @Nullable
        private final UUID scheduledTimerToken;
        private final String customModelId;
        private final String customTextureId;
        private final int customTint;
        private int configuredReturnLifetimeTicks;

        public ReturnVortexEntity(EntityType<?> type, Level level) {
            super(type, level);
            this.scheduledTimerSlot = -1;
            this.scheduledTimerToken = null;
            this.customModelId = "";
            this.customTextureId = "";
            this.customTint = 0xFFFFFF;
            this.configuredReturnLifetimeTicks = 200;
        }

        public ReturnVortexEntity(ServerLevel level, double x, double y, double z, ResourceKey<Level> returnDim, Vec3 returnPos, UUID ownerUUID) {
            this(level, x, y, z, returnDim, returnPos, ownerUUID, false, false, false, false, -1, null, "", "", 0xFFFFFF, 200);
        }

        public ReturnVortexEntity(ServerLevel level, double x, double y, double z, ResourceKey<Level> returnDim, Vec3 returnPos, UUID ownerUUID, boolean isLoganVortex) {
            this(level, x, y, z, returnDim, returnPos, ownerUUID, isLoganVortex, false, false, false, -1, null, "", "", 0xFFFFFF, 200);
        }

        public ReturnVortexEntity(ServerLevel level, double x, double y, double z, ResourceKey<Level> returnDim, Vec3 returnPos, UUID ownerUUID, boolean isLoganVortex, boolean isExodusVortex) {
            this(level, x, y, z, returnDim, returnPos, ownerUUID, isLoganVortex, isExodusVortex, false, false, -1, null, "", "", 0xFFFFFF, 200);
        }

        public ReturnVortexEntity(ServerLevel level, double x, double y, double z, ResourceKey<Level> returnDim, Vec3 returnPos, UUID ownerUUID, boolean isLoganVortex, boolean isExodusVortex, boolean isEgyptianVortex) {
            this(level, x, y, z, returnDim, returnPos, ownerUUID, isLoganVortex, isExodusVortex, isEgyptianVortex, false, -1, null, "", "", 0xFFFFFF, 200);
        }

        public ReturnVortexEntity(ServerLevel level, double x, double y, double z, ResourceKey<Level> returnDim, Vec3 returnPos, UUID ownerUUID, boolean isLoganVortex, boolean isExodusVortex, boolean isEgyptianVortex, boolean isProtoVortex, int timerSlot, @Nullable UUID timerToken) {
            this(level, x, y, z, returnDim, returnPos, ownerUUID, isLoganVortex, isExodusVortex, isEgyptianVortex, isProtoVortex, timerSlot, timerToken, "", "", 0xFFFFFF, 200);
        }

        public ReturnVortexEntity(ServerLevel level, double x, double y, double z, ResourceKey<Level> returnDim, Vec3 returnPos, UUID ownerUUID, boolean isLoganVortex, boolean isExodusVortex, boolean isEgyptianVortex, boolean isProtoVortex, int timerSlot, @Nullable UUID timerToken, String customModelId, String customTextureId, int customTint, int configuredReturnLifetimeTicks) {
            super((EntityType)ModEntities.VORTEX_ENTITY.get(), (Level)level);
            this.m_6034_(x, y, z);
            this.returnDimension = returnDim;
            this.returnPos = returnPos;
            this.ownerUUID = ownerUUID;
            this.isLoganVortex = isLoganVortex;
            this.isExodusVortex = isExodusVortex;
            this.isEgyptianVortex = isEgyptianVortex;
            this.isProtoVortex = isProtoVortex;
            this.scheduledTimerSlot = timerSlot;
            this.scheduledTimerToken = timerToken;
            this.customModelId = customModelId == null ? "" : customModelId;
            this.customTextureId = customTextureId == null ? "" : customTextureId;
            this.customTint = customTint;
            this.configuredReturnLifetimeTicks = this.sanitizeReturnLifetime(configuredReturnLifetimeTicks);
            this.enforceFixedLifetime(level, this.getReturnLifetimeLimit());
            this.f_19794_ = true;
            this.hasTeleported = false;
            this.teleportedTick = 0;
            this.enableFrontCollisionVolume = false;
            this.enableBackCollisionVolume = true;
            this.f_19804_.m_135381_(IS_LOGAN_VORTEX, (Object)isLoganVortex);
            this.f_19804_.m_135381_(IS_EXODUS_VORTEX, (Object)isExodusVortex);
            this.f_19804_.m_135381_(IS_EGYPTIAN_VORTEX, (Object)isEgyptianVortex);
            this.f_19804_.m_135381_(IS_PROTO_VORTEX, (Object)isProtoVortex);
            this.setCustomModelId(this.customModelId);
            this.setCustomTextureId(this.customTextureId);
            this.setCustomTint(this.customTint);
            SlidersMod.LOGGER.info("ReturnVortexEntity created for player {} at {}, {}, {} (IsLoganVortex={}, IsExodusVortex={}, IsEgyptianVortex={}, IsProtoVortex={})", new Object[]{ownerUUID, x, y, z, isLoganVortex, isExodusVortex, isEgyptianVortex, isProtoVortex});
            SlidersMod.LOGGER.info("Return destination: {} at {}", (Object)returnDim.m_135782_(), (Object)returnPos);
        }

        private int sanitizeReturnLifetime(int requestedTicks) {
            return requestedTicks > 0 ? requestedTicks : 200;
        }

        private int getReturnLifetimeLimit() {
            return this.sanitizeReturnLifetime(this.configuredReturnLifetimeTicks);
        }

        @Override
        protected void m_8097_() {
            super.m_8097_();
            if (!this.f_19804_.m_135352_()) {
                this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)true);
                this.f_19804_.m_135381_(LIFETIME, (Object)0);
            }
        }

        @Override
        public void spawnOgVisuals(ServerLevel level, Vec3 center, Vec3 facing) {
            super.spawnOgVisuals(level, center, facing);
            this.adjustBackColliderHeight(level);
        }

        private void adjustBackColliderHeight(ServerLevel level) {
            if (this.backCollisionEntityId == null) {
                return;
            }
            Entity entity = level.m_8791_(this.backCollisionEntityId);
            if (entity instanceof VortexCollisionObjEntity) {
                VortexCollisionObjEntity collider = (VortexCollisionObjEntity)entity;
                Vec3 shifted = collider.m_20182_().m_82520_(0.0, -0.8, 0.0);
                collider.m_7678_(shifted.f_82479_, shifted.f_82480_, shifted.f_82481_, collider.m_146908_(), collider.m_146909_());
            }
        }

        @Override
        protected void handleBackCollision(Player player, ServerLevel serverLevel, VortexCollisionObjEntity collider) {
            super.handleBackCollision(player, serverLevel, collider);
            this.cancelPendingTeleport("back collision triggered by " + player.m_7755_().getString());
            this.backCollisionCooldown = Math.max(this.backCollisionCooldown, 2);
        }

        public void setPortalFacing(Vec3 facing) {
            Vec3 normalized = facing.m_82541_();
            if (normalized.m_82556_() < 1.0E-4) {
                normalized = new Vec3(0.0, 0.0, 1.0);
            }
            this.portalFacingNormal = normalized;
        }

        private void queueTeleport(ServerPlayer owner, double distance) {
            if (this.pendingTeleport || this.hasTeleported) {
                return;
            }
            this.pendingTeleport = true;
            this.pendingTeleportDelay = 1;
            SlidersMod.LOGGER.info("Player {} triggered return vortex {}; teleport scheduled in {} tick(s) (distance={})", new Object[]{owner.m_7755_().getString(), this.m_20148_(), 1, distance});
        }

        private void cancelPendingTeleport(String reason) {
            if (!this.pendingTeleport) {
                return;
            }
            SlidersMod.LOGGER.info("Pending teleport for return vortex {} cancelled: {}", (Object)this.m_20148_(), (Object)reason);
            this.pendingTeleport = false;
            this.pendingTeleportDelay = 0;
        }

        private boolean handlePendingTeleport(ServerLevel serverLevel, @Nullable ServerPlayer owner, int lifetime) {
            if (!this.pendingTeleport) {
                return false;
            }
            if (owner == null) {
                this.cancelPendingTeleport("owner missing");
                return false;
            }
            if (this.pendingTeleportDelay > 0) {
                --this.pendingTeleportDelay;
                return false;
            }
            if (!this.isPlayerInFront(owner)) {
                this.cancelPendingTeleport("player moved behind portal during delay");
                this.backCollisionCooldown = Math.max(this.backCollisionCooldown, 2);
                return false;
            }
            double confirmationDistance = owner.m_20270_((Entity)this);
            if (confirmationDistance > 2.25) {
                this.cancelPendingTeleport("player moved to distance " + confirmationDistance);
                return false;
            }
            this.performTeleport(serverLevel, owner, lifetime);
            return true;
        }

        private boolean isPlayerInFront(ServerPlayer owner) {
            Vec3 horizontalFacing = new Vec3(this.portalFacingNormal.f_82479_, 0.0, this.portalFacingNormal.f_82481_);
            Vec3 toPlayer = new Vec3(owner.m_20185_() - this.m_20185_(), 0.0, owner.m_20189_() - this.m_20189_());
            if (horizontalFacing.m_82556_() < 1.0E-4 || toPlayer.m_82556_() < 1.0E-4) {
                return true;
            }
            Vec3 normFacing = horizontalFacing.m_82541_();
            Vec3 normPlayer = toPlayer.m_82541_();
            double dot = normFacing.m_82526_(normPlayer);
            SlidersMod.LOGGER.info("Return vortex {} front-check dot={} (player {})", new Object[]{this.m_20148_(), dot, owner.m_7755_().getString()});
            return dot > 0.0;
        }

        private void performTeleport(ServerLevel serverLevel, ServerPlayer owner, int lifetime) {
            this.pendingTeleport = false;
            this.hasTeleported = true;
            this.teleportedTick = lifetime;
            if (this.returnDimension == null || this.returnPos == null) {
                SlidersMod.LOGGER.error("Return vortex {} is missing destination data at teleport time", (Object)this.m_20148_());
                this.requestCloseWithAnimation();
                return;
            }
            ServerLevel targetLevel = serverLevel.m_7654_().m_129880_(this.returnDimension);
            if (targetLevel == null) {
                SlidersMod.LOGGER.error("Return vortex {} cannot resolve target dimension {}", (Object)this.m_20148_(), (Object)this.returnDimension.m_135782_());
                this.requestCloseWithAnimation();
                return;
            }
            SlidersMod.LOGGER.info("Teleporting to {} at {}", (Object)this.returnDimension.m_135782_(), (Object)this.returnPos);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 12, 0.2, 0.4, 0.2, 0.01);
            owner.m_264318_(targetLevel, this.returnPos.f_82479_, this.returnPos.f_82480_, this.returnPos.f_82481_, Set.of(), owner.m_146908_(), owner.m_146909_());
            Vec3 lookDirection = owner.m_20154_();
            owner.m_20334_(lookDirection.f_82479_ * 0.25, 0.2, lookDirection.f_82481_ * 0.25);
            owner.f_19864_ = true;
            this.tryAwardSlideEnhancementChip(owner);
            targetLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.returnPos.f_82479_, this.returnPos.f_82480_ + 1.0, this.returnPos.f_82481_, 12, 0.2, 0.4, 0.2, 0.01);
            owner.m_6330_((SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.PLAYERS, 3.0f, 1.0f);
            serverLevel.m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            targetLevel.m_5594_(null, new BlockPos((int)this.returnPos.f_82479_, (int)this.returnPos.f_82480_, (int)this.returnPos.f_82481_), (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            VortexEntity aestheticVortex = new VortexEntity((Level)targetLevel, this.returnPos.f_82479_, this.returnPos.f_82480_ + 2.2, this.returnPos.f_82481_, true, true, this.isLoganVortex, this.isExodusVortex, this.isEgyptianVortex, this.isProtoVortex);
            aestheticVortex.setCustomModelId(this.customModelId);
            aestheticVortex.setCustomTextureId(this.customTextureId);
            aestheticVortex.setCustomTint(this.customTint);
            SlidersMod.LOGGER.info("Aesthetic vortex at return created: IsLoganVortex={}, IsExodusVortex={}, IsEgyptianVortex={}, IsProtoVortex={}", new Object[]{this.isLoganVortex, this.isExodusVortex, this.isEgyptianVortex, this.isProtoVortex});
            aestheticVortex.grantBackCollisionImmunity(owner.m_20148_(), 100);
            targetLevel.m_7967_((Entity)aestheticVortex);
            aestheticVortex.initializeLifetimeWindow(targetLevel, true);
            aestheticVortex.applyFixedLifetime(targetLevel, this.getReturnLifetimeLimit());
            Vec3 aestheticCenter = new Vec3(this.returnPos.f_82479_, this.returnPos.f_82480_ + 2.2, this.returnPos.f_82481_);
            Vec3 aestheticFacing = owner.m_20154_().m_82490_(-1.0);
            if (aestheticFacing.m_82556_() < 1.0E-4) {
                aestheticFacing = aestheticCenter.m_82546_(owner.m_20182_());
            }
            if (aestheticFacing.m_82556_() < 1.0E-4) {
                aestheticFacing = new Vec3(0.0, 0.0, 1.0);
            }
            aestheticVortex.spawnOgVisuals(targetLevel, aestheticCenter, aestheticFacing);
            owner.m_5661_((Component)Component.m_237113_((String)"Returned to origin!").m_130940_(ChatFormatting.GREEN), true);
            ItemStack timerStack = this.findTimerInInventory(owner);
            if (timerStack != null && !timerStack.m_41619_()) {
                SlidersMod.LOGGER.info("Found timer to reset: {}", (Object)timerStack.m_41720_().getClass().getSimpleName());
                SlidersMod.LOGGER.info("Timer NBT before reset: {}", (Object)timerStack.m_41784_());
                ReturnVortexEntity.resetTimerByType(timerStack);
                SlidersMod.LOGGER.info("Timer NBT after reset: {}", (Object)timerStack.m_41784_());
                if (!ReturnVortexEntity.isDamagedTimer(timerStack)) {
                    ReturnVortexEntity.setCooldownOverheat(timerStack, owner.m_9236_());
                    SlidersMod.LOGGER.info("Applied 5-minute cooldown after return vortex traversal");
                    owner.m_5661_((Component)Component.m_237113_((String)"Returned to origin - Timer cooling down (5min)").m_130940_(ChatFormatting.GOLD), true);
                } else {
                    SlidersMod.LOGGER.info("Damaged timer reset (no cooldown applied)");
                    owner.m_5661_((Component)Component.m_237113_((String)"Returned to origin - Timer reset").m_130940_(ChatFormatting.GREEN), true);
                }
                int timerSlot = this.findTimerSlot(owner);
                if (timerSlot >= 0) {
                    owner.m_150109_().m_6836_(timerSlot, timerStack);
                    SlidersMod.LOGGER.info("Updated inventory slot {} with reset timer", (Object)timerSlot);
                }
                owner.f_36095_.m_38946_();
                SlidersMod.LOGGER.info("Forced inventory sync to client after timer reset");
            } else {
                SlidersMod.LOGGER.warn("No timer found to reset in inventory!");
            }
            DimensionManager.clearScheduledReturn(owner);
            SlidersMod.LOGGER.info("Teleportation complete!");
        }

        @Override
        public void m_8119_() {
            Level level;
            if (this.closingAnimationStarted) {
                super.m_8119_();
                return;
            }
            this.m_6075_();
            if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                AABB bounds = new AABB(this.m_20185_() - 1.5, this.m_20186_() - 1.5, this.m_20189_() - 1.5, this.m_20185_() + 1.5, this.m_20186_() + 1.5, this.m_20189_() + 1.5);
                List nearbyPlayers = serverLevel.m_6249_((Entity)this, bounds, entity -> entity instanceof Player && entity.m_6084_());
                this.processBackCollisions(serverLevel, nearbyPlayers);
                int lifetime = (Integer)this.f_19804_.m_135370_(LIFETIME);
                if (this.backCollisionCooldown > 0) {
                    --this.backCollisionCooldown;
                }
                if (this.hasTeleported) {
                    this.f_19804_.m_135381_(LIFETIME, (Object)(++lifetime));
                }
                if (this.ownerUUID == null) {
                    SlidersMod.LOGGER.error("ReturnVortexEntity has null ownerUUID! Discarding.");
                    this.requestCloseWithAnimation();
                    return;
                }
                if (this.returnDimension == null || this.returnPos == null) {
                    SlidersMod.LOGGER.error("ReturnVortexEntity has null return data! Discarding.");
                    this.requestCloseWithAnimation();
                    return;
                }
                ServerPlayer owner = serverLevel.m_7654_().m_6846_().m_11259_(this.ownerUUID);
                if (this.handlePendingTeleport(serverLevel, owner, lifetime)) {
                    return;
                }
                if (owner != null) {
                    double distance = owner.m_20270_((Entity)this);
                    if (distance <= 2.25 && !this.pendingTeleport && this.backCollisionCooldown == 0) {
                        if (!this.isPlayerInFront(owner)) {
                            SlidersMod.LOGGER.info("Player {} is behind return vortex {} (distance={}), skipping teleport queue", new Object[]{owner.m_7755_().getString(), this.m_20148_(), distance});
                        } else {
                            SlidersMod.LOGGER.info("Player {} touched return vortex at distance {}! Teleport queued...", (Object)owner.m_7755_().getString(), (Object)distance);
                            if (this.returnPos.f_82479_ == 0.0 && this.returnPos.f_82480_ == 0.0 && this.returnPos.f_82481_ == 0.0) {
                                SlidersMod.LOGGER.error("Return position is (0,0,0)! Cannot teleport. Resetting timer.");
                                owner.m_5661_((Component)Component.m_237113_((String)"Return data corrupted! Timer reset.").m_130940_(ChatFormatting.RED), true);
                                ItemStack timerStack = this.findTimerInInventory(owner);
                                if (timerStack != null && !timerStack.m_41619_()) {
                                    ReturnVortexEntity.resetTimerByType(timerStack);
                                }
                                DimensionManager.removeReturnToken(owner, this.scheduledTimerToken);
                                DimensionManager.clearScheduledReturn(owner);
                                this.requestCloseWithAnimation();
                                return;
                            }
                            this.queueTeleport(owner, distance);
                        }
                    }
                    if (!this.pendingTeleport && distance <= 5.0) {
                        Vec3 toVortex = this.m_20182_().m_82546_(owner.m_20182_()).m_82541_();
                        owner.m_20256_(owner.m_20184_().m_82549_(toVortex.m_82490_((double)0.15f)));
                    }
                } else {
                    SlidersMod.LOGGER.warn("Return vortex {} owner not found on server!", (Object)this.m_20148_());
                    if (lifetime > 40) {
                        this.requestCloseWithAnimation();
                        return;
                    }
                }
                this.teleportNearbyEntitiesAndItems(serverLevel);
                this.f_19804_.m_135381_(LIFETIME, (Object)(++lifetime));
                if (lifetime >= this.getReturnLifetimeLimit()) {
                    SlidersMod.LOGGER.info("Return vortex closing after {} ticks (timeout)", (Object)lifetime);
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.VORTEX_CLOSE.get(), SoundSource.AMBIENT, 1.5f, 1.0f);
                    if (owner != null) {
                        if (!this.hasTeleported) {
                            this.transformTimerToDamaged(owner, serverLevel);
                        }
                        DimensionManager.clearScheduledReturn(owner);
                    }
                    this.requestCloseWithAnimation();
                }
            } else if (this.m_9236_().f_46443_ && this.f_19797_ == 1) {
                Minecraft minecraft = Minecraft.m_91087_();
                VortexAmbientSoundInstance soundInstance = new VortexAmbientSoundInstance(this);
                minecraft.m_91106_().m_120367_((SoundInstance)soundInstance);
                SlidersMod.LOGGER.info("Return vortex ambient sound instance started");
            }
        }

        private ItemStack findTimerInInventory(ServerPlayer player) {
            TimerMatch match = this.findActiveTimerMatch(player);
            if (match != null) {
                SlidersMod.LOGGER.info("Found ACTIVE timer: {} at slot {}", (Object)match.stack().m_41720_().getClass().getSimpleName(), (Object)match.slot());
                return match.stack();
            }
            SlidersMod.LOGGER.warn("No active timer found in inventory!");
            return ItemStack.f_41583_;
        }

        private int findTimerSlot(ServerPlayer player) {
            TimerMatch match = this.findActiveTimerMatch(player);
            if (match != null) {
                return match.slot();
            }
            return -1;
        }

        @Nullable
        private TimerMatch resolveScheduledTimerMatch(ServerPlayer player) {
            ItemStack stack;
            TimerMatch match = DimensionManager.findTimerByToken(player, this.scheduledTimerToken);
            if (match != null) {
                return match;
            }
            if (this.scheduledTimerSlot >= 0 && this.scheduledTimerSlot < player.m_150109_().f_35974_.size() && !(stack = (ItemStack)player.m_150109_().f_35974_.get(this.scheduledTimerSlot)).m_41619_()) {
                return new TimerMatch(this.scheduledTimerSlot, stack);
            }
            return this.findActiveTimerMatch(player);
        }

        @Nullable
        private TimerMatch findActiveTimerMatch(ServerPlayer player) {
            for (int slot = 0; slot < player.m_150109_().f_35974_.size(); ++slot) {
                CompoundTag tag;
                ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(slot);
                if (stack.m_41619_() || !this.isTimerCandidate(stack) || !(tag = stack.m_41784_()).m_128471_("IsActive")) continue;
                return new TimerMatch(slot, stack);
            }
            return null;
        }

        private boolean isTimerCandidate(ItemStack stack) {
            return ClassicTimerHelper.isBaseTimer(stack) || stack.m_41720_() instanceof LoganTimerItem || stack.m_41720_() instanceof UpgradedLoganTimerTier1Item || stack.m_41720_() instanceof UpgradedLoganTimerTier2Item || stack.m_41720_() instanceof UpgradedLoganTimerTier3Item || stack.m_41720_() instanceof ExodusTimerItem || stack.m_41720_() instanceof EgyptianTimerItem;
        }

        private ItemStack createDamagedTimer(ItemStack timerStack, ServerLevel level) {
            Item item = timerStack.m_41720_();
            if (item instanceof LoganTimerItem) {
                ItemStack damaged = new ItemStack((ItemLike)ModItems.LOGAN_TIMER_DAMAGED.get());
                LoganTimerDamagedItem.initializeDamagedTimer(damaged, (Level)level);
                return damaged;
            }
            if (item instanceof UpgradedLoganTimerTier1Item) {
                int tierX = timerStack.m_41784_().m_128451_("ConfiguredX");
                int tierZ = timerStack.m_41784_().m_128451_("ConfiguredZ");
                ItemStack damaged = new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER1_DAMAGED.get());
                UpgradedLoganTimerTier1DamagedItem.initializeDamagedTimer(damaged, (Level)level, tierX, tierZ);
                return damaged;
            }
            if (item instanceof UpgradedLoganTimerTier2Item) {
                int tierX = timerStack.m_41784_().m_128451_("ConfiguredX");
                int tierZ = timerStack.m_41784_().m_128451_("ConfiguredZ");
                ItemStack damaged = new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER2_DAMAGED.get());
                UpgradedLoganTimerTier2DamagedItem.initializeDamagedTimer(damaged, (Level)level, tierX, tierZ);
                return damaged;
            }
            if (item instanceof UpgradedLoganTimerTier3Item) {
                int tierX = timerStack.m_41784_().m_128451_("ConfiguredX");
                int tierZ = timerStack.m_41784_().m_128451_("ConfiguredZ");
                ItemStack damaged = new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER3_DAMAGED.get());
                UpgradedLoganTimerTier3DamagedItem.initializeDamagedTimer(damaged, (Level)level, tierX, tierZ);
                return damaged;
            }
            if (item instanceof ExodusTimerItem) {
                String seed = timerStack.m_41784_().m_128461_("ConfiguredSeed");
                ItemStack damaged = new ItemStack((ItemLike)ModItems.EXODUS_TIMER_DAMAGED.get());
                ExodusTimerDamagedItem.initializeDamagedTimer(damaged, (Level)level, seed);
                return damaged;
            }
            if (item instanceof EgyptianTimerItem) {
                ItemStack damaged = new ItemStack((ItemLike)ModItems.EGYPTIAN_TIMER_DAMAGED.get());
                EgyptianTimerDamagedItem.initializeDamagedTimer(damaged, (Level)level);
                return damaged;
            }
            if (item instanceof CustomTimerItem) {
                ItemStack damaged = new ItemStack((ItemLike)ModItems.CUSTOM_TIMER_DAMAGED.get());
                CustomTimerDamagedItem.initializeDamagedTimer(damaged, (Level)level);
                return damaged;
            }
            ItemStack damaged = new ItemStack((ItemLike)ModItems.ORIGINAL_TIMER_DAMAGED.get());
            OriginalTimerDamagedItem.initializeDamagedTimer(damaged, (Level)level);
            return damaged;
        }

        private static void resetTimerByType(ItemStack timerStack) {
            if (timerStack.m_41720_() instanceof EgyptianTimerItem) {
                EgyptianTimerItem.resetTimer(timerStack);
            } else if (timerStack.m_41720_() instanceof ExodusTimerItem) {
                ExodusTimerItem.resetTimer(timerStack);
            } else if (timerStack.m_41720_() instanceof LoganTimerItem || timerStack.m_41720_() instanceof UpgradedLoganTimerTier1Item || timerStack.m_41720_() instanceof UpgradedLoganTimerTier2Item || timerStack.m_41720_() instanceof UpgradedLoganTimerTier3Item) {
                LoganTimerItem.resetTimer(timerStack);
            } else if (timerStack.m_41720_() instanceof CustomTimerItem) {
                CustomTimerItem.resetTimer(timerStack);
            } else {
                OriginalTimerItem.resetTimer(timerStack);
            }
        }

        private static boolean isDamagedTimer(ItemStack stack) {
            Item item = stack.m_41720_();
            return item instanceof OriginalTimerDamagedItem || item instanceof CustomTimerDamagedItem || item instanceof LoganTimerDamagedItem || item instanceof ExodusTimerDamagedItem || item instanceof EgyptianTimerDamagedItem || item instanceof UpgradedLoganTimerTier1DamagedItem || item instanceof UpgradedLoganTimerTier2DamagedItem || item instanceof UpgradedLoganTimerTier3DamagedItem;
        }

        private static void setCooldownOverheat(ItemStack stack, Level level) {
            ClassicTimerHelper.startCooldownOverheat(stack, level);
        }

        private void transformTimerToDamaged(ServerPlayer player, ServerLevel level) {
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.TIMER_BURNOUT.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
            ForceVortexManager.scheduleBurnoutParticles(player.m_20148_(), player.m_9236_().m_46467_() + 40L);
            TimerMatch match = this.resolveScheduledTimerMatch(player);
            ItemStack timerStack = ItemStack.f_41583_;
            int timerSlot = -1;
            if (match != null) {
                timerStack = match.stack();
                timerSlot = match.slot();
            } else {
                ItemStack active = this.findTimerInInventory(player);
                if (!active.m_41619_()) {
                    timerStack = active;
                    timerSlot = player.m_150109_().m_36030_(active);
                }
            }
            if (timerStack.m_41619_() || timerSlot < 0) {
                SlidersMod.LOGGER.warn("Could not find timer in inventory for damaged transformation!");
                return;
            }
            SlidersMod.LOGGER.info("Return vortex missed! Transforming {} timer to damaged", (Object)timerStack.m_41720_().getClass().getSimpleName());
            ItemStack damagedTimer = this.createDamagedTimer(timerStack, level);
            DimensionManager.removeReturnToken(player, this.scheduledTimerToken);
            player.m_150109_().m_6836_(timerSlot, damagedTimer);
            player.m_5661_((Component)Component.m_237113_((String)"Return vortex missed! Timer is now DAMAGED!"), false);
            SlidersMod.LOGGER.info("Timer transformed to damaged for player {}", (Object)player.m_7755_().getString());
        }

        @Override
        protected void m_7378_(CompoundTag tag) {
            super.m_7378_(tag);
            if (tag.m_128441_("ReturnDimension")) {
                this.returnDimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.parse((String)tag.m_128461_("ReturnDimension")));
            }
            if (tag.m_128441_("ReturnX")) {
                this.returnPos = new Vec3(tag.m_128459_("ReturnX"), tag.m_128459_("ReturnY"), tag.m_128459_("ReturnZ"));
            }
            if (tag.m_128403_("OwnerUUID")) {
                this.ownerUUID = tag.m_128342_("OwnerUUID");
            }
            this.hasTeleported = tag.m_128471_("HasTeleported");
            this.teleportedTick = tag.m_128451_("TeleportedTick");
            this.isLoganVortex = tag.m_128471_("IsLoganVortex");
            this.isExodusVortex = tag.m_128471_("IsExodusVortex");
            this.isEgyptianVortex = tag.m_128471_("IsEgyptianVortex");
            this.isProtoVortex = tag.m_128471_("IsProtoVortex");
            this.f_19804_.m_135381_(IS_LOGAN_VORTEX, (Object)this.isLoganVortex);
            this.f_19804_.m_135381_(IS_EXODUS_VORTEX, (Object)this.isExodusVortex);
            this.f_19804_.m_135381_(IS_EGYPTIAN_VORTEX, (Object)this.isEgyptianVortex);
            this.f_19804_.m_135381_(IS_PROTO_VORTEX, (Object)this.isProtoVortex);
            this.configuredReturnLifetimeTicks = this.sanitizeReturnLifetime(tag.m_128451_("ReturnLifetimeTicks"));
        }

        @Override
        protected void m_7380_(CompoundTag tag) {
            super.m_7380_(tag);
            if (this.returnDimension != null) {
                tag.m_128359_("ReturnDimension", this.returnDimension.m_135782_().toString());
            }
            if (this.returnPos != null) {
                tag.m_128347_("ReturnX", this.returnPos.f_82479_);
                tag.m_128347_("ReturnY", this.returnPos.f_82480_);
                tag.m_128347_("ReturnZ", this.returnPos.f_82481_);
            }
            if (this.ownerUUID != null) {
                tag.m_128362_("OwnerUUID", this.ownerUUID);
            }
            tag.m_128379_("HasTeleported", this.hasTeleported);
            tag.m_128405_("TeleportedTick", this.teleportedTick);
            tag.m_128379_("IsLoganVortex", this.isLoganVortex);
            tag.m_128379_("IsExodusVortex", this.isExodusVortex);
            tag.m_128379_("IsEgyptianVortex", this.isEgyptianVortex);
            tag.m_128379_("IsProtoVortex", this.isProtoVortex);
            tag.m_128405_("ReturnLifetimeTicks", this.getReturnLifetimeLimit());
        }

        private void teleportNearbyEntitiesAndItems(ServerLevel serverLevel) {
            if (this.returnDimension == null || this.returnPos == null) {
                return;
            }
            ServerLevel targetLevel = serverLevel.m_7654_().m_129880_(this.returnDimension);
            if (targetLevel == null) {
                return;
            }
            List nearbyEntities = serverLevel.m_6443_(Entity.class, this.m_20191_().m_82400_(1.25), entity -> entity != this && (!(entity instanceof Player) || !entity.m_20148_().equals(this.ownerUUID)));
            for (Entity entity2 : nearbyEntities) {
                LivingEntity livingEntity;
                if (entity2 instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)entity2;
                    this.teleportItemToReturn(itemEntity, serverLevel, targetLevel);
                    continue;
                }
                if (!(entity2 instanceof LivingEntity) || !this.isEntityInFront((Entity)(livingEntity = (LivingEntity)entity2))) continue;
                this.teleportLivingEntityToReturn(livingEntity, serverLevel, targetLevel);
            }
        }

        private boolean isEntityInFront(Entity entity) {
            Vec3 normEntity;
            Vec3 horizontalFacing = new Vec3(this.portalFacingNormal.f_82479_, 0.0, this.portalFacingNormal.f_82481_);
            Vec3 toEntity = new Vec3(entity.m_20185_() - this.m_20185_(), 0.0, entity.m_20189_() - this.m_20189_());
            if (horizontalFacing.m_82556_() < 1.0E-4 || toEntity.m_82556_() < 1.0E-4) {
                return true;
            }
            Vec3 normFacing = horizontalFacing.m_82541_();
            double dot = normFacing.m_82526_(normEntity = toEntity.m_82541_());
            return dot > 0.0;
        }

        private void teleportLivingEntityToReturn(LivingEntity entity, ServerLevel serverLevel, ServerLevel targetLevel) {
            entity.m_264318_(targetLevel, this.returnPos.f_82479_, this.returnPos.f_82480_, this.returnPos.f_82481_, Set.of(), entity.m_146908_(), entity.m_146909_());
            Vec3 lookDirection = entity.m_20154_();
            entity.m_20334_(lookDirection.f_82479_ * 0.25, 0.15, lookDirection.f_82481_ * 0.25);
            entity.f_19864_ = true;
            serverLevel.m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            targetLevel.m_5594_(null, new BlockPos((int)this.returnPos.f_82479_, (int)this.returnPos.f_82480_, (int)this.returnPos.f_82481_), (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            SlidersMod.LOGGER.info("Teleported entity {} through return vortex to {}", (Object)entity.m_7755_().getString(), (Object)this.returnPos);
        }

        private void teleportItemToReturn(ItemEntity itemEntity, ServerLevel serverLevel, ServerLevel targetLevel) {
            ItemEntity newItem = new ItemEntity((Level)targetLevel, this.returnPos.f_82479_, this.returnPos.f_82480_, this.returnPos.f_82481_, itemEntity.m_32055_().m_41777_());
            newItem.m_20256_(itemEntity.m_20184_());
            targetLevel.m_7967_((Entity)newItem);
            itemEntity.m_146870_();
            serverLevel.m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            targetLevel.m_5594_(null, new BlockPos((int)this.returnPos.f_82479_, (int)this.returnPos.f_82480_, (int)this.returnPos.f_82481_), (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            SlidersMod.LOGGER.info("Teleported item {} through return vortex to {}", (Object)itemEntity.m_32055_().m_41611_().getString(), (Object)this.returnPos);
        }

        @Override
        public Packet<ClientGamePacketListener> m_5654_() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }
    }
}

