/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.events;

import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OriginalTimerDamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="slidersmod")
public class TestDamagedCommand {
    private static final SimpleCommandExceptionType INVALID_TIMER = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Timer endommag  inconnu."));

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder<CommandSourceStack> damagedBranch = TestDamagedCommand.buildDamagedBranch();
        LiteralCommandNode<CommandSourceStack> root = TestDamagedCommand.getOrCreateSlidersRoot((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        root.addChild((CommandNode)damagedBranch.build());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildDamagedBranch() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"givedamaged").executes(ctx -> TestDamagedCommand.executeLegacy((CommandSourceStack)ctx.getSource()));
        builder.then(Commands.m_82129_((String)"timer", (ArgumentType)StringArgumentType.word()).suggests((ctx, suggestionBuilder) -> SharedSuggestionProvider.m_82970_(DamagedTimerType.ids(), (SuggestionsBuilder)suggestionBuilder)).then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1, (int)86400)).executes(ctx -> TestDamagedCommand.executeGiven((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"timer"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds")))));
        return builder;
    }

    private static LiteralCommandNode<CommandSourceStack> getOrCreateSlidersRoot(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandNode existing = dispatcher.getRoot().getChild("sliders");
        if (existing instanceof LiteralCommandNode) {
            LiteralCommandNode literal = (LiteralCommandNode)existing;
            return literal;
        }
        LiteralCommandNode root = ((LiteralArgumentBuilder)Commands.m_82127_((String)"sliders").requires(src -> src.m_6761_(2))).build();
        dispatcher.getRoot().addChild((CommandNode)root);
        return root;
    }

    private static int executeLegacy(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ItemStack stack = new ItemStack((ItemLike)ModItems.ORIGINAL_TIMER_DAMAGED.get());
        OriginalTimerDamagedItem.initializeDamagedTimer(stack, player.m_9236_());
        player.m_36356_(stack);
        player.m_5661_((Component)Component.m_237113_((String)"\u00a7aGiven damaged Original timer with random duration!"), false);
        return 1;
    }

    private static int executeGiven(CommandSourceStack source, String timerId, int seconds) throws CommandSyntaxException {
        DamagedTimerType type = DamagedTimerType.fromId(timerId);
        if (type == null) {
            throw INVALID_TIMER.create();
        }
        ServerPlayer player = source.m_81375_();
        long ticks = (long)seconds * 20L;
        ItemStack stack = new ItemStack((ItemLike)type.item().get());
        type.initialize(stack, player);
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_("RemainingTime", ticks);
        tag.m_128356_("ActivationTime", player.m_9236_().m_46467_());
        tag.m_128379_("VortexWindowActive", false);
        tag.m_128379_("VortexOpened", false);
        type.postAdjust(stack, player);
        player.m_36356_(stack);
        player.m_5661_((Component)Component.m_237113_((String)("\u00a7aGiven " + type.displayName() + " damaged timer with \u00a76" + seconds + "s\u00a7a remaining!")), false);
        return 1;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum DamagedTimerType {
        ORIGINAL("original", (RegistryObject)ModItems.ORIGINAL_TIMER_DAMAGED){

            @Override
            void initialize(ItemStack stack, ServerPlayer player) {
                OriginalTimerDamagedItem.initializeDamagedTimer(stack, player.m_9236_());
            }
        }
        ,
        LOGAN("logan", (RegistryObject)ModItems.LOGAN_TIMER_DAMAGED){

            @Override
            void initialize(ItemStack stack, ServerPlayer player) {
                LoganTimerDamagedItem.initializeDamagedTimer(stack, player.m_9236_());
            }
        }
        ,
        EXODUS("exodus", (RegistryObject)ModItems.EXODUS_TIMER_DAMAGED){

            @Override
            void initialize(ItemStack stack, ServerPlayer player) {
                ExodusTimerDamagedItem.initializeDamagedTimer(stack, player.m_9236_(), "codex_test");
            }
        }
        ,
        EGYPTIAN("egyptian", (RegistryObject)ModItems.EGYPTIAN_TIMER_DAMAGED){

            @Override
            void initialize(ItemStack stack, ServerPlayer player) {
                EgyptianTimerDamagedItem.initializeDamagedTimer(stack, player.m_9236_());
            }
        }
        ,
        LOGAN_TIER1("logan_tier1", (RegistryObject)ModItems.UPGRADED_LOGAN_TIMER_TIER1_DAMAGED){

            @Override
            void initialize(ItemStack stack, ServerPlayer player) {
                BlockPos pos = player.m_20183_();
                UpgradedLoganTimerTier1DamagedItem.initializeDamagedTimer(stack, player.m_9236_(), pos.m_123341_(), pos.m_123343_());
            }

            @Override
            String displayName() {
                return "Logan Tier 1";
            }
        }
        ,
        LOGAN_TIER2("logan_tier2", (RegistryObject)ModItems.UPGRADED_LOGAN_TIMER_TIER2_DAMAGED){

            @Override
            void initialize(ItemStack stack, ServerPlayer player) {
                BlockPos pos = player.m_20183_();
                UpgradedLoganTimerTier2DamagedItem.initializeDamagedTimer(stack, player.m_9236_(), pos.m_123341_(), pos.m_123343_());
            }

            @Override
            String displayName() {
                return "Logan Tier 2";
            }
        }
        ,
        LOGAN_TIER3("logan_tier3", (RegistryObject)ModItems.UPGRADED_LOGAN_TIMER_TIER3_DAMAGED){

            @Override
            void initialize(ItemStack stack, ServerPlayer player) {
                BlockPos pos = player.m_20183_();
                UpgradedLoganTimerTier3DamagedItem.initializeDamagedTimer(stack, player.m_9236_(), pos.m_123341_(), pos.m_123343_());
            }

            @Override
            String displayName() {
                return "Logan Tier 3";
            }
        };

        private final String id;
        private final RegistryObject<Item> item;

        private DamagedTimerType(String id, RegistryObject<Item> item) {
            this.id = id;
            this.item = item;
        }

        static DamagedTimerType fromId(String id) {
            for (DamagedTimerType type : DamagedTimerType.values()) {
                if (!type.id.equalsIgnoreCase(id)) continue;
                return type;
            }
            return null;
        }

        static List<String> ids() {
            return Arrays.stream(DamagedTimerType.values()).map(type -> type.id).collect(Collectors.toList());
        }

        RegistryObject<Item> item() {
            return this.item;
        }

        void initialize(ItemStack stack, ServerPlayer player) {
        }

        void postAdjust(ItemStack stack, ServerPlayer player) {
        }

        String displayName() {
            return this.id.substring(0, 1).toUpperCase(Locale.ROOT) + this.id.substring(1);
        }
    }
}

