/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class EnergyBarRenderer {
    private static final ResourceLocation BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/bar.png");
    private static final int BAR_WIDTH = 8;
    private static final int BAR_HEIGHT = 50;
    private static final int EMPTY_BAR_U = 0;
    private static final int FULL_BAR_U = 9;
    private static final int BAR_V = 0;

    public static void renderEnergyBar(GuiGraphics graphics, int x, int y, int energyPercent) {
        energyPercent = Math.max(0, Math.min(100, energyPercent));
        graphics.m_280163_(BAR_TEXTURE, x, y, 0.0f, 0.0f, 8, 50, 18, 50);
        if (energyPercent > 0) {
            int fullBarHeight = energyPercent * 50 / 100;
            int yOffset = 50 - fullBarHeight;
            graphics.m_280163_(BAR_TEXTURE, x, y + yOffset, 9.0f, (float)(0 + yOffset), 8, fullBarHeight, 18, 50);
        }
    }

    public static void renderEnergyBarScaled(GuiGraphics graphics, int x, int y, int scaledWidth, int scaledHeight, int energyPercent) {
        energyPercent = Math.max(0, Math.min(100, energyPercent));
        graphics.m_280163_(BAR_TEXTURE, x, y, 0.0f, 0.0f, scaledWidth, scaledHeight, 18, 50);
        if (energyPercent > 0) {
            int fullBarHeight = energyPercent * scaledHeight / 100;
            int yOffset = scaledHeight - fullBarHeight;
            graphics.m_280163_(BAR_TEXTURE, x, y + yOffset, 9.0f, (float)(0 + yOffset), scaledWidth, fullBarHeight, 18, 50);
        }
    }

    public static int getBarWidth() {
        return 8;
    }

    public static int getBarHeight() {
        return 50;
    }
}

