/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.menu;

import com.michelmuscle.slidersmod.block.entity.TimerWorkbenchBlockEntity;
import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.init.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class TimerWorkbenchMenu
extends AbstractContainerMenu {
    private static final int PLAYER_INV_SLOT_COUNT = 36;
    private static final int MACHINE_SLOT_INDEX = 36;
    private static final int UPGRADE_SLOT_INDEX = 37;
    private static final int OUTPUT_SLOT_INDEX = 38;
    private final TimerWorkbenchBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public TimerWorkbenchMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(3));
    }

    public TimerWorkbenchMenu(int containerId, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.TIMER_WORKBENCH_MENU.get(), containerId);
        if (!(entity instanceof TimerWorkbenchBlockEntity)) {
            throw new IllegalStateException("TimerWorkbenchMenu created without correct block entity");
        }
        final TimerWorkbenchBlockEntity workbench = (TimerWorkbenchBlockEntity)entity;
        this.blockEntity = workbench;
        this.level = inventory.f_35978_.m_9236_();
        this.data = data;
        TimerWorkbenchMenu.m_38869_((Container)workbench, (int)3);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.m_38897_(new Slot(workbench, 0, 44, 34){

            public boolean m_5857_(ItemStack stack) {
                return workbench.m_7013_(0, stack);
            }
        });
        this.m_38897_(new Slot(workbench, 1, 80, 34){

            public boolean m_5857_(ItemStack stack) {
                return workbench.m_7013_(1, stack);
            }
        });
        this.m_38897_(new Slot(workbench, 2, 134, 34){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38884_(data);
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = 400;
        if (maxProgress == 0 || progress == 0) {
            return 0;
        }
        return progress * 24 / maxProgress;
    }

    public int getScaledEnergy() {
        int energy = this.data.m_6413_(1);
        int maxEnergy = this.blockEntity.getMaxEnergyStored();
        if (maxEnergy == 0) {
            return 0;
        }
        return energy * 52 / maxEnergy;
    }

    public boolean isProcessing() {
        return this.data.m_6413_(2) != 0;
    }

    public int getEnergy() {
        return this.data.m_6413_(1);
    }

    public int getMaxEnergy() {
        return this.blockEntity.getMaxEnergyStored();
    }

    public int getEnergyPerTick() {
        return TimerWorkbenchBlockEntity.getEnergyPerTick();
    }

    public int getEnergyPerOperation() {
        return TimerWorkbenchBlockEntity.getEnergyPerOperation();
    }

    @Nullable
    public Component getStatusMessage() {
        ItemStack timerStack = ((Slot)this.f_38839_.get(36)).m_7993_();
        ItemStack upgradeStack = ((Slot)this.f_38839_.get(37)).m_7993_();
        ItemStack outputStack = ((Slot)this.f_38839_.get(38)).m_7993_();
        if (!outputStack.m_41619_()) {
            return Component.m_237115_((String)"gui.slidersmod.timer_workbench.status.output_full");
        }
        if (timerStack.m_41619_()) {
            return null;
        }
        if (!DimensionManager.isTieredTimer(timerStack)) {
            return Component.m_237115_((String)"gui.slidersmod.timer_workbench.status.unsupported");
        }
        if (upgradeStack.m_41619_()) {
            return null;
        }
        TimerWorkbenchBlockEntity.UpgradeType type = TimerWorkbenchBlockEntity.UpgradeType.fromItem(upgradeStack);
        if (type == TimerWorkbenchBlockEntity.UpgradeType.DIMENSIONAL_BUFFER && !DimensionManager.canUpgradeTimerTier(timerStack)) {
            return Component.m_237115_((String)"gui.slidersmod.timer_workbench.status.max_tier");
        }
        return null;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            itemstack = stackInSlot.m_41777_();
            if (index < 36 ? !this.m_38903_(stackInSlot, 36, 39, false) : !this.m_38903_(stackInSlot, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return TimerWorkbenchMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public TimerWorkbenchBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public BlockPos getBlockPos() {
        return this.blockEntity.m_58899_();
    }
}

