/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.client.effect.EgyptianLightningEffect;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class EgyptianLightningPacket {
    private final double startX;
    private final double startY;
    private final double startZ;
    private final double endX;
    private final double endY;
    private final double endZ;

    public EgyptianLightningPacket(Vec3 start, Vec3 end) {
        this.startX = start.f_82479_;
        this.startY = start.f_82480_;
        this.startZ = start.f_82481_;
        this.endX = end.f_82479_;
        this.endY = end.f_82480_;
        this.endZ = end.f_82481_;
    }

    public static void encode(EgyptianLightningPacket packet, FriendlyByteBuf buf) {
        buf.writeDouble(packet.startX);
        buf.writeDouble(packet.startY);
        buf.writeDouble(packet.startZ);
        buf.writeDouble(packet.endX);
        buf.writeDouble(packet.endY);
        buf.writeDouble(packet.endZ);
    }

    public static EgyptianLightningPacket decode(FriendlyByteBuf buf) {
        double startX = buf.readDouble();
        double startY = buf.readDouble();
        double startZ = buf.readDouble();
        double endX = buf.readDouble();
        double endY = buf.readDouble();
        double endZ = buf.readDouble();
        Vec3 start = new Vec3(startX, startY, startZ);
        Vec3 end = new Vec3(endX, endY, endZ);
        return new EgyptianLightningPacket(start, end);
    }

    public static void handle(EgyptianLightningPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Vec3 start = new Vec3(packet.startX, packet.startY, packet.startZ);
            Vec3 end = new Vec3(packet.endX, packet.endY, packet.endZ);
            EgyptianLightningEffect.createLightning(start, end);
        }));
        ctx.get().setPacketHandled(true);
    }
}

