/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.block.entity.QuantumRecallStationBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class QuantumRecallSetDistancePacket {
    private final BlockPos pos;
    private final int distance;

    public QuantumRecallSetDistancePacket(BlockPos pos, int distance) {
        this.pos = pos;
        this.distance = distance;
    }

    public static void encode(QuantumRecallSetDistancePacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeInt(packet.distance);
    }

    public static QuantumRecallSetDistancePacket decode(FriendlyByteBuf buf) {
        return new QuantumRecallSetDistancePacket(buf.m_130135_(), buf.readInt());
    }

    public static void handle(QuantumRecallSetDistancePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            ServerLevel level = sender.m_284548_();
            BlockEntity be = level.m_7702_(packet.pos);
            if (be instanceof QuantumRecallStationBlockEntity) {
                QuantumRecallStationBlockEntity station = (QuantumRecallStationBlockEntity)be;
                station.setVortexDistance(packet.distance);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

