/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.network;

import com.michelmuscle.slidersmod.client.hud.TimerHudOverlay;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ShowTimerHudPacket {
    private final long timeLeftTicks;
    private final boolean is30SecWarning;
    private final boolean is15SecWarning;

    public ShowTimerHudPacket(long timeLeftTicks, boolean is30SecWarning, boolean is15SecWarning) {
        this.timeLeftTicks = timeLeftTicks;
        this.is30SecWarning = is30SecWarning;
        this.is15SecWarning = is15SecWarning;
    }

    public static void encode(ShowTimerHudPacket packet, FriendlyByteBuf buf) {
        buf.writeLong(packet.timeLeftTicks);
        buf.writeBoolean(packet.is30SecWarning);
        buf.writeBoolean(packet.is15SecWarning);
    }

    public static ShowTimerHudPacket decode(FriendlyByteBuf buf) {
        return new ShowTimerHudPacket(buf.readLong(), buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(ShowTimerHudPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TimerHudOverlay.displayTimeRemaining(packet.timeLeftTicks, packet.is30SecWarning, packet.is15SecWarning)));
        ctx.get().setPacketHandled(true);
    }
}

