/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.gui.EnergyBarRenderer;
import com.michelmuscle.slidersmod.menu.AnalyzerStationMenu;
import com.michelmuscle.slidersmod.util.TimerUpgradeAnalyzer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AnalyzerStationScreen
extends AbstractContainerScreen<AnalyzerStationMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("slidersmod", "textures/gui/analyzer_station.png");

    public AnalyzerStationScreen(AnalyzerStationMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = 8;
        this.f_97729_ = 6;
        this.f_97730_ = 48;
        this.f_97731_ = this.f_97727_ - 92;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderEnergyBar(guiGraphics, x, y);
        this.renderAnalyzeStatus(guiGraphics, x, y);
        this.renderReport(guiGraphics, x, y);
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int barX = x + 12;
        int barY = y + 18;
        int energyMax = ((AnalyzerStationMenu)this.f_97732_).getMaxEnergyStored();
        int energyPercent = energyMax > 0 ? ((AnalyzerStationMenu)this.f_97732_).getEnergyStored() * 100 / energyMax : 0;
        EnergyBarRenderer.renderEnergyBar(guiGraphics, barX, barY, energyPercent);
    }

    private void renderAnalyzeStatus(GuiGraphics guiGraphics, int x, int y) {
        int color;
        MutableComponent status;
        int textX = x + 32;
        int textY = y + 56;
        if (((AnalyzerStationMenu)this.f_97732_).isAnalysisComplete()) {
            return;
        }
        if (((AnalyzerStationMenu)this.f_97732_).isAnalyzing()) {
            status = Component.m_237115_((String)"gui.slidersmod.analyzer.status.analyzing");
            long ticks = Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_46467_() : 0L;
            color = ticks / 10L % 2L == 0L ? 0x55FF55 : 0xFFFFFF;
        } else if (((AnalyzerStationMenu)this.f_97732_).getAnalyzedStack().m_41619_()) {
            status = Component.m_237115_((String)"gui.slidersmod.analyzer.status.insert");
            color = 0xAAAAAA;
        } else if (((AnalyzerStationMenu)this.f_97732_).getEnergyStored() < ((AnalyzerStationMenu)this.f_97732_).getEnergyPerOperation()) {
            status = Component.m_237110_((String)"gui.slidersmod.analyzer.status.energy", (Object[])new Object[]{((AnalyzerStationMenu)this.f_97732_).getEnergyPerOperation(), ((AnalyzerStationMenu)this.f_97732_).getEnergyStored()});
            color = 0xFFAA00;
        } else {
            status = Component.m_237115_((String)"gui.slidersmod.analyzer.status.idle");
            color = 0xAAAAAA;
        }
        guiGraphics.m_280614_(this.f_96547_, (Component)status, textX, textY, color, false);
    }

    private void renderReport(GuiGraphics guiGraphics, int x, int y) {
        if (!((AnalyzerStationMenu)this.f_97732_).isAnalysisComplete()) {
            return;
        }
        int infoX = x + 66;
        int infoY = y + 17;
        int maxLines = 9;
        int lineHeight = 9;
        List<Component> lines = TimerUpgradeAnalyzer.buildReport(((AnalyzerStationMenu)this.f_97732_).getAnalyzedStack());
        if (lines.isEmpty()) {
            lines = Collections.singletonList(Component.m_237115_((String)"gui.slidersmod.analyzer.report.empty"));
        }
        int rendered = 0;
        int maxWidth = 176;
        for (Component line : lines) {
            for (FormattedCharSequence seq : this.f_96547_.m_92923_((FormattedText)line, maxWidth)) {
                if (rendered >= maxLines) {
                    return;
                }
                guiGraphics.m_280649_(this.f_96547_, seq, infoX, infoY + rendered * lineHeight, 0xFFFFFF, false);
                ++rendered;
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }
}

