/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.block.entity.QuantumGatePrototypeBlockEntity;
import com.michelmuscle.slidersmod.gui.EnergyBarRenderer;
import com.michelmuscle.slidersmod.menu.QuantumGatePrototypeMenu;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.QuantumGateSetDistancePacket;
import com.michelmuscle.slidersmod.network.QuantumGateTriggerPacket;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class QuantumGatePrototypeScreen
extends AbstractContainerScreen<QuantumGatePrototypeMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("slidersmod", "textures/gui/quantum_gate_prototype.png");
    private static final int GUI_WIDTH = 229;
    private static final int GUI_HEIGHT = 166;
    private static final int SLOT_X = 33;
    private static final int SLOT_Y = 32;
    private static final int ENERGY_BAR_X = 12;
    private static final int ENERGY_BAR_Y = 18;
    private static final int STATE_TEXT_X = 90;
    private static final int STATE_TEXT_Y = 5;
    private static final int STATE_TEXT_WIDTH = 125;
    private static final int STATE_TEXT_HEIGHT = 60;
    private static final int SLIDER_X_MIN = 55;
    private static final int SLIDER_X_MAX = 109;
    private static final int SLIDER_Y = 68;
    private static final int SLIDER_HEIGHT = 11;
    private static final int BUTTON_X = 127;
    private static final int BUTTON_Y = 68;
    private static final int BUTTON_WIDTH = 44;
    private static final int BUTTON_HEIGHT = 11;
    private boolean isDraggingSlider = false;

    public QuantumGatePrototypeScreen(QuantumGatePrototypeMenu menu, Inventory playerInventory, Component component) {
        super((AbstractContainerMenu)menu, playerInventory, component);
        this.f_97726_ = 229;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = -10000;
        this.f_97729_ = -10000;
        this.f_97730_ = -10000;
        this.f_97731_ = -10000;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderEnergyBar(guiGraphics, mouseX, mouseY);
        this.renderStateText(guiGraphics);
        this.renderDistanceSlider(guiGraphics, mouseX, mouseY);
        this.renderTriggerButton(guiGraphics, mouseX, mouseY);
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int barX = this.f_97735_ + 12;
        int barY = this.f_97736_ + 18;
        int energyMax = ((QuantumGatePrototypeMenu)this.f_97732_).getMaxEnergyStored();
        int energyPercent = energyMax > 0 ? ((QuantumGatePrototypeMenu)this.f_97732_).getEnergyStored() * 100 / energyMax : 0;
        EnergyBarRenderer.renderEnergyBar(guiGraphics, barX, barY, energyPercent);
        if (mouseX >= barX && mouseX < barX + 8 && mouseY >= barY && mouseY < barY + 50) {
            int energy = ((QuantumGatePrototypeMenu)this.f_97732_).getEnergyStored();
            int maxEnergy = ((QuantumGatePrototypeMenu)this.f_97732_).getMaxEnergyStored();
            this.m_257404_((Component)Component.m_237113_((String)(energy + " / " + maxEnergy + " FE")));
        }
    }

    private void renderSlotBackground(GuiGraphics guiGraphics) {
        int slotX = this.f_97735_ + 33;
        int slotY = this.f_97736_ + 32;
        ItemStack enderPearls = ((QuantumGatePrototypeMenu)this.f_97732_).getEnderPearlStack();
        if (!enderPearls.m_41619_()) {
            guiGraphics.m_280480_(enderPearls, slotX + 1, slotY + 1);
            guiGraphics.m_280370_(this.f_96547_, enderPearls, slotX + 1, slotY + 1);
        }
    }

    private void renderStateText(GuiGraphics guiGraphics) {
        int textX = this.f_97735_ + 90;
        int textY = this.f_97736_ + 5;
        guiGraphics.m_280509_(textX, textY, textX + 125, textY + 60, -15066598);
        guiGraphics.m_280509_(textX + 1, textY + 1, textX + 125 - 1, textY + 60 - 1, -16777216);
        String stateText = ((QuantumGatePrototypeMenu)this.f_97732_).getStateText();
        int stateColor = -1;
        if (((QuantumGatePrototypeMenu)this.f_97732_).isOverheated()) {
            stateColor = -38037;
        } else if (((QuantumGatePrototypeMenu)this.f_97732_).isCharging()) {
            stateColor = -9699477;
        }
        guiGraphics.m_280488_(this.f_96547_, "State: " + stateText, textX + 5, textY + 5, stateColor);
        int lineY = textY + 20;
        int explorationSeconds = ((QuantumGatePrototypeMenu)this.f_97732_).getExplorationSecondsRemaining();
        if (explorationSeconds > 0) {
            guiGraphics.m_280488_(this.f_96547_, "Exploration: " + QuantumGatePrototypeScreen.formatSeconds(explorationSeconds), textX + 5, lineY, -9701377);
            lineY += 10;
        } else if (((QuantumGatePrototypeMenu)this.f_97732_).isCharging()) {
            int seconds = (int)Math.ceil((double)((QuantumGatePrototypeMenu)this.f_97732_).getTriggerCooldownTicks() / 20.0);
            guiGraphics.m_280488_(this.f_96547_, "Warmup: " + seconds + "s", textX + 5, lineY, -9699477);
            lineY += 10;
        } else if (((QuantumGatePrototypeMenu)this.f_97732_).getCooldownSecondsRemaining() > 0) {
            guiGraphics.m_280488_(this.f_96547_, "Cooldown: " + QuantumGatePrototypeScreen.formatSeconds(((QuantumGatePrototypeMenu)this.f_97732_).getCooldownSecondsRemaining()), textX + 5, lineY, -38037);
            lineY += 10;
        }
        String energyText = ((QuantumGatePrototypeMenu)this.f_97732_).getEnergyStored() + " / " + ((QuantumGatePrototypeMenu)this.f_97732_).getMaxEnergyStored() + " FE";
        guiGraphics.m_280488_(this.f_96547_, energyText, textX + 5, lineY, -256);
        ItemStack enderPearls = ((QuantumGatePrototypeMenu)this.f_97732_).getEnderPearlStack();
        String pearlText = "Pearls: " + enderPearls.m_41613_();
        guiGraphics.m_280488_(this.f_96547_, pearlText, textX + 5, lineY += 10, -1);
        String distText = "Distance: " + ((QuantumGatePrototypeMenu)this.f_97732_).getVortexDistance() + " blocks";
        guiGraphics.m_280488_(this.f_96547_, distText, textX + 5, lineY += 10, -1);
    }

    private void sendDistanceUpdate(int distance) {
        int clamped = Math.max(QuantumGatePrototypeBlockEntity.getMinDistance(), Math.min(QuantumGatePrototypeBlockEntity.getMaxDistance(), distance));
        ((QuantumGatePrototypeMenu)this.f_97732_).setVortexDistance(clamped);
        ModNetworking.CHANNEL.sendToServer((Object)new QuantumGateSetDistancePacket(((QuantumGatePrototypeMenu)this.f_97732_).getBlockEntity().m_58899_(), clamped));
    }

    private void renderDistanceSlider(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int sliderX = this.f_97735_ + 55;
        int sliderY = this.f_97736_ + 68;
        int sliderWidth = 54;
        guiGraphics.m_280509_(sliderX, sliderY, sliderX + sliderWidth, sliderY + 11, -13421773);
        int distance = ((QuantumGatePrototypeMenu)this.f_97732_).getVortexDistance();
        int minDist = QuantumGatePrototypeBlockEntity.getMinDistance();
        int maxDist = QuantumGatePrototypeBlockEntity.getMaxDistance();
        float ratio = (float)(distance - minDist) / (float)(maxDist - minDist);
        int thumbX = (int)((float)sliderX + ratio * (float)(sliderWidth - 4));
        guiGraphics.m_280509_(thumbX, sliderY, thumbX + 4, sliderY + 11, -16711936);
        if (mouseX >= sliderX && mouseX < sliderX + sliderWidth && mouseY >= sliderY && mouseY < sliderY + 11) {
            this.m_257404_((Component)Component.m_237113_((String)("Distance: " + distance + " blocks")));
        }
    }

    private void renderTriggerButton(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int buttonX = this.f_97735_ + 127;
        int buttonY = this.f_97736_ + 68;
        boolean canTrigger = ((QuantumGatePrototypeMenu)this.f_97732_).canTrigger();
        int buttonColor = canTrigger ? -9699477 : -10066330;
        guiGraphics.m_280509_(buttonX, buttonY, buttonX + 44, buttonY + 11, buttonColor);
        guiGraphics.m_280509_(buttonX - 1, buttonY - 1, buttonX + 44 + 1, buttonY + 11 + 1, -7829368);
        int textColor = canTrigger ? -65536 : -6710887;
        int textX = buttonX + 22 - this.f_96547_.m_92895_("Trigger") / 2;
        guiGraphics.m_280488_(this.f_96547_, "Trigger", textX, buttonY + 2, textColor);
        if (mouseX >= buttonX && mouseX < buttonX + 44 && mouseY >= buttonY && mouseY < buttonY + 11) {
            if (canTrigger) {
                this.m_257404_((Component)Component.m_237113_((String)"Click to trigger vortex"));
            } else {
                this.m_257404_((Component)Component.m_237113_((String)"Requires: 15,000 FE + 3 Ender Pearls"));
            }
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        int currentDistance = ((QuantumGatePrototypeMenu)this.f_97732_).getVortexDistance();
        int newDistance = currentDistance + (scroll > 0.0 ? 1 : -1);
        this.sendDistanceUpdate(newDistance);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int sliderX = this.f_97735_ + 55;
        int sliderY = this.f_97736_ + 68;
        int sliderWidth = 54;
        if (mouseX >= (double)sliderX && mouseX < (double)(sliderX + sliderWidth) && mouseY >= (double)sliderY && mouseY < (double)(sliderY + 11) && button == 0) {
            this.isDraggingSlider = true;
            this.updateSliderFromMouse(mouseX);
            return true;
        }
        int buttonX = this.f_97735_ + 127;
        int buttonY = this.f_97736_ + 68;
        if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + 44) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + 11) && button == 0) {
            if (((QuantumGatePrototypeMenu)this.f_97732_).canTrigger()) {
                ModNetworking.CHANNEL.sendToServer((Object)new QuantumGateTriggerPacket(((QuantumGatePrototypeMenu)this.f_97732_).getBlockEntity().m_58899_()));
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_6915_();
                }
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isDraggingSlider && button == 0) {
            this.isDraggingSlider = false;
            this.updateSliderFromMouse(mouseX);
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingSlider && button == 0) {
            this.updateSliderFromMouse(mouseX);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private void updateSliderFromMouse(double mouseX) {
        int sliderX = this.f_97735_ + 55;
        int sliderWidth = 54;
        double ratio = Math.max(0.0, Math.min(1.0, (mouseX - (double)sliderX) / (double)sliderWidth));
        int minDist = QuantumGatePrototypeBlockEntity.getMinDistance();
        int maxDist = QuantumGatePrototypeBlockEntity.getMaxDistance();
        int newDistance = minDist + (int)(ratio * (double)(maxDist - minDist));
        this.sendDistanceUpdate(newDistance);
    }

    private static String formatSeconds(int seconds) {
        int value = Math.max(0, seconds);
        int minutes = value / 60;
        int secs = value % 60;
        return String.format(Locale.ROOT, "%02d:%02d", minutes, secs);
    }
}

