/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.block.entity.QuantumRecallStationBlockEntity;
import com.michelmuscle.slidersmod.gui.EnergyBarRenderer;
import com.michelmuscle.slidersmod.menu.QuantumRecallStationMenu;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.QuantumRecallSetDistancePacket;
import com.michelmuscle.slidersmod.network.QuantumRecallTriggerPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class QuantumRecallStationScreen
extends AbstractContainerScreen<QuantumRecallStationMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("slidersmod", "textures/gui/quantum_gate_prototype.png");
    private static final int GUI_WIDTH = 229;
    private static final int GUI_HEIGHT = 166;
    private static final int ENERGY_BAR_X = 12;
    private static final int ENERGY_BAR_Y = 18;
    private static final int STATE_TEXT_X = 90;
    private static final int STATE_TEXT_Y = 5;
    private static final int STATE_TEXT_WIDTH = 125;
    private static final int STATE_TEXT_HEIGHT = 60;
    private static final int SLIDER_X_MIN = 55;
    private static final int SLIDER_X_MAX = 109;
    private static final int SLIDER_Y = 68;
    private static final int SLIDER_HEIGHT = 11;
    private static final int BUTTON_X = 127;
    private static final int BUTTON_Y = 68;
    private static final int BUTTON_WIDTH = 44;
    private static final int BUTTON_HEIGHT = 11;
    private boolean isDraggingSlider = false;

    public QuantumRecallStationScreen(QuantumRecallStationMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 229;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = -10000;
        this.f_97729_ = -10000;
        this.f_97730_ = -10000;
        this.f_97731_ = -10000;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_7286_(guiGraphics, partialTick, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderEnergyBar(guiGraphics, mouseX, mouseY);
        this.renderStateBox(guiGraphics);
        this.renderDistanceSlider(guiGraphics, mouseX, mouseY);
        this.renderTriggerButton(guiGraphics, mouseX, mouseY);
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int barX = this.f_97735_ + 12;
        int barY = this.f_97736_ + 18;
        int energyMax = ((QuantumRecallStationMenu)this.f_97732_).getMaxEnergyStored();
        int energyPercent = energyMax > 0 ? ((QuantumRecallStationMenu)this.f_97732_).getEnergyStored() * 100 / energyMax : 0;
        EnergyBarRenderer.renderEnergyBar(guiGraphics, barX, barY, energyPercent);
        if (mouseX >= barX && mouseX < barX + 8 && mouseY >= barY && mouseY < barY + 50) {
            int energy = ((QuantumRecallStationMenu)this.f_97732_).getEnergyStored();
            this.m_257404_((Component)Component.m_237113_((String)(energy + " / " + energyMax + " FE")));
        }
    }

    private void renderStateBox(GuiGraphics guiGraphics) {
        QuantumRecallStationBlockEntity be = ((QuantumRecallStationMenu)this.f_97732_).getBlockEntity();
        if (be == null) {
            return;
        }
        int textX = this.f_97735_ + 90;
        int textY = this.f_97736_ + 5;
        guiGraphics.m_280509_(textX, textY, textX + 125, textY + 60, -15066598);
        guiGraphics.m_280509_(textX + 1, textY + 1, textX + 125 - 1, textY + 60 - 1, -16777216);
        int lineY = textY + 5;
        guiGraphics.m_280488_(this.f_96547_, "State: " + (((QuantumRecallStationMenu)this.f_97732_).canTrigger() ? "Ready" : "Waiting"), textX + 5, lineY, -1);
        lineY += 10;
        int cooldownTicks = ((QuantumRecallStationMenu)this.f_97732_).getCooldownTicks();
        if (cooldownTicks > 0) {
            guiGraphics.m_280488_(this.f_96547_, "Cooldown: " + this.formatTicks(cooldownTicks), textX + 5, lineY, -38037);
            lineY += 10;
        } else {
            guiGraphics.m_280488_(this.f_96547_, "Cooldown: Ready", textX + 5, lineY, -9699477);
            lineY += 10;
        }
        int remaining = ((QuantumRecallStationMenu)this.f_97732_).getMarkRemainingTicks();
        if (((QuantumRecallStationMenu)this.f_97732_).hasMarkedEntity()) {
            guiGraphics.m_280488_(this.f_96547_, "Expires in: " + this.formatTicks(remaining), textX + 5, lineY, -256);
            guiGraphics.m_280488_(this.f_96547_, be.getMarkedEntityInfo(), textX + 5, lineY += 10, -1);
        } else {
            guiGraphics.m_280488_(this.f_96547_, "No entity marked", textX + 5, lineY, -38037);
        }
    }

    private void renderDistanceSlider(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int sliderX = this.f_97735_ + 55;
        int sliderY = this.f_97736_ + 68;
        int sliderWidth = 54;
        guiGraphics.m_280509_(sliderX, sliderY, sliderX + sliderWidth, sliderY + 11, -13421773);
        int distance = ((QuantumRecallStationMenu)this.f_97732_).getVortexDistance();
        int minDist = QuantumRecallStationBlockEntity.getMinDistance();
        int maxDist = QuantumRecallStationBlockEntity.getMaxDistance();
        float ratio = (float)(distance - minDist) / (float)(maxDist - minDist);
        int thumbX = (int)((float)sliderX + ratio * (float)(sliderWidth - 4));
        guiGraphics.m_280509_(thumbX, sliderY, thumbX + 4, sliderY + 11, -16711936);
        if (mouseX >= sliderX && mouseX < sliderX + sliderWidth && mouseY >= sliderY && mouseY < sliderY + 11) {
            this.m_257404_((Component)Component.m_237113_((String)("Distance: " + distance + " blocks")));
        }
    }

    private void renderTriggerButton(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int buttonX = this.f_97735_ + 127;
        int buttonY = this.f_97736_ + 68;
        boolean canTrigger = ((QuantumRecallStationMenu)this.f_97732_).canTrigger();
        int buttonColor = canTrigger ? -9699477 : -10066330;
        guiGraphics.m_280509_(buttonX, buttonY, buttonX + 44, buttonY + 11, buttonColor);
        guiGraphics.m_280509_(buttonX - 1, buttonY - 1, buttonX + 44 + 1, buttonY + 11 + 1, -7829368);
        int textColor = canTrigger ? -65536 : -6710887;
        int textX = buttonX + 22 - this.f_96547_.m_92895_("Trigger") / 2;
        guiGraphics.m_280488_(this.f_96547_, "Trigger", textX, buttonY + 2, textColor);
        if (mouseX >= buttonX && mouseX < buttonX + 44 && mouseY >= buttonY && mouseY < buttonY + 11) {
            if (canTrigger) {
                this.m_257404_((Component)Component.m_237113_((String)"Click to trigger recall"));
            } else {
                this.m_257404_((Component)Component.m_237113_((String)"Requires: mark + 200k FE + no cooldown"));
            }
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        int currentDistance = ((QuantumRecallStationMenu)this.f_97732_).getVortexDistance();
        int newDistance = currentDistance + (scroll > 0.0 ? 1 : -1);
        this.sendDistanceUpdate(newDistance);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int sliderX = this.f_97735_ + 55;
        int sliderY = this.f_97736_ + 68;
        int sliderWidth = 54;
        if (mouseX >= (double)sliderX && mouseX < (double)(sliderX + sliderWidth) && mouseY >= (double)sliderY && mouseY < (double)(sliderY + 11) && button == 0) {
            this.isDraggingSlider = true;
            this.updateSliderFromMouse(mouseX);
            return true;
        }
        int buttonX = this.f_97735_ + 127;
        int buttonY = this.f_97736_ + 68;
        if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + 44) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + 11) && button == 0) {
            if (((QuantumRecallStationMenu)this.f_97732_).canTrigger()) {
                ModNetworking.CHANNEL.sendToServer((Object)new QuantumRecallTriggerPacket(((QuantumRecallStationMenu)this.f_97732_).getBlockPos()));
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_6915_();
                }
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isDraggingSlider && button == 0) {
            this.isDraggingSlider = false;
            this.updateSliderFromMouse(mouseX);
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingSlider && button == 0) {
            this.updateSliderFromMouse(mouseX);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private void updateSliderFromMouse(double mouseX) {
        int sliderX = this.f_97735_ + 55;
        int sliderWidth = 54;
        double ratio = Math.max(0.0, Math.min(1.0, (mouseX - (double)sliderX) / (double)sliderWidth));
        int minDist = QuantumRecallStationBlockEntity.getMinDistance();
        int maxDist = QuantumRecallStationBlockEntity.getMaxDistance();
        int newDistance = minDist + (int)(ratio * (double)(maxDist - minDist));
        this.sendDistanceUpdate(newDistance);
    }

    private void sendDistanceUpdate(int distance) {
        int clamped = Math.max(QuantumRecallStationBlockEntity.getMinDistance(), Math.min(QuantumRecallStationBlockEntity.getMaxDistance(), distance));
        ((QuantumRecallStationMenu)this.f_97732_).setVortexDistance(clamped);
        ModNetworking.CHANNEL.sendToServer((Object)new QuantumRecallSetDistancePacket(((QuantumRecallStationMenu)this.f_97732_).getBlockPos(), clamped));
    }

    private String formatTicks(int ticks) {
        int seconds = ticks / 20;
        int m = seconds / 60;
        int s = seconds % 60;
        return String.format("%02d:%02d", m, s);
    }
}

