/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.gui.EnergyBarRenderer;
import com.michelmuscle.slidersmod.gui.ProgressArrowRenderer;
import com.michelmuscle.slidersmod.menu.TimerWorkbenchMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TimerWorkbenchScreen
extends AbstractContainerScreen<TimerWorkbenchMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("slidersmod", "textures/gui/timer_workbench.png");

    public TimerWorkbenchScreen(TimerWorkbenchMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderProgress(guiGraphics, x, y);
        this.renderEnergy(guiGraphics, x, y);
        this.renderStatus(guiGraphics, x, y);
    }

    private void renderProgress(GuiGraphics guiGraphics, int x, int y) {
        int arrowX = x + 101;
        int arrowY = y + 38;
        if (((TimerWorkbenchMenu)this.f_97732_).isProcessing()) {
            int scaledProgress = ((TimerWorkbenchMenu)this.f_97732_).getScaledProgress();
            int progressPercent = scaledProgress * 100 / 24;
            ProgressArrowRenderer.renderProgressArrow(guiGraphics, arrowX, arrowY, progressPercent);
        } else {
            ProgressArrowRenderer.renderProgressArrow(guiGraphics, arrowX, arrowY, 0);
        }
    }

    private void renderEnergy(GuiGraphics guiGraphics, int x, int y) {
        int barX = x + 12;
        int barY = y + 18;
        int energyMax = ((TimerWorkbenchMenu)this.f_97732_).getMaxEnergy();
        int energyPercent = energyMax > 0 ? ((TimerWorkbenchMenu)this.f_97732_).getEnergy() * 100 / energyMax : 0;
        EnergyBarRenderer.renderEnergyBar(guiGraphics, barX, barY, energyPercent);
    }

    private void renderStatus(GuiGraphics guiGraphics, int x, int y) {
        if (((TimerWorkbenchMenu)this.f_97732_).isProcessing()) {
            return;
        }
        Component status = ((TimerWorkbenchMenu)this.f_97732_).getStatusMessage();
        if (status == null) {
            return;
        }
        int textX = x + 32;
        int textY = y + 56;
        guiGraphics.m_280614_(this.f_96547_, status, textX, textY, 0xAAAAAA, false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        if (mouseX >= left + 12 && mouseX <= left + 20 && mouseY >= top + 18 && mouseY <= top + 68) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)(((TimerWorkbenchMenu)this.f_97732_).getEnergy() + " / " + ((TimerWorkbenchMenu)this.f_97732_).getMaxEnergy() + " FE")), mouseX, mouseY);
        }
    }
}

