/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.screen;

import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1Item;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.UpgradedLoganTimerConfigPacket;
import com.michelmuscle.slidersmod.screen.component.PortalStabilityUi;
import com.michelmuscle.slidersmod.util.GuiTextureHelper;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class UpgradedLoganTimerTier1ConfigScreen
extends Screen {
    private static final int GUI_WIDTH = GuiTextureHelper.DISPLAY_SIZE;
    private static final int GUI_HEIGHT = GuiTextureHelper.DISPLAY_SIZE;
    private static final int PRECISION_RANGE = 3000;
    private static final long MIN_CONFIG_SECONDS = 30L;
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/logan.png");
    private static final GuiTextureHelper.TextureRect HOURS_FIELD = new GuiTextureHelper.TextureRect(54, 104, 106, 148);
    private static final GuiTextureHelper.TextureRect MINUTES_FIELD = new GuiTextureHelper.TextureRect(107, 104, 159, 148);
    private static final GuiTextureHelper.TextureRect SECONDS_FIELD = new GuiTextureHelper.TextureRect(158, 104, 210, 148);
    private static final GuiTextureHelper.TextureRect INFO_PANEL_AREA = new GuiTextureHelper.TextureRect(259, 11, 488, 351);
    private static final GuiTextureHelper.TextureRect X_LABEL_AREA = new GuiTextureHelper.TextureRect(303, 367, 323, 385);
    private static final GuiTextureHelper.TextureRect Z_LABEL_AREA = new GuiTextureHelper.TextureRect(419, 367, 439, 385);
    private static final GuiTextureHelper.TextureRect X_FIELD_AREA = new GuiTextureHelper.TextureRect(258, 387, 350, 418);
    private static final GuiTextureHelper.TextureRect Z_FIELD_AREA = new GuiTextureHelper.TextureRect(395, 387, 487, 418);
    private static final GuiTextureHelper.TextureRect CONFIRM_BUTTON_AREA = new GuiTextureHelper.TextureRect(258, 437, 349, 468);
    private static final GuiTextureHelper.TextureRect CANCEL_BUTTON_AREA = new GuiTextureHelper.TextureRect(395, 437, 487, 468);
    private static final boolean SHOW_DEBUG_OVERLAY = false;
    private static final int LED_INSET = Math.max(2, GuiTextureHelper.toLogicalWidth(4));
    private final ItemStack timerStack;
    private final boolean isTimerActive;
    private EditBox xInput;
    private EditBox zInput;
    private EditBox hoursInput;
    private EditBox minutesInput;
    private EditBox secondsInput;
    private Button confirmButton;
    private Button cancelButton;
    private int guiLeft;
    private int guiTop;
    private long remainingTime = 0L;
    private int tickCounter = 0;
    private final long maxConfigSeconds;

    public UpgradedLoganTimerTier1ConfigScreen(ItemStack timerStack) {
        super((Component)Component.m_237113_((String)"Upgraded Logan's Timer Tier 1"));
        this.timerStack = timerStack;
        this.isTimerActive = UpgradedLoganTimerTier1Item.isActive(timerStack);
        this.maxConfigSeconds = TimerUpgradeData.getMaxConfiguredSeconds(timerStack);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - GUI_WIDTH) / 2;
        this.guiTop = (this.f_96544_ - GUI_HEIGHT) / 2;
        int currentX = (int)UpgradedLoganTimerTier1Item.getConfiguredX(this.timerStack);
        int currentZ = (int)UpgradedLoganTimerTier1Item.getConfiguredZ(this.timerStack);
        long currentSeconds = UpgradedLoganTimerTier1Item.getConfiguredTime(this.timerStack);
        int hours = (int)(currentSeconds % 86400L / 3600L);
        int minutes = (int)(currentSeconds % 3600L / 60L);
        int seconds = (int)(currentSeconds % 60L);
        if (this.isTimerActive) {
            this.updateRemainingTime();
            long remainingSeconds = this.remainingTime / 20L;
            hours = (int)(remainingSeconds % 86400L / 3600L);
            minutes = (int)(remainingSeconds % 3600L / 60L);
            seconds = (int)(remainingSeconds % 60L);
        }
        this.xInput = this.createCoordinateInputField(X_FIELD_AREA, (Component)Component.m_237113_((String)"Target X"));
        this.xInput.m_94144_(String.valueOf(currentX));
        this.xInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.xInput);
        this.zInput = this.createCoordinateInputField(Z_FIELD_AREA, (Component)Component.m_237113_((String)"Target Z"));
        this.zInput.m_94144_(String.valueOf(currentZ));
        this.zInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.zInput);
        this.hoursInput = this.createLedInputField(HOURS_FIELD, (Component)Component.m_237113_((String)"Hours"));
        this.hoursInput.m_94144_(String.format("%02d", hours));
        this.hoursInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.hoursInput);
        this.minutesInput = this.createLedInputField(MINUTES_FIELD, (Component)Component.m_237113_((String)"Minutes"));
        this.minutesInput.m_94144_(String.format("%02d", minutes));
        this.minutesInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.minutesInput);
        this.secondsInput = this.createLedInputField(SECONDS_FIELD, (Component)Component.m_237113_((String)"Seconds"));
        this.secondsInput.m_94144_(String.format("%02d", seconds));
        this.secondsInput.m_94186_(!this.isTimerActive);
        this.m_142416_((GuiEventListener)this.secondsInput);
        if (!this.isTimerActive) {
            this.confirmButton = this.buildButton(CONFIRM_BUTTON_AREA, (Component)Component.m_237113_((String)"Confirm").m_130940_(ChatFormatting.WHITE), this::onConfirm);
            this.m_142416_((GuiEventListener)this.confirmButton);
        }
        this.cancelButton = this.buildButton(CANCEL_BUTTON_AREA, (Component)Component.m_237113_((String)"Cancel").m_130940_(ChatFormatting.WHITE), this::onCancel);
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.addPortalStabilityControls();
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.isTimerActive) {
            ++this.tickCounter;
            if (this.tickCounter >= 20) {
                this.tickCounter = 0;
                this.updateRemainingTime();
                this.updateDisplayedTime();
            }
        }
    }

    private void updateRemainingTime() {
        if (this.isTimerActive && this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            long activationTime = UpgradedLoganTimerTier1Item.getActivationTime(this.timerStack);
            long configuredTime = UpgradedLoganTimerTier1Item.getConfiguredTime(this.timerStack);
            long currentGameTime = this.f_96541_.f_91073_.m_46467_();
            long elapsed = currentGameTime - activationTime;
            this.remainingTime = Math.max(0L, configuredTime * 20L - elapsed);
        }
    }

    private void updateDisplayedTime() {
        long remainingSeconds = this.remainingTime / 20L;
        int hours = (int)(remainingSeconds % 86400L / 3600L);
        int minutes = (int)(remainingSeconds % 3600L / 60L);
        int seconds = (int)(remainingSeconds % 60L);
        this.hoursInput.m_94144_(String.format("%02d", hours));
        this.minutesInput.m_94144_(String.format("%02d", minutes));
        this.secondsInput.m_94144_(String.format("%02d", seconds));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.renderTimerTexture(graphics);
        this.drawInputBackgrounds(graphics);
        this.drawInfoPanel(graphics);
        this.drawCoordinateBackgrounds(graphics);
        this.drawCoordinateLabels(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void addPortalStabilityControls() {
        if (!PortalStabilityUi.shouldShow(this.timerStack)) {
            return;
        }
        int width = Math.max(80, INFO_PANEL_AREA.getLogicalWidth() - 20);
        int x = this.guiLeft + INFO_PANEL_AREA.getLogicalX() + 10;
        int baseY = this.guiTop + INFO_PANEL_AREA.getLogicalY() + INFO_PANEL_AREA.getLogicalHeight() - 52;
        this.m_142416_((GuiEventListener)PortalStabilityUi.createPortalButton(this.timerStack, x, baseY, width));
        this.m_142416_((GuiEventListener)PortalStabilityUi.createReturnButton(this.timerStack, x, baseY + 24, width));
    }

    private void drawInputBackgrounds(GuiGraphics graphics) {
        this.fillRect(graphics, HOURS_FIELD, -268435456);
        this.fillRect(graphics, MINUTES_FIELD, -268435456);
        this.fillRect(graphics, SECONDS_FIELD, -268435456);
    }

    private void drawInfoPanel(GuiGraphics graphics) {
        int x = this.guiLeft + INFO_PANEL_AREA.getLogicalX();
        int y = this.guiTop + INFO_PANEL_AREA.getLogicalY();
        int w = INFO_PANEL_AREA.getLogicalWidth();
        int h = INFO_PANEL_AREA.getLogicalHeight();
        graphics.m_280509_(x, y, x + w, y + h, -822083584);
        graphics.m_280509_(x, y, x + w, y + 1, 0x40FFFFFF);
        graphics.m_280509_(x, y + h - 1, x + w, y + h, 0x40666666);
        graphics.m_280509_(x, y, x + 1, y + h, 0x40666666);
        graphics.m_280509_(x + w - 1, y, x + w, y + h, 0x40FFFFFF);
        int padding = GuiTextureHelper.toLogicalX(8);
        int cursorY = y + padding;
        int textX = x + padding;
        long configuredSeconds = UpgradedLoganTimerTier1Item.getConfiguredTime(this.timerStack);
        graphics.m_280488_(this.f_96547_, "Time set:", textX, cursorY, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, this.formatTimeSet(configuredSeconds), textX, cursorY += 9, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, "Range:", textX, cursorY += 9 + 4, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, this.rangeText(), textX, cursorY += 9, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, "Precision:", textX, cursorY += 9 + 6, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, " 3000 blocks", textX, cursorY += 9, -1);
        Objects.requireNonNull(this.f_96547_);
        long configuredX = UpgradedLoganTimerTier1Item.getConfiguredX(this.timerStack);
        long configuredZ = UpgradedLoganTimerTier1Item.getConfiguredZ(this.timerStack);
        graphics.m_280488_(this.f_96547_, "Target:", textX, cursorY += 9 + 4, -1);
        Objects.requireNonNull(this.f_96547_);
        String targetText = "X=" + configuredX + " Z=" + configuredZ;
        graphics.m_280488_(this.f_96547_, targetText, textX, cursorY += 9, -1);
    }

    private void drawCoordinateBackgrounds(GuiGraphics graphics) {
        this.fillRect(graphics, X_FIELD_AREA, -268435456);
        this.fillRect(graphics, Z_FIELD_AREA, -268435456);
    }

    private void drawCoordinateLabels(GuiGraphics graphics) {
        this.drawCenteredLabel(graphics, X_LABEL_AREA, "X");
        this.drawCenteredLabel(graphics, Z_LABEL_AREA, "Z");
    }

    private void drawCenteredLabel(GuiGraphics graphics, GuiTextureHelper.TextureRect rect, String text) {
        int x = this.guiLeft + rect.getLogicalX() + rect.getLogicalWidth() / 2;
        int n = this.guiTop + rect.getLogicalY() + rect.getLogicalHeight() / 2;
        Objects.requireNonNull(this.f_96547_);
        int y = n - 9 / 2;
        graphics.m_280137_(this.f_96547_, text, x, y, -1);
    }

    private void renderTimerTexture(GuiGraphics graphics) {
        graphics.m_280411_(GUI_TEXTURE, this.guiLeft, this.guiTop, GUI_WIDTH, GUI_HEIGHT, 0.0f, 0.0f, 500, 500, 500, 500);
    }

    private void drawDebugOverlay(GuiGraphics graphics) {
        graphics.m_280509_(this.guiLeft, this.guiTop, this.guiLeft + GUI_WIDTH, this.guiTop + GUI_HEIGHT, 0x2000FFFF);
        for (int i = 0; i <= GUI_WIDTH; i += 10) {
            graphics.m_280509_(this.guiLeft + i, this.guiTop, this.guiLeft + i + 1, this.guiTop + GUI_HEIGHT, 0x20000000);
            graphics.m_280509_(this.guiLeft, this.guiTop + i, this.guiLeft + GUI_WIDTH, this.guiTop + i + 1, 0x20000000);
        }
    }

    private EditBox createLedInputField(GuiTextureHelper.TextureRect rect, Component label) {
        int rectWidth = rect.getLogicalWidth();
        int rectHeight = rect.getLogicalHeight();
        int fieldWidth = Math.max(14, rectWidth - LED_INSET * 2);
        int fieldHeight = Math.max(14, rectHeight - LED_INSET * 2);
        int x = this.guiLeft + rect.getLogicalX() + Math.max(0, (rectWidth - fieldWidth) / 2);
        int y = this.guiTop + rect.getLogicalY() + Math.max(0, (rectHeight - fieldHeight) / 2);
        EditBox field = new EditBox(this.f_96547_, x, y, fieldWidth, fieldHeight, label);
        field.m_94182_(false);
        field.m_94202_(-50130);
        field.m_94205_(-10867925);
        field.m_94199_(2);
        return field;
    }

    private EditBox createCoordinateInputField(GuiTextureHelper.TextureRect rect, Component label) {
        int x = this.guiLeft + rect.getLogicalX() + GuiTextureHelper.toLogicalX(6);
        int y = this.guiTop + rect.getLogicalY() + GuiTextureHelper.toLogicalY(6);
        int w = rect.getLogicalWidth() - GuiTextureHelper.toLogicalX(12);
        int h = rect.getLogicalHeight() - GuiTextureHelper.toLogicalY(12);
        EditBox field = new EditBox(this.f_96547_, x, y, Math.max(40, w), Math.max(14, h), label);
        field.m_94182_(false);
        field.m_94199_(9);
        field.m_94202_(-50130);
        field.m_94205_(-10867925);
        return field;
    }

    private Button buildButton(GuiTextureHelper.TextureRect rect, Component label, Button.OnPress onPress) {
        return Button.m_253074_((Component)label, (Button.OnPress)onPress).m_252987_(this.guiLeft + rect.getLogicalX(), this.guiTop + rect.getLogicalY(), rect.getLogicalWidth(), rect.getLogicalHeight()).m_253136_();
    }

    private void fillRect(GuiGraphics graphics, GuiTextureHelper.TextureRect rect, int color) {
        int x1 = this.guiLeft + rect.getLogicalX();
        int y1 = this.guiTop + rect.getLogicalY();
        int x2 = x1 + rect.getLogicalWidth();
        int y2 = y1 + rect.getLogicalHeight();
        graphics.m_280509_(x1, y1, x2, y2, color);
    }

    private String formatTimeSet(long totalSeconds) {
        return this.formatDuration(totalSeconds);
    }

    private String formatDuration(long totalSeconds) {
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private String rangeText() {
        return this.formatDuration(30L) + " \u2192 " + this.formatDuration(this.maxConfigSeconds);
    }

    private void onConfirm(Button button) {
        try {
            int seconds;
            int minutes;
            String xStr = this.xInput.m_94155_().trim();
            String zStr = this.zInput.m_94155_().trim();
            if (xStr.isEmpty() || zStr.isEmpty()) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Both X and Z coordinates are required!").m_130940_(ChatFormatting.RED), true);
                return;
            }
            int x = Integer.parseInt(xStr);
            int z = Integer.parseInt(zStr);
            if (Math.abs(x) > 30000000 || Math.abs(z) > 30000000) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Coordinates must be between -30,000,000 and 30,000,000!").m_130940_(ChatFormatting.RED), true);
                return;
            }
            int hours = this.parseInput(this.hoursInput.m_94155_(), 0, 23);
            long totalSeconds = (long)hours * 3600L + (long)(minutes = this.parseInput(this.minutesInput.m_94155_(), 0, 59)) * 60L + (long)(seconds = this.parseInput(this.secondsInput.m_94155_(), 0, 59));
            if (totalSeconds < 30L || totalSeconds > this.maxConfigSeconds) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)("Dur e invalide ! Entre " + this.formatDuration(30L) + " et " + this.formatDuration(this.maxConfigSeconds))).m_130940_(ChatFormatting.RED), true);
                return;
            }
            ModNetworking.CHANNEL.sendToServer((Object)new UpgradedLoganTimerConfigPacket(x, z, totalSeconds));
            this.m_7379_();
        }
        catch (NumberFormatException e) {
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Invalid input! Please enter valid numbers.").m_130940_(ChatFormatting.RED), true);
        }
    }

    private void onCancel(Button button) {
        this.m_7379_();
    }

    private int parseInput(String input, int min, int max) throws NumberFormatException {
        if (input.isEmpty()) {
            return 0;
        }
        int value = Integer.parseInt(input);
        if (value < min || value > max) {
            throw new NumberFormatException("Value out of range: " + value);
        }
        return value;
    }

    public boolean m_7043_() {
        return false;
    }
}

