/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.system;

import com.michelmuscle.slidersmod.SlidersMod;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PlayerSeedRegistry
extends SavedData {
    private static final String DATA_NAME = "slidersmod_player_seeds";
    private final Map<String, Set<String>> playerSeeds = new HashMap<String, Set<String>>();

    public static PlayerSeedRegistry get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (PlayerSeedRegistry)storage.m_164861_(PlayerSeedRegistry::load, PlayerSeedRegistry::new, DATA_NAME);
    }

    public static PlayerSeedRegistry load(CompoundTag tag) {
        PlayerSeedRegistry registry = new PlayerSeedRegistry();
        ListTag playerList = tag.m_128437_("Players", 10);
        for (int i = 0; i < playerList.size(); ++i) {
            CompoundTag playerTag = playerList.m_128728_(i);
            String playerUUID = playerTag.m_128461_("UUID");
            ListTag seedList = playerTag.m_128437_("Seeds", 8);
            HashSet<String> seeds = new HashSet<String>();
            for (int j = 0; j < seedList.size(); ++j) {
                seeds.add(seedList.m_128778_(j));
            }
            registry.playerSeeds.put(playerUUID, seeds);
        }
        SlidersMod.LOGGER.info("Loaded player seed registry: {} players with discovered seeds", (Object)registry.playerSeeds.size());
        return registry;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag playerList = new ListTag();
        for (Map.Entry<String, Set<String>> entry : this.playerSeeds.entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128359_("UUID", entry.getKey());
            ListTag seedList = new ListTag();
            for (String seed : entry.getValue()) {
                seedList.add((Object)StringTag.m_129297_((String)seed));
            }
            playerTag.m_128365_("Seeds", (Tag)seedList);
            playerList.add((Object)playerTag);
        }
        tag.m_128365_("Players", (Tag)playerList);
        SlidersMod.LOGGER.info("Saved player seed registry: {} players", (Object)this.playerSeeds.size());
        return tag;
    }

    public void addSeedToPlayer(UUID playerUUID, String seed) {
        String uuidString = playerUUID.toString();
        Set seeds = this.playerSeeds.computeIfAbsent(uuidString, k -> new HashSet());
        boolean wasNew = seeds.add(seed);
        if (wasNew) {
            this.m_77762_();
            SlidersMod.LOGGER.info("Player {} discovered new seed: {} (total: {})", new Object[]{playerUUID, seed, seeds.size()});
        }
    }

    public boolean hasPlayerDiscoveredSeed(UUID playerUUID, String seed) {
        String uuidString = playerUUID.toString();
        Set<String> seeds = this.playerSeeds.get(uuidString);
        if (seeds == null) {
            return false;
        }
        return seeds.contains(seed);
    }

    public Set<String> getPlayerSeeds(UUID playerUUID) {
        String uuidString = playerUUID.toString();
        Set<String> seeds = this.playerSeeds.get(uuidString);
        if (seeds == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(seeds);
    }

    public int getPlayerSeedCount(UUID playerUUID) {
        String uuidString = playerUUID.toString();
        Set<String> seeds = this.playerSeeds.get(uuidString);
        if (seeds == null) {
            return 0;
        }
        return seeds.size();
    }

    public void removeSeedFromPlayer(UUID playerUUID, String seed) {
        String uuidString = playerUUID.toString();
        Set<String> seeds = this.playerSeeds.get(uuidString);
        if (seeds != null && seeds.remove(seed)) {
            this.m_77762_();
            SlidersMod.LOGGER.info("Removed seed {} from player {}", (Object)seed, (Object)playerUUID);
        }
    }

    public void clearPlayerSeeds(UUID playerUUID) {
        String uuidString = playerUUID.toString();
        if (this.playerSeeds.remove(uuidString) != null) {
            this.m_77762_();
            SlidersMod.LOGGER.info("Cleared all seeds for player {}", (Object)playerUUID);
        }
    }

    public int getPlayerCount() {
        return this.playerSeeds.size();
    }

    public int getTotalSeedCount() {
        return this.playerSeeds.values().stream().mapToInt(Set::size).sum();
    }
}

