/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.util;

import com.michelmuscle.slidersmod.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RecycleRecipeResolver {
    private static final List<Item> COMMON_UPGRADES = List.of((Item)ModItems.CRYSTAL_BUFFER.get(), (Item)ModItems.ADVANCED_CRYSTAL_BUFFER.get(), (Item)ModItems.ULTIMATE_CRYSTAL_BUFFER.get(), (Item)ModItems.OVERHEAT_COOLDOWN_REDUCER.get(), (Item)ModItems.OVERHEAT_PROBABILITY_REDUCER.get(), (Item)ModItems.TEMPORAL_STABILIZER.get(), (Item)ModItems.PORTAL_STABILITY_UPGRADE.get(), (Item)ModItems.EGYPTIAN_TRACKER_UPGRADE.get(), (Item)ModItems.PHASE_MODULATOR.get(), (Item)ModItems.DIMENSION_ANCHOR.get(), (Item)ModItems.QUANTUM_RELOCATOR.get(), (Item)ModItems.SLIDE_ENGINE_CORE.get());
    private static final List<Item> RARE_UPGRADES = List.of((Item)ModItems.DIMENSIONAL_BUFFER.get(), (Item)ModItems.VORTEX_CALIBRATOR.get(), (Item)ModItems.EXODUS_SEED_UPGRADE.get());

    public static TimerType getTimerType(ItemStack stack) {
        if (stack.m_41619_()) {
            return TimerType.NOT_A_TIMER;
        }
        String className = stack.m_41720_().getClass().getSimpleName();
        if (className.contains("Stuck")) {
            return TimerType.STUCK;
        }
        if (className.contains("Damaged")) {
            return TimerType.DAMAGED;
        }
        if (className.contains("Timer")) {
            return TimerType.NORMAL;
        }
        return TimerType.NOT_A_TIMER;
    }

    public static boolean isUpgrade(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        return COMMON_UPGRADES.contains(item) || RARE_UPGRADES.contains(item);
    }

    public static boolean isModule(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        return item == ModItems.DIMENSIONAL_MODULE.get() || item == ModItems.QUANTUM_CELL.get();
    }

    public static ItemStack generateOutput(ItemStack input, RandomSource random) {
        TimerType type = RecycleRecipeResolver.getTimerType(input);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TimerType.NORMAL -> RecycleRecipeResolver.generateNormalTimerOutput(random);
            case TimerType.DAMAGED -> RecycleRecipeResolver.generateDamagedTimerOutput(random);
            case TimerType.STUCK -> RecycleRecipeResolver.generateStuckTimerOutput(random);
            case TimerType.NOT_A_TIMER -> RecycleRecipeResolver.isUpgrade(input) ? RecycleRecipeResolver.generateUpgradeOutput(random) : (RecycleRecipeResolver.isModule(input) ? RecycleRecipeResolver.generateModuleOutput(random) : ItemStack.f_41583_);
        };
    }

    private static ItemStack generateNormalTimerOutput(RandomSource random) {
        if (random.m_188501_() < 0.5f) {
            return RecycleRecipeResolver.generateRandomUpgrade(random);
        }
        int chipCount = random.m_188503_(4) + 3;
        return new ItemStack((ItemLike)ModItems.SLIDE_ENHANCEMENT_CHIP.get(), chipCount);
    }

    private static ItemStack generateDamagedTimerOutput(RandomSource random) {
        if (random.m_188501_() < 0.3f) {
            return RecycleRecipeResolver.generateRandomUpgrade(random);
        }
        int chipCount = random.m_188503_(3) + 2;
        return new ItemStack((ItemLike)ModItems.SLIDE_ENHANCEMENT_CHIP.get(), chipCount);
    }

    private static ItemStack generateStuckTimerOutput(RandomSource random) {
        if (random.m_188501_() < 0.2f) {
            return RecycleRecipeResolver.generateRandomUpgrade(random);
        }
        int chipCount = random.m_188503_(2) + 1;
        return new ItemStack((ItemLike)ModItems.SLIDE_ENHANCEMENT_CHIP.get(), chipCount);
    }

    private static ItemStack generateUpgradeOutput(RandomSource random) {
        int chipCount = random.m_188503_(3) + 1;
        return new ItemStack((ItemLike)ModItems.SLIDE_ENHANCEMENT_CHIP.get(), chipCount);
    }

    private static ItemStack generateModuleOutput(RandomSource random) {
        int chipCount = random.m_188503_(3) + 2;
        return new ItemStack((ItemLike)ModItems.SLIDE_ENHANCEMENT_CHIP.get(), chipCount);
    }

    private static ItemStack generateRandomUpgrade(RandomSource random) {
        ArrayList<Item> weightedPool = new ArrayList<Item>();
        weightedPool.addAll(COMMON_UPGRADES);
        if (random.m_188501_() < 0.1f) {
            Item rareUpgrade = RARE_UPGRADES.get(random.m_188503_(RARE_UPGRADES.size()));
            return new ItemStack((ItemLike)rareUpgrade);
        }
        Item commonUpgrade = COMMON_UPGRADES.get(random.m_188503_(COMMON_UPGRADES.size()));
        return new ItemStack((ItemLike)commonUpgrade);
    }

    public static boolean canRecycle(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        TimerType type = RecycleRecipeResolver.getTimerType(stack);
        if (type != TimerType.NOT_A_TIMER) {
            return true;
        }
        return RecycleRecipeResolver.isUpgrade(stack) || RecycleRecipeResolver.isModule(stack);
    }

    public static enum TimerType {
        NORMAL,
        DAMAGED,
        STUCK,
        NOT_A_TIMER;

    }
}

