/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client;

import com.michelmuscle.slidersmod.SlidersMod;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.joml.Matrix4f;

public final class ObjMeshRawUV {
    private static final float UV_SHIFT = 1.0E-6f;
    public static boolean DRAW_BOTH_WINDINGS = true;
    public static boolean FORCE_FLAT_VIEW_NORMAL = true;
    private final List<Tri> tris = new ArrayList<Tri>();
    private int maxVi = -1;
    private float[] nxByVi;
    private float[] nyByVi;
    private float[] nzByVi;
    private static final AtomicBoolean UV_LOGGED = new AtomicBoolean(false);
    private float minU = 0.0f;
    private float maxU = 1.0f;
    private float minV = 0.0f;
    private float maxV = 1.0f;
    private float invRangeU = 1.0f;
    private float invRangeV = 1.0f;
    private boolean normalizeUV = false;

    private ObjMeshRawUV() {
    }

    public static ObjMeshRawUV load(ResourceLocation loc) throws IOException {
        Minecraft mc = Minecraft.m_91087_();
        Optional res = mc.m_91098_().m_213713_(loc);
        if (!res.isPresent()) {
            throw new IOException("Missing resource: " + String.valueOf(loc));
        }
        try (InputStream in = ((Resource)res.get()).m_215507_();){
            ObjMeshRawUV mesh = ObjMeshRawUV.fromStream(in);
            mesh.computeUvBounds(loc);
            ObjMeshRawUV objMeshRawUV = mesh;
            return objMeshRawUV;
        }
    }

    public static ObjMeshRawUV fromStream(InputStream in) throws IOException {
        ObjMeshRawUV mesh = new ObjMeshRawUV();
        ArrayList<V> vs = new ArrayList<V>();
        ArrayList<T> vts = new ArrayList<T>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] tokens;
                String[] s;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("v ")) {
                    s = line.split("\\s+");
                    vs.add(new V(ObjMeshRawUV.parseF(s, 1), ObjMeshRawUV.parseF(s, 2), ObjMeshRawUV.parseF(s, 3)));
                    continue;
                }
                if (line.startsWith("vt ")) {
                    s = line.split("\\s+");
                    float u = ObjMeshRawUV.parseF(s, 1);
                    float v = 1.0f - ObjMeshRawUV.parseF(s, 2);
                    vts.add(new T(u, v));
                    continue;
                }
                if (!line.startsWith("f ") || (tokens = line.substring(2).trim().split("\\s+")).length < 3) continue;
                int[] idxA = ObjMeshRawUV.parseIdx(tokens[0]);
                int i = 1;
                while (i + 1 < tokens.length) {
                    int[] idxB = ObjMeshRawUV.parseIdx(tokens[i]);
                    int[] idxC = ObjMeshRawUV.parseIdx(tokens[i + 1]);
                    V p0 = ObjMeshRawUV.pickV(vs, idxA[0]);
                    V p1 = ObjMeshRawUV.pickV(vs, idxB[0]);
                    V p2 = ObjMeshRawUV.pickV(vs, idxC[0]);
                    T t0 = ObjMeshRawUV.pickVT(vts, idxA[1]);
                    T t1 = ObjMeshRawUV.pickVT(vts, idxB[1]);
                    T t2 = ObjMeshRawUV.pickVT(vts, idxC[1]);
                    mesh.tris.add(new Tri(p0, p1, p2, t0, t1, t2, idxA[0], idxB[0], idxC[0]));
                    mesh.maxVi = Math.max(mesh.maxVi, Math.max(idxA[0], Math.max(idxB[0], idxC[0])));
                    ++i;
                }
            }
        }
        mesh.buildVertexNormals();
        return mesh;
    }

    private static float parseF(String[] s, int i) {
        return Float.parseFloat(s[i]);
    }

    private static int[] parseIdx(String token) {
        String[] sp = token.split("/");
        int vi = Integer.parseInt(sp[0]) - 1;
        int vti = -1;
        if (sp.length >= 2 && !sp[1].isEmpty()) {
            vti = Integer.parseInt(sp[1]) - 1;
        }
        return new int[]{vi, vti};
    }

    private static V pickV(List<V> list, int idx) {
        return idx < 0 || idx >= list.size() ? new V(0.0f, 0.0f, 0.0f) : list.get(idx);
    }

    private static T pickVT(List<T> list, int idx) {
        return idx < 0 || idx >= list.size() ? new T(0.0f, 0.0f) : list.get(idx);
    }

    private void buildVertexNormals() {
        if (this.maxVi < 0) {
            return;
        }
        this.nxByVi = new float[this.maxVi + 1];
        this.nyByVi = new float[this.maxVi + 1];
        this.nzByVi = new float[this.maxVi + 1];
        for (Tri tr : this.tris) {
            float ax = tr.p1.x - tr.p0.x;
            float ay = tr.p1.y - tr.p0.y;
            float az = tr.p1.z - tr.p0.z;
            float bx = tr.p2.x - tr.p0.x;
            float by = tr.p2.y - tr.p0.y;
            float bz = tr.p2.z - tr.p0.z;
            float nx = ay * bz - az * by;
            float ny = az * bx - ax * bz;
            float nz = ax * by - ay * bx;
            int n = tr.pi0;
            this.nxByVi[n] = this.nxByVi[n] + nx;
            int n2 = tr.pi0;
            this.nyByVi[n2] = this.nyByVi[n2] + ny;
            int n3 = tr.pi0;
            this.nzByVi[n3] = this.nzByVi[n3] + nz;
            int n4 = tr.pi1;
            this.nxByVi[n4] = this.nxByVi[n4] + nx;
            int n5 = tr.pi1;
            this.nyByVi[n5] = this.nyByVi[n5] + ny;
            int n6 = tr.pi1;
            this.nzByVi[n6] = this.nzByVi[n6] + nz;
            int n7 = tr.pi2;
            this.nxByVi[n7] = this.nxByVi[n7] + nx;
            int n8 = tr.pi2;
            this.nyByVi[n8] = this.nyByVi[n8] + ny;
            int n9 = tr.pi2;
            this.nzByVi[n9] = this.nzByVi[n9] + nz;
        }
        for (int i = 0; i <= this.maxVi; ++i) {
            float nx = this.nxByVi[i];
            float ny = this.nyByVi[i];
            float nz = this.nzByVi[i];
            float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
            if (len > 1.0E-6f) {
                this.nxByVi[i] = nx / len;
                this.nyByVi[i] = ny / len;
                this.nzByVi[i] = nz / len;
                continue;
            }
            this.nxByVi[i] = 0.0f;
            this.nyByVi[i] = 0.0f;
            this.nzByVi[i] = 1.0f;
        }
    }

    private void computeUvBounds(ResourceLocation loc) {
        boolean alreadyLogged = UV_LOGGED.getAndSet(true);
        float minUFound = Float.POSITIVE_INFINITY;
        float maxUFound = Float.NEGATIVE_INFINITY;
        float minVFound = Float.POSITIVE_INFINITY;
        float maxVFound = Float.NEGATIVE_INFINITY;
        for (Tri tr : this.tris) {
            minUFound = Math.min(minUFound, Math.min(tr.t0.u, Math.min(tr.t1.u, tr.t2.u)));
            maxUFound = Math.max(maxUFound, Math.max(tr.t0.u, Math.max(tr.t1.u, tr.t2.u)));
            minVFound = Math.min(minVFound, Math.min(tr.t0.v, Math.min(tr.t1.v, tr.t2.v)));
            maxVFound = Math.max(maxVFound, Math.max(tr.t0.v, Math.max(tr.t1.v, tr.t2.v)));
        }
        this.minU = minUFound;
        this.maxU = maxUFound;
        this.minV = minVFound;
        this.maxV = maxVFound;
        float rangeU = Math.max(this.maxU - this.minU, 1.0E-6f);
        float rangeV = Math.max(this.maxV - this.minV, 1.0E-6f);
        this.invRangeU = 1.0f / rangeU;
        this.invRangeV = 1.0f / rangeV;
        boolean bl = this.normalizeUV = Math.abs(this.minU) > 0.001f || Math.abs(this.minV) > 0.001f || Math.abs(this.maxU - 1.0f) > 0.001f || Math.abs(this.maxV - 1.0f) > 0.001f;
        if (!alreadyLogged) {
            SlidersMod.LOGGER.info("ObjMeshRawUV {} UV bounds: U[{}, {}] V[{}, {}] normalize={}", new Object[]{loc, String.format("%.3f", Float.valueOf(minUFound)), String.format("%.3f", Float.valueOf(maxUFound)), String.format("%.3f", Float.valueOf(minVFound)), String.format("%.3f", Float.valueOf(maxVFound)), this.normalizeUV});
        }
    }

    private float normalizeU(float u) {
        if (!this.normalizeUV) {
            return u;
        }
        return (u - this.minU) * this.invRangeU;
    }

    private float normalizeV(float v) {
        if (!this.normalizeUV) {
            return v;
        }
        return (v - this.minV) * this.invRangeV;
    }

    public void draw(VertexConsumer vc, Matrix4f pose, int light) {
        this.drawTinted(vc, pose, light, 0.0f, 0.0f, 255, 255, 255);
    }

    public void draw(VertexConsumer vc, Matrix4f pose, int light, float du, float dv) {
        this.drawTinted(vc, pose, light, du, dv, 255, 255, 255);
    }

    public void drawTinted(VertexConsumer vc, Matrix4f pose, int light, float du, float dv, int red, int green, int blue) {
        if (du != 0.0f) {
            du -= (float)Math.floor(du);
        }
        if (dv != 0.0f) {
            dv -= (float)Math.floor(dv);
        }
        du += 1.0E-6f;
        dv += 1.0E-6f;
        for (Tri tr : this.tris) {
            float n0z;
            float n1z;
            float n2z;
            float n0y;
            float n1y;
            float n2y;
            float n0x;
            float n1x;
            float n2x;
            float u0 = this.normalizeU(tr.t0.u) + du;
            float v0 = this.normalizeV(tr.t0.v) + dv;
            float u1 = this.normalizeU(tr.t1.u) + du;
            float v1 = this.normalizeV(tr.t1.v) + dv;
            float u2 = this.normalizeU(tr.t2.u) + du;
            float v2 = this.normalizeV(tr.t2.v) + dv;
            if (FORCE_FLAT_VIEW_NORMAL) {
                n2x = 0.0f;
                n1x = 0.0f;
                n0x = 0.0f;
                n2y = 0.0f;
                n1y = 0.0f;
                n0y = 0.0f;
                n2z = 1.0f;
                n1z = 1.0f;
                n0z = 1.0f;
            } else {
                n0x = this.nxByVi[tr.pi0];
                n0y = this.nyByVi[tr.pi0];
                n0z = this.nzByVi[tr.pi0];
                n1x = this.nxByVi[tr.pi1];
                n1y = this.nyByVi[tr.pi1];
                n1z = this.nzByVi[tr.pi1];
                n2x = this.nxByVi[tr.pi2];
                n2y = this.nyByVi[tr.pi2];
                n2z = this.nzByVi[tr.pi2];
            }
            ObjMeshRawUV.put(vc, pose, tr.p0, u0, v0, light, n0x, n0y, n0z, red, green, blue);
            ObjMeshRawUV.put(vc, pose, tr.p1, u1, v1, light, n1x, n1y, n1z, red, green, blue);
            ObjMeshRawUV.put(vc, pose, tr.p2, u2, v2, light, n2x, n2y, n2z, red, green, blue);
            if (!DRAW_BOTH_WINDINGS) continue;
            ObjMeshRawUV.put(vc, pose, tr.p2, u2, v2, light, n2x, n2y, n2z, red, green, blue);
            ObjMeshRawUV.put(vc, pose, tr.p1, u1, v1, light, n1x, n1y, n1z, red, green, blue);
            ObjMeshRawUV.put(vc, pose, tr.p0, u0, v0, light, n0x, n0y, n0z, red, green, blue);
        }
    }

    public void drawVerticalFrame(VertexConsumer vc, Matrix4f pose, int light, int frameIndex, int frameCount) {
        this.drawVerticalFrameTinted(vc, pose, light, frameIndex, frameCount, 255, 255, 255);
    }

    public void drawVerticalFrameTinted(VertexConsumer vc, Matrix4f pose, int light, int frameIndex, int frameCount, int red, int green, int blue) {
        if (frameCount <= 0) {
            this.drawTinted(vc, pose, light, 0.0f, 0.0f, red, green, blue);
            return;
        }
        int safeFrame = Math.floorMod(frameIndex, frameCount);
        float frameHeight = 1.0f / (float)frameCount;
        float offsetV = (float)safeFrame * frameHeight + 1.0E-6f;
        for (Tri tr : this.tris) {
            float n0z;
            float n1z;
            float n2z;
            float n0y;
            float n1y;
            float n2y;
            float n0x;
            float n1x;
            float n2x;
            float u0 = this.normalizeU(tr.t0.u) + 1.0E-6f;
            float u1 = this.normalizeU(tr.t1.u) + 1.0E-6f;
            float u2 = this.normalizeU(tr.t2.u) + 1.0E-6f;
            float v0 = this.normalizeV(tr.t0.v) * frameHeight + offsetV;
            float v1 = this.normalizeV(tr.t1.v) * frameHeight + offsetV;
            float v2 = this.normalizeV(tr.t2.v) * frameHeight + offsetV;
            if (FORCE_FLAT_VIEW_NORMAL) {
                n2x = 0.0f;
                n1x = 0.0f;
                n0x = 0.0f;
                n2y = 0.0f;
                n1y = 0.0f;
                n0y = 0.0f;
                n2z = 1.0f;
                n1z = 1.0f;
                n0z = 1.0f;
            } else {
                n0x = this.nxByVi[tr.pi0];
                n0y = this.nyByVi[tr.pi0];
                n0z = this.nzByVi[tr.pi0];
                n1x = this.nxByVi[tr.pi1];
                n1y = this.nyByVi[tr.pi1];
                n1z = this.nzByVi[tr.pi1];
                n2x = this.nxByVi[tr.pi2];
                n2y = this.nyByVi[tr.pi2];
                n2z = this.nzByVi[tr.pi2];
            }
            ObjMeshRawUV.put(vc, pose, tr.p0, u0, v0, light, n0x, n0y, n0z, red, green, blue);
            ObjMeshRawUV.put(vc, pose, tr.p1, u1, v1, light, n1x, n1y, n1z, red, green, blue);
            ObjMeshRawUV.put(vc, pose, tr.p2, u2, v2, light, n2x, n2y, n2z, red, green, blue);
            if (!DRAW_BOTH_WINDINGS) continue;
            ObjMeshRawUV.put(vc, pose, tr.p2, u2, v2, light, n2x, n2y, n2z, red, green, blue);
            ObjMeshRawUV.put(vc, pose, tr.p1, u1, v1, light, n1x, n1y, n1z, red, green, blue);
            ObjMeshRawUV.put(vc, pose, tr.p0, u0, v0, light, n0x, n0y, n0z, red, green, blue);
        }
    }

    private static void put(VertexConsumer vc, Matrix4f pose, V p, float u, float v, int light, float nx, float ny, float nz, int red, int green, int blue) {
        vc.m_252986_(pose, p.x, p.y, p.z).m_6122_(red, green, blue, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(nx, ny, nz).m_5752_();
    }

    public static float wrap01(float t) {
        if ((t -= (float)Math.floor(t)) < 0.0f) {
            t += 1.0f;
        }
        return t >= 1.0f ? 0.0f : t;
    }

    public static float wrap01Mirror(float t) {
        return (t -= (float)Math.floor(t / 2.0f) * 2.0f) <= 1.0f ? t : 2.0f - t;
    }

    public static final class V {
        public final float x;
        public final float y;
        public final float z;

        public V(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static final class T {
        public final float u;
        public final float v;

        public T(float u, float v) {
            this.u = u;
            this.v = v;
        }
    }

    public static final class Tri {
        public final V p0;
        public final V p1;
        public final V p2;
        public final T t0;
        public final T t1;
        public final T t2;
        public final int pi0;
        public final int pi1;
        public final int pi2;

        public Tri(V p0, V p1, V p2, T t0, T t1, T t2, int pi0, int pi1, int pi2) {
            this.p0 = p0;
            this.p1 = p1;
            this.p2 = p2;
            this.t0 = t0;
            this.t1 = t1;
            this.t2 = t2;
            this.pi0 = Math.max(pi0, 0);
            this.pi1 = Math.max(pi1, 0);
            this.pi2 = Math.max(pi2, 0);
        }
    }
}

