/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.effect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class EgyptianLightningEffect {
    private static final List<LightningInstance> activeLightnings = new ArrayList<LightningInstance>();
    private static final Random random = new Random();
    private static final int TOTAL_DURATION = 20;
    private static final int FLICKER_FREQUENCY = 2;

    public static void createLightning(Vec3 start, Vec3 end) {
        activeLightnings.add(new LightningInstance(start, end));
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        Iterator<LightningInstance> iterator = activeLightnings.iterator();
        while (iterator.hasNext()) {
            LightningInstance lightning = iterator.next();
            ++lightning.tick;
            if (lightning.tick > 20) {
                iterator.remove();
                continue;
            }
            EgyptianLightningEffect.spawnLightningParticles((Level)level, lightning.start, lightning.end, lightning.tick);
        }
    }

    private static void spawnLightningParticles(Level level, Vec3 start, Vec3 end, int tick) {
        boolean shouldFlicker;
        boolean bl = shouldFlicker = tick % 2 == 0;
        if (!shouldFlicker) {
            return;
        }
        int branchCount = 3 + random.nextInt(3);
        for (int branch = 0; branch < branchCount; ++branch) {
            EgyptianLightningEffect.createLightningBranch(level, start, end);
        }
    }

    private static void createLightningBranch(Level level, Vec3 start, Vec3 end) {
        double distance = start.m_82554_(end);
        int segments = Math.max(5, (int)(distance / 0.5));
        Vec3 direction = end.m_82546_(start);
        Vec3 perpendicular = new Vec3(-direction.f_82481_, 0.0, direction.f_82479_).m_82541_();
        for (int i = 0; i < segments; ++i) {
            double progress = (double)i / (double)segments;
            Vec3 basePos = start.m_82549_(direction.m_82490_(progress));
            double turbulence = (random.nextDouble() - 0.5) * 0.5;
            Vec3 particlePos = basePos.m_82549_(perpendicular.m_82490_(turbulence));
            level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, random.nextGaussian() * 0.05, random.nextGaussian() * 0.05, random.nextGaussian() * 0.05);
            if (!(random.nextDouble() < 0.3)) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02);
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, end.f_82479_, end.f_82480_, end.f_82481_, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1);
    }

    private static class LightningInstance {
        final Vec3 start;
        final Vec3 end;
        int tick = 0;

        LightningInstance(Vec3 start, Vec3 end) {
            this.start = start;
            this.end = end;
        }
    }
}

