/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.renderer;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.client.ObjMesh;
import com.michelmuscle.slidersmod.client.VortexRenderTypes;
import com.michelmuscle.slidersmod.client.renderer.ExodusVortexObjRenderer;
import com.michelmuscle.slidersmod.entity.ExodusVortexBorderObjEntity;
import com.michelmuscle.slidersmod.util.CustomVortexVisuals;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.q_misc_util.my_util.DQuaternion;

public class ExodusVortexBorderObjRenderer
extends EntityRenderer<ExodusVortexBorderObjEntity> {
    private static ObjMesh MESH;
    private static ObjMesh CUSTOM_MESH;
    private static final ResourceLocation OBJ;
    private static final ResourceLocation CUSTOM_OBJ;
    private static final ResourceLocation TEX;

    public ExodusVortexBorderObjRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.f_114477_ = 0.0f;
    }

    public void render(ExodusVortexBorderObjEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ObjMesh mesh = this.resolveMesh(entity);
        if (mesh == null) {
            return;
        }
        float scroll = ((float)entity.m_9236_().m_46467_() + partialTicks) / 20.0f;
        float du = ObjMesh.wrap01(scroll * ExodusVortexObjRenderer.SCROLL_SPEED);
        float dv = ObjMesh.wrap01(scroll * ExodusVortexObjRenderer.SCROLL_SPEED);
        float fade = entity.getScaleFactor(partialTicks);
        if (fade <= 0.0f) {
            return;
        }
        poseStack.m_85836_();
        Quaternionf rotation = ExodusVortexBorderObjRenderer.orientation(entity.getAxisW(), entity.getAxisH());
        poseStack.m_252781_(rotation);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_85841_(ExodusVortexObjRenderer.SCALE * fade, ExodusVortexObjRenderer.SCALE * fade, ExodusVortexObjRenderer.SCALE * fade);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        ResourceLocation texture = this.resolveTexture(entity);
        VertexConsumer translucent = buffer.m_6299_(VortexRenderTypes.vortex(texture));
        if (entity.hasCustomAppearance()) {
            int tint = entity.getCustomTint();
            int red = tint >> 16 & 0xFF;
            int green = tint >> 8 & 0xFF;
            int blue = tint & 0xFF;
            mesh.drawTinted(translucent, pose, 0xF000F0, du, dv, red, green, blue);
        } else {
            mesh.draw(translucent, pose, 0xF000F0, du, dv);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ExodusVortexBorderObjEntity entity) {
        return this.resolveTexture(entity);
    }

    private ResourceLocation resolveTexture(ExodusVortexBorderObjEntity entity) {
        if (entity.hasCustomAppearance()) {
            return CustomVortexVisuals.resolveEntityTexture(entity.getCustomTextureId(), TEX);
        }
        return TEX;
    }

    private ObjMesh resolveMesh(ExodusVortexBorderObjEntity entity) {
        boolean custom = entity.hasCustomAppearance() && "customexodus".equals(entity.getCustomTextureId());
        try {
            if (custom) {
                if (CUSTOM_MESH == null) {
                    CUSTOM_MESH = ObjMesh.load(CUSTOM_OBJ);
                }
                return CUSTOM_MESH;
            }
            if (MESH == null) {
                MESH = ObjMesh.load(OBJ);
            }
            return MESH;
        }
        catch (Exception e) {
            SlidersMod.LOGGER.error("Unable to load exodus border OBJ", (Throwable)e);
            return null;
        }
    }

    private static Quaternionf orientation(Vec3 axisW, Vec3 axisH) {
        Vec3 w = ExodusVortexBorderObjRenderer.normalize(axisW, new Vec3(1.0, 0.0, 0.0));
        Vec3 h = ExodusVortexBorderObjRenderer.normalize(axisH, new Vec3(0.0, 1.0, 0.0));
        DQuaternion dq = PortalManipulation.getPortalOrientationQuaternion((Vec3)w, (Vec3)h);
        return new Quaternionf((float)dq.x, (float)dq.y, (float)dq.z, (float)dq.w);
    }

    private static Vec3 normalize(Vec3 vec, Vec3 fallback) {
        if (vec.m_82556_() < 1.0E-6) {
            return fallback;
        }
        Vec3 normalized = vec.m_82541_();
        if (normalized.m_82556_() < 1.0E-6) {
            return fallback;
        }
        return normalized;
    }

    static {
        OBJ = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/exodusborder.obj");
        CUSTOM_OBJ = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/customexodusborder.obj");
        TEX = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/exodus.png");
    }
}

