/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.renderer;

import com.michelmuscle.slidersmod.client.ObjMesh;
import com.michelmuscle.slidersmod.client.VortexRenderTypes;
import com.michelmuscle.slidersmod.entity.OgVortexObjEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class OgVortexObjRenderer
extends EntityRenderer<OgVortexObjEntity> {
    private static ObjMesh MESH;
    private static final ResourceLocation OBJ;
    private static final ResourceLocation TEX;
    public static float SCROLL_SPEED;
    public static float SCROLL_ANGLE_DEG;
    public static float SCALE;
    public static boolean GLOW;

    public OgVortexObjRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.f_114477_ = 0.0f;
    }

    public void render(OgVortexObjEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        try {
            if (MESH == null) {
                MESH = ObjMesh.load(OBJ);
            }
        }
        catch (Exception ignored) {
            return;
        }
        float time = ((float)entity.m_9236_().m_46467_() + partialTicks) / 20.0f;
        float angle = (float)Math.toRadians(SCROLL_ANGLE_DEG);
        float du = ObjMesh.wrap01(time * SCROLL_SPEED * (float)Math.cos(angle));
        float dv = ObjMesh.wrap01(time * SCROLL_SPEED * (float)Math.sin(angle));
        poseStack.m_85836_();
        poseStack.m_85841_(SCALE, SCALE, SCALE);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        VertexConsumer translucent = buffer.m_6299_(VortexRenderTypes.vortex(TEX));
        MESH.draw(translucent, pose, 0xF000F0, du, dv);
        if (GLOW) {
            VertexConsumer glow = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)TEX));
            MESH.draw(glow, pose, 0xF000F0, du, dv);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(OgVortexObjEntity entity) {
        return TEX;
    }

    static {
        OBJ = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"models/entity/ogvortex.obj");
        TEX = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/ogvortex.png");
        SCROLL_SPEED = 0.243f;
        SCROLL_ANGLE_DEG = 270.0f;
        SCALE = 1.0f;
        GLOW = false;
    }
}

