/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.renderer;

import com.michelmuscle.slidersmod.entity.VortexEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class VortexRenderer
extends EntityRenderer<VortexEntity> {
    private static final ResourceLocation VORTEX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/vortex.png");
    private static final ResourceLocation LOGAN_VORTEX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/loganvortex.png");
    private static final ResourceLocation EXODUS_VORTEX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/exodus_vortex.png");
    private static final ResourceLocation EGYPTIAN_VORTEX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/egyptian_vortex.png");
    private static final ResourceLocation PROTO_VORTEX_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/entity/protovortex.png");

    public VortexRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(VortexEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity.usesImmersivePortalVisual()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        float scale = 3.0f;
        poseStack.m_85841_(scale, scale, scale);
        float rotation = ((float)entity.f_19797_ + partialTick) * 5.0f;
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation));
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        ResourceLocation texture = this.getTextureLocation(entity);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
        VortexRenderer.vertex(vertexConsumer, matrix4f, matrix3f, packedLight, -0.5f, -0.5f, 0, 0.0f, 0.0f);
        VortexRenderer.vertex(vertexConsumer, matrix4f, matrix3f, packedLight, -0.5f, 0.5f, 0, 0.0f, 1.0f);
        VortexRenderer.vertex(vertexConsumer, matrix4f, matrix3f, packedLight, 0.5f, 0.5f, 0, 1.0f, 1.0f);
        VortexRenderer.vertex(vertexConsumer, matrix4f, matrix3f, packedLight, 0.5f, -0.5f, 0, 1.0f, 0.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    private static void vertex(VertexConsumer consumer, Matrix4f matrix4f, Matrix3f matrix3f, int light, float x, float y, int z, float u, float v) {
        consumer.m_252986_(matrix4f, x, y, (float)z).m_6122_(255, 255, 255, 200).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(VortexEntity entity) {
        if (entity.isEgyptianVortex()) {
            return EGYPTIAN_VORTEX_TEXTURE;
        }
        if (entity.isProtoVortex()) {
            return PROTO_VORTEX_TEXTURE;
        }
        if (entity.isExodusVortex()) {
            return EXODUS_VORTEX_TEXTURE;
        }
        if (entity.isLoganVortex()) {
            return LOGAN_VORTEX_TEXTURE;
        }
        return VORTEX_TEXTURE;
    }
}

