/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.entity;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.advancements.AchievementManager;
import com.michelmuscle.slidersmod.client.sound.VortexAmbientSoundInstance;
import com.michelmuscle.slidersmod.config.SlidersModConfig;
import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.entity.ExodusVortexEntity;
import com.michelmuscle.slidersmod.entity.OgVortexBackObjEntity;
import com.michelmuscle.slidersmod.entity.OgVortexBorderObjEntity;
import com.michelmuscle.slidersmod.entity.VortexCollisionObjEntity;
import com.michelmuscle.slidersmod.init.ModEntities;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.ExodusTimerItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerItem;
import com.michelmuscle.slidersmod.item.OriginalTimerDamagedItem;
import com.michelmuscle.slidersmod.item.OriginalTimerItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3Item;
import com.michelmuscle.slidersmod.portal.VortexImmersivePortalHelper;
import com.michelmuscle.slidersmod.portal.VortexPortalPlacement;
import com.michelmuscle.slidersmod.portal.VortexPortalTracker;
import com.michelmuscle.slidersmod.system.ForceVortexManager;
import com.michelmuscle.slidersmod.system.PlayerSeedRegistry;
import com.michelmuscle.slidersmod.system.StuckTimerManager;
import com.michelmuscle.slidersmod.util.ClassicTimerHelper;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import com.michelmuscle.slidersmod.world.VortexShowcaseManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;

public class VortexEntity
extends Entity {
    protected static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> IS_RETURN_PORTAL = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> HAS_BEEN_USED = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_LOGAN_VORTEX = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_EXODUS_VORTEX = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_EGYPTIAN_VORTEX = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_PROTO_VORTEX = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_RAID_PORTAL = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> USES_IMMERSIVE_PORTAL = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<String> CUSTOM_MODEL_ID = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<String> CUSTOM_TEXTURE_ID = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<Integer> CUSTOM_TINT = SynchedEntityData.m_135353_(VortexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int MAX_LIFETIME = 600;
    private static final int MAX_LIFETIME_AFTER_USE = 200;
    protected static final float VORTEX_RADIUS = 1.5f;
    private static final float SLIDE_CHIP_CHANCE = 0.2f;
    private static final String QUANTUM_GATE_TARGET_DIM_TAG = "QuantumGateTargetDimension";
    private static final int PORTAL_SHRINK_TICKS = 8;
    private static final int BORDER_FADE_TICKS = 10;
    private static final int BORDER_FADE_DELAY_TICKS = 4;
    protected UUID ownerUUID;
    protected DimensionManager.RandomDestination cachedDestination;
    protected ItemStack timerStack = ItemStack.f_41583_;
    protected int usedAtTick = -1;
    private long spawnGameTime = -1L;
    private long lastUseGameTime = -1L;
    private long closeAtGameTime = -1L;
    protected UUID linkedAestheticVortexUUID = null;
    @Nullable
    protected ResourceKey<Level> linkedAestheticDimension = null;
    @Nullable
    protected UUID immersivePortalId = null;
    @Nullable
    protected UUID decorationEntityId = null;
    @Nullable
    protected UUID backDecorationEntityId = null;
    @Nullable
    protected UUID collisionEntityId = null;
    @Nullable
    protected UUID backCollisionEntityId = null;
    @Nullable
    protected UUID customShowcaseEntityId = null;
    private double portalTargetWidth = 3.0;
    private double portalTargetHeight = 3.0;
    @Nullable
    protected BlockPos lightAnchorPos = null;
    protected boolean lightPlaced = false;
    protected boolean closingAnimationStarted = false;
    protected int closingAnimationTick = 0;
    protected final Map<UUID, Integer> backCollisionImmunity = new HashMap<UUID, Integer>();
    protected boolean enableBackDecoration = true;
    protected boolean enableFrontCollisionVolume = true;
    protected boolean enableBackCollisionVolume = true;
    protected boolean hasFixedPortalLifetime = false;
    protected int fixedPortalLifetimeTicks = -1;
    protected boolean returnScheduled = false;

    public VortexEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public VortexEntity(Level level, double x, double y, double z, UUID ownerUUID, ItemStack timerStack) {
        this((EntityType)ModEntities.VORTEX_ENTITY.get(), level);
        this.m_6034_(x, y, z);
        this.ownerUUID = ownerUUID;
        this.timerStack = timerStack.m_41777_();
        this.f_19804_.m_135381_(LIFETIME, (Object)0);
        this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)false);
        boolean isLoganVortex = timerStack.m_41784_().m_128471_("IsLoganVortex");
        boolean isProtoVortex = timerStack.m_41784_().m_128471_("IsProtoVortex");
        boolean isExodusVortex = timerStack.m_41784_().m_128471_("IsExodusVortex");
        boolean isEgyptianVortex = timerStack.m_41784_().m_128471_("IsEgyptianVortex");
        boolean isDamagedVortex = timerStack.m_41784_().m_128471_("IsDamagedVortex");
        this.f_19804_.m_135381_(IS_LOGAN_VORTEX, (Object)isLoganVortex);
        this.f_19804_.m_135381_(IS_EXODUS_VORTEX, (Object)isExodusVortex);
        this.f_19804_.m_135381_(IS_EGYPTIAN_VORTEX, (Object)isEgyptianVortex);
        this.f_19804_.m_135381_(IS_PROTO_VORTEX, (Object)isProtoVortex);
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cachedDestination = this.resolveInitialDestination(serverLevel, isLoganVortex, isDamagedVortex);
            this.applyPortalStabilityFromStack(serverLevel);
        }
    }

    public VortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed) {
        this(level, x, y, z, isReturnPortal, alreadyUsed, false, false, false, false);
    }

    public VortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed, boolean isLoganVortex) {
        this(level, x, y, z, isReturnPortal, alreadyUsed, isLoganVortex, false, false, false);
    }

    public VortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed, boolean isLoganVortex, boolean isExodusVortex) {
        this(level, x, y, z, isReturnPortal, alreadyUsed, isLoganVortex, isExodusVortex, false, false);
    }

    public VortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed, boolean isLoganVortex, boolean isExodusVortex, boolean isEgyptianVortex) {
        this(level, x, y, z, isReturnPortal, alreadyUsed, isLoganVortex, isExodusVortex, isEgyptianVortex, false);
    }

    public VortexEntity(Level level, double x, double y, double z, boolean isReturnPortal, boolean alreadyUsed, boolean isLoganVortex, boolean isExodusVortex, boolean isEgyptianVortex, boolean isProtoVortex) {
        this((EntityType)ModEntities.VORTEX_ENTITY.get(), level);
        this.m_6034_(x, y, z);
        this.f_19804_.m_135381_(LIFETIME, (Object)0);
        this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)isReturnPortal);
        this.f_19804_.m_135381_(IS_LOGAN_VORTEX, (Object)isLoganVortex);
        this.f_19804_.m_135381_(IS_EXODUS_VORTEX, (Object)isExodusVortex);
        this.f_19804_.m_135381_(IS_EGYPTIAN_VORTEX, (Object)isEgyptianVortex);
        this.f_19804_.m_135381_(IS_PROTO_VORTEX, (Object)isProtoVortex);
        if (alreadyUsed) {
            this.f_19804_.m_135381_(HAS_BEEN_USED, (Object)true);
            this.usedAtTick = 0;
        }
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initializeLifetimeWindow(serverLevel, alreadyUsed);
        }
    }

    public VortexEntity(Level level, double x, double y, double z, boolean isReturnPortal) {
        this(level, x, y, z, isReturnPortal, false, false, false, false, false);
    }

    private boolean isQuantumGateTimer() {
        return !this.timerStack.m_41619_() && this.timerStack.m_41784_().m_128471_("IsQuantumGatePrototype");
    }

    private boolean shouldScheduleReturnForQuantumGate(Player player) {
        if (!this.isQuantumGateTimer()) {
            return true;
        }
        CompoundTag tag = this.timerStack.m_41784_();
        String assignedKey = "QuantumGateReturnPlayer";
        if (tag.m_128403_("QuantumGateReturnPlayer")) {
            UUID assigned = tag.m_128342_("QuantumGateReturnPlayer");
            return assigned.equals(player.m_20148_());
        }
        tag.m_128362_("QuantumGateReturnPlayer", player.m_20148_());
        return true;
    }

    @Nullable
    protected DimensionManager.RandomDestination resolveInitialDestination(ServerLevel serverLevel, boolean isLoganVortex, boolean isDamagedVortex) {
        ResourceLocation forcedLocation;
        String forcedTarget;
        CompoundTag tag;
        if (this.isQuantumGateTimer() && (tag = this.timerStack.m_41784_()).m_128441_(QUANTUM_GATE_TARGET_DIM_TAG) && !(forcedTarget = tag.m_128461_(QUANTUM_GATE_TARGET_DIM_TAG)).isEmpty() && (forcedLocation = ResourceLocation.m_135820_((String)forcedTarget)) != null) {
            ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)forcedLocation);
            DimensionManager.RandomDestination destination = DimensionManager.generateDestinationInDimension(serverLevel.m_7654_(), (ResourceKey<Level>)dimensionKey);
            if (destination != null) {
                return destination;
            }
        }
        int tier = DimensionManager.getTimerTier(this.timerStack);
        if (isDamagedVortex && !isLoganVortex) {
            return DimensionManager.generateRandomDestinationDamaged(serverLevel.m_7654_(), tier, 0.1);
        }
        return DimensionManager.generateRandomDestination(serverLevel.m_7654_(), tier, isLoganVortex);
    }

    protected VortexEntity createAestheticVortex(ServerLevel targetLevel, double x, double y, double z) {
        VortexEntity aesthetic = new VortexEntity((Level)targetLevel, x, y, z, true, true);
        boolean isLogan = (Boolean)this.f_19804_.m_135370_(IS_LOGAN_VORTEX);
        boolean isExodus = (Boolean)this.f_19804_.m_135370_(IS_EXODUS_VORTEX);
        boolean isEgyptian = (Boolean)this.f_19804_.m_135370_(IS_EGYPTIAN_VORTEX);
        boolean isProto = (Boolean)this.f_19804_.m_135370_(IS_PROTO_VORTEX);
        aesthetic.f_19804_.m_135381_(IS_LOGAN_VORTEX, (Object)isLogan);
        aesthetic.f_19804_.m_135381_(IS_EXODUS_VORTEX, (Object)isExodus);
        aesthetic.f_19804_.m_135381_(IS_EGYPTIAN_VORTEX, (Object)isEgyptian);
        aesthetic.f_19804_.m_135381_(IS_PROTO_VORTEX, (Object)isProto);
        if (this.isRaidPortal()) {
            aesthetic.setRaidPortal(true);
        }
        if (!this.timerStack.m_41619_()) {
            aesthetic.timerStack = this.timerStack.m_41777_();
            if (isProto) {
                aesthetic.timerStack.m_41784_().m_128379_("IsProtoVortex", true);
            }
        }
        aesthetic.enableFrontCollisionVolume = false;
        aesthetic.enableBackCollisionVolume = true;
        return aesthetic;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFETIME, (Object)0);
        this.f_19804_.m_135372_(IS_RETURN_PORTAL, (Object)false);
        this.f_19804_.m_135372_(HAS_BEEN_USED, (Object)false);
        this.f_19804_.m_135372_(IS_LOGAN_VORTEX, (Object)false);
        this.f_19804_.m_135372_(IS_EXODUS_VORTEX, (Object)false);
        this.f_19804_.m_135372_(IS_EGYPTIAN_VORTEX, (Object)false);
        this.f_19804_.m_135372_(IS_PROTO_VORTEX, (Object)false);
        this.f_19804_.m_135372_(IS_RAID_PORTAL, (Object)false);
        this.f_19804_.m_135372_(USES_IMMERSIVE_PORTAL, (Object)false);
        this.f_19804_.m_135372_(CUSTOM_MODEL_ID, (Object)"");
        this.f_19804_.m_135372_(CUSTOM_TEXTURE_ID, (Object)"");
        this.f_19804_.m_135372_(CUSTOM_TINT, (Object)0xFFFFFF);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            Entity portalEntity;
            ServerLevel serverLevel;
            Level level;
            if (this.closingAnimationStarted) {
                Level level2 = this.m_9236_();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)level2;
                    this.tickClosingAnimation(serverLevel2);
                } else {
                    this.finalizeClosing();
                }
                return;
            }
            if (!this.backCollisionImmunity.isEmpty()) {
                this.backCollisionImmunity.replaceAll((uuid, ticks) -> ticks - 1);
                this.backCollisionImmunity.values().removeIf(ticks -> ticks <= 0);
            }
            int lifetime = (Integer)this.f_19804_.m_135370_(LIFETIME);
            boolean hasBeenUsed = (Boolean)this.f_19804_.m_135370_(HAS_BEEN_USED);
            boolean isRaidPortal = (Boolean)this.f_19804_.m_135370_(IS_RAID_PORTAL);
            boolean isReturnPortal = this.isReturnPortal();
            if (this.immersivePortalId != null && (level = this.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                if (this.f_19797_ % 20 == 0 && (!((portalEntity = serverLevel.m_8791_(this.immersivePortalId)) instanceof Portal) || portalEntity.m_213877_())) {
                    this.immersivePortalId = null;
                    this.f_19804_.m_135381_(USES_IMMERSIVE_PORTAL, (Object)false);
                }
            }
            if (isReturnPortal) {
                this.detectEntityPassThrough();
            } else {
                this.checkEntityCollisions();
            }
            this.f_19804_.m_135381_(LIFETIME, (Object)(++lifetime));
            if (this.spawnGameTime < 0L && (portalEntity = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevelSpawn = (ServerLevel)portalEntity;
                this.spawnGameTime = serverLevelSpawn.m_46467_();
            }
            if (!isRaidPortal && (portalEntity = this.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)portalEntity;
                long now = serverLevel.m_46467_();
                if (this.closeAtGameTime < 0L && this.spawnGameTime >= 0L) {
                    long l = this.closeAtGameTime = hasBeenUsed && this.lastUseGameTime > 0L ? this.lastUseGameTime + 200L : this.spawnGameTime + 600L;
                }
                if (this.closeAtGameTime > 0L && now >= this.closeAtGameTime) {
                    if (!hasBeenUsed && this.timerStack != null && !this.timerStack.m_41619_() && this.ownerUUID != null) {
                        ItemStack stack;
                        ServerPlayer owner;
                        boolean isForcedVortex;
                        ServerPlayer owner2;
                        CompoundTag stackTag = this.timerStack.m_41784_();
                        boolean isDamagedVortex = stackTag.m_128471_("IsDamagedVortex");
                        if (isDamagedVortex && (owner2 = serverLevel.m_7654_().m_6846_().m_11259_(this.ownerUUID)) != null) {
                            ItemStack damagedTimer = null;
                            for (ItemStack invStack : owner2.m_150109_().f_35974_) {
                                if (!(invStack.m_41720_() instanceof OriginalTimerDamagedItem) && !(invStack.m_41720_() instanceof LoganTimerDamagedItem) && !(invStack.m_41720_() instanceof UpgradedLoganTimerTier1DamagedItem) && !(invStack.m_41720_() instanceof UpgradedLoganTimerTier2DamagedItem) && !(invStack.m_41720_() instanceof UpgradedLoganTimerTier3DamagedItem) && !(invStack.m_41720_() instanceof ExodusTimerDamagedItem) && !(invStack.m_41720_() instanceof EgyptianTimerDamagedItem) || !invStack.m_41784_().m_128471_("IsActive")) continue;
                                damagedTimer = invStack;
                                break;
                            }
                            if (damagedTimer != null) {
                                StuckTimerManager.executeStuckTransformation(owner2, damagedTimer);
                            } else {
                                SlidersMod.LOGGER.warn("Could not find ACTIVE damaged timer for stuck transformation!");
                            }
                        }
                        if ((isForcedVortex = stackTag.m_128471_("IsForcedVortex")) && (owner = serverLevel.m_7654_().m_6846_().m_11259_(this.ownerUUID)) != null) {
                            ForceVortexManager.executeInstantBurnout(owner, this.timerStack);
                            owner.m_5661_((Component)Component.m_237113_((String)"?c?l Vortex closed without traversal! Timer damaged."), true);
                        }
                        if ((owner = serverLevel.m_7654_().m_6846_().m_11259_(this.ownerUUID)) != null && !(stack = this.resolveOwnerTimer(owner)).m_41619_()) {
                            VortexEntity.resetTimerPolymorphic(stack);
                            VortexEntity.setCooldownOverheat(stack, owner.m_9236_());
                            owner.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u00a7lVortex closed! Timer cooled down."), true);
                        }
                    }
                    this.playCloseSound();
                    this.requestCloseWithAnimation();
                    return;
                }
            }
        } else if (this.f_19797_ == 1) {
            this.startAmbientSound();
        }
    }

    private void detectEntityPassThrough() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AABB bounds = new AABB(this.m_20185_() - 1.5, this.m_20186_() - 1.5, this.m_20189_() - 1.5, this.m_20185_() + 1.5, this.m_20186_() + 1.5, this.m_20189_() + 1.5);
        List entities = serverLevel.m_6249_((Entity)this, bounds, entity -> entity != this && entity.m_6084_());
        this.processBackCollisions(serverLevel, entities);
        for (Entity entity2 : entities) {
            if (!(entity2.m_20280_((Entity)this) <= 2.25) || !(entity2 instanceof Player) && !(entity2 instanceof LivingEntity) && !(entity2 instanceof ItemEntity)) continue;
            this.markAsUsed();
            break;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void startAmbientSound() {
        Minecraft minecraft = Minecraft.m_91087_();
        VortexAmbientSoundInstance soundInstance = new VortexAmbientSoundInstance(this);
        minecraft.m_91106_().m_120367_((SoundInstance)soundInstance);
    }

    private void checkEntityCollisions() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AABB bounds = new AABB(this.m_20185_() - 1.5, this.m_20186_() - 1.5, this.m_20189_() - 1.5, this.m_20185_() + 1.5, this.m_20186_() + 1.5, this.m_20189_() + 1.5);
        List entities = this.m_9236_().m_6249_((Entity)this, bounds, entity -> entity != this && entity.m_6084_());
        VortexCollisionObjEntity frontCollider = this.getFrontCollisionVolume(serverLevel);
        VortexCollisionObjEntity backCollider = this.getBackCollisionVolume(serverLevel);
        for (Entity entity2 : entities) {
            boolean hitBack;
            boolean bl = hitBack = backCollider != null && backCollider.isEntityTouching(entity2) && entity2 instanceof Player;
            if (hitBack) {
                this.handleBackCollision((Player)entity2, serverLevel, backCollider);
                continue;
            }
            double distanceSq = entity2.m_20280_((Entity)this);
            boolean intersects = frontCollider != null ? frontCollider.isEntityTouching(entity2) : distanceSq <= 2.25;
            if (!intersects) continue;
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                this.teleportPlayer(player, serverLevel);
                continue;
            }
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity2;
                this.teleportLivingEntity(livingEntity, serverLevel);
                continue;
            }
            if (!(entity2 instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity2;
            this.teleportItem(itemEntity, serverLevel);
        }
    }

    @Nullable
    protected VortexCollisionObjEntity getFrontCollisionVolume(ServerLevel serverLevel) {
        if (this.collisionEntityId == null) {
            return null;
        }
        Entity collision = serverLevel.m_8791_(this.collisionEntityId);
        if (collision instanceof VortexCollisionObjEntity) {
            VortexCollisionObjEntity collider = (VortexCollisionObjEntity)collision;
            return collider;
        }
        this.collisionEntityId = null;
        return null;
    }

    @Nullable
    protected VortexCollisionObjEntity getBackCollisionVolume(ServerLevel serverLevel) {
        if (this.backCollisionEntityId == null) {
            return null;
        }
        Entity collision = serverLevel.m_8791_(this.backCollisionEntityId);
        if (collision instanceof VortexCollisionObjEntity) {
            VortexCollisionObjEntity collider = (VortexCollisionObjEntity)collision;
            return collider;
        }
        this.backCollisionEntityId = null;
        return null;
    }

    private void markAsUsed() {
        if (((Boolean)this.f_19804_.m_135370_(IS_RAID_PORTAL)).booleanValue()) {
            return;
        }
        this.usedAtTick = (Integer)this.f_19804_.m_135370_(LIFETIME);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel srv = (ServerLevel)level;
            this.lastUseGameTime = srv.m_46467_();
            if (!this.hasFixedPortalLifetime) {
                this.closeAtGameTime = this.lastUseGameTime + 200L;
            }
        } else {
            this.lastUseGameTime = this.f_19797_;
            if (!this.hasFixedPortalLifetime) {
                this.closeAtGameTime = this.lastUseGameTime + 200L;
            }
        }
        if (!((Boolean)this.f_19804_.m_135370_(HAS_BEEN_USED)).booleanValue()) {
            this.f_19804_.m_135381_(HAS_BEEN_USED, (Object)true);
            String string = this.isReturnPortal() ? "aesthetic" : "normal";
        }
    }

    public void initializeLifetimeWindow(ServerLevel level, boolean alreadyUsed) {
        long now;
        this.spawnGameTime = now = level.m_46467_();
        if (alreadyUsed) {
            this.f_19804_.m_135381_(HAS_BEEN_USED, (Object)true);
            this.lastUseGameTime = now;
            this.closeAtGameTime = now + 200L;
        } else {
            this.closeAtGameTime = now + 600L;
        }
    }

    protected void enforceFixedLifetime(ServerLevel level, int durationTicks) {
        this.hasFixedPortalLifetime = true;
        this.fixedPortalLifetimeTicks = durationTicks;
        this.overrideCloseAtGameTime(level.m_46467_() + (long)durationTicks);
    }

    public void applyFixedLifetime(ServerLevel level, int durationTicks) {
        this.enforceFixedLifetime(level, durationTicks);
    }

    private void applyPortalStabilityFromStack(ServerLevel serverLevel) {
        if (this.timerStack.m_41619_()) {
            return;
        }
        if (TimerUpgradeData.hasPortalStabilityUpgrade(this.timerStack)) {
            int ticks = TimerUpgradeData.getPortalDurationTicks(this.timerStack);
            this.enforceFixedLifetime(serverLevel, ticks);
        }
    }

    public long getCloseAtGameTimeValue() {
        return this.closeAtGameTime;
    }

    public void overrideCloseAtGameTime(long absoluteTick) {
        this.closeAtGameTime = absoluteTick;
    }

    public static int getPostUseLifetimeTicks() {
        return 200;
    }

    public void setRaidPortal(boolean raidPortal) {
        this.f_19804_.m_135381_(IS_RAID_PORTAL, (Object)raidPortal);
    }

    public boolean isRaidPortal() {
        return (Boolean)this.f_19804_.m_135370_(IS_RAID_PORTAL);
    }

    protected void handleBackCollision(Player player, ServerLevel serverLevel, VortexCollisionObjEntity collider) {
        Integer immunity = this.backCollisionImmunity.get(player.m_20148_());
        if (immunity != null && immunity > 0) {
            return;
        }
        float damage = Math.max(collider.getDamageAmount(), 0.0f);
        if (damage > 0.0f) {
            player.m_6469_(serverLevel.m_269111_().m_269425_(), damage);
        }
        float knockback = Math.max(collider.getKnockback(), 0.0f);
        Vec3 push = collider.getNormal().m_82541_();
        double strength = 0.5 + (double)knockback;
        player.m_5997_(push.f_82479_ * strength, 0.25 + (double)knockback * 0.2, push.f_82481_ * strength);
        player.f_19864_ = true;
    }

    protected void processBackCollisions(ServerLevel serverLevel, List<Entity> entities) {
        VortexCollisionObjEntity backCollider = this.getBackCollisionVolume(serverLevel);
        if (backCollider == null) {
            return;
        }
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (!backCollider.isEntityTouching(entity)) continue;
            this.handleBackCollision(player, serverLevel, backCollider);
        }
    }

    private void emitTeleportPoof(Vec3 origin) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, origin.f_82479_, origin.f_82480_ + 0.5, origin.f_82481_, 12, 0.25, 0.25, 0.25, 0.01);
        serverLevel.m_6263_(null, origin.f_82479_, origin.f_82480_, origin.f_82481_, SoundEvents.f_11928_, SoundSource.AMBIENT, 0.6f, 1.6f);
    }

    private void teleportPlayer(Player player, ServerLevel serverLevel) {
        ServerLevel targetLevel;
        DimensionManager.RandomDestination destination;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ForceVortexManager.cancelWarningForPlayer(serverPlayer.m_20148_(), serverLevel.m_7654_());
        }
        if ((destination = this.cachedDestination) == null) {
            player.m_5661_((Component)Component.m_237113_((String)"cFailed to find destination!"), true);
            return;
        }
        if (this.timerStack.m_41619_()) {
            SlidersMod.LOGGER.error("Timer stack is empty in VortexEntity! Cannot schedule return.");
            player.m_5661_((Component)Component.m_237113_((String)"cTimer error! Cannot schedule return."), true);
            this.requestCloseWithAnimation();
            return;
        }
        this.markAsUsed();
        CompoundTag tag = this.timerStack.m_41784_();
        boolean isQuantumGate = tag.m_128471_("IsQuantumGatePrototype");
        boolean isForcedVortex = tag.m_128471_("IsForcedVortex");
        boolean isDamagedVortex = tag.m_128471_("IsDamagedVortex");
        if (isForcedVortex || isDamagedVortex) {
            // empty if block
        }
        if ((targetLevel = serverLevel.m_7654_().m_129880_(destination.dimension)) != null) {
            ExodusVortexEntity exodusVortex;
            String generatedSeed;
            this.emitTeleportPoof(player.m_20182_());
            player.m_264318_(targetLevel, (double)destination.pos.m_123341_() + 0.5, (double)destination.pos.m_123342_(), (double)destination.pos.m_123343_() + 0.5, Set.of(), player.m_146908_(), player.m_146909_());
            if (isForcedVortex && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ForceVortexManager.executeInstantBurnout(serverPlayer, this.timerStack);
                tag.m_128473_("IsForcedVortex");
            } else if (isDamagedVortex && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.createNewDamagedTimer(serverPlayer);
                tag.m_128473_("IsDamagedVortex");
            }
            Vec3 lookDirection = player.m_20154_();
            double verticalBoost = 0.2;
            player.m_20334_(lookDirection.f_82479_ * 0.5, 0.5, lookDirection.f_82481_ * 0.5);
            player.f_19864_ = true;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AchievementManager.triggerFirstSlide(serverPlayer);
                serverPlayer.m_6330_((SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.PLAYERS, 3.0f, 1.0f);
                if (serverLevel.m_7654_() != null) {
                    for (ServerPlayer observer : serverLevel.m_7654_().m_6846_().m_11314_()) {
                        if (observer.m_20148_().equals(serverPlayer.m_20148_()) || !observer.m_9236_().m_46472_().equals((Object)serverLevel.m_46472_()) || !(observer.m_20183_().m_123331_((Vec3i)this.m_20183_()) <= 1024.0)) continue;
                        AchievementManager.grantAchievement(observer, "tier_2_dont_slide_alone", "saw_slide");
                    }
                }
            }
            serverLevel.m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            targetLevel.m_5594_(null, destination.pos, (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            Vec3 aestheticCenter = new Vec3((double)destination.pos.m_123341_() + 0.5, (double)destination.pos.m_123342_() + 2.2, (double)destination.pos.m_123343_() + 0.5);
            VortexEntity aestheticVortex = this.findLinkedAesthetic(targetLevel);
            if (aestheticVortex == null) {
                aestheticVortex = this.createAestheticVortex(targetLevel, aestheticCenter.f_82479_, aestheticCenter.f_82480_, aestheticCenter.f_82481_);
                targetLevel.m_7967_((Entity)aestheticVortex);
                aestheticVortex.initializeLifetimeWindow(targetLevel, true);
                long originNow = serverLevel.m_46467_();
                long remainingTicks = this.getCloseAtGameTimeValue() > 0L ? Math.max(1L, this.getCloseAtGameTimeValue() - originNow) : 200L;
                long targetNow = targetLevel.m_46467_();
                aestheticVortex.overrideCloseAtGameTime(targetNow + remainingTicks);
                Vec3 pushDirection = player.m_20154_();
                Vec3 facingVector = pushDirection.m_82490_(-1.0);
                if (facingVector.m_82556_() < 1.0E-4) {
                    facingVector = aestheticCenter.m_82546_(player.m_20182_());
                }
                if (facingVector.m_82556_() < 1.0E-4) {
                    facingVector = new Vec3(0.0, 0.0, 1.0);
                }
                aestheticVortex.spawnOgVisuals(targetLevel, aestheticCenter, facingVector);
                this.linkedAestheticVortexUUID = aestheticVortex.m_20148_();
                this.linkedAestheticDimension = targetLevel.m_46472_();
            }
            aestheticVortex.grantBackCollisionImmunity(player.m_20148_(), 100);
            if (aestheticVortex instanceof ExodusVortexEntity && !(generatedSeed = (exodusVortex = (ExodusVortexEntity)aestheticVortex).getGeneratedSeed()).isEmpty()) {
                String previousSeed = ExodusTimerItem.getConfiguredSeed(this.timerStack);
                boolean wasRandomMode = previousSeed.isEmpty();
                ExodusTimerItem.setConfiguredSeed(this.timerStack, generatedSeed);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PlayerSeedRegistry playerRegistry = PlayerSeedRegistry.get(serverPlayer.m_20194_());
                    playerRegistry.addSeedToPlayer(serverPlayer.m_20148_(), generatedSeed);
                }
                boolean hasSeedUpgrade = TimerUpgradeData.hasSeedUpgrade(this.timerStack);
                if (wasRandomMode && hasSeedUpgrade) {
                    player.m_5661_((Component)Component.m_237113_((String)("Dimension seed generated: " + generatedSeed + " (saved to timer)")).m_130940_(ChatFormatting.GOLD), false);
                }
            }
            this.linkedAestheticVortexUUID = aestheticVortex.m_20148_();
            this.linkedAestheticDimension = targetLevel.m_46472_();
            if (this.isReturnPortal() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!this.timerStack.m_41619_()) {
                    if (isQuantumGate) {
                        serverPlayer.m_5661_((Component)Component.m_237113_((String)"Quantum Gate prototype stabilized.").m_130940_(ChatFormatting.GOLD), true);
                    } else {
                        UUID activeToken = this.getActiveReturnToken();
                        ItemStack inventoryTimer = this.resolveOwnerTimer(serverPlayer);
                        if (!inventoryTimer.m_41619_()) {
                            VortexEntity.resetTimerPolymorphic(inventoryTimer);
                            if (activeToken != null) {
                                DimensionManager.removeReturnToken(serverPlayer, activeToken);
                            }
                            if (!VortexEntity.isDamagedTimer(inventoryTimer)) {
                                int cooldownTicks = ClassicTimerHelper.startCooldownOverheat(inventoryTimer, serverPlayer.m_9236_());
                                int cooldownMinutes = Math.max(1, cooldownTicks / 1200);
                                serverPlayer.m_5661_((Component)Component.m_237113_((String)("Returned to origin - Timer cooling down (" + cooldownMinutes + "min)")).m_130940_(ChatFormatting.GOLD), true);
                            } else {
                                serverPlayer.m_5661_((Component)Component.m_237113_((String)"Returned to origin - Timer reset").m_130940_(ChatFormatting.GREEN), true);
                            }
                            serverPlayer.f_36095_.m_38946_();
                        } else {
                            SlidersMod.LOGGER.warn("Could not find active timer in inventory of type: {}", (Object)this.timerStack.m_41720_().getClass().getSimpleName());
                        }
                    }
                }
            }
            if ((isDamagedVortex || this.isReturnPortal()) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.tryAwardSlideEnhancementChip(serverPlayer);
            }
            if (player instanceof ServerPlayer) {
                double overheatMultiplier;
                double baseOverheatChance;
                double overheatChance;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Random random = new Random();
                double roll = random.nextDouble();
                if (roll < (overheatChance = Math.min(1.0, (baseOverheatChance = TimerUpgradeData.getPermanentOverheatChance(this.timerStack)) * (overheatMultiplier = ((Double)SlidersModConfig.OVERHEAT_PROBABILITY_MULTIPLIER.get()).doubleValue()))) && !this.timerStack.m_41619_()) {
                    ItemStack inventoryTimer = this.resolveOwnerTimer(serverPlayer);
                    if (!inventoryTimer.m_41619_()) {
                        VortexEntity.setTimerOverheated(inventoryTimer, true);
                        targetLevel.m_5594_(null, destination.pos, (SoundEvent)ModSounds.TIMER_BURNOUT.get(), SoundSource.PLAYERS, 1.5f, 1.0f);
                        ForceVortexManager.scheduleBurnoutParticles(serverPlayer.m_20148_(), targetLevel.m_46467_() + 40L);
                        serverPlayer.m_5661_((Component)Component.m_237113_((String)"Timer overheated !"), false);
                    } else {
                        SlidersMod.LOGGER.warn("Could not find timer in inventory to mark as overheated!");
                    }
                }
            }
            if (!isForcedVortex && !isDamagedVortex && this.ownerUUID != null && this.ownerUUID.equals(player.m_20148_()) && !this.returnScheduled) {
                if (this.shouldScheduleReturnForQuantumGate(player)) {
                    DimensionManager.scheduleReturn(player, this.timerStack, destination.dimension, destination.pos);
                    this.returnScheduled = true;
                }
            } else if (!isForcedVortex && !isDamagedVortex && this.ownerUUID != null && !this.ownerUUID.equals(player.m_20148_()) || isForcedVortex || isDamagedVortex) {
                // empty if block
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int i = 1;
                while (i <= 10) {
                    int delay = i++;
                    targetLevel.m_7654_().m_6937_((Runnable)new TickTask(delay, () -> ForceVortexManager.cancelWarningForPlayer(serverPlayer.m_20148_(), targetLevel.m_7654_())));
                }
            }
        }
    }

    protected void tryAwardSlideEnhancementChip(ServerPlayer player) {
        if (player == null) {
            return;
        }
        if (player.m_217043_().m_188501_() > 0.2f) {
            return;
        }
        ItemStack chip = new ItemStack((ItemLike)ModItems.SLIDE_ENHANCEMENT_CHIP.get());
        boolean added = player.m_150109_().m_36054_(chip);
        if (!added) {
            player.m_36176_(chip, false);
        }
        player.m_5661_((Component)Component.m_237113_((String)"You found a slide enhancement chip !"), true);
    }

    private void createNewDamagedTimer(ServerPlayer player) {
        ItemStack oldDamagedTimer = null;
        int timerSlot = -1;
        String damagedTimerType = null;
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (!(stack.m_41720_() instanceof OriginalTimerDamagedItem) && !(stack.m_41720_() instanceof LoganTimerDamagedItem) && !(stack.m_41720_() instanceof UpgradedLoganTimerTier1DamagedItem) && !(stack.m_41720_() instanceof UpgradedLoganTimerTier2DamagedItem) && !(stack.m_41720_() instanceof UpgradedLoganTimerTier3DamagedItem) && !(stack.m_41720_() instanceof ExodusTimerDamagedItem) && !(stack.m_41720_() instanceof EgyptianTimerDamagedItem) || !stack.m_41784_().m_128471_("IsActive")) continue;
            oldDamagedTimer = stack;
            timerSlot = i;
            damagedTimerType = stack.m_41720_().getClass().getSimpleName();
            break;
        }
        if (oldDamagedTimer != null && timerSlot >= 0) {
            ItemStack newDamagedTimer;
            int preservedTrackingMode;
            CompoundTag oldTag = oldDamagedTimer.m_41784_();
            CompoundTag upgradesCopy = oldTag.m_128425_("TimerUpgrades", 10) ? oldTag.m_128469_("TimerUpgrades").m_6426_() : null;
            int n = preservedTrackingMode = oldTag.m_128441_("TrackingMode") ? oldTag.m_128451_("TrackingMode") : -1;
            if (oldDamagedTimer.m_41720_() instanceof UpgradedLoganTimerTier1DamagedItem) {
                int targetX = UpgradedLoganTimerTier1DamagedItem.getConfiguredX(oldDamagedTimer);
                int targetZ = UpgradedLoganTimerTier1DamagedItem.getConfiguredZ(oldDamagedTimer);
                newDamagedTimer = new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER1_DAMAGED.get());
                UpgradedLoganTimerTier1DamagedItem.initializeDamagedTimer(newDamagedTimer, player.m_9236_(), targetX, targetZ);
            } else if (oldDamagedTimer.m_41720_() instanceof UpgradedLoganTimerTier2DamagedItem) {
                int targetX = UpgradedLoganTimerTier2DamagedItem.getConfiguredX(oldDamagedTimer);
                int targetZ = UpgradedLoganTimerTier2DamagedItem.getConfiguredZ(oldDamagedTimer);
                newDamagedTimer = new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER2_DAMAGED.get());
                UpgradedLoganTimerTier2DamagedItem.initializeDamagedTimer(newDamagedTimer, player.m_9236_(), targetX, targetZ);
            } else if (oldDamagedTimer.m_41720_() instanceof UpgradedLoganTimerTier3DamagedItem) {
                int targetX = UpgradedLoganTimerTier3DamagedItem.getConfiguredX(oldDamagedTimer);
                int targetZ = UpgradedLoganTimerTier3DamagedItem.getConfiguredZ(oldDamagedTimer);
                newDamagedTimer = new ItemStack((ItemLike)ModItems.UPGRADED_LOGAN_TIMER_TIER3_DAMAGED.get());
                UpgradedLoganTimerTier3DamagedItem.initializeDamagedTimer(newDamagedTimer, player.m_9236_(), targetX, targetZ);
            } else if (oldDamagedTimer.m_41720_() instanceof LoganTimerDamagedItem) {
                newDamagedTimer = new ItemStack((ItemLike)ModItems.LOGAN_TIMER_DAMAGED.get());
                LoganTimerDamagedItem.initializeDamagedTimer(newDamagedTimer, player.m_9236_());
            } else if (oldDamagedTimer.m_41720_() instanceof ExodusTimerDamagedItem) {
                String configuredSeed = oldTag.m_128425_("ConfiguredSeed", 8) ? oldTag.m_128461_("ConfiguredSeed") : "";
                newDamagedTimer = new ItemStack((ItemLike)ModItems.EXODUS_TIMER_DAMAGED.get());
                ExodusTimerDamagedItem.initializeDamagedTimer(newDamagedTimer, player.m_9236_(), configuredSeed);
            } else if (oldDamagedTimer.m_41720_() instanceof EgyptianTimerDamagedItem) {
                newDamagedTimer = new ItemStack((ItemLike)ModItems.EGYPTIAN_TIMER_DAMAGED.get());
                EgyptianTimerDamagedItem.initializeDamagedTimer(newDamagedTimer, player.m_9236_());
            } else {
                newDamagedTimer = new ItemStack((ItemLike)ModItems.ORIGINAL_TIMER_DAMAGED.get());
                OriginalTimerDamagedItem.initializeDamagedTimer(newDamagedTimer, player.m_9236_());
            }
            CompoundTag newTag = newDamagedTimer.m_41784_();
            if (upgradesCopy != null) {
                newTag.m_128365_("TimerUpgrades", (Tag)upgradesCopy);
            }
            if (preservedTrackingMode >= 0) {
                newTag.m_128405_("TrackingMode", preservedTrackingMode);
            }
            player.m_150109_().m_6836_(timerSlot, newDamagedTimer);
            player.m_5661_((Component)Component.m_237113_((String)"?eNew random jump duration assigned..."), true);
        } else {
            SlidersMod.LOGGER.warn("Could not find ACTIVE damaged timer in inventory!");
        }
    }

    private void teleportLivingEntity(LivingEntity entity, ServerLevel serverLevel) {
        DimensionManager.RandomDestination destination = this.cachedDestination;
        if (destination == null) {
            return;
        }
        this.markAsUsed();
        ServerLevel targetLevel = serverLevel.m_7654_().m_129880_(destination.dimension);
        if (targetLevel != null) {
            this.emitTeleportPoof(entity.m_20182_());
            entity.m_264318_(targetLevel, (double)destination.pos.m_123341_() + 0.5, (double)destination.pos.m_123342_(), (double)destination.pos.m_123343_() + 0.5, Set.of(), entity.m_146908_(), entity.m_146909_());
            Vec3 lookDirection = entity.m_20154_();
            entity.m_20334_(lookDirection.f_82479_ * 0.5, 0.3, lookDirection.f_82481_ * 0.5);
            entity.f_19864_ = true;
            serverLevel.m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            targetLevel.m_5594_(null, destination.pos, (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
        }
    }

    private void teleportItem(ItemEntity itemEntity, ServerLevel serverLevel) {
        ServerLevel targetLevel;
        DimensionManager.RandomDestination destination = this.cachedDestination;
        if (destination == null) {
            return;
        }
        this.markAsUsed();
        if (itemEntity.m_32055_().m_41720_() == Items.f_42415_) {
            for (ServerPlayer player : serverLevel.m_8795_(p -> p.m_20183_().m_123331_((Vec3i)this.m_20183_()) < 100.0)) {
                AchievementManager.triggerItemThrownInVortex(player);
            }
        }
        if ((targetLevel = serverLevel.m_7654_().m_129880_(destination.dimension)) != null) {
            this.emitTeleportPoof(itemEntity.m_20182_());
            ItemEntity newItem = new ItemEntity((Level)targetLevel, (double)destination.pos.m_123341_() + 0.5, (double)destination.pos.m_123342_(), (double)destination.pos.m_123343_() + 0.5, itemEntity.m_32055_().m_41777_());
            newItem.m_20256_(itemEntity.m_20184_());
            targetLevel.m_7967_((Entity)newItem);
            itemEntity.m_146870_();
            serverLevel.m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            targetLevel.m_5594_(null, destination.pos, (SoundEvent)ModSounds.VORTEX_GO.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
        }
    }

    private void spawnParticles() {
    }

    private void playCloseSound() {
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.VORTEX_CLOSE.get(), SoundSource.AMBIENT, 1.5f, 1.0f);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_) {
            if (this.closingAnimationStarted) {
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.tickClosingAnimation(serverLevel);
                } else {
                    this.finalizeClosing();
                }
                return;
            }
            this.discardBoundPortal();
            this.discardBoundDecoration();
            this.discardBackDecoration();
            this.discardFrontCollisionVolume();
            this.discardBackCollisionVolume();
            this.removeTemporaryLight();
        }
        super.m_142687_(reason);
    }

    public void bindImmersivePortal(UUID portalId) {
        this.immersivePortalId = portalId;
        this.f_19804_.m_135381_(USES_IMMERSIVE_PORTAL, (Object)true);
    }

    public void reserveImmersivePortalVisual() {
        this.f_19804_.m_135381_(USES_IMMERSIVE_PORTAL, (Object)true);
    }

    public void cancelImmersivePortalReservationIfUnbound() {
        if (this.immersivePortalId == null) {
            this.f_19804_.m_135381_(USES_IMMERSIVE_PORTAL, (Object)false);
        }
    }

    public void bindDecoration(@Nullable UUID decorationId) {
        this.decorationEntityId = decorationId;
    }

    public void bindBackDecoration(@Nullable UUID decorationId) {
        this.backDecorationEntityId = decorationId;
    }

    public void bindCollisionVolume(@Nullable UUID collisionId) {
        this.collisionEntityId = collisionId;
    }

    public void bindBackCollisionVolume(@Nullable UUID collisionId) {
        this.backCollisionEntityId = collisionId;
    }

    public void bindCustomShowcase(@Nullable UUID entityId) {
        this.customShowcaseEntityId = entityId;
    }

    @Nullable
    public UUID getCustomShowcaseEntityId() {
        return this.customShowcaseEntityId;
    }

    public void setLinkedAestheticVortex(UUID uuid) {
        this.linkedAestheticVortexUUID = uuid;
    }

    private VortexEntity findLinkedAesthetic(ServerLevel level) {
        if (this.linkedAestheticVortexUUID == null) {
            return null;
        }
        if (this.linkedAestheticDimension != null && !level.m_46472_().equals(this.linkedAestheticDimension)) {
            return null;
        }
        Entity linked = level.m_8791_(this.linkedAestheticVortexUUID);
        if (linked instanceof VortexEntity) {
            VortexEntity vortex = (VortexEntity)linked;
            if (!linked.m_213877_()) {
                return vortex;
            }
        }
        return null;
    }

    public void setTimerStack(ItemStack stack) {
        this.timerStack = stack == null ? ItemStack.f_41583_ : stack.m_41777_();
    }

    public void setOwnerUUID(@Nullable UUID owner) {
        this.ownerUUID = owner;
    }

    public void setCollisionVolumesEnabled(boolean front, boolean back) {
        this.enableFrontCollisionVolume = front;
        this.enableBackCollisionVolume = back;
    }

    public void setLifetimeTicks(int ticks) {
        this.f_19804_.m_135381_(LIFETIME, (Object)ticks);
    }

    public void markAsAlreadyUsed() {
        this.f_19804_.m_135381_(HAS_BEEN_USED, (Object)true);
        this.usedAtTick = 0;
    }

    public void setUsedAtTickToNow() {
        this.usedAtTick = (Integer)this.f_19804_.m_135370_(LIFETIME);
        this.f_19804_.m_135381_(HAS_BEEN_USED, (Object)true);
    }

    public void rememberPortalTargetSize(double width, double height) {
        this.portalTargetWidth = width;
        this.portalTargetHeight = height;
    }

    public double getPortalTargetWidth() {
        return this.portalTargetWidth;
    }

    public double getPortalTargetHeight() {
        return this.portalTargetHeight;
    }

    public void grantBackCollisionImmunity(UUID playerId, int ticks) {
        if (playerId == null || ticks <= 0) {
            return;
        }
        this.backCollisionImmunity.put(playerId, Math.max(this.backCollisionImmunity.getOrDefault(playerId, 0), ticks));
    }

    public void setLightAnchor(BlockPos pos) {
        this.lightAnchorPos = pos;
        this.placeTemporaryLight();
    }

    public boolean usesImmersivePortalVisual() {
        return (Boolean)this.f_19804_.m_135370_(USES_IMMERSIVE_PORTAL);
    }

    private void discardBoundPortal() {
        if (this.immersivePortalId == null) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            this.immersivePortalId = null;
            this.f_19804_.m_135381_(USES_IMMERSIVE_PORTAL, (Object)false);
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity portalEntity = serverLevel.m_8791_(this.immersivePortalId);
        if (portalEntity instanceof Portal) {
            portalEntity.m_146870_();
        }
        VortexPortalTracker.unregister(serverLevel, this.immersivePortalId);
        this.immersivePortalId = null;
        this.f_19804_.m_135381_(USES_IMMERSIVE_PORTAL, (Object)false);
    }

    private void discardBoundDecoration() {
        if (this.decorationEntityId == null) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            this.decorationEntityId = null;
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity decoration = serverLevel.m_8791_(this.decorationEntityId);
        if (decoration != null) {
            decoration.m_146870_();
        }
        this.decorationEntityId = null;
    }

    private void discardBackDecoration() {
        if (this.backDecorationEntityId == null) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            this.backDecorationEntityId = null;
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity decoration = serverLevel.m_8791_(this.backDecorationEntityId);
        if (decoration != null) {
            decoration.m_146870_();
        }
        this.backDecorationEntityId = null;
    }

    private void discardFrontCollisionVolume() {
        if (this.collisionEntityId == null) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            this.collisionEntityId = null;
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity collision = serverLevel.m_8791_(this.collisionEntityId);
        if (collision != null) {
            collision.m_146870_();
        }
        this.collisionEntityId = null;
    }

    private void discardBackCollisionVolume() {
        if (this.backCollisionEntityId == null) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            this.backCollisionEntityId = null;
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity collision = serverLevel.m_8791_(this.backCollisionEntityId);
        if (collision != null) {
            collision.m_146870_();
        }
        this.backCollisionEntityId = null;
    }

    public void discardCustomShowcaseEntity() {
        Entity tunnel;
        if (this.customShowcaseEntityId == null) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            this.customShowcaseEntityId = null;
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ServerLevel showcase = serverLevel.m_7654_().m_129880_(VortexShowcaseManager.dimensionKey());
        if (showcase != null && (tunnel = showcase.m_8791_(this.customShowcaseEntityId)) != null) {
            tunnel.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.customShowcaseEntityId = null;
    }

    private void placeTemporaryLight() {
        if (this.lightPlaced || this.lightAnchorPos == null) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState state = serverLevel.m_8055_(this.lightAnchorPos);
        if (!state.m_60795_() && !state.m_60713_(Blocks.f_152480_)) {
            return;
        }
        BlockState lightState = (BlockState)Blocks.f_152480_.m_49966_().m_61124_((Property)LightBlock.f_153657_, (Comparable)Integer.valueOf(15));
        serverLevel.m_7731_(this.lightAnchorPos, lightState, 3);
        this.lightPlaced = true;
    }

    private void removeTemporaryLight() {
        if (!this.lightPlaced || this.lightAnchorPos == null) {
            return;
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            this.lightPlaced = false;
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState state = serverLevel.m_8055_(this.lightAnchorPos);
        if (state.m_60713_(Blocks.f_152480_)) {
            serverLevel.m_7731_(this.lightAnchorPos, Blocks.f_50016_.m_49966_(), 3);
        }
        this.lightPlaced = false;
    }

    private static VortexPortalPlacement buildPlacementFacing(Vec3 center, Vec3 facing) {
        Vec3 axisH;
        Vec3 normal;
        Vec3 axisW;
        Vec3 horizontal = new Vec3(facing.f_82479_, 0.0, facing.f_82481_);
        if (horizontal.m_82556_() < 1.0E-4) {
            horizontal = new Vec3(0.0, 0.0, 1.0);
        }
        axisW = (axisW = (normal = horizontal.m_82541_()).m_82537_(axisH = new Vec3(0.0, 1.0, 0.0))).m_82556_() < 1.0E-4 ? new Vec3(1.0, 0.0, 0.0) : axisW.m_82541_();
        axisH = axisW.m_82537_(normal).m_82541_();
        return new VortexPortalPlacement(center, axisW, axisH, normal, false);
    }

    private static void attachOgVisuals(ServerLevel level, VortexEntity vortex, Vec3 center, Vec3 facing) {
        VortexPortalPlacement placement = VortexEntity.buildPlacementFacing(center, facing);
        VortexImmersivePortalHelper.attachVisuals(level, vortex, placement, null);
    }

    public void spawnOgVisuals(ServerLevel level, Vec3 center, Vec3 facing) {
        VortexEntity.attachOgVisuals(level, this, center, facing);
    }

    public boolean wantsBackDecoration() {
        return this.enableBackDecoration;
    }

    public void setBackDecorationEnabled(boolean enabled) {
        this.enableBackDecoration = enabled;
    }

    public boolean wantsFrontCollisionVolume() {
        return this.enableFrontCollisionVolume;
    }

    public void setFrontCollisionEnabled(boolean enabled) {
        this.enableFrontCollisionVolume = enabled;
    }

    public boolean wantsBackCollisionVolume() {
        return this.enableBackCollisionVolume;
    }

    public void setBackCollisionEnabled(boolean enabled) {
        this.enableBackCollisionVolume = enabled;
    }

    protected void requestCloseWithAnimation() {
        ServerLevel serverLevel;
        block5: {
            block4: {
                if (this.closingAnimationStarted) {
                    return;
                }
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (this.usesImmersivePortalVisual()) break block5;
            }
            this.closingAnimationStarted = false;
            this.closingAnimationTick = 0;
            this.discardBoundPortal();
            this.discardBoundDecoration();
            this.discardCustomShowcaseEntity();
            super.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        this.closingAnimationStarted = true;
        this.closingAnimationTick = 0;
        this.triggerBorderFadeOut(serverLevel);
    }

    private void triggerBorderFadeOut(ServerLevel serverLevel) {
        Entity decoration;
        if (this.decorationEntityId != null && (decoration = serverLevel.m_8791_(this.decorationEntityId)) instanceof OgVortexBorderObjEntity) {
            OgVortexBorderObjEntity border = (OgVortexBorderObjEntity)decoration;
            border.startFadeOut();
        }
        if (this.backDecorationEntityId != null && (decoration = serverLevel.m_8791_(this.backDecorationEntityId)) instanceof OgVortexBackObjEntity) {
            OgVortexBackObjEntity back = (OgVortexBackObjEntity)decoration;
            back.hide();
        }
    }

    private void tickClosingAnimation(ServerLevel serverLevel) {
        if (this.immersivePortalId == null) {
            this.finalizeClosing();
            return;
        }
        Entity portalEntity = serverLevel.m_8791_(this.immersivePortalId);
        if (!(portalEntity instanceof Portal)) {
            this.finalizeClosing();
            return;
        }
        Portal portal = (Portal)portalEntity;
        ++this.closingAnimationTick;
        if (this.closingAnimationTick <= 4) {
            return;
        }
        int shrinkTicks = this.closingAnimationTick - 4;
        double progress = Mth.m_14008_((double)((double)shrinkTicks / 8.0), (double)0.0, (double)1.0);
        double size = Mth.m_14139_((double)progress, (double)3.0, (double)0.05);
        VortexImmersivePortalHelper.updatePortalSize(this, portal, Math.max(size, 0.05));
        if (progress >= 1.0) {
            this.finalizeClosing();
        }
    }

    private void finalizeClosing() {
        this.closingAnimationStarted = false;
        this.closingAnimationTick = 0;
        this.discardBoundPortal();
        this.discardBoundDecoration();
        this.discardBackDecoration();
        this.discardFrontCollisionVolume();
        this.discardBackCollisionVolume();
        this.removeTemporaryLight();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VortexImmersivePortalHelper.cleanupResidualPortals(serverLevel, this.m_20182_(), 1.5, 0.75);
        }
        this.discardCustomShowcaseEntity();
        super.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean isReturnPortal() {
        return (Boolean)this.f_19804_.m_135370_(IS_RETURN_PORTAL);
    }

    public boolean isLoganVortex() {
        return (Boolean)this.f_19804_.m_135370_(IS_LOGAN_VORTEX);
    }

    public boolean isExodusVortex() {
        return (Boolean)this.f_19804_.m_135370_(IS_EXODUS_VORTEX);
    }

    public boolean isEgyptianVortex() {
        return (Boolean)this.f_19804_.m_135370_(IS_EGYPTIAN_VORTEX);
    }

    public boolean isProtoVortex() {
        return (Boolean)this.f_19804_.m_135370_(IS_PROTO_VORTEX);
    }

    public void setProtoVortex(boolean value) {
        this.f_19804_.m_135381_(IS_PROTO_VORTEX, (Object)value);
    }

    public String getCustomModelId() {
        return (String)this.f_19804_.m_135370_(CUSTOM_MODEL_ID);
    }

    public void setCustomModelId(@Nullable String id) {
        this.f_19804_.m_135381_(CUSTOM_MODEL_ID, (Object)(id == null ? "" : id));
    }

    public String getCustomTextureId() {
        return (String)this.f_19804_.m_135370_(CUSTOM_TEXTURE_ID);
    }

    public void setCustomTextureId(@Nullable String id) {
        this.f_19804_.m_135381_(CUSTOM_TEXTURE_ID, (Object)(id == null ? "" : id));
    }

    public int getCustomTint() {
        return (Integer)this.f_19804_.m_135370_(CUSTOM_TINT);
    }

    public void setCustomTint(int tint) {
        this.f_19804_.m_135381_(CUSTOM_TINT, (Object)tint);
    }

    public DimensionManager.RandomDestination getCachedDestination() {
        return this.cachedDestination;
    }

    public void setCachedDestination(DimensionManager.RandomDestination destination) {
        this.cachedDestination = destination;
    }

    protected void m_7378_(CompoundTag tag) {
        this.f_19804_.m_135381_(LIFETIME, (Object)tag.m_128451_("Lifetime"));
        this.spawnGameTime = tag.m_128441_("SpawnGameTime") ? tag.m_128454_("SpawnGameTime") : -1L;
        this.lastUseGameTime = tag.m_128441_("LastUseGameTime") ? tag.m_128454_("LastUseGameTime") : -1L;
        this.closeAtGameTime = tag.m_128441_("CloseAtGameTime") ? tag.m_128454_("CloseAtGameTime") : -1L;
        this.closeAtGameTime = tag.m_128441_("CloseAtGameTime") ? tag.m_128454_("CloseAtGameTime") : -1L;
        this.f_19804_.m_135381_(IS_RETURN_PORTAL, (Object)tag.m_128471_("IsReturnPortal"));
        this.f_19804_.m_135381_(HAS_BEEN_USED, (Object)tag.m_128471_("HasBeenUsed"));
        this.f_19804_.m_135381_(IS_RAID_PORTAL, (Object)tag.m_128471_("IsRaidPortal"));
        this.f_19804_.m_135381_(IS_LOGAN_VORTEX, (Object)tag.m_128471_("IsLoganVortex"));
        this.f_19804_.m_135381_(IS_EXODUS_VORTEX, (Object)tag.m_128471_("IsExodusVortex"));
        this.f_19804_.m_135381_(IS_EGYPTIAN_VORTEX, (Object)tag.m_128471_("IsEgyptianVortex"));
        this.f_19804_.m_135381_(IS_PROTO_VORTEX, (Object)tag.m_128471_("IsProtoVortex"));
        this.f_19804_.m_135381_(USES_IMMERSIVE_PORTAL, (Object)tag.m_128471_("UsesImmersivePortal"));
        String modelId = tag.m_128425_("CustomModelId", 8) ? tag.m_128461_("CustomModelId") : "";
        String textureId = tag.m_128425_("CustomTextureId", 8) ? tag.m_128461_("CustomTextureId") : "";
        int tint = tag.m_128425_("CustomTint", 3) ? tag.m_128451_("CustomTint") : 0xFFFFFF;
        this.f_19804_.m_135381_(CUSTOM_MODEL_ID, (Object)modelId);
        this.f_19804_.m_135381_(CUSTOM_TEXTURE_ID, (Object)textureId);
        this.f_19804_.m_135381_(CUSTOM_TINT, (Object)tint);
        boolean bl = this.enableBackDecoration = tag.m_128441_("EnableBackDecoration") ? tag.m_128471_("EnableBackDecoration") : true;
        boolean legacyCollisionFlag = tag.m_128441_("EnableCollisionVolumes") ? tag.m_128471_("EnableCollisionVolumes") : !this.isReturnPortal();
        this.enableFrontCollisionVolume = tag.m_128441_("EnableFrontCollisionVolume") ? tag.m_128471_("EnableFrontCollisionVolume") : legacyCollisionFlag;
        this.enableBackCollisionVolume = tag.m_128441_("EnableBackCollisionVolume") ? tag.m_128471_("EnableBackCollisionVolume") : legacyCollisionFlag;
        this.immersivePortalId = null;
        this.usedAtTick = tag.m_128451_("UsedAtTick");
        this.hasFixedPortalLifetime = tag.m_128471_("HasFixedPortalLifetime");
        this.fixedPortalLifetimeTicks = tag.m_128451_("FixedPortalLifetimeTicks");
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        if (tag.m_128441_("DestinationDim")) {
            ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.parse((String)tag.m_128461_("DestinationDim")));
            BlockPos pos = new BlockPos(tag.m_128451_("DestX"), tag.m_128451_("DestY"), tag.m_128451_("DestZ"));
            this.cachedDestination = new DimensionManager.RandomDestination((ResourceKey<Level>)dim, pos);
        }
        if (tag.m_128403_("LinkedAestheticVortex")) {
            this.linkedAestheticVortexUUID = tag.m_128342_("LinkedAestheticVortex");
        }
        if (tag.m_128403_("DecorationEntity")) {
            this.decorationEntityId = tag.m_128342_("DecorationEntity");
        }
        if (tag.m_128403_("BackDecorationEntity")) {
            this.backDecorationEntityId = tag.m_128342_("BackDecorationEntity");
        }
        if (tag.m_128403_("CollisionEntity")) {
            this.collisionEntityId = tag.m_128342_("CollisionEntity");
        }
        if (tag.m_128403_("BackCollisionEntity")) {
            this.backCollisionEntityId = tag.m_128342_("BackCollisionEntity");
        }
        if (tag.m_128403_("CustomShowcase")) {
            this.customShowcaseEntityId = tag.m_128342_("CustomShowcase");
        }
        if (tag.m_128441_("LightAnchorX")) {
            this.lightAnchorPos = new BlockPos(tag.m_128451_("LightAnchorX"), tag.m_128451_("LightAnchorY"), tag.m_128451_("LightAnchorZ"));
            this.lightPlaced = tag.m_128471_("LightPlaced");
            if (this.lightPlaced) {
                this.placeTemporaryLight();
            }
        }
        if (tag.m_128441_("PortalTargetWidth")) {
            this.portalTargetWidth = tag.m_128459_("PortalTargetWidth");
        }
        if (tag.m_128441_("PortalTargetHeight")) {
            this.portalTargetHeight = tag.m_128459_("PortalTargetHeight");
        }
    }

    public void closeWithAnimation() {
        this.requestCloseWithAnimation();
    }

    protected void m_7380_(CompoundTag tag) {
        String textureId;
        tag.m_128405_("Lifetime", ((Integer)this.f_19804_.m_135370_(LIFETIME)).intValue());
        tag.m_128379_("IsReturnPortal", ((Boolean)this.f_19804_.m_135370_(IS_RETURN_PORTAL)).booleanValue());
        tag.m_128379_("HasBeenUsed", ((Boolean)this.f_19804_.m_135370_(HAS_BEEN_USED)).booleanValue());
        tag.m_128379_("IsRaidPortal", ((Boolean)this.f_19804_.m_135370_(IS_RAID_PORTAL)).booleanValue());
        tag.m_128379_("IsLoganVortex", ((Boolean)this.f_19804_.m_135370_(IS_LOGAN_VORTEX)).booleanValue());
        tag.m_128379_("IsExodusVortex", ((Boolean)this.f_19804_.m_135370_(IS_EXODUS_VORTEX)).booleanValue());
        tag.m_128379_("IsEgyptianVortex", ((Boolean)this.f_19804_.m_135370_(IS_EGYPTIAN_VORTEX)).booleanValue());
        tag.m_128379_("IsProtoVortex", ((Boolean)this.f_19804_.m_135370_(IS_PROTO_VORTEX)).booleanValue());
        tag.m_128356_("SpawnGameTime", this.spawnGameTime);
        tag.m_128356_("LastUseGameTime", this.lastUseGameTime);
        tag.m_128356_("CloseAtGameTime", this.closeAtGameTime);
        tag.m_128379_("HasFixedPortalLifetime", this.hasFixedPortalLifetime);
        tag.m_128405_("FixedPortalLifetimeTicks", this.fixedPortalLifetimeTicks);
        tag.m_128379_("UsesImmersivePortal", ((Boolean)this.f_19804_.m_135370_(USES_IMMERSIVE_PORTAL)).booleanValue());
        String modelId = (String)this.f_19804_.m_135370_(CUSTOM_MODEL_ID);
        if (!modelId.isEmpty()) {
            tag.m_128359_("CustomModelId", modelId);
        }
        if (!(textureId = (String)this.f_19804_.m_135370_(CUSTOM_TEXTURE_ID)).isEmpty()) {
            tag.m_128359_("CustomTextureId", textureId);
        }
        tag.m_128405_("CustomTint", ((Integer)this.f_19804_.m_135370_(CUSTOM_TINT)).intValue());
        tag.m_128379_("EnableBackDecoration", this.enableBackDecoration);
        tag.m_128379_("EnableFrontCollisionVolume", this.enableFrontCollisionVolume);
        tag.m_128379_("EnableBackCollisionVolume", this.enableBackCollisionVolume);
        tag.m_128379_("EnableCollisionVolumes", this.enableFrontCollisionVolume || this.enableBackCollisionVolume);
        tag.m_128347_("PortalTargetWidth", this.portalTargetWidth);
        tag.m_128347_("PortalTargetHeight", this.portalTargetHeight);
        tag.m_128405_("UsedAtTick", this.usedAtTick);
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
        if (this.cachedDestination != null) {
            tag.m_128359_("DestinationDim", this.cachedDestination.dimension.m_135782_().toString());
            tag.m_128405_("DestX", this.cachedDestination.pos.m_123341_());
            tag.m_128405_("DestY", this.cachedDestination.pos.m_123342_());
            tag.m_128405_("DestZ", this.cachedDestination.pos.m_123343_());
        }
        if (this.linkedAestheticVortexUUID != null) {
            tag.m_128362_("LinkedAestheticVortex", this.linkedAestheticVortexUUID);
        }
        if (this.decorationEntityId != null) {
            tag.m_128362_("DecorationEntity", this.decorationEntityId);
        }
        if (this.backDecorationEntityId != null) {
            tag.m_128362_("BackDecorationEntity", this.backDecorationEntityId);
        }
        if (this.collisionEntityId != null) {
            tag.m_128362_("CollisionEntity", this.collisionEntityId);
        }
        if (this.backCollisionEntityId != null) {
            tag.m_128362_("BackCollisionEntity", this.backCollisionEntityId);
        }
        if (this.customShowcaseEntityId != null) {
            tag.m_128362_("CustomShowcase", this.customShowcaseEntityId);
        }
        if (this.lightAnchorPos != null) {
            tag.m_128405_("LightAnchorX", this.lightAnchorPos.m_123341_());
            tag.m_128405_("LightAnchorY", this.lightAnchorPos.m_123342_());
            tag.m_128405_("LightAnchorZ", this.lightAnchorPos.m_123343_());
            tag.m_128379_("LightPlaced", this.lightPlaced);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    private static void setTimerOverheated(ItemStack stack, boolean overheated) {
        Item item = stack.m_41720_();
        if (item instanceof OriginalTimerItem) {
            OriginalTimerItem.setOverheated(stack, overheated);
        } else if (item instanceof LoganTimerItem) {
            LoganTimerItem.setOverheated(stack, overheated);
        } else if (item instanceof ExodusTimerItem) {
            ExodusTimerItem.setOverheated(stack, overheated);
        } else if (item instanceof EgyptianTimerItem) {
            EgyptianTimerItem.setOverheated(stack, overheated);
        } else if (item instanceof UpgradedLoganTimerTier1Item) {
            UpgradedLoganTimerTier1Item.setOverheated(stack, overheated);
        } else if (item instanceof UpgradedLoganTimerTier2Item) {
            UpgradedLoganTimerTier2Item.setOverheated(stack, overheated);
        } else if (item instanceof UpgradedLoganTimerTier3Item) {
            UpgradedLoganTimerTier3Item.setOverheated(stack, overheated);
        } else {
            SlidersMod.LOGGER.warn("Unknown timer type, cannot set overheat status: {}", (Object)item.getClass().getSimpleName());
        }
    }

    private static void resetTimerPolymorphic(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof OriginalTimerItem) {
            OriginalTimerItem.resetTimer(stack);
        } else if (item instanceof LoganTimerItem) {
            LoganTimerItem.resetTimer(stack);
        } else if (item instanceof ExodusTimerItem) {
            ExodusTimerItem.resetTimer(stack);
        } else if (item instanceof EgyptianTimerItem) {
            EgyptianTimerItem.resetTimer(stack);
        } else if (item instanceof UpgradedLoganTimerTier1Item) {
            UpgradedLoganTimerTier1Item.resetTimer(stack);
        } else if (item instanceof UpgradedLoganTimerTier2Item) {
            UpgradedLoganTimerTier2Item.resetTimer(stack);
        } else if (item instanceof UpgradedLoganTimerTier3Item) {
            UpgradedLoganTimerTier3Item.resetTimer(stack);
        } else {
            SlidersMod.LOGGER.warn("Unknown timer type, cannot reset: {}", (Object)item.getClass().getSimpleName());
        }
    }

    private static boolean isDamagedTimer(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof OriginalTimerDamagedItem || item instanceof LoganTimerDamagedItem || item instanceof ExodusTimerDamagedItem || item instanceof EgyptianTimerDamagedItem || item instanceof UpgradedLoganTimerTier1DamagedItem || item instanceof UpgradedLoganTimerTier2DamagedItem || item instanceof UpgradedLoganTimerTier3DamagedItem;
    }

    private static void setCooldownOverheat(ItemStack stack, Level level) {
        ClassicTimerHelper.startCooldownOverheat(stack, level);
    }

    @Nullable
    private UUID getActiveReturnToken() {
        if (this.timerStack == null || this.timerStack.m_41619_()) {
            return null;
        }
        CompoundTag tag = this.timerStack.m_41783_();
        if (tag != null && tag.m_128403_("ActiveReturnToken")) {
            return tag.m_128342_("ActiveReturnToken");
        }
        return null;
    }

    private ItemStack resolveOwnerTimer(ServerPlayer owner) {
        ItemStack stack;
        UUID token = this.getActiveReturnToken();
        if (token != null && !(stack = DimensionManager.findTimerStackByToken(owner, token)).m_41619_()) {
            return stack;
        }
        for (ItemStack stack2 : owner.m_150109_().f_35974_) {
            if (stack2.m_41619_() || !ItemStack.m_150942_((ItemStack)stack2, (ItemStack)this.timerStack)) continue;
            return stack2;
        }
        return ItemStack.f_41583_;
    }
}

