/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.events;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.advancements.AchievementManager;
import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.EgyptianTimerDamagedItem;
import com.michelmuscle.slidersmod.item.EgyptianTimerItem;
import com.michelmuscle.slidersmod.item.ExodusTimerDamagedItem;
import com.michelmuscle.slidersmod.item.ExodusTimerItem;
import com.michelmuscle.slidersmod.item.LoganTimerDamagedItem;
import com.michelmuscle.slidersmod.item.LoganTimerItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier1Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier2Item;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3DamagedItem;
import com.michelmuscle.slidersmod.item.UpgradedLoganTimerTier3Item;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.network.ShowTimerHudPacket;
import com.michelmuscle.slidersmod.network.TimerSwingPacket;
import com.michelmuscle.slidersmod.system.ForceVortexManager;
import com.michelmuscle.slidersmod.system.SlidersRaidManager;
import com.michelmuscle.slidersmod.system.StuckTimerManager;
import com.michelmuscle.slidersmod.system.VortexTrackingSystem;
import com.michelmuscle.slidersmod.util.ClassicTimerHelper;
import com.michelmuscle.slidersmod.world.VortexShowcaseManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="slidersmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    private static final Map<UUID, Boolean> has30SecWarning = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> has15SecWarning = new HashMap<UUID, Boolean>();

    @SubscribeEvent
    public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        if (ClassicTimerHelper.isBaseTimer(stack) || ClassicTimerHelper.isDamagedTimer(stack) || stack.m_41720_() instanceof LoganTimerItem || stack.m_41720_() instanceof LoganTimerDamagedItem || stack.m_41720_() instanceof UpgradedLoganTimerTier1Item || stack.m_41720_() instanceof UpgradedLoganTimerTier1DamagedItem || stack.m_41720_() instanceof UpgradedLoganTimerTier2Item || stack.m_41720_() instanceof UpgradedLoganTimerTier2DamagedItem || stack.m_41720_() instanceof UpgradedLoganTimerTier3Item || stack.m_41720_() instanceof UpgradedLoganTimerTier3DamagedItem || stack.m_41720_() instanceof ExodusTimerItem || stack.m_41720_() instanceof ExodusTimerDamagedItem || stack.m_41720_() instanceof EgyptianTimerItem || stack.m_41720_() instanceof EgyptianTimerDamagedItem) {
            ModNetworking.CHANNEL.sendToServer((Object)new TimerSwingPacket());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            DimensionManager.tick(event.getServer());
            for (ServerLevel level : event.getServer().m_129785_()) {
                ClassicTimerHelper.tickBaseTimerSpawns(level);
                ClassicTimerHelper.tickDamagedTimerSpawns(level);
                LoganTimerItem.tickScheduledSpawns(level);
                LoganTimerDamagedItem.tickScheduledSpawns(level);
                UpgradedLoganTimerTier1Item.tickScheduledSpawns(level);
                UpgradedLoganTimerTier2Item.tickScheduledSpawns(level);
                UpgradedLoganTimerTier3Item.tickScheduledSpawns(level);
                UpgradedLoganTimerTier1DamagedItem.tickScheduledSpawns(level);
                UpgradedLoganTimerTier2DamagedItem.tickScheduledSpawns(level);
                UpgradedLoganTimerTier3DamagedItem.tickScheduledSpawns(level);
                ExodusTimerItem.tickScheduledSpawns(level);
                ExodusTimerDamagedItem.tickScheduledSpawns(level);
                EgyptianTimerItem.tickScheduledSpawns(level);
                EgyptianTimerDamagedItem.tickScheduledSpawns(level);
                ForceVortexManager.tick(level);
                StuckTimerManager.tick(level);
                SlidersRaidManager.tick(level);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        VortexShowcaseManager.ensureShowcaseReady(event.getServer());
        DimensionManager.initializePersistentData(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().f_46443_) {
            ServerPlayer player = (ServerPlayer)event.player;
            VortexTrackingSystem.processTrackingSearch(player, player.m_9236_().m_46467_());
            if (player.f_19797_ % 10 == 0) {
                ModEvents.checkDamagedTimerWarnings(player);
            }
            if (player.f_19797_ % 20 == 0) {
                ModEvents.checkDamagedTimerExpiration(player);
            }
            if (player.f_19797_ % 100 == 0) {
                ModEvents.cleanupStuckTimers(player);
            }
            if (player.f_19797_ % 20 == 0) {
                ModEvents.trackAchievements(player);
            }
        }
    }

    private static void trackAchievements(ServerPlayer player) {
        String lastDimension;
        String currentDimension;
        int totalChips = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != ModItems.SLIDE_ENHANCEMENT_CHIP.get()) continue;
            totalChips += stack.m_41613_();
        }
        int previousChips = player.getPersistentData().m_128451_("slidersmod_chips_tracked");
        if (totalChips > previousChips) {
            for (int i = previousChips; i < totalChips; ++i) {
                AchievementManager.addChipCollected(player);
            }
            player.getPersistentData().m_128405_("slidersmod_chips_tracked", totalChips);
            player.m_5661_((Component)Component.m_237115_((String)"message.slidersmod.slide_chip_found"), true);
            if (!player.getPersistentData().m_128471_("slidersmod_ach_first_chip") && totalChips > 0) {
                AchievementManager.grantAchievement(player, "tier_1_gg_qball", "chip_first");
                player.getPersistentData().m_128379_("slidersmod_ach_first_chip", true);
            }
        }
        if (ModEvents.containsItem(player, (Item)ModItems.SLIDE_ENHANCEMENT_CHIP.get())) {
            AchievementManager.grantAchievement(player, "tier_1_gg_qball", "chip_first");
        }
        if (!(currentDimension = player.m_9236_().m_46472_().m_135782_().toString()).equals(lastDimension = player.getPersistentData().m_128461_("slidersmod_last_dimension"))) {
            AchievementManager.trackDimensionVisit(player, currentDimension);
            player.getPersistentData().m_128359_("slidersmod_last_dimension", currentDimension);
            ModEvents.grantOnceForDimension(player, currentDimension, "slidersmod:felina", "tier_2_meow");
            ModEvents.grantOnceForDimension(player, currentDimension, "slidersmod:eldoggo", "tier_2_not_dog");
            ModEvents.grantOnceForDimension(player, currentDimension, "slidersmod:eclipse", "tier_2_oh_no");
            ModEvents.grantOnceForDimension(player, currentDimension, "slidersmod:badlands", "tier_2_not_here_long");
        }
        AchievementManager.trackDimensionTime(player, currentDimension, 20L);
        if (ModEvents.containsItem(player, (Item)ModItems.LOGAN_TIMER.get())) {
            AchievementManager.grantAchievement(player, "tier_1_overworld_enjoyer", "logan_timer");
        }
        if (ModEvents.containsItem(player, (Item)ModItems.ORIGINAL_TIMER.get())) {
            AchievementManager.grantAchievement(player, "tier_1_motorola_microtac", "original_timer");
        }
        if (ModEvents.containsItem(player, (Item)ModItems.EGYPTIAN_TIMER.get())) {
            AchievementManager.grantAchievement(player, "tier_2_egyptian", "egyptian_timer");
        }
        if (ModEvents.containsItem(player, (Item)ModItems.EXODUS_TIMER.get())) {
            AchievementManager.grantAchievement(player, "tier_2_exodus", "exodus_timer");
        }
        if (ModEvents.containsItem(player, (Item)ModItems.UPGRADED_LOGAN_TIMER_TIER1.get()) || ModEvents.containsItem(player, (Item)ModItems.UPGRADED_LOGAN_TIMER_TIER2.get()) || ModEvents.containsItem(player, (Item)ModItems.UPGRADED_LOGAN_TIMER_TIER3.get())) {
            AchievementManager.grantAchievement(player, "tier_3_logan_tier1", "logan_upgraded");
        }
        if (ModEvents.containsItem(player, (Item)ModItems.TIMER_WORKBENCH.get())) {
            AchievementManager.grantAchievement(player, "tier_1_soldering_iron", "workbench_inv");
        }
        if (ModEvents.containsItem(player, (Item)ModItems.QUANTUM_GATE_PROTOTYPE.get())) {
            AchievementManager.grantAchievement(player, "tier_1_its_u4", "qgp_inv");
        }
        if (ModEvents.containsItem(player, (Item)ModItems.PROTO_SYNCHRONIZER.get())) {
            AchievementManager.grantAchievement(player, "tier_1_made_in_minecraft", "proto_inv");
        }
    }

    private static boolean containsItem(ServerPlayer player, Item target) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !stack.m_150930_(target)) continue;
            return true;
        }
        return false;
    }

    private static void grantOnceForDimension(ServerPlayer player, String currentDimension, String target, String achievement) {
        if (!currentDimension.equals(target)) {
            return;
        }
        String nbtKey = "slidersmod_ach_dim_" + target.replace(":", "_");
        if (player.getPersistentData().m_128471_(nbtKey)) {
            return;
        }
        AchievementManager.grantAchievement(player, achievement, "enter_dim");
        player.getPersistentData().m_128379_(nbtKey, true);
    }

    private static long getRemainingTimeForNormalTimer(ItemStack stack, ServerPlayer player) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128471_("IsActive")) {
            return 0L;
        }
        long configuredSeconds = tag.m_128454_("ConfiguredTime");
        long activationTime = tag.m_128454_("ActivationTime");
        long currentTime = player.m_9236_().m_46467_();
        long elapsed = currentTime - activationTime;
        long remainingTicks = configuredSeconds * 20L - elapsed;
        return Math.max(0L, remainingTicks);
    }

    private static void checkDamagedTimerWarnings(ServerPlayer player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            long seconds;
            long timeLeft;
            UUID playerId = player.m_20148_();
            if ((ClassicTimerHelper.isBaseTimer(stack) || stack.m_41720_() instanceof LoganTimerItem || stack.m_41720_() instanceof UpgradedLoganTimerTier1Item || stack.m_41720_() instanceof UpgradedLoganTimerTier2Item || stack.m_41720_() instanceof UpgradedLoganTimerTier3Item || stack.m_41720_() instanceof ExodusTimerItem || stack.m_41720_() instanceof EgyptianTimerItem) && stack.m_41784_().m_128471_("IsActive")) {
                timeLeft = ModEvents.getRemainingTimeForNormalTimer(stack, player);
                seconds = timeLeft / 20L;
                if (seconds <= 30L && seconds > 29L && !has30SecWarning.getOrDefault(playerId, false).booleanValue()) {
                    has30SecWarning.put(playerId, true);
                    player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.REMAINING_TIME_30SEC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ShowTimerHudPacket(timeLeft, true, false));
                    SlidersMod.LOGGER.info("30 second warning for player {} (NORMAL TIMER)", (Object)player.m_7755_().getString());
                }
                if (seconds <= 14L && seconds > 13L && !has15SecWarning.getOrDefault(playerId, false).booleanValue()) {
                    has15SecWarning.put(playerId, true);
                    player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.REMAINING_TIME_15SEC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ShowTimerHudPacket(timeLeft, false, true));
                    SlidersMod.LOGGER.info("15 second warning for player {} (NORMAL TIMER)", (Object)player.m_7755_().getString());
                }
                if (seconds > 30L) {
                    has30SecWarning.remove(playerId);
                    has15SecWarning.remove(playerId);
                    continue;
                }
                if (seconds <= 15L) continue;
                has15SecWarning.remove(playerId);
                continue;
            }
            if (!ClassicTimerHelper.isDamagedTimer(stack)) continue;
            timeLeft = ClassicTimerHelper.getDamagedRemainingTime(stack, player.m_9236_());
            seconds = timeLeft / 20L;
            if (seconds <= 30L && seconds > 29L && !has30SecWarning.getOrDefault(playerId, false).booleanValue()) {
                has30SecWarning.put(playerId, true);
                player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.REMAINING_TIME_30SEC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ShowTimerHudPacket(timeLeft, true, false));
                SlidersMod.LOGGER.info("30 second warning for player {} (DAMAGED TIMER)", (Object)player.m_7755_().getString());
            }
            if (seconds <= 14L && seconds > 13L && !has15SecWarning.getOrDefault(playerId, false).booleanValue()) {
                has15SecWarning.put(playerId, true);
                player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.REMAINING_TIME_15SEC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                ModNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ShowTimerHudPacket(timeLeft, false, true));
                SlidersMod.LOGGER.info("15 second warning for player {} (DAMAGED TIMER)", (Object)player.m_7755_().getString());
            }
            if (seconds > 30L) {
                has30SecWarning.remove(playerId);
                has15SecWarning.remove(playerId);
                continue;
            }
            if (seconds <= 15L) continue;
            has15SecWarning.remove(playerId);
        }
    }

    private static void checkDamagedTimerExpiration(ServerPlayer player) {
        NonNullList items = player.m_150109_().f_35974_;
        for (int slot = 0; slot < items.size(); ++slot) {
            boolean vortexOpened;
            ItemStack stack = (ItemStack)items.get(slot);
            if (stack.m_41619_()) continue;
            long timeLeft = Long.MAX_VALUE;
            if (ClassicTimerHelper.isDamagedTimer(stack)) {
                timeLeft = ClassicTimerHelper.getDamagedRemainingTime(stack, player.m_9236_());
            } else if (stack.m_41720_() instanceof LoganTimerDamagedItem) {
                timeLeft = LoganTimerDamagedItem.getRemainingTime(stack, player.m_9236_());
            } else if (stack.m_41720_() instanceof UpgradedLoganTimerTier1DamagedItem) {
                timeLeft = UpgradedLoganTimerTier1DamagedItem.getRemainingTime(stack, player.m_9236_());
            } else if (stack.m_41720_() instanceof UpgradedLoganTimerTier2DamagedItem) {
                timeLeft = UpgradedLoganTimerTier2DamagedItem.getRemainingTime(stack, player.m_9236_());
            } else if (stack.m_41720_() instanceof UpgradedLoganTimerTier3DamagedItem) {
                timeLeft = UpgradedLoganTimerTier3DamagedItem.getRemainingTime(stack, player.m_9236_());
            } else if (stack.m_41720_() instanceof ExodusTimerDamagedItem) {
                timeLeft = ExodusTimerDamagedItem.getRemainingTime(stack, player.m_9236_());
            } else if (stack.m_41720_() instanceof EgyptianTimerDamagedItem) {
                timeLeft = EgyptianTimerDamagedItem.getRemainingTime(stack, player.m_9236_());
            }
            if (timeLeft == Long.MAX_VALUE || timeLeft > 0L || (vortexOpened = stack.m_41784_().m_128471_("VortexOpened"))) continue;
            SlidersMod.LOGGER.info("Player {} failed to open vortex in time! Transforming to stuck timer...", (Object)player.m_7755_().getString());
            StuckTimerManager.executeStuckTransformation(player, stack, slot);
            return;
        }
    }

    private static void cleanupStuckTimers(ServerPlayer player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            UUID uuid;
            if (!ClassicTimerHelper.isBaseTimer(stack) || !ClassicTimerHelper.isActive(stack)) continue;
            long activationTime = ClassicTimerHelper.getActivationTime(stack);
            long currentTime = player.m_9236_().m_46467_();
            long timeActive = currentTime - activationTime;
            if (timeActive <= 2400L || DimensionManager.hasScheduledReturn(uuid = player.m_20148_())) continue;
            ClassicTimerHelper.resetTimer(stack);
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7eTimer auto-reset (stuck for too long)"), true);
            SlidersMod.LOGGER.warn("Timer auto-reset for player " + String.valueOf(uuid) + " - was active for " + timeActive / 20L + " seconds without scheduled return");
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            SlidersRaidManager.handleMobDeath((Entity)event.getEntity(), event.getSource().m_7639_());
        }
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack stack = event.getItem().m_32055_();
        if (stack.m_150930_((Item)ModItems.LOGAN_TIMER.get())) {
            AchievementManager.grantAchievement(player2, "tier_1_overworld_enjoyer", "logan_timer_pickup");
        } else if (stack.m_150930_((Item)ModItems.ORIGINAL_TIMER.get())) {
            AchievementManager.grantAchievement(player2, "tier_1_motorola_microtac", "original_timer_pickup");
        } else if (stack.m_150930_((Item)ModItems.EGYPTIAN_TIMER.get())) {
            AchievementManager.grantAchievement(player2, "tier_2_egyptian", "egyptian_timer_pickup");
        } else if (stack.m_150930_((Item)ModItems.EXODUS_TIMER.get())) {
            AchievementManager.grantAchievement(player2, "tier_2_exodus", "exodus_timer_pickup");
        } else if (stack.m_150930_((Item)ModItems.UPGRADED_LOGAN_TIMER_TIER1.get()) || stack.m_150930_((Item)ModItems.UPGRADED_LOGAN_TIMER_TIER2.get()) || stack.m_150930_((Item)ModItems.UPGRADED_LOGAN_TIMER_TIER3.get())) {
            AchievementManager.grantAchievement(player2, "tier_3_logan_tier1", "logan_upgraded_pickup");
        } else if (stack.m_150930_((Item)ModItems.TIMER_WORKBENCH.get())) {
            AchievementManager.grantAchievement(player2, "tier_1_soldering_iron", "workbench_pickup");
        } else if (stack.m_150930_((Item)ModItems.QUANTUM_GATE_PROTOTYPE.get())) {
            AchievementManager.grantAchievement(player2, "tier_1_its_u4", "qgp_pickup");
        } else if (stack.m_150930_((Item)ModItems.PROTO_SYNCHRONIZER.get())) {
            AchievementManager.grantAchievement(player2, "tier_1_made_in_minecraft", "proto_pickup");
        }
        if (!SlidersRaidManager.isRaidDamagedTimer(stack)) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128471_("RaidFreshDrop")) {
            return;
        }
        tag.m_128473_("RaidFreshDrop");
        SlidersRaidManager.initializeRaidDamagedTimer(stack, player2.m_284548_());
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack stack = event.getCrafting();
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_150930_((Item)ModItems.TIMER_WORKBENCH.get())) {
            AchievementManager.grantAchievement(player2, "tier_1_soldering_iron", "workbench_craft");
        } else if (stack.m_150930_((Item)ModItems.QUANTUM_GATE_PROTOTYPE.get())) {
            AchievementManager.grantAchievement(player2, "tier_1_its_u4", "qgp_craft");
        } else if (stack.m_150930_((Item)ModItems.PROTO_SYNCHRONIZER.get())) {
            AchievementManager.grantAchievement(player2, "tier_1_made_in_minecraft", "proto_craft");
        } else if (stack.m_150930_((Item)ModItems.ORIGINAL_TIMER.get())) {
            AchievementManager.grantAchievement(player2, "tier_1_motorola_microtac", "original_timer_craft");
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CompoundTag nbt = player2.getPersistentData();
        if (nbt.m_128471_("slidersmod_guide_given")) {
            return;
        }
        Item guideItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("patchouli", "guide_book"));
        if (guideItem == null || guideItem == Items.f_41852_) {
            return;
        }
        ItemStack guide = new ItemStack((ItemLike)guideItem);
        guide.m_41784_().m_128359_("patchouli:book", "slidersmod:sliders_guide");
        if (!player2.m_150109_().m_36054_(guide)) {
            player2.m_36176_(guide, false);
        }
        nbt.m_128379_("slidersmod_guide_given", true);
    }
}

