/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ProgressArrowRenderer {
    private static final ResourceLocation ARROW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)"textures/gui/rightarrow.png");
    private static final int ARROW_WIDTH = 29;
    private static final int ARROW_HEIGHT = 8;
    private static final int EMPTY_ARROW_V = 0;
    private static final int FULL_ARROW_V = 8;

    public static void renderProgressArrow(GuiGraphics graphics, int x, int y, int progress) {
        progress = Math.max(0, Math.min(100, progress));
        graphics.m_280163_(ARROW_TEXTURE, x, y, 0.0f, 0.0f, 29, 8, 29, 16);
        if (progress > 0) {
            int fullArrowWidth = progress * 29 / 100;
            graphics.m_280163_(ARROW_TEXTURE, x, y, 0.0f, 8.0f, fullArrowWidth, 8, 29, 16);
        }
    }

    public static void renderProgressArrowScaled(GuiGraphics graphics, int x, int y, int scaledWidth, int scaledHeight, int progress) {
        progress = Math.max(0, Math.min(100, progress));
        graphics.m_280163_(ARROW_TEXTURE, x, y, 0.0f, 0.0f, scaledWidth, scaledHeight, 29, 16);
        if (progress > 0) {
            int fullArrowWidth = progress * scaledWidth / 100;
            graphics.m_280163_(ARROW_TEXTURE, x, y, 0.0f, 8.0f, fullArrowWidth, scaledHeight, 29, 16);
        }
    }

    public static int getArrowWidth() {
        return 29;
    }

    public static int getArrowHeight() {
        return 8;
    }
}

