/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.item;

import com.michelmuscle.slidersmod.block.entity.QuantumRecallStationBlockEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class QuantumMarkerItem
extends Item {
    public static final String TAG_LINKED_BLOCK_X = "LinkedBlockX";
    public static final String TAG_LINKED_BLOCK_Y = "LinkedBlockY";
    public static final String TAG_LINKED_BLOCK_Z = "LinkedBlockZ";
    public static final String TAG_LINKED_BLOCK_DIM = "LinkedBlockDimension";
    public static final String TAG_MARKED_UUID = "MarkedEntityUUID";
    public static final String TAG_MARKED_DIMENSION = "MarkedEntityDimension";
    public static final String TAG_MARKED_X = "MarkedEntityX";
    public static final String TAG_MARKED_Y = "MarkedEntityY";
    public static final String TAG_MARKED_Z = "MarkedEntityZ";
    public static final String TAG_MARKED_NAME = "MarkedEntityName";
    public static final String TAG_MARKED_TYPE = "MarkedEntityType";
    public static final String TAG_MARKED_TIME = "MarkedEntityGameTime";

    public QuantumMarkerItem(Item.Properties props) {
        super(props);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        Entity entity2;
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (player.m_6047_()) {
            if (!(level instanceof ServerLevel)) {
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            ServerLevel serverLevel = (ServerLevel)level;
            StationRef stationRef = this.resolveLinkedStation(serverLevel, stack);
            if (stationRef == null) {
                player.m_5661_((Component)Component.m_237113_((String)"[Quantum Marker] This marker is no longer linked to a Quantum Recall Station.").m_130940_(ChatFormatting.RED), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            this.markEntity(stack, (LivingEntity)player);
            stationRef.station.markEntity((LivingEntity)player);
            QuantumMarkerItem.setMarkedGameTime(stack, serverLevel.m_46467_());
            BlockPos stationPos = stationRef.station.m_58899_();
            stationRef.level.m_7260_(stationPos, stationRef.level.m_8055_(stationPos), stationRef.level.m_8055_(stationPos), 3);
            if (!stationRef.station.hasMarkedEntity()) {
                player.m_5661_((Component)Component.m_237113_((String)"[Quantum Marker] Failed to link entity to the station.").m_130940_(ChatFormatting.RED), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76[Quantum Marker] Marked yourself!"), true);
            player.m_6469_(player.m_269291_().m_269425_(), 0.5f);
            stack.m_41774_(1);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        EntityHitResult hitResult = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)player.m_20299_(1.0f), (Vec3)player.m_20299_(1.0f).m_82549_(player.m_20154_().m_82490_(64.0)), (AABB)player.m_20191_().m_82369_(player.m_20154_().m_82490_(64.0)), entity -> !entity.m_5833_() && entity != player);
        if (hitResult != null && (entity2 = hitResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity entity3 = (LivingEntity)entity2;
            return this.m_6880_(stack, player, entity3, hand) == InteractionResult.SUCCESS ? InteractionResultHolder.m_19090_((Object)stack) : InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (entity == player) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c[Quantum Marker] You cannot mark yourself!"), true);
            return InteractionResult.FAIL;
        }
        if (entity instanceof Player && !player.m_7500_()) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c[Quantum Marker] You cannot mark other players!"), true);
            return InteractionResult.FAIL;
        }
        if (!this.canMark(entity)) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c[Quantum Marker] This entity type cannot be marked!"), true);
            return InteractionResult.FAIL;
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        StationRef stationRef = this.resolveLinkedStation(serverLevel, stack);
        if (stationRef == null) {
            player.m_5661_((Component)Component.m_237113_((String)"[Quantum Marker] This marker is no longer linked to a Quantum Recall Station.").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        this.markEntity(stack, entity);
        stationRef.station.markEntity(entity);
        QuantumMarkerItem.setMarkedGameTime(stack, serverLevel.m_46467_());
        BlockPos stationPos = stationRef.station.m_58899_();
        stationRef.level.m_7260_(stationPos, stationRef.level.m_8055_(stationPos), stationRef.level.m_8055_(stationPos), 3);
        if (!stationRef.station.hasMarkedEntity()) {
            player.m_5661_((Component)Component.m_237113_((String)"[Quantum Marker] Failed to link entity to the station.").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        player.m_5661_((Component)Component.m_237113_((String)("\u00a76[Quantum Marker] Marked: \u00a7e" + entity.m_5446_().getString())), true);
        entity.m_6469_(entity.m_269291_().m_269425_(), 0.5f);
        stack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    private boolean canMark(LivingEntity entity) {
        String entityType = entity.m_6095_().toString();
        return !entityType.contains("ender_dragon") && !entityType.contains("warden") && !entityType.contains("witherskeleton") && !entityType.contains("elder_guardian");
    }

    private void markEntity(ItemStack marker, LivingEntity entity) {
        CompoundTag tag = marker.m_41784_();
        tag.m_128362_(TAG_MARKED_UUID, entity.m_20148_());
        tag.m_128359_(TAG_MARKED_DIMENSION, entity.m_9236_().m_46472_().m_135782_().toString());
        tag.m_128347_(TAG_MARKED_X, entity.m_20185_());
        tag.m_128347_(TAG_MARKED_Y, entity.m_20186_());
        tag.m_128347_(TAG_MARKED_Z, entity.m_20189_());
        tag.m_128359_(TAG_MARKED_NAME, entity.m_5446_().getString());
        tag.m_128359_(TAG_MARKED_TYPE, entity.m_6095_().m_20676_().getString());
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            tag.m_128356_(TAG_MARKED_TIME, serverLevel.m_46467_());
        }
    }

    public static boolean isMarked(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128403_(TAG_MARKED_UUID);
    }

    @Nullable
    public static UUID getMarkedEntityUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_(TAG_MARKED_UUID)) {
            return tag.m_128342_(TAG_MARKED_UUID);
        }
        return null;
    }

    @Nullable
    public static String getMarkedEntityDimension(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return tag.m_128461_(TAG_MARKED_DIMENSION);
        }
        return null;
    }

    public static void clearMarking(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(TAG_MARKED_UUID);
            tag.m_128473_(TAG_MARKED_DIMENSION);
            tag.m_128473_(TAG_MARKED_X);
            tag.m_128473_(TAG_MARKED_Y);
            tag.m_128473_(TAG_MARKED_Z);
            tag.m_128473_(TAG_MARKED_NAME);
            tag.m_128473_(TAG_MARKED_TYPE);
            tag.m_128473_(TAG_MARKED_TIME);
        }
    }

    public static void linkToBlock(ItemStack marker, int blockX, int blockY, int blockZ, String blockDimension) {
        CompoundTag tag = marker.m_41784_();
        tag.m_128405_(TAG_LINKED_BLOCK_X, blockX);
        tag.m_128405_(TAG_LINKED_BLOCK_Y, blockY);
        tag.m_128405_(TAG_LINKED_BLOCK_Z, blockZ);
        tag.m_128359_(TAG_LINKED_BLOCK_DIM, blockDimension);
    }

    public static boolean isLinkedToBlock(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(TAG_LINKED_BLOCK_X) && tag.m_128441_(TAG_LINKED_BLOCK_DIM);
    }

    @Nullable
    public static BlockPos getLinkedBlockPos(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TAG_LINKED_BLOCK_X)) {
            int x = tag.m_128451_(TAG_LINKED_BLOCK_X);
            int y = tag.m_128451_(TAG_LINKED_BLOCK_Y);
            int z = tag.m_128451_(TAG_LINKED_BLOCK_Z);
            return new BlockPos(x, y, z);
        }
        return null;
    }

    @Nullable
    public static String getLinkedBlockDimension(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return tag.m_128461_(TAG_LINKED_BLOCK_DIM);
        }
        return null;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (QuantumMarkerItem.isLinkedToBlock(stack)) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                int x = tag.m_128451_(TAG_LINKED_BLOCK_X);
                int y = tag.m_128451_(TAG_LINKED_BLOCK_Y);
                int z = tag.m_128451_(TAG_LINKED_BLOCK_Z);
                if (QuantumMarkerItem.isMarked(stack)) {
                    String name = tag.m_128461_(TAG_MARKED_NAME);
                    String type = tag.m_128461_(TAG_MARKED_TYPE);
                    tooltip.add((Component)Component.m_237113_((String)("\u00a76Linked to: \u00a7e[" + x + ", " + y + ", " + z + "]")));
                    tooltip.add((Component)Component.m_237113_((String)("\u00a76Marked Entity: \u00a7e" + name)));
                    tooltip.add((Component)Component.m_237113_((String)("\u00a76Type: \u00a7e" + type)));
                    tooltip.add((Component)Component.m_237113_((String)"\u00a77Use in Quantum Recall Station to initiate recall"));
                    if (tag.m_128441_(TAG_MARKED_TIME)) {
                        tooltip.add((Component)Component.m_237113_((String)("\u00a77Marked at tick: \u00a7e" + tag.m_128454_(TAG_MARKED_TIME))));
                    }
                } else {
                    tooltip.add((Component)Component.m_237113_((String)("\u00a76Linked to: \u00a7e[" + x + ", " + y + ", " + z + "]")));
                    tooltip.add((Component)Component.m_237113_((String)"\u00a77Right-click on an entity to mark it"));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)"\u00a77Place in Quantum Recall Station to link it"));
            tooltip.add((Component)Component.m_237113_((String)"\u00a77Then right-click on an entity to mark it"));
        }
    }

    @Nullable
    private StationRef resolveLinkedStation(ServerLevel currentLevel, ItemStack stack) {
        BlockEntity blockEntity;
        BlockPos blockPos = QuantumMarkerItem.getLinkedBlockPos(stack);
        String dimensionId = QuantumMarkerItem.getLinkedBlockDimension(stack);
        if (blockPos == null || dimensionId == null) {
            return null;
        }
        ResourceLocation location = ResourceLocation.m_135820_((String)dimensionId);
        if (location == null) {
            return null;
        }
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)location);
        ServerLevel stationLevel = currentLevel.m_7654_().m_129880_(dimensionKey);
        if (stationLevel == null) {
            return null;
        }
        if (!stationLevel.m_46749_(blockPos)) {
            stationLevel.m_46745_(blockPos);
        }
        if (!((blockEntity = stationLevel.m_7702_(blockPos)) instanceof QuantumRecallStationBlockEntity)) {
            return null;
        }
        QuantumRecallStationBlockEntity station = (QuantumRecallStationBlockEntity)blockEntity;
        return new StationRef(stationLevel, station);
    }

    private static void setMarkedGameTime(ItemStack stack, long gameTime) {
        stack.m_41784_().m_128356_(TAG_MARKED_TIME, gameTime);
    }

    private record StationRef(ServerLevel level, QuantumRecallStationBlockEntity station) {
    }
}

