/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.item;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.dimension.DimensionManager;
import com.michelmuscle.slidersmod.entity.LoganVortexEntity;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.TimerItemBase;
import com.michelmuscle.slidersmod.network.LoganVortexBeamPacket;
import com.michelmuscle.slidersmod.network.ModNetworking;
import com.michelmuscle.slidersmod.portal.VortexImmersivePortalHelper;
import com.michelmuscle.slidersmod.portal.VortexPortalPlacement;
import com.michelmuscle.slidersmod.portal.VortexPortalTargets;
import com.michelmuscle.slidersmod.screen.UpgradedLoganTimerTier1ConfigScreen;
import com.michelmuscle.slidersmod.system.ForceVortexManager;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.Portal;

public class UpgradedLoganTimerTier1Item
extends TimerItemBase {
    private static final String TAG_CONFIGURED_X = "ConfiguredX";
    private static final String TAG_CONFIGURED_Z = "ConfiguredZ";
    private static final String TAG_CONFIGURED_TIME = "ConfiguredTime";
    private static final String TAG_IS_ACTIVE = "IsActive";
    private static final String TAG_ACTIVATION_TIME = "ActivationTime";
    private static final String TAG_RETURN_DIM = "ReturnDimension";
    private static final String TAG_RETURN_X = "ReturnX";
    private static final String TAG_RETURN_Y = "ReturnY";
    private static final String TAG_RETURN_Z = "ReturnZ";
    private static final String TAG_IS_OVERHEATED = "IsOverheated";
    private static final int PRECISION_RANGE = 3000;
    private static final int PORTAL_DELAY_TICKS = 20;
    private static final int PORTAL_GROWTH_TOTAL_TICKS = 10;
    private static final int GROWTH_START_TICKS_BEFORE_SPAWN = 4;
    private static final double MAX_RAY_DISTANCE = 7.0;
    private static final double DEFAULT_VORTEX_DISTANCE = 5.0;
    private static final double AXIS_EPSILON = 1.0E-4;
    private static final Vec3 WORLD_UP = new Vec3(0.0, 1.0, 0.0);
    private static final Vec3 WORLD_FORWARD = new Vec3(0.0, 0.0, 1.0);
    private static final float VERTICAL_ALIGN_PITCH_MIN = -15.0f;
    private static final float VERTICAL_ALIGN_PITCH_MAX = 20.0f;
    private static final double FREE_SHOT_VERTICAL_Y = 2.2;
    private static final Map<UUID, ScheduledVortexSpawn> scheduledSpawns = new ConcurrentHashMap<UUID, ScheduledVortexSpawn>();

    public UpgradedLoganTimerTier1Item(Item.Properties properties) {
        super(properties);
    }

    public static void setOverheated(ItemStack stack, boolean overheated) {
        CompoundTag tag = stack.m_41784_();
        if (overheated) {
            tag.m_128379_(TAG_IS_OVERHEATED, true);
        } else {
            tag.m_128473_(TAG_IS_OVERHEATED);
        }
    }

    public static boolean isOverheated(ItemStack stack) {
        return stack.m_41784_().m_128471_(TAG_IS_OVERHEATED);
    }

    public static void repairOverheat(ItemStack stack) {
        UpgradedLoganTimerTier1Item.setOverheated(stack, false);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            Minecraft.m_91087_().m_91152_((Screen)new UpgradedLoganTimerTier1ConfigScreen(stack));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_("IsCooldownOverheat") && tag.m_128441_("CooldownEndTime")) {
            long cooldownEndTime = tag.m_128454_("CooldownEndTime");
            long currentTime = level.m_46467_();
            if (currentTime >= cooldownEndTime) {
                UpgradedLoganTimerTier1Item.setOverheated(stack, false);
                tag.m_128473_("CooldownEndTime");
                tag.m_128473_("IsCooldownOverheat");
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    serverPlayer.m_5661_((Component)Component.m_237113_((String)"\u00a7aTimer cooldown complete!"), true);
                }
                SlidersMod.LOGGER.info("Timer cooldown expired for player {}", (Object)entity.m_7755_().getString());
            }
        }
    }

    public static void onSwing(Player player, ItemStack stack, Level level) {
        if (level.f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(TAG_IS_OVERHEATED)) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7cTimer overheated! Repair with Phase Modulator"), true);
            return;
        }
        int targetX = tag.m_128451_(TAG_CONFIGURED_X);
        int targetZ = tag.m_128451_(TAG_CONFIGURED_Z);
        long configuredTime = tag.m_128454_(TAG_CONFIGURED_TIME);
        if (configuredTime == 0L) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7cTimer not configured! Right-click to set coordinates and duration."), true);
            return;
        }
        if (tag.m_128471_(TAG_IS_ACTIVE)) {
            boolean trulyAtOrigin;
            String returnDim = tag.m_128461_(TAG_RETURN_DIM);
            String currentDim = level.m_46472_().m_135782_().toString();
            double returnX = tag.m_128459_(TAG_RETURN_X);
            double returnY = tag.m_128459_(TAG_RETURN_Y);
            double returnZ = tag.m_128459_(TAG_RETURN_Z);
            double currentX = player.m_20185_();
            double currentY = player.m_20186_();
            double currentZ = player.m_20189_();
            double distanceSq = Math.pow(currentX - returnX, 2.0) + Math.pow(currentY - returnY, 2.0) + Math.pow(currentZ - returnZ, 2.0);
            boolean atOriginPosition = distanceSq < 2500.0;
            boolean inOriginDimension = returnDim.equals(currentDim);
            boolean bl = trulyAtOrigin = inOriginDimension && atOriginPosition;
            if (trulyAtOrigin) {
                if (UpgradedLoganTimerTier1Item.hasActiveVortexNearby(player)) {
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7cTimer already active! Wait for the vortex to close or traverse it."), true);
                    return;
                }
                SlidersMod.LOGGER.info("Vortex closed without traversal in origin, resetting timer");
                UpgradedLoganTimerTier1Item.resetTimer(stack);
            } else {
                ServerPlayer serverPlayer;
                int slotIndex;
                SlidersMod.LOGGER.info("Player NOT at origin: dim match={}, distance={} blocks", (Object)inOriginDimension, (Object)Math.sqrt(distanceSq));
                if (UpgradedLoganTimerTier1Item.hasActiveVortexNearby(player)) {
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7cWait for the arrival vortex to close before forcing a new one."), true);
                    return;
                }
                if (player instanceof ServerPlayer && (slotIndex = UpgradedLoganTimerTier1Item.findTimerSlotIndex((Player)(serverPlayer = (ServerPlayer)player), stack)) >= 0) {
                    ForceVortexManager.handleTimerSwingWhileActive(serverPlayer, stack, slotIndex);
                }
                return;
            }
        }
        UpgradedLoganTimerTier1Item.openNormalVortex(player, stack, level);
    }

    private static int findTimerSlotIndex(Player player, ItemStack targetStack) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack != targetStack) continue;
            return i;
        }
        return -1;
    }

    private static boolean hasActiveVortexNearby(Player player) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AABB searchBounds = new AABB(player.m_20185_() - 20.0, player.m_20186_() - 20.0, player.m_20189_() - 20.0, player.m_20185_() + 20.0, player.m_20186_() + 20.0, player.m_20189_() + 20.0);
        List nearbyVortexes = serverLevel.m_45976_(LoganVortexEntity.class, searchBounds);
        return !nearbyVortexes.isEmpty();
    }

    private static void openNormalVortex(Player player, ItemStack stack, Level level) {
        ServerLevel serverLevel;
        CompoundTag tag = stack.m_41784_();
        VortexPortalPlacement placement = UpgradedLoganTimerTier1Item.computeVortexPlacement(player, level);
        tag.m_128359_(TAG_RETURN_DIM, level.m_46472_().m_135782_().toString());
        boolean isForcedVortex = tag.m_128471_("IsForcedVortex");
        if (isForcedVortex && level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            Random random = new Random();
            BlockPos randomPos = DimensionManager.findSafeSpawnLocation(serverLevel.m_7654_().m_129880_(Level.f_46428_), random.nextInt(1500000) - 750000, random.nextInt(1500000) - 750000);
            if (randomPos != null) {
                tag.m_128347_(TAG_RETURN_X, (double)randomPos.m_123341_() + 0.5);
                tag.m_128347_(TAG_RETURN_Y, (double)randomPos.m_123342_());
                tag.m_128347_(TAG_RETURN_Z, (double)randomPos.m_123343_() + 0.5);
                SlidersMod.LOGGER.info("Upgraded Logan Timer Tier 1 (FORCED) saved random return position: {}", (Object)randomPos);
            } else {
                tag.m_128347_(TAG_RETURN_X, player.m_20185_());
                tag.m_128347_(TAG_RETURN_Y, player.m_20186_());
                tag.m_128347_(TAG_RETURN_Z, player.m_20189_());
                SlidersMod.LOGGER.warn("Failed to generate random position, using player position");
            }
        } else {
            tag.m_128347_(TAG_RETURN_X, player.m_20185_());
            tag.m_128347_(TAG_RETURN_Y, player.m_20186_());
            tag.m_128347_(TAG_RETURN_Z, player.m_20189_());
            SlidersMod.LOGGER.info("Upgraded Logan Timer Tier 1 saved return position: dim={}, pos=({}, {}, {})", new Object[]{level.m_46472_().m_135782_(), player.m_20185_(), player.m_20186_(), player.m_20189_()});
        }
        tag.m_128379_(TAG_IS_ACTIVE, true);
        tag.m_128356_(TAG_ACTIVATION_TIME, level.m_46467_());
        tag.m_128379_("IsLoganVortex", true);
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Vec3 playerPos = player.m_20299_(1.0f).m_82549_(player.m_20154_().m_82490_(0.5));
                Vec3 vortexPos = placement.center();
                ModNetworking.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new LoganVortexBeamPacket(playerPos, vortexPos));
                SlidersMod.LOGGER.info("Upgraded Logan Timer Tier 1 red beam effect triggered from {} to {}", (Object)playerPos, (Object)vortexPos);
            }
        }
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            BlockPos soundPos = BlockPos.m_274446_((Position)placement.center());
            serverLevel.m_5594_(null, soundPos, (SoundEvent)ModSounds.VORTEX_OPEN.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            UUID previewPortalId = VortexImmersivePortalHelper.spawnPreviewPortal(serverLevel, placement, VortexPortalTargets.LOGAN).map(Entity::m_20148_).orElse(null);
            long spawnTime = serverLevel.m_46467_() + 20L;
            scheduledSpawns.put(UUID.randomUUID(), new ScheduledVortexSpawn(spawnTime, serverLevel, placement, player, stack, previewPortalId));
            SlidersMod.LOGGER.info("Upgraded Logan Timer Tier 1 vortex spawn scheduled for game time {}", (Object)spawnTime);
        }
        player.m_5661_((Component)Component.m_237113_((String)"\u00a7aVortex opening..."), true);
    }

    public static void tickScheduledSpawns(ServerLevel level) {
        long currentTime = level.m_46467_();
        Iterator<Map.Entry<UUID, ScheduledVortexSpawn>> iterator = scheduledSpawns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ScheduledVortexSpawn> entry = iterator.next();
            ScheduledVortexSpawn spawn = entry.getValue();
            long ticksLeft = spawn.spawnTime - currentTime;
            if (ticksLeft <= 0L) {
                UpgradedLoganTimerTier1Item.spawnVortex(spawn.level, spawn);
                iterator.remove();
                continue;
            }
            if (spawn.previewPortalId == null) continue;
            UpgradedLoganTimerTier1Item.updatePreviewPortal(spawn.level, spawn, ticksLeft);
        }
    }

    private static void spawnVortex(ServerLevel level, ScheduledVortexSpawn spawn) {
        Vec3 center = spawn.placement.center();
        ItemStack stack = spawn.stack;
        int targetX = stack.m_41784_().m_128451_(TAG_CONFIGURED_X);
        int targetZ = stack.m_41784_().m_128451_(TAG_CONFIGURED_Z);
        LoganVortexEntity vortex = new LoganVortexEntity((Level)level, center.f_82479_, center.f_82480_ + 1.0, center.f_82481_, spawn.player.m_20148_(), stack, targetX, targetZ, 3000);
        level.m_7967_((Entity)vortex);
        VortexImmersivePortalHelper.attachVisuals(level, vortex, spawn.placement, spawn.previewPortalId);
        SlidersMod.LOGGER.info("Upgraded Logan Timer Tier 1 vortex spawned at: {} targeting ({}, {}) with precision  {}", new Object[]{center, targetX, targetZ, 3000});
    }

    private static void updatePreviewPortal(ServerLevel level, ScheduledVortexSpawn spawn, long ticksLeft) {
        Portal portal = VortexImmersivePortalHelper.findPortal(level, spawn.previewPortalId);
        if (portal == null) {
            return;
        }
        long growthTicks = 15L;
        if (ticksLeft > growthTicks) {
            VortexImmersivePortalHelper.updatePortalSize(portal, VortexPortalTargets.LOGAN, 0.05);
            VortexImmersivePortalHelper.setPortalVisibility(portal, false);
            return;
        }
        int ticksSinceStart = (int)(4L - ticksLeft);
        double progress = Mth.m_14008_((double)((double)ticksSinceStart / 10.0), (double)0.0, (double)1.0);
        double size = Mth.m_14139_((double)progress, (double)0.05, (double)3.0);
        VortexImmersivePortalHelper.updatePortalSize(portal, VortexPortalTargets.LOGAN, size);
        VortexImmersivePortalHelper.setPortalVisibility(portal, true);
    }

    public static long getConfiguredX(ItemStack stack) {
        return stack.m_41784_().m_128454_(TAG_CONFIGURED_X);
    }

    public static long getConfiguredZ(ItemStack stack) {
        return stack.m_41784_().m_128454_(TAG_CONFIGURED_Z);
    }

    public static void setConfiguredX(ItemStack stack, int x) {
        stack.m_41784_().m_128405_(TAG_CONFIGURED_X, x);
    }

    public static void setConfiguredZ(ItemStack stack, int z) {
        stack.m_41784_().m_128405_(TAG_CONFIGURED_Z, z);
    }

    public static long getConfiguredTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(TAG_CONFIGURED_TIME);
    }

    public static void setConfiguredTime(ItemStack stack, long seconds) {
        long clamped = TimerUpgradeData.clampConfiguredSeconds(stack, seconds);
        stack.m_41784_().m_128356_(TAG_CONFIGURED_TIME, clamped);
    }

    public static long getActivationTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(TAG_ACTIVATION_TIME);
    }

    public static boolean isActive(ItemStack stack) {
        return stack.m_41784_().m_128471_(TAG_IS_ACTIVE);
    }

    public static void resetTimer(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(TAG_IS_ACTIVE, false);
        tag.m_128473_(TAG_ACTIVATION_TIME);
        tag.m_128473_(TAG_RETURN_DIM);
    }

    private static VortexPortalPlacement computeVortexPlacement(Player player, Level level) {
        boolean snapToVertical;
        Vec3 lookVec;
        Vec3 endPos;
        Vec3 eyePos = player.m_20299_(1.0f);
        ClipContext context = new ClipContext(eyePos, endPos = eyePos.m_82549_((lookVec = player.m_20154_().m_82541_()).m_82490_(7.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult result = level.m_45547_(context);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos hitPos = result.m_82425_();
            Direction face = result.m_82434_();
            Vec3 normal = Vec3.m_82528_((Vec3i)face.m_122436_()).m_82541_();
            if (normal.m_82526_(lookVec) < 0.0) {
                normal = normal.m_82490_(-1.0);
            }
            Vec3 center = Vec3.m_82512_((Vec3i)hitPos.m_121945_(face));
            Vec3 axisH = UpgradedLoganTimerTier1Item.resolveAxisH(normal, WORLD_UP);
            Vec3 axisW = normal.m_82537_(axisH).m_82541_();
            axisH = axisW.m_82537_(normal).m_82541_();
            return new VortexPortalPlacement(center, axisW, axisH, normal, true);
        }
        Vec3 center = eyePos.m_82549_(lookVec.m_82490_(5.0));
        float pitch = player.m_146909_();
        boolean bl = snapToVertical = pitch >= -15.0f && pitch <= 20.0f;
        if (snapToVertical) {
            Vec3 axisH;
            Vec3 normal;
            Vec3 axisW;
            Vec3 horizontal = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_);
            if (horizontal.m_82556_() < 1.0E-4) {
                double yawRad = Math.toRadians(player.m_146908_());
                horizontal = new Vec3(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
            }
            axisW = (axisW = (normal = horizontal.m_82541_()).m_82537_(axisH = WORLD_UP)).m_82556_() < 1.0E-4 ? WORLD_FORWARD : axisW.m_82541_();
            axisH = axisW.m_82537_(normal).m_82541_();
            Vec3 adjustedCenter = new Vec3(center.f_82479_, player.m_20182_().f_82480_ + 2.2, center.f_82481_);
            return new VortexPortalPlacement(adjustedCenter, axisW, axisH, normal, false);
        }
        Vec3 normal = lookVec.m_82541_();
        Vec3 axisH = UpgradedLoganTimerTier1Item.resolveAxisH(normal, player.m_20289_(1.0f));
        Vec3 axisW = normal.m_82537_(axisH).m_82541_();
        axisH = axisW.m_82537_(normal).m_82541_();
        return new VortexPortalPlacement(center, axisW, axisH, normal, false);
    }

    private static Vec3 resolveAxisH(Vec3 normal, Vec3 preferredUp) {
        Vec3 axisH;
        Vec3 candidate = preferredUp.m_82546_(normal.m_82490_(preferredUp.m_82526_(normal)));
        if (candidate.m_82556_() < 1.0E-4) {
            Vec3 fallback = Math.abs(normal.f_82480_) < 0.9 ? WORLD_UP : WORLD_FORWARD;
            candidate = fallback.m_82546_(normal.m_82490_(fallback.m_82526_(normal)));
        }
        if (candidate.m_82556_() < 1.0E-4) {
            candidate = normal.m_82537_(WORLD_FORWARD);
        }
        if (candidate.m_82556_() < 1.0E-4) {
            candidate = normal.m_82537_(new Vec3(1.0, 0.0, 0.0));
        }
        if ((axisH = candidate.m_82541_()).m_82526_(WORLD_UP) < 0.0 && Math.abs(normal.f_82480_) < 0.999) {
            axisH = axisH.m_82490_(-1.0);
        }
        return axisH;
    }

    public boolean m_142522_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128471_(TAG_IS_OVERHEATED) || tag.m_128471_(TAG_IS_ACTIVE);
    }

    public int m_142158_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128471_(TAG_IS_ACTIVE)) {
            return 13;
        }
        long configuredTime = tag.m_128454_(TAG_CONFIGURED_TIME);
        long activationTime = tag.m_128454_(TAG_ACTIVATION_TIME);
        if (configuredTime <= 0L) {
            return 13;
        }
        Level level = this.getClientLevel();
        if (level == null) {
            return 13;
        }
        long currentTime = level.m_46467_();
        long elapsedTicks = currentTime - activationTime;
        long elapsedSeconds = elapsedTicks / 20L;
        long remainingSeconds = configuredTime - elapsedSeconds;
        if (remainingSeconds <= 0L) {
            return 0;
        }
        float percentage = (float)remainingSeconds / (float)configuredTime;
        return Math.max(0, Math.min(13, Math.round(percentage * 13.0f)));
    }

    public int m_142159_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(TAG_IS_OVERHEATED)) {
            return 0xFF0000;
        }
        if (!tag.m_128471_(TAG_IS_ACTIVE)) {
            return 65280;
        }
        long configuredTime = tag.m_128454_(TAG_CONFIGURED_TIME);
        long activationTime = tag.m_128454_(TAG_ACTIVATION_TIME);
        if (configuredTime <= 0L) {
            return 65280;
        }
        Level level = this.getClientLevel();
        if (level == null) {
            return 65280;
        }
        long currentTime = level.m_46467_();
        long elapsedTicks = currentTime - activationTime;
        long elapsedSeconds = elapsedTicks / 20L;
        long remainingSeconds = configuredTime - elapsedSeconds;
        float percentage = (float)remainingSeconds / (float)configuredTime;
        if (percentage > 0.5f) {
            return 65280;
        }
        if (percentage > 0.25f) {
            return 0xFFFF00;
        }
        return 0xFF0000;
    }

    @Nullable
    private Level getClientLevel() {
        try {
            return Minecraft.m_91087_().f_91073_;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String formatTime(long totalSeconds) {
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (hours > 0L) {
            return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%02dm %02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }

    private static class ScheduledVortexSpawn {
        final long spawnTime;
        final ServerLevel level;
        final VortexPortalPlacement placement;
        final Player player;
        final ItemStack stack;
        @Nullable
        final UUID previewPortalId;

        ScheduledVortexSpawn(long spawnTime, ServerLevel level, VortexPortalPlacement placement, Player player, ItemStack stack, @Nullable UUID previewPortalId) {
            this.spawnTime = spawnTime;
            this.level = level;
            this.placement = placement;
            this.player = player;
            this.stack = stack.m_41777_();
            this.previewPortalId = previewPortalId;
        }
    }
}

