/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.menu;

import com.michelmuscle.slidersmod.block.entity.ProtoSynchronizerBlockEntity;
import com.michelmuscle.slidersmod.init.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ProtoSynchronizerMenu
extends AbstractContainerMenu {
    public final ProtoSynchronizerBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public ProtoSynchronizerMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(3));
    }

    public ProtoSynchronizerMenu(int containerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.PROTO_SYNCHRONIZER_MENU.get(), containerId);
        ProtoSynchronizerMenu.m_38869_((Container)inv, (int)3);
        this.blockEntity = (ProtoSynchronizerBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.m_38897_(new Slot(this.blockEntity, 0, 43, 16){

            public boolean m_5857_(ItemStack stack) {
                return ProtoSynchronizerMenu.this.blockEntity.m_7013_(0, stack);
            }
        });
        this.m_38897_(new Slot(this.blockEntity, 1, 43, 52){

            public boolean m_5857_(ItemStack stack) {
                return ProtoSynchronizerMenu.this.blockEntity.m_7013_(1, stack);
            }
        });
        this.m_38897_(new Slot(this.blockEntity, 2, 115, 34){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38884_(data);
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = 600;
        if (maxProgress == 0 || progress == 0) {
            return 0;
        }
        return progress * 100 / maxProgress;
    }

    public int getScaledEnergy() {
        int energy = this.data.m_6413_(1);
        int maxEnergy = this.blockEntity.getMaxEnergy();
        if (maxEnergy == 0) {
            return 0;
        }
        return energy * 52 / maxEnergy;
    }

    public boolean isProcessing() {
        return this.data.m_6413_(2) != 0;
    }

    public int getEnergy() {
        return this.data.m_6413_(1);
    }

    public int getMaxEnergy() {
        return this.blockEntity.getMaxEnergy();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            itemstack = stackInSlot.m_41777_();
            if (index < 36 ? !this.m_38903_(stackInSlot, 36, 39, false) : !this.m_38903_(stackInSlot, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return ProtoSynchronizerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public BlockPos getBlockPos() {
        return this.blockEntity.m_58899_();
    }
}

