/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.menu;

import com.michelmuscle.slidersmod.block.entity.ResearchTableBlockEntity;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModMenuTypes;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ResearchTableMenu
extends AbstractContainerMenu {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int BE_SLOTS = 2;
    private static final int INPUT_X = 43;
    private static final int INPUT_Y = 34;
    private static final int OUTPUT_X = 117;
    private static final int OUTPUT_Y = 34;
    private static final int INV_X = 8;
    private static final int INV_Y = 84;
    private static final int HOTBAR_Y = 142;
    private static final int SLOT_SPACING = 18;
    private final ResearchTableBlockEntity blockEntity;
    private final ContainerLevelAccess access;
    private final ContainerData data;

    public ResearchTableMenu(int id, Inventory playerInv, FriendlyByteBuf buf) {
        this(id, playerInv, ResearchTableMenu.getBlockEntity(playerInv, buf), (ContainerData)new SimpleContainerData(6));
    }

    public ResearchTableMenu(int id, Inventory playerInventory, ResearchTableBlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.RESEARCH_TABLE_MENU.get(), id);
        this.blockEntity = blockEntity;
        this.access = ContainerLevelAccess.m_39289_((Level)Objects.requireNonNull(blockEntity.m_58904_()), (BlockPos)blockEntity.m_58899_());
        this.data = data;
        this.m_38884_(this.data);
        this.addSlots(playerInventory, blockEntity.getItemHandler());
    }

    private static ResearchTableBlockEntity getBlockEntity(Inventory inventory, FriendlyByteBuf buffer) {
        Objects.requireNonNull(inventory, "player inventory cannot be null");
        Objects.requireNonNull(buffer, "buffer cannot be null");
        BlockPos pos = buffer.m_130135_();
        BlockEntity be = inventory.f_35978_.m_9236_().m_7702_(pos);
        if (!(be instanceof ResearchTableBlockEntity)) {
            throw new IllegalStateException("BlockEntity at " + String.valueOf(pos) + " is not a ResearchTableBlockEntity");
        }
        ResearchTableBlockEntity table = (ResearchTableBlockEntity)be;
        return table;
    }

    private void addSlots(Inventory playerInventory, ItemStackHandler handler) {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 43, 34){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_((Item)ModItems.SLIDE_ENHANCEMENT_CHIP.get());
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 117, 34){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = 84 + row * 18;
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, x, y));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public int getProgress() {
        return this.safeGet(0);
    }

    public int getMaxProgress() {
        int v = this.safeGet(1);
        return v <= 0 ? 1 : v;
    }

    public int getEnergyStored() {
        return this.safeGet(2);
    }

    public int getMaxEnergyStored() {
        int v = this.safeGet(3);
        return v <= 0 ? 1 : v;
    }

    public int getScanValue() {
        return this.safeGet(4);
    }

    public int getScanMax() {
        int v = this.safeGet(5);
        return v <= 0 ? 1 : v;
    }

    private int safeGet(int idx) {
        try {
            return this.data.m_6413_(idx);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getStateOrdinal() {
        return this.safeGet(4);
    }

    public boolean m_6875_(Player player) {
        return ResearchTableMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int invEndExclusive;
            int beEndExclusive;
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            int beStart = 0;
            int invStart = beEndExclusive = beStart + 2;
            int hotbarStart = invEndExclusive = invStart + 27;
            int hotbarEndExclusive = hotbarStart + 9;
            if (index < beEndExclusive ? !this.m_38903_(stack, invStart, hotbarEndExclusive, true) : (index < invEndExclusive ? !this.m_38903_(stack, 0, 1, false) && !this.m_38903_(stack, hotbarStart, hotbarEndExclusive, false) : index < hotbarEndExclusive && !this.m_38903_(stack, 0, 1, false) && !this.m_38903_(stack, invStart, invEndExclusive, false))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return itemstack;
    }
}

