/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.menu;

import com.michelmuscle.slidersmod.block.entity.TimerRecyclerBlockEntity;
import com.michelmuscle.slidersmod.init.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class TimerRecyclerMenu
extends AbstractContainerMenu {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int BE_SLOTS = 2;
    private static final int INPUT_X = 43;
    private static final int INPUT_Y = 34;
    private static final int OUTPUT_X = 117;
    private static final int OUTPUT_Y = 34;
    private static final int INV_X = 8;
    private static final int INV_Y = 84;
    private static final int HOTBAR_Y = 142;
    private static final int SLOT_SPACING = 18;
    private final TimerRecyclerBlockEntity blockEntity;
    private final ContainerLevelAccess access;
    private final ContainerData data;

    public TimerRecyclerMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(4));
    }

    public TimerRecyclerMenu(int containerId, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.TIMER_RECYCLER_MENU.get(), containerId);
        if (!(entity instanceof TimerRecyclerBlockEntity)) {
            throw new IllegalStateException("TimerRecyclerMenu requires correct block entity");
        }
        TimerRecyclerBlockEntity recycler = (TimerRecyclerBlockEntity)entity;
        this.blockEntity = recycler;
        this.access = ContainerLevelAccess.m_39289_((Level)recycler.m_58904_(), (BlockPos)recycler.m_58899_());
        this.data = data;
        this.m_38884_(this.data);
        this.addSlots(inventory, this.blockEntity.getItemHandler());
    }

    private void addSlots(Inventory playerInventory, ItemStackHandler handler) {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 43, 34){

            public boolean m_5857_(ItemStack stack) {
                return TimerRecyclerMenu.this.blockEntity.getItemHandler().isItemValid(0, stack);
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 117, 34){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = 84 + row * 18;
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, x, y));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int invEndExclusive;
            int beEndExclusive;
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            int beStart = 0;
            int invStart = beEndExclusive = beStart + 2;
            int hotbarStart = invEndExclusive = invStart + 27;
            int hotbarEndExclusive = hotbarStart + 9;
            if (index < beEndExclusive ? !this.m_38903_(stack, invStart, hotbarEndExclusive, true) : (index < invEndExclusive ? !this.m_38903_(stack, 0, 1, false) && !this.m_38903_(stack, hotbarStart, hotbarEndExclusive, false) : index < hotbarEndExclusive && !this.m_38903_(stack, 0, 1, false) && !this.m_38903_(stack, invStart, invEndExclusive, false))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return TimerRecyclerMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public TimerRecyclerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public ContainerData getData() {
        return this.data;
    }

    public int getProgress() {
        return this.data.m_6413_(0);
    }

    public int getMaxProgress() {
        int v = this.data.m_6413_(1);
        return v <= 0 ? 1 : v;
    }

    public int getEnergyStored() {
        return this.data.m_6413_(2);
    }

    public int getMaxEnergyStored() {
        int v = this.data.m_6413_(3);
        return v <= 0 ? 1 : v;
    }
}

