/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.menu;

import com.michelmuscle.slidersmod.block.entity.TimerWorkbenchBlockEntity;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModMenuTypes;
import com.michelmuscle.slidersmod.util.ClassicTimerHelper;
import com.michelmuscle.slidersmod.util.TimerUpgradeSlots;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class TimerWorkbenchMenu
extends AbstractContainerMenu {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int MACHINE_SLOT_INDEX = 9;
    private static final int OUTPUT_SLOT_INDEX = 10;
    private static final int UPGRADE_SLOT_START = 11;
    private static final int UPGRADE_SLOT_COUNT = 25;
    private static final int UPGRADE_SLOT_END = 36;
    private static final int[] CATEGORY_Y = new int[]{27, 52, 77, 102, 127};
    private static final int[] SLOT_X = new int[]{125, 148, 171, 194, 217};
    private final TimerWorkbenchBlockEntity blockEntity;
    private final ContainerData data;
    private final BlockPos blockPos;

    public TimerWorkbenchMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(4));
    }

    public TimerWorkbenchMenu(int containerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.TIMER_WORKBENCH_MENU.get(), containerId);
        if (!(entity instanceof TimerWorkbenchBlockEntity)) {
            throw new IllegalStateException("TimerWorkbenchMenu created without correct block entity");
        }
        TimerWorkbenchBlockEntity be = (TimerWorkbenchBlockEntity)entity;
        this.blockEntity = be;
        this.data = data;
        this.blockPos = be.m_58899_();
        TimerWorkbenchMenu.m_38869_((Container)be, (int)2);
        this.addPlayerHotbar(inv);
        this.m_38897_(new Slot(be, 0, 32, 48){

            public boolean m_5857_(ItemStack stack) {
                return TimerUpgradeSlots.isTimer(stack);
            }

            public boolean m_8010_(Player player) {
                return TimerWorkbenchMenu.this.blockEntity.canPickupTimer();
            }
        });
        this.m_38897_(new Slot(be, 1, 32, 73){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        for (int cat = 0; cat < 5; ++cat) {
            for (int col = 0; col < 5; ++col) {
                int slotIndex = cat * 5 + col;
                int x = SLOT_X[col];
                int y = CATEGORY_Y[cat];
                this.m_38897_((Slot)new UpgradeSlot(be, slotIndex, x, y, cat, col));
            }
        }
        this.m_38884_(data);
    }

    private void addPlayerHotbar(Inventory inv) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 48 + i * 18, 172));
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public int getProgress() {
        return this.data.m_6413_(0);
    }

    public int getState() {
        return this.data.m_6413_(1);
    }

    public int getEnergy() {
        return this.data.m_6413_(2);
    }

    public int getMaxEnergy() {
        return this.data.m_6413_(3);
    }

    public TimerWorkbenchBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public ItemStack getTimerStack() {
        return this.blockEntity.getTimerStack();
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public int getUpgradeSlotStart() {
        return 11;
    }

    public int getUpgradeSlotEnd() {
        return 36;
    }

    private boolean isUpgradeAllowed(int bufferIndex, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ItemStack timer = this.blockEntity.getTimerStack();
        if (timer.m_41619_() || !TimerUpgradeSlots.isTimer(timer)) {
            return false;
        }
        TimerUpgradeSlots.initializeTimer(timer);
        TimerUpgradeSlots.initializeTimer(timer);
        int category = bufferIndex / 5;
        int slotInCategory = bufferIndex % 5;
        int unlocked = TimerUpgradeSlots.getSlotCount(timer, category);
        if (slotInCategory >= unlocked) {
            return false;
        }
        switch (category) {
            case 0: {
                return stack.m_150930_((Item)ModItems.OVERHEAT_PROBABILITY_REDUCER.get());
            }
            case 1: {
                return stack.m_150930_((Item)ModItems.OVERHEAT_COOLDOWN_REDUCER.get());
            }
            case 2: {
                return stack.m_150930_((Item)ModItems.TEMPORAL_STABILIZER.get());
            }
            case 3: {
                return stack.m_150930_((Item)ModItems.DIMENSIONAL_BUFFER.get());
            }
            case 4: {
                String path = this.getTimerPath(timer);
                if (slotInCategory == 0) {
                    return path.contains("egyptian_timer") && stack.m_150930_((Item)ModItems.EGYPTIAN_TRACKER_UPGRADE.get());
                }
                if (slotInCategory == 1) {
                    return path.contains("exodus_timer") && stack.m_150930_((Item)ModItems.EXODUS_SEED_UPGRADE.get());
                }
                if (slotInCategory == 2) {
                    return path.contains("exodus_timer") && stack.m_150930_((Item)ModItems.DIMENSION_ANCHOR.get());
                }
                if (slotInCategory == 3) {
                    return stack.m_150930_((Item)ModItems.PORTAL_STABILITY_UPGRADE.get());
                }
                if (slotInCategory == 4) {
                    return ClassicTimerHelper.isDamagedTimer(timer) && (stack.m_150930_((Item)ModItems.CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.ADVANCED_CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.ULTIMATE_CRYSTAL_BUFFER.get()));
                }
                return false;
            }
        }
        return false;
    }

    private String getTimerPath(ItemStack timer) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)timer.m_41720_());
        return key != null ? key.m_135815_() : "";
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack current = slot.m_7993_();
            newStack = current.m_41777_();
            if (index < 9) {
                if (!this.m_38903_(current, 11, 36, false) && !this.m_38903_(current, 9, 10, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 11 && index < 36) {
                if (!this.m_38903_(current, 0, 9, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (index == 9 && !this.blockEntity.canPickupTimer()) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(current, 0, 9, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (current.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    private class UpgradeSlot
    extends SlotItemHandler {
        private final int category;
        private final int slotInCategory;

        UpgradeSlot(TimerWorkbenchBlockEntity be, int slotIndex, int x, int y, int category, int slotInCategory) {
            super((IItemHandler)be.getUpgradeHandler(), slotIndex, x, y);
            this.category = category;
            this.slotInCategory = slotInCategory;
        }

        public boolean m_6659_() {
            ItemStack timer = TimerWorkbenchMenu.this.blockEntity.getTimerStack();
            if (timer.m_41619_() || !TimerUpgradeSlots.isTimer(timer)) {
                return false;
            }
            TimerUpgradeSlots.initializeTimer(timer);
            int unlocked = TimerUpgradeSlots.getSlotCount(timer, this.category);
            return this.slotInCategory < unlocked;
        }

        public boolean m_5857_(ItemStack stack) {
            return this.m_6659_() && TimerWorkbenchMenu.this.isUpgradeAllowed(this.category * 5 + this.slotInCategory, stack);
        }

        public boolean m_8010_(Player player) {
            return this.m_6659_() && super.m_8010_(player);
        }
    }
}

