/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.portal;

import com.michelmuscle.slidersmod.SlidersMod;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import qouteall.imm_ptl.core.portal.Portal;

@Mod.EventBusSubscriber(modid="slidersmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class VortexPortalTracker {
    private static final Map<ResourceKey<Level>, Map<Long, Set<UUID>>> PORTALS = new ConcurrentHashMap<ResourceKey<Level>, Map<Long, Set<UUID>>>();

    private VortexPortalTracker() {
    }

    public static void register(ServerLevel level, Portal portal) {
        ChunkPos chunkPos = new ChunkPos(BlockPos.m_274446_((Position)portal.m_20182_()));
        PORTALS.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new ConcurrentHashMap()).computeIfAbsent(chunkPos.m_45588_(), key -> ConcurrentHashMap.newKeySet()).add(portal.m_20148_());
    }

    public static void unregister(ServerLevel level, UUID portalId) {
        Map<Long, Set<UUID>> byChunk = PORTALS.get(level.m_46472_());
        if (byChunk == null) {
            return;
        }
        for (Set<UUID> ids : byChunk.values()) {
            if (ids.remove(portalId)) break;
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        ChunkAccess chunkAccess = event.getChunk();
        if (!(chunkAccess instanceof LevelChunk)) {
            return;
        }
        LevelChunk levelChunk = (LevelChunk)chunkAccess;
        VortexPortalTracker.handleChunkUnload(serverLevel, levelChunk.m_7697_());
    }

    private static void handleChunkUnload(ServerLevel level, ChunkPos chunkPos) {
        Map<Long, Set<UUID>> byChunk = PORTALS.get(level.m_46472_());
        if (byChunk == null) {
            return;
        }
        Set<UUID> ids = byChunk.remove(chunkPos.m_45588_());
        if (ids == null || ids.isEmpty()) {
            return;
        }
        for (UUID id : ids) {
            Entity entity = level.m_8791_(id);
            if (!(entity instanceof Portal)) continue;
            Portal portal = (Portal)entity;
            portal.m_146870_();
            SlidersMod.LOGGER.debug("Discarded lingering Immersive Portal {} on chunk unload {}", (Object)id, (Object)chunkPos);
        }
    }
}

