/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.util;

public enum UpgradeType {
    OVERHEAT_COOLDOWN_REDUCER("overheat_cooldown_reducer", "Overheat Cooldown"),
    OVERHEAT_PROBABILITY_REDUCER("overheat_probability_reducer", "Overheat Probability"),
    TEMPORAL_STABILIZER("temporal_stabilizer", "Temporal Enhancement"),
    DIMENSIONAL_BUFFER_TIER1("dimensional_buffer_tier1", "Dimensional Buffer"),
    DIMENSIONAL_BUFFER_TIER2("dimensional_buffer_tier2", "Dimensional Buffer"),
    DIMENSIONAL_BUFFER_TIER3("dimensional_buffer_tier3", "Dimensional Buffer"),
    DIMENSIONAL_BUFFER_TIER4("dimensional_buffer_tier4", "Dimensional Buffer"),
    DIMENSIONAL_BUFFER_TIER5("dimensional_buffer_tier5", "Dimensional Buffer"),
    CRYSTAL_BUFFER("crystal_buffer", "Crystal Buffer"),
    EGYPTIAN_TRACKER("egyptian_tracker", "Egyptian Tracker"),
    EXODUS_SEED("exodus_seed", "Exodus Seed"),
    DIMENSION_ANCHOR("dimension_anchor", "Dimension Anchor"),
    PORTAL_STABILITY("portal_stability", "Portal Stability"),
    SLOT_EXPANDER("slot_expander", "Slot Expander");

    private final String registryName;
    private final String displayName;

    private UpgradeType(String registryName, String displayName) {
        this.registryName = registryName;
        this.displayName = displayName;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getCategoryIndex() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case OVERHEAT_PROBABILITY_REDUCER -> 0;
            case OVERHEAT_COOLDOWN_REDUCER -> 1;
            case TEMPORAL_STABILIZER -> 2;
            case DIMENSIONAL_BUFFER_TIER1, DIMENSIONAL_BUFFER_TIER2, DIMENSIONAL_BUFFER_TIER3, DIMENSIONAL_BUFFER_TIER4, DIMENSIONAL_BUFFER_TIER5 -> 3;
            case CRYSTAL_BUFFER, EGYPTIAN_TRACKER, EXODUS_SEED, DIMENSION_ANCHOR -> 4;
            case PORTAL_STABILITY -> 4;
            case SLOT_EXPANDER -> -1;
        };
    }

    public String getCategoryName() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case OVERHEAT_PROBABILITY_REDUCER -> "Overheat Probability";
            case OVERHEAT_COOLDOWN_REDUCER -> "Overheat Cooldown";
            case TEMPORAL_STABILIZER -> "Temporal Enhancement";
            case DIMENSIONAL_BUFFER_TIER1, DIMENSIONAL_BUFFER_TIER2, DIMENSIONAL_BUFFER_TIER3, DIMENSIONAL_BUFFER_TIER4, DIMENSIONAL_BUFFER_TIER5 -> "Dimensional Buffer";
            case CRYSTAL_BUFFER -> "Crystal Buffer";
            case EGYPTIAN_TRACKER -> "Egyptian Tracker";
            case EXODUS_SEED -> "Exodus Seed";
            case DIMENSION_ANCHOR -> "Dimension Anchor";
            case PORTAL_STABILITY -> "Portal Stability";
            case SLOT_EXPANDER -> "Meta";
        };
    }

    public static UpgradeType getByRegistryName(String name) {
        for (UpgradeType type : UpgradeType.values()) {
            if (!type.registryName.equals(name)) continue;
            return type;
        }
        return null;
    }
}

