/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.world;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.dimension.DimKeys;
import com.michelmuscle.slidersmod.init.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;

public final class VortexShowcaseManager {
    private static final BlockPos OG_POS = new BlockPos(50, 100, 50);
    private static final BlockPos LOGAN_POS = new BlockPos(55, 100, 50);
    private static final BlockPos EGYPTIAN_POS = new BlockPos(50, 110, 50);
    private static final BlockPos PROTO_POS = new BlockPos(55, 110, 50);
    private static final BlockPos EXODUS_POS = new BlockPos(50, 120, 50);
    private static final BlockPos OG_CHUNK_OWNER = new BlockPos(50, 0, 50);
    private static final BlockPos LOGAN_CHUNK_OWNER = new BlockPos(55, 0, 50);
    private static final BlockPos EGYPTIAN_CHUNK_OWNER = new BlockPos(50, 0, 50);
    private static final BlockPos PROTO_CHUNK_OWNER = new BlockPos(55, 0, 50);
    private static final BlockPos EXODUS_CHUNK_OWNER = new BlockPos(50, 0, 50);
    private static final String SHOWCASE_TAG = "slidersmod.showcase_anchor";

    private VortexShowcaseManager() {
    }

    public static ResourceKey<Level> dimensionKey() {
        return DimKeys.VORTEX_SHOWCASE;
    }

    public static void ensureShowcaseReady(MinecraftServer server) {
        ServerLevel level = server.m_129880_(VortexShowcaseManager.dimensionKey());
        if (level == null) {
            SlidersMod.LOGGER.error("Unable to access slidersmod:void dimension. OBJ showcase cannot be prepared.");
            return;
        }
        VortexShowcaseManager.forceChunk(level, OG_CHUNK_OWNER, OG_POS);
        VortexShowcaseManager.forceChunk(level, LOGAN_CHUNK_OWNER, LOGAN_POS);
        VortexShowcaseManager.forceChunk(level, EGYPTIAN_CHUNK_OWNER, EGYPTIAN_POS);
        VortexShowcaseManager.forceChunk(level, PROTO_CHUNK_OWNER, PROTO_POS);
        VortexShowcaseManager.forceChunk(level, EXODUS_CHUNK_OWNER, EXODUS_POS);
        VortexShowcaseManager.ensureEntity(level, (EntityType)ModEntities.OG_VORTEX_OBJ_ENTITY.get(), OG_POS, "og");
        VortexShowcaseManager.ensureEntity(level, (EntityType)ModEntities.LOGAN_VORTEX_OBJ_ENTITY.get(), LOGAN_POS, "logan");
        VortexShowcaseManager.ensureEntity(level, (EntityType)ModEntities.EGYPTIAN_VORTEX_OBJ_ENTITY.get(), EGYPTIAN_POS, "egyptian");
        VortexShowcaseManager.ensureEntity(level, (EntityType)ModEntities.PROTO_VORTEX_OBJ_ENTITY.get(), PROTO_POS, "proto");
        VortexShowcaseManager.ensureEntity(level, (EntityType)ModEntities.EXODUS_VORTEX_OBJ_ENTITY.get(), EXODUS_POS, "exodus");
    }

    private static void forceChunk(ServerLevel level, BlockPos owner, BlockPos anchorPos) {
        ChunkPos chunkPos = new ChunkPos(anchorPos);
        boolean forced = ForgeChunkManager.forceChunk((ServerLevel)level, (String)"slidersmod", (BlockPos)owner, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)true);
        if (forced) {
            SlidersMod.LOGGER.debug("Forced showcase chunk {} in {}", (Object)chunkPos, (Object)level.m_46472_().m_135782_());
        }
    }

    private static <T extends Entity> void ensureEntity(ServerLevel level, EntityType<T> type, BlockPos pos, String anchorId) {
        boolean present;
        AABB box = new AABB(pos).m_82400_(0.25);
        boolean bl = present = !level.m_142425_(type, box, e -> anchorId.equals(e.getPersistentData().m_128461_(SHOWCASE_TAG))).isEmpty();
        if (present) {
            return;
        }
        Entity entity = type.m_20615_((Level)level);
        if (entity == null) {
            SlidersMod.LOGGER.error("Failed to create entity {} for showcase dimension.", (Object)type.m_204041_().m_205785_().m_135782_());
            return;
        }
        entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
        entity.m_20331_(true);
        entity.m_20242_(true);
        entity.f_19794_ = true;
        entity.getPersistentData().m_128359_(SHOWCASE_TAG, anchorId);
        level.m_7967_(entity);
        SlidersMod.LOGGER.info("Placed {} vortex preview at {} in slidersmod:void.", (Object)type.m_204041_().m_205785_().m_135782_(), (Object)pos);
    }

    public static Vec3 getOgAnchorCenter() {
        return Vec3.m_82512_((Vec3i)OG_POS);
    }

    public static Vec3 getLoganAnchorCenter() {
        return Vec3.m_82512_((Vec3i)LOGAN_POS);
    }

    public static Vec3 getEgyptianAnchorCenter() {
        return Vec3.m_82512_((Vec3i)EGYPTIAN_POS);
    }

    public static Vec3 getProtoAnchorCenter() {
        return Vec3.m_82512_((Vec3i)PROTO_POS);
    }

    public static Vec3 getExodusAnchorCenter() {
        return Vec3.m_82512_((Vec3i)EXODUS_POS);
    }
}

