/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.advancements;

import com.michelmuscle.slidersmod.SlidersMod;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;

public class AchievementManager {
    public static void grantAchievement(ServerPlayer player, String achievementPath, String criterionId) {
        AchievementManager.grantAchievement(player, achievementPath);
    }

    public static void grantAchievement(ServerPlayer player, String achievementPath) {
        if (player == null || player.m_9236_().f_46443_) {
            return;
        }
        try {
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                return;
            }
            if (achievementPath == null) {
                return;
            }
            ResourceLocation advancementId = ResourceLocation.fromNamespaceAndPath((String)"slidersmod", (String)achievementPath);
            Advancement advancement = server.m_129889_().m_136041_(advancementId);
            if (advancement == null) {
                SlidersMod.LOGGER.warn("Achievement not found: {}", (Object)advancementId);
                return;
            }
            PlayerAdvancements advancementManager = player.m_8960_();
            AdvancementProgress progress = advancementManager.m_135996_(advancement);
            if (!progress.m_8193_()) {
                for (String criterion : progress.m_8219_()) {
                    advancementManager.m_135988_(advancement, criterion);
                }
            }
        }
        catch (Exception e) {
            SlidersMod.LOGGER.error("Error granting achievement to player: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void trigger69SecondTimer(ServerPlayer player) {
        AchievementManager.grantAchievement(player, "tier_2_lenny_face", "lenny");
    }

    public static void triggerFirstSlide(ServerPlayer player) {
        if (player.getPersistentData().m_128471_("slidersmod_first_slide_done")) {
            return;
        }
        player.getPersistentData().m_128379_("slidersmod_first_slide_done", true);
        AchievementManager.grantAchievement(player, "tier_1_sliding_time", "first_slide");
    }

    public static void triggerGoodLuckWithThat(ServerPlayer player) {
        AchievementManager.grantAchievement(player, "tier_3_good_luck", "over_hour");
    }

    public static void triggerMrPatience(ServerPlayer player) {
        AchievementManager.grantAchievement(player, "tier_3_mr_patience", "over_day");
    }

    public static void addChipCollected(ServerPlayer player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        int currentChips = player.getPersistentData().m_128451_("slidersmod_chips_collected");
        player.getPersistentData().m_128405_("slidersmod_chips_collected", ++currentChips);
        if (currentChips == 10) {
            AchievementManager.grantAchievement(player, "tier_3_collectionneur", "chips_collected");
        }
        if (currentChips == 100) {
            AchievementManager.grantAchievement(player, "hidden_collector_crazy", "crazy_collector");
        }
    }

    public static void trackDimensionVisit(ServerPlayer player, String dimensionKey) {
        if (player == null || player.m_9236_().f_46443_) {
            return;
        }
        ListTag visitedDims = player.getPersistentData().m_128437_("slidersmod_visited_dimensions", 8);
        boolean alreadyVisited = false;
        for (int i = 0; i < visitedDims.size(); ++i) {
            if (!visitedDims.m_128778_(i).equals(dimensionKey)) continue;
            alreadyVisited = true;
            break;
        }
        if (!alreadyVisited) {
            visitedDims.add((Object)StringTag.m_129297_((String)dimensionKey));
            player.getPersistentData().m_128365_("slidersmod_visited_dimensions", (Tag)visitedDims);
            if (visitedDims.size() == 10) {
                AchievementManager.grantAchievement(player, "tier_3_explorateur_dimensionnel", "dimensions_visited");
            }
        }
    }

    public static void trackDimensionTime(ServerPlayer player, String dimensionKey, long ticks) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        String nbtKey = "slidersmod_time_in_" + dimensionKey.replace(":", "_");
        long currentTime = player.getPersistentData().m_128454_(nbtKey);
        player.getPersistentData().m_128356_(nbtKey, currentTime += ticks);
        if (currentTime >= 72000L && currentTime - ticks < 72000L) {
            AchievementManager.grantAchievement(player, "hidden_marathon", "marathon");
        }
    }

    public static void resetDimensionTime(ServerPlayer player, String dimensionKey) {
        String nbtKey = "slidersmod_time_in_" + dimensionKey.replace(":", "_");
        player.getPersistentData().m_128473_(nbtKey);
    }

    public static void triggerVortexTracked(ServerPlayer player) {
        AchievementManager.grantAchievement(player, "tier_2_interdimensional_detective", "vortex_tracked");
    }

    public static void triggerDimensionSeedUsed(ServerPlayer player) {
        AchievementManager.grantAchievement(player, "tier_2_dimension_seed", "seed_used");
    }

    public static void triggerItemThrownInVortex(ServerPlayer player) {
        AchievementManager.grantAchievement(player, "tier_3_too_rich", "diamond_in_vortex");
    }

    public static void addResearchFailure(ServerPlayer player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        int consecutiveFailures = player.getPersistentData().m_128451_("slidersmod_research_failures");
        player.getPersistentData().m_128405_("slidersmod_research_failures", ++consecutiveFailures);
        if (consecutiveFailures == 10) {
            AchievementManager.grantAchievement(player, "hidden_malchanceux", "research_failures");
        }
    }

    public static void resetResearchFailures(ServerPlayer player) {
        player.getPersistentData().m_128405_("slidersmod_research_failures", 0);
    }

    public static void triggerStuckInDimension(ServerPlayer player) {
        AchievementManager.grantAchievement(player, "hidden_stuck", "stuck_timer");
    }
}

