/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.block.entity;

import com.michelmuscle.slidersmod.client.sound.BlockSoundManager;
import com.michelmuscle.slidersmod.init.ModBlockEntities;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.menu.AnalyzerStationMenu;
import com.michelmuscle.slidersmod.util.ClassicTimerHelper;
import com.michelmuscle.slidersmod.util.TimerUpgradeAnalyzer;
import com.michelmuscle.slidersmod.util.TimerUpgradeSlots;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyzerStationBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    public static final int SLOT_TIMER = 0;
    public static final int SLOT_MODULATOR = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int SLOT_COUNT = 3;
    private static final int ENERGY_CAPACITY = 25000;
    public static final int PROCESS_TIME = 200;
    public static final int ENERGY_PER_OPERATION = 5000;
    private static final int ENERGY_PER_TICK = 25;
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            AnalyzerStationBlockEntity.this.m_6596_();
            AnalyzerStationBlockEntity.this.onInventoryChanged(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> TimerUpgradeSlots.isTimer(stack);
                case 1 -> {
                    if (stack.m_150930_((Item)ModItems.PHASE_MODULATOR.get()) || stack.m_150930_((Item)ModItems.SINGLE_USE_CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.SINGLE_USE_ADV_CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.SINGLE_USE_ULTIMATE_CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.ADVANCED_CRYSTAL_BUFFER.get()) || stack.m_150930_((Item)ModItems.ULTIMATE_CRYSTAL_BUFFER.get())) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> false;
                default -> false;
            };
        }
    };
    private final LazyOptional<ItemStackHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(25000, 1000);
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this.energyStorage);
    private int progress = 0;
    private boolean processing = false;
    private final ContainerData data = new SimpleContainerData(3){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> AnalyzerStationBlockEntity.this.progress;
                case 1 -> AnalyzerStationBlockEntity.this.energyStorage.getEnergyStored();
                case 2 -> {
                    if (AnalyzerStationBlockEntity.this.processing) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AnalyzerStationBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    AnalyzerStationBlockEntity.this.energyStorage.setEnergy(value);
                    break;
                }
                case 2: {
                    AnalyzerStationBlockEntity.this.processing = value != 0;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public AnalyzerStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ANALYZER_STATION.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AnalyzerStationBlockEntity entity) {
        boolean isSingleUse;
        if (level.f_46443_) {
            if (entity.progress > 0 && entity.processing && !BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.startBlockSound(pos, (SoundEvent)ModSounds.ANALYZER_STATION_ACTIVE.get());
            } else if ((!entity.processing || entity.progress == 0) && BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.stopBlockSound(pos);
            }
            return;
        }
        boolean dirty = false;
        ItemStack timer = entity.itemHandler.getStackInSlot(0);
        ItemStack modulator = entity.itemHandler.getStackInSlot(1);
        ItemStack output = entity.itemHandler.getStackInSlot(2);
        if (timer.m_41619_() || modulator.m_41619_() || !output.m_41619_()) {
            entity.progress = 0;
            entity.processing = false;
            return;
        }
        boolean isPhaseMod = modulator.m_150930_((Item)ModItems.PHASE_MODULATOR.get());
        boolean bl = isSingleUse = modulator.m_150930_((Item)ModItems.SINGLE_USE_CRYSTAL_BUFFER.get()) || modulator.m_150930_((Item)ModItems.SINGLE_USE_ADV_CRYSTAL_BUFFER.get()) || modulator.m_150930_((Item)ModItems.SINGLE_USE_ULTIMATE_CRYSTAL_BUFFER.get());
        if (!isSingleUse && (modulator.m_150930_((Item)ModItems.CRYSTAL_BUFFER.get()) || modulator.m_150930_((Item)ModItems.ADVANCED_CRYSTAL_BUFFER.get()) || modulator.m_150930_((Item)ModItems.ULTIMATE_CRYSTAL_BUFFER.get()))) {
            isSingleUse = true;
        }
        if (!isPhaseMod && !isSingleUse) {
            entity.progress = 0;
            entity.processing = false;
            return;
        }
        if (entity.energyStorage.getEnergyStored() < 25) {
            entity.processing = false;
            return;
        }
        entity.energyStorage.extractEnergy(25, false);
        ++entity.progress;
        entity.processing = true;
        dirty = true;
        if (entity.progress >= 200) {
            ItemStack result = timer.m_41777_();
            CompoundTag tag = result.m_41784_();
            if (isPhaseMod) {
                tag.m_128379_("IsOverheated", false);
                tag.m_128473_("IsCooldownOverheat");
                tag.m_128473_("CooldownEndTime");
                ClassicTimerHelper.setOverheated(result, false);
            } else if (isSingleUse && ClassicTimerHelper.isDamagedTimer(result)) {
                double factor = AnalyzerStationBlockEntity.getSingleUseFactor(modulator);
                long remaining = tag.m_128454_("RemainingTime");
                if (remaining > 0L && factor > 0.0) {
                    long adjusted = Math.max(20L, (long)((double)remaining * factor));
                    tag.m_128356_("RemainingTime", adjusted);
                }
            }
            entity.itemHandler.setStackInSlot(2, result);
            timer.m_41774_(1);
            modulator.m_41774_(1);
            entity.progress = 0;
            entity.processing = false;
            dirty = true;
        }
        if (dirty) {
            entity.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    private void onInventoryChanged(int slot) {
        this.progress = 0;
        this.processing = false;
        if (!this.levelIsClient()) {
            this.m_6596_();
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public ContainerData getData() {
        return this.data;
    }

    public LazyOptional<IEnergyStorage> getEnergyCapability() {
        return this.energyCapability;
    }

    public void drops() {
        if (this.f_58857_ == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
        }
    }

    public static boolean isAnalyzableTimer(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        return TimerUpgradeAnalyzer.isSupportedTimer(item);
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7983_() {
        return this.itemHandler.getStackInSlot(0).m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack extracted = this.itemHandler.extractItem(slot, amount, false);
        if (!extracted.m_41619_()) {
            this.m_6596_();
        }
        return extracted;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        for (int i = 0; i < 3; ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.progress = 0;
        this.processing = false;
    }

    private static double getSingleUseFactor(ItemStack stack) {
        if (stack.m_150930_((Item)ModItems.SINGLE_USE_CRYSTAL_BUFFER.get())) {
            return 0.75;
        }
        if (stack.m_150930_((Item)ModItems.SINGLE_USE_ADV_CRYSTAL_BUFFER.get())) {
            return 0.5;
        }
        if (stack.m_150930_((Item)ModItems.SINGLE_USE_ULTIMATE_CRYSTAL_BUFFER.get())) {
            return 0.25;
        }
        return 1.0;
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
        this.energyCapability.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemCapability.lazyMap(handler -> handler);
        this.energyCapability.lazyMap(storage -> storage);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("energy", (Tag)this.energyStorage.serializeNBT());
        tag.m_128405_("progress", this.progress);
        tag.m_128379_("processing", this.processing);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.energyStorage.deserializeNBT(tag.m_128423_("energy"));
        this.progress = tag.m_128451_("progress");
        this.processing = tag.m_128471_("processing");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.slidersmod.analyzer_station");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new AnalyzerStationMenu(id, inventory, this, this.data);
    }

    private boolean levelIsClient() {
        return this.f_58857_ != null && this.f_58857_.f_46443_;
    }

    private class CustomEnergyStorage
    implements IEnergyStorage {
        private int energy;
        private final int capacity;
        private final int maxReceive;

        CustomEnergyStorage(int capacity, int maxReceive) {
            this.capacity = capacity;
            this.maxReceive = maxReceive;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate && received > 0) {
                this.energy += received;
                AnalyzerStationBlockEntity.this.m_6596_();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = Math.min(this.energy, maxExtract);
            if (!simulate && extracted > 0) {
                this.energy -= extracted;
                AnalyzerStationBlockEntity.this.m_6596_();
            }
            return extracted;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        void setEnergy(int value) {
            this.energy = Math.min(value, this.capacity);
        }

        CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("energy", this.energy);
            return tag;
        }

        void deserializeNBT(@Nullable Tag nbt) {
            if (nbt instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)nbt;
                this.energy = compound.m_128451_("energy");
            }
        }
    }
}

