/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.block.entity;

import com.michelmuscle.slidersmod.SlidersMod;
import com.michelmuscle.slidersmod.client.sound.BlockSoundManager;
import com.michelmuscle.slidersmod.init.ModBlockEntities;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.item.ExodusTimerItem;
import com.michelmuscle.slidersmod.item.QuantumRelocatorItem;
import com.michelmuscle.slidersmod.menu.ProtoSynchronizerMenu;
import com.michelmuscle.slidersmod.system.DimensionSeedRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtoSynchronizerBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    public static final int SLOT_EXODUS_TIMER = 0;
    public static final int SLOT_RELOCATOR_INPUT = 1;
    public static final int SLOT_RELOCATOR_OUTPUT = 2;
    private static final int SLOT_COUNT = 3;
    private static final int ENERGY_CAPACITY = 100000;
    private static final int ENERGY_PER_OPERATION = 10000;
    public static final int PROCESS_TIME = 600;
    private static final int ENERGY_PER_TICK = 16;
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            ProtoSynchronizerBlockEntity.this.m_6596_();
            ProtoSynchronizerBlockEntity.this.onInventoryChanged(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.m_41720_() instanceof ExodusTimerItem;
                case 1 -> {
                    if (stack.m_41720_() instanceof QuantumRelocatorItem && !QuantumRelocatorItem.hasEncodedSeed(stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> false;
                default -> false;
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(100000, 1000);
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    private int progress = 0;
    private String targetSeed = "";
    private boolean isProcessing = false;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ProtoSynchronizerBlockEntity.this.progress;
                case 1 -> ProtoSynchronizerBlockEntity.this.energyStorage.getEnergyStored();
                case 2 -> {
                    if (ProtoSynchronizerBlockEntity.this.isProcessing) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ProtoSynchronizerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ProtoSynchronizerBlockEntity.this.energyStorage.setEnergy(value);
                    break;
                }
                case 2: {
                    ProtoSynchronizerBlockEntity.this.isProcessing = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public ProtoSynchronizerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PROTO_SYNCHRONIZER.get(), pos, state);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ProtoSynchronizerBlockEntity entity) {
        if (level.f_46443_) {
            if (entity.isProcessing && !BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.startBlockSound(pos, (SoundEvent)ModSounds.PROTO_SYNCHRONIZER_ACTIVE.get());
            } else if (!entity.isProcessing && BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.stopBlockSound(pos);
            }
            return;
        }
        boolean dirty = false;
        if (entity.canProcess()) {
            if (!entity.isProcessing) {
                entity.startProcessing();
                dirty = true;
            }
            if (entity.energyStorage.extractEnergy(16, false) == 16) {
                ++entity.progress;
                dirty = true;
                if (entity.progress >= 600) {
                    entity.finishProcessing();
                }
            } else if (entity.isProcessing) {
                entity.isProcessing = false;
                dirty = true;
            }
        } else if (entity.isProcessing || entity.progress > 0) {
            entity.resetProcessing();
            dirty = true;
        }
        if (dirty) {
            entity.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    private boolean canProcess() {
        DimensionSeedRegistry registry;
        ItemStack exodusTimer = this.itemHandler.getStackInSlot(0);
        ItemStack relocatorInput = this.itemHandler.getStackInSlot(1);
        ItemStack relocatorOutput = this.itemHandler.getStackInSlot(2);
        if (exodusTimer.m_41619_() || !(exodusTimer.m_41720_() instanceof ExodusTimerItem)) {
            return false;
        }
        if (relocatorInput.m_41619_() || !(relocatorInput.m_41720_() instanceof QuantumRelocatorItem)) {
            return false;
        }
        if (QuantumRelocatorItem.hasEncodedSeed(relocatorInput)) {
            return false;
        }
        if (!relocatorOutput.m_41619_() && relocatorOutput.m_41613_() >= relocatorOutput.m_41741_()) {
            return false;
        }
        if (this.targetSeed.isEmpty() || !DimensionSeedRegistry.isValidSeedFormat(this.targetSeed)) {
            return false;
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && !(registry = DimensionSeedRegistry.get(this.f_58857_.m_7654_())).isValidSeed(this.targetSeed)) {
            return false;
        }
        return this.energyStorage.getEnergyStored() >= 16;
    }

    private void startProcessing() {
        this.isProcessing = true;
        SlidersMod.LOGGER.info("Proto-Synchronizer started processing seed: {}", (Object)this.targetSeed);
    }

    private void resetProcessing() {
        this.progress = 0;
        this.isProcessing = false;
    }

    private void finishProcessing() {
        ItemStack output = new ItemStack((ItemLike)this.itemHandler.getStackInSlot(1).m_41720_());
        QuantumRelocatorItem.encodeSeed(output, this.targetSeed);
        this.itemHandler.setStackInSlot(2, output);
        this.itemHandler.extractItem(1, 1, false);
        this.resetProcessing();
        SlidersMod.LOGGER.info("Proto-Synchronizer finished encoding seed: {}", (Object)this.targetSeed);
    }

    public void setTargetSeed(String seed) {
        this.targetSeed = seed;
        this.m_6596_();
    }

    public String getTargetSeed() {
        return this.targetSeed;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return 600;
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    private void onInventoryChanged(int slot) {
        if (!(slot != 0 && slot != 1 || this.canProcess())) {
            this.resetProcessing();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("energy", (Tag)this.energyStorage.serializeNBT());
        tag.m_128405_("progress", this.progress);
        tag.m_128359_("targetSeed", this.targetSeed);
        tag.m_128379_("isProcessing", this.isProcessing);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.energyStorage.deserializeNBT(tag.m_128423_("energy"));
        this.progress = tag.m_128451_("progress");
        this.targetSeed = tag.m_128461_("targetSeed");
        this.isProcessing = tag.m_128471_("isProcessing");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Proto-Synchronizer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new ProtoSynchronizerMenu(containerId, playerInventory, this, this.data);
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7983_() {
        for (int i = 0; i < 3; ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.itemHandler.extractItem(slot, amount, false);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        for (int i = 0; i < 3; ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void drops() {
        if (this.f_58857_ == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
        }
    }

    private class CustomEnergyStorage
    implements IEnergyStorage {
        private int energy;
        private final int capacity;
        private final int maxReceive;

        public CustomEnergyStorage(int capacity, int maxReceive) {
            this.capacity = capacity;
            this.maxReceive = maxReceive;
            this.energy = 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate) {
                this.energy += energyReceived;
                ProtoSynchronizerBlockEntity.this.m_6596_();
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(this.energy, maxExtract);
            if (!simulate) {
                this.energy -= energyExtracted;
                ProtoSynchronizerBlockEntity.this.m_6596_();
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return this.energy > 0;
        }

        public boolean canReceive() {
            return this.energy < this.capacity;
        }

        public void setEnergy(int energy) {
            this.energy = Math.min(energy, this.capacity);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("energy", this.energy);
            return tag;
        }

        public void deserializeNBT(Tag nbt) {
            if (nbt instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)nbt;
                this.energy = tag.m_128451_("energy");
            }
        }
    }
}

