/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.block.entity;

import com.michelmuscle.slidersmod.init.ModBlockEntities;
import com.michelmuscle.slidersmod.item.CustomTimerItem;
import com.michelmuscle.slidersmod.menu.TimerCustomizerMenu;
import com.michelmuscle.slidersmod.util.CustomVortexVisuals;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimerCustomizerBlockEntity
extends BlockEntity
implements Container,
MenuProvider {
    public static final int SLOT_TIMER = 0;
    private static final int DATA_SIZE = 5;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TimerCustomizerBlockEntity.this.syncFromItem();
            TimerCustomizerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() instanceof CustomTimerItem;
        }
    };
    private final LazyOptional<IItemHandler> handlerOptional = LazyOptional.of(() -> this.itemHandler);
    private final ContainerData dataAccess;
    private CustomVortexVisuals.ModelVariant modelVariant = CustomVortexVisuals.ModelVariant.ORIGINAL;
    private CustomVortexVisuals.TextureVariant textureVariant = CustomVortexVisuals.TextureVariant.ORIGINAL;
    private int tint = 0xFFFFFF;
    private boolean trackingMode;
    private boolean trackerAvailable;

    public TimerCustomizerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TIMER_CUSTOMIZER.get(), pos, state);
        this.dataAccess = new SimpleContainerData(5){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> TimerCustomizerBlockEntity.this.modelVariant.ordinal();
                    case 1 -> TimerCustomizerBlockEntity.this.textureVariant.ordinal();
                    case 2 -> TimerCustomizerBlockEntity.this.tint;
                    case 3 -> {
                        if (TimerCustomizerBlockEntity.this.trackingMode) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 4 -> {
                        if (TimerCustomizerBlockEntity.this.trackerAvailable) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        TimerCustomizerBlockEntity.this.setModelByIndex(value);
                        break;
                    }
                    case 1: {
                        TimerCustomizerBlockEntity.this.setTextureByIndex(value);
                        break;
                    }
                    case 2: {
                        TimerCustomizerBlockEntity.this.setTint(value);
                        break;
                    }
                    case 3: {
                        TimerCustomizerBlockEntity.this.trackingMode = value > 0;
                        break;
                    }
                    case 4: {
                        TimerCustomizerBlockEntity.this.trackerAvailable = value > 0;
                    }
                }
            }
        };
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    public void applySettings(int modelIndex, int textureIndex, int tintValue, boolean tracking) {
        this.setModelByIndex(modelIndex);
        this.setTextureByIndex(this.modelVariant.defaultTexture().ordinal());
        this.setTint(tintValue);
        this.trackingMode = tracking && this.trackerAvailable;
        this.writeToTimer();
        this.m_6596_();
    }

    private void setModelByIndex(int index) {
        CustomVortexVisuals.ModelVariant[] values = CustomVortexVisuals.ModelVariant.values();
        if (index < 0 || index >= values.length) {
            return;
        }
        this.modelVariant = values[index];
        this.textureVariant = this.modelVariant.defaultTexture();
    }

    private void setTextureByIndex(int index) {
        CustomVortexVisuals.TextureVariant[] values = CustomVortexVisuals.TextureVariant.values();
        if (index < 0 || index >= values.length) {
            return;
        }
        this.textureVariant = CustomVortexVisuals.enforceTexture(this.modelVariant, values[index]);
    }

    private void setTint(int tintValue) {
        this.tint = Math.max(0, Math.min(0xFFFFFF, tintValue));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handlerOptional.invalidate();
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("Model", this.modelVariant.ordinal());
        tag.m_128405_("Texture", this.textureVariant.ordinal());
        tag.m_128405_("Tint", this.tint);
        tag.m_128379_("TrackingMode", this.trackingMode);
        tag.m_128379_("TrackerAvailable", this.trackerAvailable);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        }
        this.setModelByIndex(tag.m_128451_("Model"));
        this.setTextureByIndex(tag.m_128451_("Texture"));
        this.setTint(tag.m_128451_("Tint"));
        this.trackingMode = tag.m_128471_("TrackingMode");
        this.trackerAvailable = tag.m_128471_("TrackerAvailable");
    }

    public void syncFromItem() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        Item item = stack.m_41720_();
        if (!(item instanceof CustomTimerItem)) {
            this.trackerAvailable = false;
            this.trackingMode = false;
            return;
        }
        CustomTimerItem customTimer = (CustomTimerItem)item;
        CustomTimerItem.ensureVisualDefaults(stack);
        this.modelVariant = CustomTimerItem.getSelectedModelVariant(stack);
        this.textureVariant = CustomVortexVisuals.enforceTexture(this.modelVariant, CustomTimerItem.getSelectedTextureVariant(stack));
        this.tint = CustomTimerItem.getCustomTint(stack);
        this.trackerAvailable = TimerUpgradeData.hasTrackerUpgrade(stack);
        int trackingFlag = stack.m_41784_().m_128451_("TrackingMode");
        this.trackingMode = this.trackerAvailable && trackingFlag == 1;
        this.m_6596_();
    }

    private void writeToTimer() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        Item item = stack.m_41720_();
        if (!(item instanceof CustomTimerItem)) {
            return;
        }
        CustomTimerItem customTimer = (CustomTimerItem)item;
        CustomTimerItem.setModelVariant(stack, this.modelVariant);
        CustomTimerItem.setTextureVariant(stack, this.textureVariant);
        CustomTimerItem.setCustomTint(stack, this.tint);
        if (this.trackerAvailable) {
            stack.m_41784_().m_128405_("TrackingMode", this.trackingMode ? 1 : 0);
        } else {
            stack.m_41784_().m_128405_("TrackingMode", 0);
        }
    }

    public boolean hasTrackerUpgrade() {
        return this.trackerAvailable;
    }

    public boolean isTrackingMode() {
        return this.trackingMode;
    }

    public CustomVortexVisuals.ModelVariant getModelVariant() {
        return this.modelVariant;
    }

    public CustomVortexVisuals.TextureVariant getTextureVariant() {
        return this.textureVariant;
    }

    public int getTint() {
        return this.tint;
    }

    public Component getName() {
        return Component.m_237115_((String)"block.slidersmod.timer_customizer");
    }

    public Component m_5446_() {
        return this.getName();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new TimerCustomizerMenu(id, inventory, this);
    }

    public int m_6643_() {
        return this.itemHandler.getSlots();
    }

    public boolean m_7983_() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        return stack.m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        if (stack.m_41619_() || amount <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack extracted = stack.m_41620_(amount);
        if (!extracted.m_41619_()) {
            this.m_6596_();
        }
        return extracted;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
        this.syncFromItem();
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        this.syncFromItem();
    }

    public void drops() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)this);
        }
    }
}

