/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.block.entity;

import com.michelmuscle.slidersmod.client.sound.BlockSoundManager;
import com.michelmuscle.slidersmod.config.SlidersModConfig;
import com.michelmuscle.slidersmod.init.ModBlockEntities;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.menu.TimerRecyclerMenu;
import com.michelmuscle.slidersmod.util.RecycleRecipeResolver;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimerRecyclerBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    private static final int SLOT_COUNT = 2;
    private static final int ENERGY_CAPACITY = 20000;
    private static final int ENERGY_MAX_RECEIVE = 800;
    private static final int ENERGY_COST_PER_OPERATION = 8000;
    private static final int PROCESS_TIME = 200;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TimerRecyclerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 1) {
                return false;
            }
            return RecycleRecipeResolver.canRecycle(stack);
        }
    };
    private final LazyOptional<ItemStackHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(20000, 800);
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this.energyStorage);
    private int progress = 0;
    private final SimpleContainerData data = new SimpleContainerData(4){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> TimerRecyclerBlockEntity.this.progress;
                case 1 -> 200;
                case 2 -> TimerRecyclerBlockEntity.this.energyStorage.getEnergyStored();
                case 3 -> 20000;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                TimerRecyclerBlockEntity.this.progress = value;
            } else if (index == 2) {
                TimerRecyclerBlockEntity.this.energyStorage.setEnergy(value);
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public TimerRecyclerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TIMER_RECYCLER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TimerRecyclerBlockEntity entity) {
        if (level.f_46443_) {
            if (entity.progress > 0 && !BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.startBlockSound(pos, (SoundEvent)ModSounds.TIMER_RECYCLER_ACTIVE.get());
            } else if (entity.progress == 0 && BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.stopBlockSound(pos);
            }
            return;
        }
        boolean dirty = false;
        ItemStack inputStack = entity.itemHandler.getStackInSlot(0);
        ItemStack outputStack = entity.itemHandler.getStackInSlot(1);
        double energyMultiplier = (Double)SlidersModConfig.TIMER_RECYCLER_ENERGY_MULTIPLIER.get();
        int adjustedEnergyCost = (int)(8000.0 * energyMultiplier);
        if (entity.progress == 0 && !inputStack.m_41619_() && RecycleRecipeResolver.canRecycle(inputStack) && entity.energyStorage.getEnergyStored() >= adjustedEnergyCost) {
            entity.progress = 1;
        }
        if (entity.progress > 0) {
            inputStack = entity.itemHandler.getStackInSlot(0);
            if (inputStack.m_41619_() || !RecycleRecipeResolver.canRecycle(inputStack)) {
                entity.progress = 0;
                dirty = true;
            } else {
                int energyPerTick = adjustedEnergyCost / 200;
                if (entity.energyStorage.canExtract() && entity.energyStorage.extractEnergy(energyPerTick, false) == energyPerTick) {
                    ++entity.progress;
                    if (entity.progress > 200) {
                        entity.completeRecycling();
                        entity.progress = 0;
                    }
                    dirty = true;
                } else if (entity.progress > 1) {
                    ++entity.progress;
                    if (entity.progress > 200) {
                        entity.completeRecycling();
                        entity.progress = 0;
                    }
                    dirty = true;
                } else {
                    entity.progress = 0;
                }
            }
        }
        if (dirty) {
            entity.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    private void completeRecycling() {
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        if (inputStack.m_41619_() || !RecycleRecipeResolver.canRecycle(inputStack)) {
            return;
        }
        ItemStack generatedOutput = RecycleRecipeResolver.generateOutput(inputStack, this.f_58857_.m_213780_());
        ItemStack currentOutput = this.itemHandler.getStackInSlot(1);
        if (currentOutput.m_41619_()) {
            this.itemHandler.setStackInSlot(1, generatedOutput);
        } else if (currentOutput.m_41720_() == generatedOutput.m_41720_() && currentOutput.m_41613_() + generatedOutput.m_41613_() <= currentOutput.m_41741_()) {
            currentOutput.m_41769_(generatedOutput.m_41613_());
        } else {
            this.progress = 0;
            return;
        }
        inputStack.m_41774_(1);
        this.itemHandler.setStackInSlot(0, inputStack);
        this.m_6596_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCapability.invalidate();
        this.itemCapability.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("progress", this.progress);
        tag.m_128356_("energy", (long)this.energyStorage.getEnergyStored());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("progress");
        this.energyStorage.setEnergy(tag.m_128454_("energy"));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Timer Recycler");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new TimerRecyclerMenu(windowId, playerInventory, this, (ContainerData)this.data);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public CustomEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressScaled(int max) {
        return this.progress * max / 200;
    }

    public void drops() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.add(this.itemHandler.getStackInSlot(i));
        }
        for (ItemStack item : items) {
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), item);
            entity.m_32010_(10);
            this.f_58857_.m_7967_((Entity)entity);
        }
    }

    public static class CustomEnergyStorage
    extends EnergyStorage {
        public CustomEnergyStorage(int capacity, int maxTransfer) {
            super(capacity, maxTransfer, maxTransfer, 0);
        }

        public void setEnergy(long energy) {
            this.energy = (int)energy;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate) {
                this.energy += energyReceived;
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
            if (!simulate) {
                this.energy -= energyExtracted;
            }
            return energyExtracted;
        }

        public boolean canExtract() {
            return this.energy > 0;
        }

        public boolean canReceive() {
            return this.energy < this.capacity;
        }
    }
}

