/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.block.entity;

import com.michelmuscle.slidersmod.client.sound.BlockSoundManager;
import com.michelmuscle.slidersmod.init.ModBlockEntities;
import com.michelmuscle.slidersmod.init.ModItems;
import com.michelmuscle.slidersmod.init.ModSounds;
import com.michelmuscle.slidersmod.menu.TimerWorkbenchMenu;
import com.michelmuscle.slidersmod.util.ClassicTimerHelper;
import com.michelmuscle.slidersmod.util.TimerUpgradeData;
import com.michelmuscle.slidersmod.util.TimerUpgradeSlots;
import com.michelmuscle.slidersmod.util.UpgradeInstance;
import com.michelmuscle.slidersmod.util.UpgradeRarity;
import com.michelmuscle.slidersmod.util.UpgradeType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimerWorkbenchBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    public static final int SLOT_TIMER = 0;
    public static final int SLOT_OUTPUT = 1;
    private static final int SLOT_COUNT = 2;
    private static final String TAG_UPGRADE_VALUE = "UpgradeValue";
    private static final String TAG_UPGRADE_RARITY = "UpgradeRarity";
    public static final int ANALYZE_TIME = 100;
    public static final int WORK_TIME = 100;
    public static final int ENERGY_CAPACITY = 20000;
    public static final int ENERGY_PER_OPERATION = 10000;
    public static final int ENERGY_PER_TICK = 100;
    private State state = State.IDLE;
    private int progress = 0;
    private boolean applyRequested = false;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TimerWorkbenchBlockEntity.this.m_6596_();
            if (slot == 0) {
                TimerWorkbenchBlockEntity.this.state = State.IDLE;
                TimerWorkbenchBlockEntity.this.progress = 0;
                TimerWorkbenchBlockEntity.this.applyRequested = false;
                ItemStack stack = TimerWorkbenchBlockEntity.this.itemHandler.getStackInSlot(0);
                TimerWorkbenchBlockEntity.this.clearUpgradeBuffer();
                if (!stack.m_41619_()) {
                    TimerUpgradeSlots.initializeTimer(stack);
                    TimerWorkbenchBlockEntity.this.loadUpgradesFromTimer(stack);
                }
                TimerWorkbenchBlockEntity.this.m_6596_();
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot == 0 && TimerUpgradeSlots.isTimer(stack);
        }
    };
    private final ItemStackHandler upgradeHandler = new ItemStackHandler(25){

        protected void onContentsChanged(int slot) {
            TimerWorkbenchBlockEntity.this.m_6596_();
        }
    };
    private final LazyOptional<ItemStackHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(20000, 5000);
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this.energyStorage);
    private final ContainerData data = new SimpleContainerData(4){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> TimerWorkbenchBlockEntity.this.progress;
                case 1 -> TimerWorkbenchBlockEntity.this.state.ordinal();
                case 2 -> TimerWorkbenchBlockEntity.this.energyStorage.getEnergyStored();
                case 3 -> TimerWorkbenchBlockEntity.this.energyStorage.getMaxEnergyStored();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TimerWorkbenchBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    TimerWorkbenchBlockEntity.this.state = State.values()[value];
                    break;
                }
                case 2: {
                    TimerWorkbenchBlockEntity.this.energyStorage.setEnergy(value);
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public TimerWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TIMER_WORKBENCH.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TimerWorkbenchBlockEntity be) {
        if (level == null) {
            return;
        }
        if (level.f_46443_) {
            boolean processing;
            boolean bl = processing = be.state != State.IDLE || be.progress > 0;
            if (processing) {
                if (!BlockSoundManager.isSoundPlaying(pos)) {
                    BlockSoundManager.startBlockSound(pos, (SoundEvent)ModSounds.RESEARCH_TABLE_ACTIVE.get());
                }
            } else if (BlockSoundManager.isSoundPlaying(pos)) {
                BlockSoundManager.stopBlockSound(pos);
            }
            return;
        }
        boolean dirty = false;
        if (be.state == State.IDLE && be.applyRequested && !be.itemHandler.getStackInSlot(0).m_41619_() && be.itemHandler.getStackInSlot(1).m_41619_()) {
            TimerUpgradeSlots.initializeTimer(be.itemHandler.getStackInSlot(0));
            be.state = State.ANALYZING;
            be.progress = 0;
            be.applyRequested = false;
            dirty = true;
        }
        switch (be.state) {
            case IDLE: {
                break;
            }
            case ANALYZING: {
                ++be.progress;
                dirty = true;
                if (be.progress < 100) break;
                be.progress = 0;
                be.state = State.WORKING;
                break;
            }
            case WORKING: {
                if (be.energyStorage.getEnergyStored() < 100) break;
                be.energyStorage.extractEnergy(100, false);
                ++be.progress;
                dirty = true;
                if (be.progress < 100) break;
                be.progress = 0;
                be.finishProcessing();
                be.state = State.IDLE;
            }
        }
        if (dirty) {
            be.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    private void finishProcessing() {
        ItemStack timer = this.itemHandler.getStackInSlot(0);
        if (timer.m_41619_()) {
            return;
        }
        this.applyUpgradesFromBuffer(timer);
        this.itemHandler.setStackInSlot(1, timer.m_41777_());
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        this.clearUpgradeBuffer();
    }

    public ContainerData getContainerData() {
        return this.data;
    }

    public void drops() {
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
        this.clearUpgradeBuffer();
        this.applyRequested = false;
    }

    public ItemStack getTimerStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public ItemStackHandler getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public boolean hasPendingUpgrades() {
        for (int i = 0; i < this.upgradeHandler.getSlots(); ++i) {
            if (this.upgradeHandler.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public boolean canPickupTimer() {
        return this.state == State.IDLE && !this.applyRequested && !this.hasPendingUpgrades();
    }

    public void requestApply() {
        this.applyRequested = true;
    }

    public boolean isApplyRequested() {
        return this.applyRequested;
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        return this.itemHandler.getStackInSlot(0).m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.itemHandler.extractItem(slot, amount, false);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
        this.clearUpgradeBuffer();
        this.applyRequested = false;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.slidersmod.timer_workbench");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new TimerWorkbenchMenu(id, inv, this, this.data);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("upgradeBuffer", (Tag)this.upgradeHandler.serializeNBT());
        tag.m_128365_("energy", (Tag)this.energyStorage.serializeNBT());
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("state", this.state.ordinal());
        tag.m_128379_("applyRequested", this.applyRequested);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        if (tag.m_128441_("upgradeBuffer")) {
            this.upgradeHandler.deserializeNBT(tag.m_128469_("upgradeBuffer"));
        }
        this.energyStorage.deserializeNBT(tag.m_128423_("energy"));
        this.progress = tag.m_128451_("progress");
        this.state = State.values()[tag.m_128451_("state")];
        this.applyRequested = tag.m_128471_("applyRequested");
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.m_41619_()) {
            TimerUpgradeSlots.initializeTimer(stack);
            this.loadUpgradesFromTimer(stack);
        } else {
            this.clearUpgradeBuffer();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemCapability.lazyMap(handler -> handler);
    }

    private void clearUpgradeBuffer() {
        for (int i = 0; i < this.upgradeHandler.getSlots(); ++i) {
            this.upgradeHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    private void loadUpgradesFromTimer(ItemStack timer) {
        this.clearUpgradeBuffer();
        if (timer.m_41619_() || !TimerUpgradeSlots.isTimer(timer)) {
            return;
        }
        TimerUpgradeSlots.initializeTimer(timer);
        for (int category = 0; category < 5; ++category) {
            int unlocked = TimerUpgradeSlots.getSlotCount(timer, category);
            for (int slot = 0; slot < unlocked; ++slot) {
                UpgradeInstance inst = TimerUpgradeSlots.getUpgrade(timer, category, slot);
                if (inst == null) continue;
                ItemStack upgradeStack = this.createStackFromUpgrade(inst, timer);
                if (!upgradeStack.m_41619_()) {
                    int bufferIndex = category * 5 + slot;
                    this.upgradeHandler.setStackInSlot(bufferIndex, upgradeStack);
                }
                TimerUpgradeSlots.removeUpgrade(timer, category, slot);
            }
        }
        this.m_6596_();
    }

    private void applyUpgradesFromBuffer(ItemStack timer) {
        TimerUpgradeSlots.initializeTimer(timer);
        RandomSource rnd = this.f_58857_ != null ? this.f_58857_.f_46441_ : RandomSource.m_216327_();
        boolean appliedAny = false;
        TimerUpgradeData.removePortalStabilityUpgrade(timer);
        TimerUpgradeData.clearSeedData(timer);
        TimerUpgradeData.removeTrackerUpgrade(timer);
        for (int category = 0; category < 5; ++category) {
            int unlocked = TimerUpgradeSlots.getSlotCount(timer, category);
            for (int slot = 0; slot < unlocked; ++slot) {
                TimerUpgradeSlots.removeUpgrade(timer, category, slot);
            }
        }
        for (int bufferIndex = 0; bufferIndex < this.upgradeHandler.getSlots(); ++bufferIndex) {
            UpgradeInstance inst;
            int category;
            int unlocked;
            int slotInCategory;
            ItemStack stack = this.upgradeHandler.getStackInSlot(bufferIndex);
            if (stack.m_41619_() || (slotInCategory = bufferIndex % 5) >= (unlocked = TimerUpgradeSlots.getSlotCount(timer, category = bufferIndex / 5)) || (inst = this.mapStackToUpgrade(stack, rnd, timer)) == null || !TimerUpgradeSlots.addUpgrade(timer, category, slotInCategory, inst)) continue;
            if (inst.getType() == UpgradeType.PORTAL_STABILITY) {
                int ticks = (int)(inst.getPrimaryValue() * 20.0);
                TimerUpgradeData.addPortalStabilityUpgrade(timer);
                TimerUpgradeData.setPortalDurations(timer, ticks, ticks);
            } else if (inst.getType() == UpgradeType.EGYPTIAN_TRACKER) {
                TimerUpgradeData.addTrackerUpgrade(timer);
            } else if (inst.getType() == UpgradeType.EXODUS_SEED) {
                TimerUpgradeData.addSeedUpgrade(timer);
            } else if (inst.getType() == UpgradeType.DIMENSION_ANCHOR) {
                TimerUpgradeData.increaseSeedSlots(timer);
            }
            this.upgradeHandler.setStackInSlot(bufferIndex, ItemStack.f_41583_);
            appliedAny = true;
        }
        if (appliedAny) {
            this.m_6596_();
        }
    }

    @Nullable
    private UpgradeInstance mapStackToUpgrade(ItemStack stack, RandomSource rnd, ItemStack timer) {
        UpgradeRarity r;
        UpgradeRarity rarityFromTag = null;
        double valueFromTag = Double.NaN;
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            if (tag.m_128441_(TAG_UPGRADE_RARITY)) {
                try {
                    rarityFromTag = UpgradeRarity.valueOf(tag.m_128461_(TAG_UPGRADE_RARITY));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (tag.m_128441_(TAG_UPGRADE_VALUE)) {
                valueFromTag = tag.m_128459_(TAG_UPGRADE_VALUE);
            }
        }
        if (stack.m_150930_((Item)ModItems.OVERHEAT_PROBABILITY_REDUCER.get())) {
            r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.COMMON;
            double v = !Double.isNaN(valueFromTag) ? valueFromTag : UpgradeInstance.createWithGeneratedValue(UpgradeType.OVERHEAT_PROBABILITY_REDUCER, r, rnd).getPrimaryValue();
            return new UpgradeInstance(UpgradeType.OVERHEAT_PROBABILITY_REDUCER, r, v);
        }
        if (stack.m_150930_((Item)ModItems.OVERHEAT_COOLDOWN_REDUCER.get())) {
            r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.COMMON;
            double v = !Double.isNaN(valueFromTag) ? valueFromTag : UpgradeInstance.createWithGeneratedValue(UpgradeType.OVERHEAT_COOLDOWN_REDUCER, r, rnd).getPrimaryValue();
            return new UpgradeInstance(UpgradeType.OVERHEAT_COOLDOWN_REDUCER, r, v);
        }
        if (stack.m_150930_((Item)ModItems.TEMPORAL_STABILIZER.get())) {
            r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.UNCOMMON;
            double v = !Double.isNaN(valueFromTag) ? valueFromTag : UpgradeInstance.createWithGeneratedValue(UpgradeType.TEMPORAL_STABILIZER, r, rnd).getPrimaryValue();
            return new UpgradeInstance(UpgradeType.TEMPORAL_STABILIZER, r, v);
        }
        if (stack.m_150930_((Item)ModItems.DIMENSIONAL_BUFFER.get())) {
            r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.RARE;
            double v = !Double.isNaN(valueFromTag) ? valueFromTag : UpgradeInstance.createWithGeneratedValue(UpgradeType.DIMENSIONAL_BUFFER_TIER3, r, rnd).getPrimaryValue();
            return new UpgradeInstance(UpgradeType.DIMENSIONAL_BUFFER_TIER3, r, v);
        }
        if (stack.m_150930_((Item)ModItems.EGYPTIAN_TRACKER_UPGRADE.get()) && this.isEgyptianTimer(timer)) {
            r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.EPIC;
            double v = !Double.isNaN(valueFromTag) ? valueFromTag : UpgradeInstance.createWithGeneratedValue(UpgradeType.EGYPTIAN_TRACKER, r, rnd).getPrimaryValue();
            return new UpgradeInstance(UpgradeType.EGYPTIAN_TRACKER, r, v);
        }
        if (stack.m_150930_((Item)ModItems.EXODUS_SEED_UPGRADE.get()) && this.isExodusTimer(timer)) {
            r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.EPIC;
            double v = !Double.isNaN(valueFromTag) ? valueFromTag : UpgradeInstance.createWithGeneratedValue(UpgradeType.EXODUS_SEED, r, rnd).getPrimaryValue();
            return new UpgradeInstance(UpgradeType.EXODUS_SEED, r, v);
        }
        if (stack.m_150930_((Item)ModItems.DIMENSION_ANCHOR.get()) && this.isExodusTimer(timer)) {
            r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.EPIC;
            double v = !Double.isNaN(valueFromTag) ? valueFromTag : UpgradeInstance.createWithGeneratedValue(UpgradeType.DIMENSION_ANCHOR, r, rnd).getPrimaryValue();
            return new UpgradeInstance(UpgradeType.DIMENSION_ANCHOR, r, v);
        }
        if (stack.m_150930_((Item)ModItems.SLOT_EXPANSER_UPGRADE.get()) || stack.m_150930_((Item)ModItems.VORTEX_CALIBRATOR.get())) {
            r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.UNCOMMON;
            double v = !Double.isNaN(valueFromTag) ? valueFromTag : 0.0;
            return new UpgradeInstance(UpgradeType.SLOT_EXPANDER, r, v);
        }
        if (stack.m_150930_((Item)ModItems.PORTAL_STABILITY_UPGRADE.get())) {
            r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.RARE;
            double v = !Double.isNaN(valueFromTag) ? valueFromTag : UpgradeInstance.createWithGeneratedValue(UpgradeType.PORTAL_STABILITY, r, rnd).getPrimaryValue();
            return new UpgradeInstance(UpgradeType.PORTAL_STABILITY, r, v);
        }
        if (ClassicTimerHelper.isDamagedTimer(timer)) {
            if (stack.m_150930_((Item)ModItems.ULTIMATE_CRYSTAL_BUFFER.get())) {
                r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.LEGENDARY;
                double v = !Double.isNaN(valueFromTag) ? valueFromTag : UpgradeInstance.createWithGeneratedValue(UpgradeType.CRYSTAL_BUFFER, r, rnd).getPrimaryValue();
                return new UpgradeInstance(UpgradeType.CRYSTAL_BUFFER, r, v);
            }
            if (stack.m_150930_((Item)ModItems.ADVANCED_CRYSTAL_BUFFER.get())) {
                r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.RARE;
                double v = !Double.isNaN(valueFromTag) ? valueFromTag : UpgradeInstance.createWithGeneratedValue(UpgradeType.CRYSTAL_BUFFER, r, rnd).getPrimaryValue();
                return new UpgradeInstance(UpgradeType.CRYSTAL_BUFFER, r, v);
            }
            if (stack.m_150930_((Item)ModItems.CRYSTAL_BUFFER.get())) {
                r = rarityFromTag != null ? rarityFromTag : UpgradeRarity.COMMON;
                double v = !Double.isNaN(valueFromTag) ? valueFromTag : UpgradeInstance.createWithGeneratedValue(UpgradeType.CRYSTAL_BUFFER, r, rnd).getPrimaryValue();
                return new UpgradeInstance(UpgradeType.CRYSTAL_BUFFER, r, v);
            }
        }
        return null;
    }

    private ItemStack createStackFromUpgrade(UpgradeInstance inst, ItemStack timer) {
        ItemStack stack = ItemStack.f_41583_;
        switch (inst.getType()) {
            case OVERHEAT_PROBABILITY_REDUCER: {
                stack = new ItemStack((ItemLike)ModItems.OVERHEAT_PROBABILITY_REDUCER.get());
                break;
            }
            case OVERHEAT_COOLDOWN_REDUCER: {
                stack = new ItemStack((ItemLike)ModItems.OVERHEAT_COOLDOWN_REDUCER.get());
                break;
            }
            case TEMPORAL_STABILIZER: {
                stack = new ItemStack((ItemLike)ModItems.TEMPORAL_STABILIZER.get());
                break;
            }
            case DIMENSIONAL_BUFFER_TIER1: 
            case DIMENSIONAL_BUFFER_TIER2: 
            case DIMENSIONAL_BUFFER_TIER3: 
            case DIMENSIONAL_BUFFER_TIER4: 
            case DIMENSIONAL_BUFFER_TIER5: {
                stack = new ItemStack((ItemLike)ModItems.DIMENSIONAL_BUFFER.get());
                break;
            }
            case CRYSTAL_BUFFER: {
                if (inst.getRarity() == UpgradeRarity.LEGENDARY) {
                    stack = new ItemStack((ItemLike)ModItems.ULTIMATE_CRYSTAL_BUFFER.get());
                    break;
                }
                if (inst.getRarity() == UpgradeRarity.RARE || inst.getRarity() == UpgradeRarity.EPIC) {
                    stack = new ItemStack((ItemLike)ModItems.ADVANCED_CRYSTAL_BUFFER.get());
                    break;
                }
                stack = new ItemStack((ItemLike)ModItems.CRYSTAL_BUFFER.get());
                break;
            }
            case EGYPTIAN_TRACKER: {
                if (!this.isEgyptianTimer(timer)) break;
                stack = new ItemStack((ItemLike)ModItems.EGYPTIAN_TRACKER_UPGRADE.get());
                break;
            }
            case EXODUS_SEED: {
                if (!this.isExodusTimer(timer)) break;
                stack = new ItemStack((ItemLike)ModItems.EXODUS_SEED_UPGRADE.get());
                break;
            }
            case DIMENSION_ANCHOR: {
                if (!this.isExodusTimer(timer)) break;
                stack = new ItemStack((ItemLike)ModItems.DIMENSION_ANCHOR.get());
                break;
            }
            case PORTAL_STABILITY: {
                stack = new ItemStack((ItemLike)ModItems.PORTAL_STABILITY_UPGRADE.get());
                break;
            }
            case SLOT_EXPANDER: {
                stack = new ItemStack((ItemLike)ModItems.SLOT_EXPANSER_UPGRADE.get());
            }
        }
        if (!stack.m_41619_()) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128347_(TAG_UPGRADE_VALUE, inst.getPrimaryValue());
            tag.m_128359_(TAG_UPGRADE_RARITY, inst.getRarity().name());
        }
        return stack;
    }

    private boolean isEgyptianTimer(ItemStack timer) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)timer.m_41720_());
        return key != null && key.m_135815_().contains("egyptian_timer");
    }

    private boolean isExodusTimer(ItemStack timer) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)timer.m_41720_());
        return key != null && key.m_135815_().contains("exodus_timer");
    }

    public static int getEnergyPerTick() {
        return 100;
    }

    public static enum State {
        IDLE,
        ANALYZING,
        WORKING;

    }

    private static class CustomEnergyStorage
    implements IEnergyStorage {
        private int energy;
        private final int capacity;
        private final int maxReceive;

        CustomEnergyStorage(int capacity, int maxReceive) {
            this.capacity = capacity;
            this.maxReceive = maxReceive;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate && received > 0) {
                this.energy += received;
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = Math.min(this.energy, maxExtract);
            if (!simulate && extracted > 0) {
                this.energy -= extracted;
            }
            return extracted;
        }

        public int getEnergyStored() {
            return this.energy;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        void setEnergy(int value) {
            this.energy = Math.min(value, this.capacity);
        }

        CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("energy", this.energy);
            return tag;
        }

        void deserializeNBT(@Nullable Tag nbt) {
            if (nbt instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)nbt;
                this.energy = compound.m_128451_("energy");
            }
        }
    }
}

