/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.joml.Matrix4f;

public final class ObjMesh {
    private static final float UV_SHIFT = 1.0E-6f;
    public static boolean DRAW_BOTH_WINDINGS = true;
    public static boolean FORCE_FLAT_VIEW_NORMAL = true;
    private final List<Tri> tris = new ArrayList<Tri>();
    private int maxVtIndex = -1;
    private int[] offU = new int[0];
    private int[] offV = new int[0];
    private final List<int[]> edgesUV = new ArrayList<int[]>();
    private float[] baseU;
    private float[] baseV;
    private boolean haveCanonicalUV = false;
    private int maxVi = -1;
    private float[] nxByVi;
    private float[] nyByVi;
    private float[] nzByVi;

    private ObjMesh() {
    }

    public static ObjMesh load(ResourceLocation loc) throws IOException {
        Minecraft mc = Minecraft.m_91087_();
        Optional res = mc.m_91098_().m_213713_(loc);
        if (!res.isPresent()) {
            throw new IOException("Missing resource: " + String.valueOf(loc));
        }
        try (InputStream in = ((Resource)res.get()).m_215507_();){
            ObjMesh objMesh = ObjMesh.fromStream(in);
            return objMesh;
        }
    }

    public static ObjMesh fromStream(InputStream in) throws IOException {
        ObjMesh mesh = new ObjMesh();
        ArrayList<V> vs = new ArrayList<V>();
        ArrayList<T> vts = new ArrayList<T>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = r.readLine()) != null) {
                String[] f;
                String[] s;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("v ")) {
                    s = line.split("\\s+");
                    vs.add(new V(ObjMesh.parseF(s, 1), ObjMesh.parseF(s, 2), ObjMesh.parseF(s, 3)));
                    continue;
                }
                if (line.startsWith("vt ")) {
                    s = line.split("\\s+");
                    float u = ObjMesh.parseF(s, 1);
                    float v = 1.0f - ObjMesh.parseF(s, 2);
                    vts.add(new T(u, v));
                    continue;
                }
                if (!line.startsWith("f ") || (f = line.substring(2).trim().split("\\s+")).length < 3) continue;
                int[] A = ObjMesh.parseIdx(f[0]);
                int i = 1;
                while (i + 1 < f.length) {
                    int[] B = ObjMesh.parseIdx(f[i]);
                    int[] C = ObjMesh.parseIdx(f[i + 1]);
                    V p0 = ObjMesh.pickV(vs, A[0]);
                    V p1 = ObjMesh.pickV(vs, B[0]);
                    V p2 = ObjMesh.pickV(vs, C[0]);
                    int ti0 = A[1];
                    int ti1 = B[1];
                    int ti2 = C[1];
                    int pi0 = A[0];
                    int pi1 = B[0];
                    int pi2 = C[0];
                    T t0 = ObjMesh.pickVT(vts, ti0);
                    T t1 = ObjMesh.pickVT(vts, ti1);
                    T t2 = ObjMesh.pickVT(vts, ti2);
                    mesh.tris.add(new Tri(p0, p1, p2, t0, t1, t2, ti0, ti1, ti2, pi0, pi1, pi2));
                    if (pi0 > mesh.maxVi) {
                        mesh.maxVi = pi0;
                    }
                    if (pi1 > mesh.maxVi) {
                        mesh.maxVi = pi1;
                    }
                    if (pi2 > mesh.maxVi) {
                        mesh.maxVi = pi2;
                    }
                    ++i;
                }
            }
        }
        mesh.computeMaxVtIndex();
        mesh.phaseLockUV();
        mesh.buildUVEdges();
        mesh.buildCanonicalUV();
        mesh.buildVertexNormals();
        return mesh;
    }

    private static float parseF(String[] s, int i) {
        return Float.parseFloat(s[i]);
    }

    private static int[] parseIdx(String token) {
        String[] sp = token.split("/");
        int vi = Integer.parseInt(sp[0]) - 1;
        int vti = -1;
        if (sp.length >= 2 && !sp[1].isEmpty()) {
            vti = Integer.parseInt(sp[1]) - 1;
        }
        return new int[]{vi, vti};
    }

    private static V pickV(List<V> list, int idx) {
        return idx < 0 || idx >= list.size() ? new V(0.0f, 0.0f, 0.0f) : list.get(idx);
    }

    private static T pickVT(List<T> list, int idx) {
        return idx < 0 || idx >= list.size() ? new T(0.0f, 0.0f) : list.get(idx);
    }

    private void computeMaxVtIndex() {
        this.maxVtIndex = -1;
        for (Tri tr : this.tris) {
            if (tr.ti0 >= 0 && tr.ti0 > this.maxVtIndex) {
                this.maxVtIndex = tr.ti0;
            }
            if (tr.ti1 >= 0 && tr.ti1 > this.maxVtIndex) {
                this.maxVtIndex = tr.ti1;
            }
            if (tr.ti2 < 0 || tr.ti2 <= this.maxVtIndex) continue;
            this.maxVtIndex = tr.ti2;
        }
        if (this.maxVtIndex >= 0) {
            this.offU = new int[this.maxVtIndex + 1];
            this.offV = new int[this.maxVtIndex + 1];
            Arrays.fill(this.offU, Integer.MIN_VALUE);
            Arrays.fill(this.offV, Integer.MIN_VALUE);
        } else {
            this.offV = new int[0];
            this.offU = this.offV;
        }
    }

    /*
     * Exception decompiling
     */
    private void phaseLockUV() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void buildUVEdges() {
        HashSet<Long> set = new HashSet<Long>();
        for (Tri t : this.tris) {
            int[] arr = new int[]{t.ti0, t.ti1, t.ti2};
            for (int a = 0; a < 3; ++a) {
                int hi;
                int lo;
                long key;
                int i = arr[a];
                int j = arr[(a + 1) % 3];
                if (i < 0 || j < 0 || !set.add(key = (long)(lo = Math.min(i, j)) << 32 ^ (long)(hi = Math.max(i, j)))) continue;
                this.edgesUV.add(new int[]{lo, hi});
            }
        }
    }

    private void buildCanonicalUV() {
        if (this.maxVtIndex < 0) {
            this.haveCanonicalUV = false;
            this.baseV = null;
            this.baseU = null;
            return;
        }
        this.baseU = new float[this.maxVtIndex + 1];
        this.baseV = new float[this.maxVtIndex + 1];
        boolean[] seen = new boolean[this.maxVtIndex + 1];
        Arrays.fill(seen, false);
        for (Tri tr : this.tris) {
            if (tr.ti0 >= 0 && !seen[tr.ti0]) {
                this.baseU[tr.ti0] = tr.t0.u + (float)this.offUor0(tr.ti0);
                this.baseV[tr.ti0] = tr.t0.v + (float)this.offVor0(tr.ti0);
                seen[tr.ti0] = true;
            }
            if (tr.ti1 >= 0 && !seen[tr.ti1]) {
                this.baseU[tr.ti1] = tr.t1.u + (float)this.offUor0(tr.ti1);
                this.baseV[tr.ti1] = tr.t1.v + (float)this.offVor0(tr.ti1);
                seen[tr.ti1] = true;
            }
            if (tr.ti2 < 0 || seen[tr.ti2]) continue;
            this.baseU[tr.ti2] = tr.t2.u + (float)this.offUor0(tr.ti2);
            this.baseV[tr.ti2] = tr.t2.v + (float)this.offVor0(tr.ti2);
            seen[tr.ti2] = true;
        }
        this.unwrapChannel(this.baseU);
        this.unwrapChannel(this.baseV);
        this.haveCanonicalUV = true;
    }

    private void buildVertexNormals() {
        if (this.maxVi < 0) {
            return;
        }
        this.nxByVi = new float[this.maxVi + 1];
        this.nyByVi = new float[this.maxVi + 1];
        this.nzByVi = new float[this.maxVi + 1];
        for (Tri tr : this.tris) {
            float ax = tr.p1.x - tr.p0.x;
            float ay = tr.p1.y - tr.p0.y;
            float az = tr.p1.z - tr.p0.z;
            float bx = tr.p2.x - tr.p0.x;
            float by = tr.p2.y - tr.p0.y;
            float bz = tr.p2.z - tr.p0.z;
            float nx = ay * bz - az * by;
            float ny = az * bx - ax * bz;
            float nz = ax * by - ay * bx;
            int n = tr.pi0;
            this.nxByVi[n] = this.nxByVi[n] + nx;
            int n2 = tr.pi0;
            this.nyByVi[n2] = this.nyByVi[n2] + ny;
            int n3 = tr.pi0;
            this.nzByVi[n3] = this.nzByVi[n3] + nz;
            int n4 = tr.pi1;
            this.nxByVi[n4] = this.nxByVi[n4] + nx;
            int n5 = tr.pi1;
            this.nyByVi[n5] = this.nyByVi[n5] + ny;
            int n6 = tr.pi1;
            this.nzByVi[n6] = this.nzByVi[n6] + nz;
            int n7 = tr.pi2;
            this.nxByVi[n7] = this.nxByVi[n7] + nx;
            int n8 = tr.pi2;
            this.nyByVi[n8] = this.nyByVi[n8] + ny;
            int n9 = tr.pi2;
            this.nzByVi[n9] = this.nzByVi[n9] + nz;
        }
        for (int i = 0; i <= this.maxVi; ++i) {
            float nx = this.nxByVi[i];
            float ny = this.nyByVi[i];
            float nz = this.nzByVi[i];
            float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
            if (len > 1.0E-6f) {
                this.nxByVi[i] = nx / len;
                this.nyByVi[i] = ny / len;
                this.nzByVi[i] = nz / len;
                continue;
            }
            this.nxByVi[i] = 0.0f;
            this.nyByVi[i] = 0.0f;
            this.nzByVi[i] = 1.0f;
        }
    }

    public void draw(VertexConsumer vc, Matrix4f pose, int light, float du, float dv) {
        this.drawTinted(vc, pose, light, du, dv, 255, 255, 255);
    }

    public void drawTinted(VertexConsumer vc, Matrix4f pose, int light, float du, float dv, int red, int green, int blue) {
        if (du != 0.0f) {
            du -= (float)Math.floor(du);
        }
        if (dv != 0.0f) {
            dv -= (float)Math.floor(dv);
        }
        float EPS = 1.0E-6f;
        du += 1.0E-6f;
        dv += 1.0E-6f;
        for (Tri tr : this.tris) {
            float n0z;
            float n1z;
            float n2z;
            float n0y;
            float n1y;
            float n2y;
            float n0x;
            float n1x;
            float n2x;
            float v2;
            float u2;
            float v1;
            float u1;
            float v0;
            float u0;
            if (this.haveCanonicalUV) {
                u0 = tr.ti0 >= 0 ? this.baseU[tr.ti0] + du : tr.t0.u + du;
                v0 = tr.ti0 >= 0 ? this.baseV[tr.ti0] + dv : tr.t0.v + dv;
                u1 = tr.ti1 >= 0 ? this.baseU[tr.ti1] + du : tr.t1.u + du;
                v1 = tr.ti1 >= 0 ? this.baseV[tr.ti1] + dv : tr.t1.v + dv;
                u2 = tr.ti2 >= 0 ? this.baseU[tr.ti2] + du : tr.t2.u + du;
                v2 = tr.ti2 >= 0 ? this.baseV[tr.ti2] + dv : tr.t2.v + dv;
            } else {
                u0 = tr.t0.u + du;
                v0 = tr.t0.v + dv;
                u1 = tr.t1.u + du;
                v1 = tr.t1.v + dv;
                u2 = tr.t2.u + du;
                v2 = tr.t2.v + dv;
            }
            if (FORCE_FLAT_VIEW_NORMAL) {
                n2x = 0.0f;
                n1x = 0.0f;
                n0x = 0.0f;
                n2y = 0.0f;
                n1y = 0.0f;
                n0y = 0.0f;
                n2z = 1.0f;
                n1z = 1.0f;
                n0z = 1.0f;
            } else {
                n0x = this.nxByVi[tr.pi0];
                n0y = this.nyByVi[tr.pi0];
                n0z = this.nzByVi[tr.pi0];
                n1x = this.nxByVi[tr.pi1];
                n1y = this.nyByVi[tr.pi1];
                n1z = this.nzByVi[tr.pi1];
                n2x = this.nxByVi[tr.pi2];
                n2y = this.nyByVi[tr.pi2];
                n2z = this.nzByVi[tr.pi2];
            }
            ObjMesh.put(vc, pose, tr.p0, u0, v0, light, n0x, n0y, n0z, red, green, blue);
            ObjMesh.put(vc, pose, tr.p1, u1, v1, light, n1x, n1y, n1z, red, green, blue);
            ObjMesh.put(vc, pose, tr.p2, u2, v2, light, n2x, n2y, n2z, red, green, blue);
            if (!DRAW_BOTH_WINDINGS) continue;
            ObjMesh.put(vc, pose, tr.p2, u2, v2, light, n2x, n2y, n2z, red, green, blue);
            ObjMesh.put(vc, pose, tr.p1, u1, v1, light, n1x, n1y, n1z, red, green, blue);
            ObjMesh.put(vc, pose, tr.p0, u0, v0, light, n0x, n0y, n0z, red, green, blue);
        }
    }

    public void drawFrame(VertexConsumer vc, Matrix4f pose, int light, int frameIndex, int frameCount) {
        if (frameCount <= 0) {
            this.drawTinted(vc, pose, light, 0.0f, 0.0f, 255, 255, 255);
            return;
        }
        int safeFrame = Math.floorMod(frameIndex, frameCount);
        float frameHeight = 1.0f / (float)frameCount;
        float offsetV = (float)safeFrame * frameHeight + 1.0E-6f;
        for (Tri tr : this.tris) {
            float n0z;
            float n1z;
            float n2z;
            float n0y;
            float n1y;
            float n2y;
            float n0x;
            float n1x;
            float n2x;
            float v2;
            float v1;
            float v0;
            float u2;
            float u1;
            float u0;
            if (this.haveCanonicalUV) {
                u0 = tr.ti0 >= 0 ? this.baseU[tr.ti0] + 1.0E-6f : tr.t0.u + 1.0E-6f;
                u1 = tr.ti1 >= 0 ? this.baseU[tr.ti1] + 1.0E-6f : tr.t1.u + 1.0E-6f;
                u2 = tr.ti2 >= 0 ? this.baseU[tr.ti2] + 1.0E-6f : tr.t2.u + 1.0E-6f;
                v0 = (tr.ti0 >= 0 ? this.baseV[tr.ti0] : tr.t0.v) * frameHeight + offsetV;
                v1 = (tr.ti1 >= 0 ? this.baseV[tr.ti1] : tr.t1.v) * frameHeight + offsetV;
                v2 = (tr.ti2 >= 0 ? this.baseV[tr.ti2] : tr.t2.v) * frameHeight + offsetV;
            } else {
                u0 = tr.t0.u + 1.0E-6f;
                u1 = tr.t1.u + 1.0E-6f;
                u2 = tr.t2.u + 1.0E-6f;
                v0 = tr.t0.v * frameHeight + offsetV;
                v1 = tr.t1.v * frameHeight + offsetV;
                v2 = tr.t2.v * frameHeight + offsetV;
            }
            if (FORCE_FLAT_VIEW_NORMAL) {
                n2x = 0.0f;
                n1x = 0.0f;
                n0x = 0.0f;
                n2y = 0.0f;
                n1y = 0.0f;
                n0y = 0.0f;
                n2z = 1.0f;
                n1z = 1.0f;
                n0z = 1.0f;
            } else {
                n0x = this.nxByVi[tr.pi0];
                n0y = this.nyByVi[tr.pi0];
                n0z = this.nzByVi[tr.pi0];
                n1x = this.nxByVi[tr.pi1];
                n1y = this.nyByVi[tr.pi1];
                n1z = this.nzByVi[tr.pi1];
                n2x = this.nxByVi[tr.pi2];
                n2y = this.nyByVi[tr.pi2];
                n2z = this.nzByVi[tr.pi2];
            }
            ObjMesh.put(vc, pose, tr.p0, u0, v0, light, n0x, n0y, n0z, 255, 255, 255);
            ObjMesh.put(vc, pose, tr.p1, u1, v1, light, n1x, n1y, n1z, 255, 255, 255);
            ObjMesh.put(vc, pose, tr.p2, u2, v2, light, n2x, n2y, n2z, 255, 255, 255);
            if (!DRAW_BOTH_WINDINGS) continue;
            ObjMesh.put(vc, pose, tr.p2, u2, v2, light, n2x, n2y, n2z, 255, 255, 255);
            ObjMesh.put(vc, pose, tr.p1, u1, v1, light, n1x, n1y, n1z, 255, 255, 255);
            ObjMesh.put(vc, pose, tr.p0, u0, v0, light, n0x, n0y, n0z, 255, 255, 255);
        }
    }

    private void unwrapChannel(float[] uByVt) {
        int n = uByVt.length;
        boolean[] seen = new boolean[n];
        ArrayDeque<Integer> q = new ArrayDeque<Integer>();
        for (int start = 0; start < n; ++start) {
            if (seen[start]) continue;
            seen[start] = true;
            q.clear();
            q.add(start);
            while (!q.isEmpty()) {
                int i = (Integer)q.removeFirst();
                float ui = uByVt[i];
                for (int[] e : this.edgesUV) {
                    int j;
                    int a = e[0];
                    int b = e[1];
                    if (a != i && b != i || (j = a == i ? b : a) < 0 || j >= n || seen[j]) continue;
                    float uj = uByVt[j];
                    int k = Math.round(ui - uj);
                    uByVt[j] = uj + (float)k;
                    seen[j] = true;
                    q.addLast(j);
                }
            }
        }
    }

    private static void put(VertexConsumer vc, Matrix4f pose, V p, float u, float v, int light, float nx, float ny, float nz, int red, int green, int blue) {
        vc.m_252986_(pose, p.x, p.y, p.z).m_6122_(red, green, blue, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(nx, ny, nz).m_5752_();
    }

    private int offUor0(int idx) {
        return idx >= 0 && idx < this.offU.length && this.offU[idx] != Integer.MIN_VALUE ? this.offU[idx] : 0;
    }

    private int offVor0(int idx) {
        return idx >= 0 && idx < this.offV.length && this.offV[idx] != Integer.MIN_VALUE ? this.offV[idx] : 0;
    }

    public static float wrap01(float t) {
        if ((t -= (float)Math.floor(t)) < 0.0f) {
            t += 1.0f;
        }
        return t >= 1.0f ? 0.0f : t;
    }

    public static float wrap01Mirror(float t) {
        return (t -= (float)Math.floor(t / 2.0f) * 2.0f) <= 1.0f ? t : 2.0f - t;
    }

    public static final class V {
        public final float x;
        public final float y;
        public final float z;

        public V(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static final class T {
        public final float u;
        public final float v;

        public T(float u, float v) {
            this.u = u;
            this.v = v;
        }
    }

    public static final class Tri {
        public final V p0;
        public final V p1;
        public final V p2;
        public final T t0;
        public final T t1;
        public final T t2;
        public final int ti0;
        public final int ti1;
        public final int ti2;
        public final int pi0;
        public final int pi1;
        public final int pi2;

        public Tri(V p0, V p1, V p2, T t0, T t1, T t2, int ti0, int ti1, int ti2, int pi0, int pi1, int pi2) {
            this.p0 = p0;
            this.p1 = p1;
            this.p2 = p2;
            this.t0 = t0;
            this.t1 = t1;
            this.t2 = t2;
            this.ti0 = ti0;
            this.ti1 = ti1;
            this.ti2 = ti2;
            this.pi0 = pi0;
            this.pi1 = pi1;
            this.pi2 = pi2;
        }
    }
}

