/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.effect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class VortexBeamEffect {
    private static final List<BeamInstance> activeBeams = new ArrayList<BeamInstance>();
    private static final int PHASE_1_DURATION = 5;
    private static final int PHASE_2_DURATION = 10;
    private static final int PHASE_3_DURATION = 5;
    private static final int TOTAL_DURATION = 20;

    public static void createBeam(Vec3 start, Vec3 end) {
        activeBeams.add(new BeamInstance(start, end));
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        Iterator<BeamInstance> iterator = activeBeams.iterator();
        while (iterator.hasNext()) {
            BeamInstance beam = iterator.next();
            ++beam.tick;
            if (beam.tick > 20) {
                iterator.remove();
                continue;
            }
            float progress = VortexBeamEffect.calculateProgress(beam.tick);
            VortexBeamEffect.spawnBeamParticles((Level)level, beam.start, beam.end, progress);
        }
    }

    private static float calculateProgress(int tick) {
        if (tick <= 5) {
            return (float)tick / 5.0f;
        }
        if (tick <= 15) {
            return 1.0f;
        }
        int phaseTickRelative = tick - 5 - 10;
        return 1.0f - (float)phaseTickRelative / 5.0f;
    }

    private static void spawnBeamParticles(Level level, Vec3 start, Vec3 end, float progress) {
        Vec3 currentEnd;
        Vec3 currentStart;
        if (progress < 1.0f) {
            currentStart = start;
            currentEnd = start.m_82549_(end.m_82546_(start).m_82490_((double)progress));
        } else if (progress >= 1.0f) {
            currentStart = start.m_82549_(end.m_82546_(start).m_82490_((double)(1.0f - progress)));
            currentEnd = end;
        } else {
            currentStart = start;
            currentEnd = end;
        }
        double distance = currentStart.m_82554_(currentEnd);
        int particleCount = Math.max(1, (int)(distance * 5.0));
        for (int i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)particleCount;
            Vec3 particlePos = currentStart.m_82549_(currentEnd.m_82546_(currentStart).m_82490_(t));
            level.m_7106_((ParticleOptions)ParticleTypes.f_175827_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private static class BeamInstance {
        final Vec3 start;
        final Vec3 end;
        int tick = 0;

        BeamInstance(Vec3 start, Vec3 end) {
            this.start = start;
            this.end = end;
        }
    }
}

