/*
 * Decompiled with CFR 0.152.
 */
package com.michelmuscle.slidersmod.client.hud;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ForceVortexWarningHud {
    private static boolean warningActive = false;
    private static int secondsLeft = 0;

    public static void showWarning(int seconds) {
        warningActive = true;
        secondsLeft = seconds;
    }

    public static void cancelWarning() {
        warningActive = false;
        secondsLeft = 0;
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        if (!warningActive) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        GuiGraphics graphics = event.getGuiGraphics();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2 - 80;
        String warningText = "\u00a7c  FORCING VORTEX WILL DAMAGE TIMER!";
        Object actionText = secondsLeft > 0 ? "\u00a7eLEFT-CLICK AGAIN TO CONFIRM (" + secondsLeft + "...)" : "\u00a7aCanceled!";
        int warningWidth = mc.f_91062_.m_92895_(warningText);
        int actionWidth = mc.f_91062_.m_92895_((String)actionText);
        int maxWidth = Math.max(warningWidth, actionWidth);
        int padding = 15;
        int bgX = centerX - maxWidth / 2 - padding;
        int bgY = centerY - padding;
        int bgWidth = maxWidth + padding * 2;
        Objects.requireNonNull(mc.f_91062_);
        int bgHeight = 9 * 2 + padding * 3;
        int alpha = secondsLeft > 0 && System.currentTimeMillis() % 500L < 250L ? 221 : 170;
        int bgColor = alpha << 24 | 0x440000;
        graphics.m_280509_(bgX, bgY, bgX + bgWidth, bgY + bgHeight, bgColor);
        int borderColor = -65536;
        graphics.m_280509_(bgX, bgY, bgX + bgWidth, bgY + 3, borderColor);
        graphics.m_280509_(bgX, bgY + bgHeight - 3, bgX + bgWidth, bgY + bgHeight, borderColor);
        graphics.m_280509_(bgX, bgY, bgX + 3, bgY + bgHeight, borderColor);
        graphics.m_280509_(bgX + bgWidth - 3, bgY, bgX + bgWidth, bgY + bgHeight, borderColor);
        graphics.m_280137_(mc.f_91062_, warningText, centerX, centerY, 0xFFFFFF);
        Font font = mc.f_91062_;
        Objects.requireNonNull(mc.f_91062_);
        graphics.m_280137_(font, (String)actionText, centerX, centerY + 9 + 5, 0xFFFFFF);
    }
}

